/***********************************************************************\
 *                                PC2.c                                *
 *                 Copyright (C) by Stangl Roman, 1993                 *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * Dialog.c     Dialog window procedures.                              *
 *                                                                     *
\***********************************************************************/

static char RCSID[]="@(#) $Header: Dialog.c Version 1.30 04,1993 $ (LBL)";

#define         _FILE_  "PC/2 - Dialog.c V1.30"

#include        "PC2.h"                 /* User include files */
#include        "Error.h"

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - About dialog.                               *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY AD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2,
        (swpScreen.cy-swp.cy)/2,
        0,
        0,
        SWP_MOVE);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
        MPFROMSHORT(ID_ABOUTDIALOG),    /* Panel ID in ressource file */
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Cancel key pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Program Installation dialog.                *
 * Req:                                                                                 *
 *      StartSession .. a structure of type SESSIONDATA where the information entered   *
 *                      in the dialog is entered. If DID_OK is pressed this structure   *
 *                      is used to start the session and set its priority.              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY PI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;
    UCHAR       Buffer[4];

    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2,
        (swpScreen.cy-swp.cy)/2,
        0,
        0,
        SWP_MOVE);
/*                                                                                      *\
 * Set the maximum number of chars accepted from the entryfield (thus overwriting the   *
 * default number of 63 and load the data from the SESSIONDATA structure SessionData    *
 * into the entryfields.                                                                *
\*                                                                                      */
    WinSendDlgItemMsg(                  /* Send message to dialog window */
        hwndDlg,                        /* Handle of dialog window */
        PIEF_PROGRAMTITLE,              /* Program title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 60 */
        MPFROMSHORT(EF_SIZE60),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Load the default text of the entryfield */
        hwndDlg,
        PIEF_PROGRAMTITLE,
        SessionData.PgmTitle);
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_PATHFILENAME,              /* Path and Filename title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText( 
        hwndDlg,
        PIEF_PATHFILENAME,
        SessionData.PgmName);
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_DIRECTORY,                 /* Working directory entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(
        hwndDlg,
        PIEF_DIRECTORY,
        SessionData.PgmDirectory);
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_PARAMETERS,                /* Program Parameters entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 255 */
        MPFROMSHORT(EF_SIZE255),
        (MPARAM)NULL);
    WinSetDlgItemText(
        hwndDlg,
        PIEF_PARAMETERS,
        SessionData.PgmInputs);
                                        /* Insert DOS Settings. If none exist add the
                                           IDLE_* default settings */
    if(strlen(SessionData.PgmDosSettings)!=0)
        WinSendDlgItemMsg(
            hwndDlg,
            PIEF_DOSSETTINGS,           /* Program DOS Settings entryfield */
            MLM_INSERT,                 /* Insert text */
            MPFROMP(SessionData.PgmDosSettings),
            (MPARAM)NULL);
    else
        WinSendDlgItemMsg(
            hwndDlg,
            PIEF_DOSSETTINGS,           /* Program DOS Settings entryfield */
            MLM_INSERT,                 /* Insert text */
            MPFROMP("IDLE_SECONDS=5\nIDLE_SENSITIVITY=100\n"),
            (MPARAM)NULL);
    if((SessionData.SessionType!=SSF_TYPE_VDM) &&
        (SessionData.SessionType!=SSF_TYPE_WINDOWEDVDM))
        WinSetWindowPos(                /* Hide DOS Settings window until the application
                                           type is DOS Window or DOS Fullscreen */
            WinWindowFromID(hwndDlg, PIEF_DOSSETTINGS), 0, 0, 0, 0, 0,SWP_HIDE);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program type group to the state indicated by *
 * the SessionData structure.                                                           *
\*                                                                                      */
    switch(SessionData.SessionType)
    {
    case SSF_TYPE_DEFAULT:
        WinSendDlgItemMsg(              /* Send message to Shell radiobutton */
            hwndDlg,                    /* Handle of dialog window */
            PIRB_SHELL,                 /* Program type: Shell radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case SSF_TYPE_FULLSCREEN:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_OS2FULLSCREEN,         /* Program type: OS/2 Fullscreen radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case SSF_TYPE_WINDOWABLEVIO:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_OS2WINDOW,             /* Program type: OS/2 Window radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case SSF_TYPE_PM:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_PM,                    /* Program type: OS/2 PM radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case SSF_TYPE_VDM:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_DOSFULLSCREEN,         /* Program type: DOS Fullscreen radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case SSF_TYPE_WINDOWEDVDM:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_DOSWINDOW,             /* Program type: DOS Window radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    }
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program style group to the state indicated   *
 * by the SessionData structure.                                                        *
\*                                                                                      */

    if(!(SessionData.PgmControl & (SSF_CONTROL_MAXIMIZE | SSF_CONTROL_MINIMIZE)))
        WinSendDlgItemMsg(              /* Send message to Default radiobutton */
            hwndDlg,                    /* Handle of dialog window */
            PIRB_DEFAULTSTYLE,          /* Program style: Default radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_MAXIMIZE)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_MAXIMIZED,             /* Program style: Maximized radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_MINIMIZE)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_MINIMIZED,             /* Program style: Minimized radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_INVISIBLE)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_INVISIBLE,             /* Program style: Invisible checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.PgmControl & SSF_CONTROL_NOAUTOCLOSE)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_NOAUTOCLOSE,           /* Program style: NoAutoClose checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    if(SessionData.FgBg & SSF_FGBG_BACK)
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_BACKGROUND,            /* Program style: Background checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
/*                                                                                      *\
 * Now we preselect the radiobutton in the Program priority group to the state          *
 * indicated by the SessionData structure.                                              *
\*                                                                                      */
    switch(SessionData.PriorityClass)
    {
    case PRTYC_NOCHANGE:
        WinSendDlgItemMsg(              /* Send message to Priority NoChange radiobutton */
            hwndDlg,                    /* Handle of dialog window */
            PIRB_NOCHANGE,              /* Program priority: NoChange radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case PRTYC_IDLETIME:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_IDLETIME,              /* Program priority: IdleTime radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case PRTYC_REGULAR:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_REGULAR,               /* Program priority: Regular radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case PRTYC_TIMECRITICAL:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_TIMECRITICAL,          /* Program priority: TimeCritical radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        break;
    case PRTYC_FOREGROUNDSERVER:
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_FOREGROUNDSERVER,      /* Program priority: ForegroundServer radiobutton */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    }
/*                                                                                      *\
 * Now we preselect the listbox in the Program priority group to the state indicated by *
 * the SessionData structure.                                                           *
\*                                                                                      */
    {
    UCHAR       Buffer[4];
    int         LoopCount;

    for(LoopCount=PRTYD_MAXIMUM; LoopCount>=PRTYD_MINIMUM; LoopCount--)
        {
        sprintf(Buffer,"%+2d",LoopCount);
        WinInsertLboxItem(              /* Insert an item to listbos */
                                        /* List box handle */
            WinWindowFromID(hwndDlg, PILB_DELTAPRIORITY),
            LIT_END,                    /* Insert at end */
            Buffer);                    /* Text to be inserted */
        }
    WinSendDlgItemMsg(                  /* Send message to Delta Priority listbox */
        hwndDlg,                        /* Handle of dialog window */
        PILB_DELTAPRIORITY,
        LM_SELECTITEM,                  /* Set selection of an item */
                                        /* Select value from SessionData */
        MPFROMSHORT(PRTYD_MAXIMUM-SessionData.PriorityDelta),
        MPFROMSHORT(TRUE));
    WinSendDlgItemMsg(                  /* Send message to Delta Priority listbox */
        hwndDlg,                        /* Handle of dialog window */
        PILB_DELTAPRIORITY,
        LM_SETTOPINDEX,                 /* Set default selection to top of the list box */
        MPFROMSHORT(PRTYD_MAXIMUM-SessionData.PriorityDelta),
        (MPARAM)NULL);
    }
/*                                                                                      *\
 * The 4 entryfields for the Size&Position are a bit more complicated to handle.        *
 * First we set the entryfields to a size of 4 and the default values are read from the *
 * SessionData structure. Only if Size&Position is selected, this 4 entryfields are not *
 * readonly.                                                                            *
\*                                                                                      */
    WinSendDlgItemMsg(                  /* Send message to dialog window */
        hwndDlg,                        /* Handle of dialog window */
        PIEF_X,                         /* Program size: X entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 4 */
        MPFROMSHORT(4),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Set a text string in a dialog item */
        hwndDlg,
        PIEF_X,
        (UCHAR *)_itoa(SessionData.InitXPos, Buffer, 10));
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_Y,                         /* Program size: Y entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 4 */
        MPFROMSHORT(4),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Set a text string in a dialog item */
        hwndDlg,
        PIEF_Y,
        (UCHAR *)_itoa(SessionData.InitYPos, Buffer, 10));
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_XSIZE,                     /* Program Size: Size X entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 4 */
        MPFROMSHORT(4),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Set a text string in a dialog item */
        hwndDlg,
        PIEF_XSIZE,
        (UCHAR *)_itoa(SessionData.InitXSize, Buffer, 10));
    WinSendDlgItemMsg(
        hwndDlg,
        PIEF_YSIZE,                     /* Program size: Size Y entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 4 */
        MPFROMSHORT(4),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Set a text string in a dialog item */
        hwndDlg,
        PIEF_YSIZE,
        (UCHAR *)_itoa(SessionData.InitYSize, Buffer, 10));
    if(!(SessionData.PgmControl & SSF_CONTROL_SETPOS))
        {
        WinSendDlgItemMsg(              /* Send message to X entryfield */
            hwndDlg,
            PIEF_X,                     /* Program size: X entryfield */
            EM_SETREADONLY,             /* Set to enable readonly */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        WinSendDlgItemMsg(              /* Send message to Y entryfield */
            hwndDlg,
            PIEF_Y,                     /* Program size: Y entryfield */
            EM_SETREADONLY,             /* Set to enable readonly */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        WinSendDlgItemMsg(              /* Send message to Size X entryfield */
            hwndDlg,
            PIEF_XSIZE,                 /* Program size: Size X entryfield */
            EM_SETREADONLY,             /* Set to enable readonly */
            MPFROMSHORT(TRUE),
        (MPARAM)NULL);
        WinSendDlgItemMsg(              /* Send message to Size Y entryfield */
            hwndDlg,
            PIEF_YSIZE,                 /* Program size: Size Y entryfield */
            EM_SETREADONLY,             /* Set to enable readonly */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
        }
    else
        WinSendDlgItemMsg(
            hwndDlg,
            PIRB_SIZEPOSITION,          /* Program style: Size&Position checkbox */
            BM_SETCHECK,                /* Set it to pressed */
            MPFROMSHORT(TRUE),
            (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
                                        /* Panel ID in ressource file */
        MPFROMSHORT(PIID_PROGRAMDIALOG),
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_CONTROL:                        /* Test for autoradio button pressed */

/*                                                                                      *\
 * The Size & Position radiobutton must be checked every time it is selected, because   *
 * only if it is selected, the user may have write access to X, Y, Size X and Size Y    *
 * entryfields, otherwise they are read only. The DOS Setting MLE is only visible if a  *
 * DOS window or fullscreen application type is selected.                               *
\*                                                                                      */
    if(SHORT2FROMMP(mp1)==BN_CLICKED)   /* Was autoradio button clicked */
        switch(SHORT1FROMMP(mp1))
        {
        case PIRB_SIZEPOSITION:         /* Program type: User defined size & position */
            if((BOOL)WinSendDlgItemMsg( /* Send message to Size & Position radiobutton */
                hwndDlg,                /* Handle of dialog window */
                PIRB_SIZEPOSITION,      /* Program size: Size & Position radiobutton */
                BM_QUERYCHECK,          /* Query the state */
                (MPARAM)NULL,
                (MPARAM)NULL)==TRUE)
            {
                SessionData.PgmControl|=SSF_CONTROL_SETPOS;
                WinSendDlgItemMsg(      /* Send message to X entryfield */
                    hwndDlg,            /* Handle of dialog window */
                    PIEF_X,             /* Program size: X entryfield */
                    EM_SETREADONLY,     /* Set to disable readonly */
                    MPFROMSHORT(FALSE),
                    (MPARAM)NULL);
                WinSendDlgItemMsg(      /* Send message to Y entryfield */
                    hwndDlg,            /* Handle of dialog window */
                    PIEF_Y,             /* Program size: Y entryfield */
                    EM_SETREADONLY,     /* Set to disable readonly */
                    MPFROMSHORT(FALSE),
                    (MPARAM)NULL);
                WinSendDlgItemMsg(      /* Send message to Size X entryfield */
                    hwndDlg,            /* Handle of dialog window */
                    PIEF_XSIZE,         /* Program size: Size X entryfield */
                    EM_SETREADONLY,     /* Set to disable readonly */
                    MPFROMSHORT(FALSE),
                    (MPARAM)NULL);
                WinSendDlgItemMsg(      /* Send message to Size Y entryfield */
                    hwndDlg,            /* Handle of dialog window */
                    PIEF_YSIZE,         /* Program size: Size Y entryfield */
                    EM_SETREADONLY,     /* Set to disable readonly */
                    MPFROMSHORT(FALSE),
                    (MPARAM)NULL);
            }
            else
            {
                WinSendDlgItemMsg(      /* Send message to X entryfield */
                    hwndDlg,            /* Handle of dialog window */
                    PIEF_X,             /* Program size: X entryfield */
                    EM_SETREADONLY,     /* Set to enable readonly */
                    MPFROMSHORT(TRUE),
                    (MPARAM)NULL);
                WinSendDlgItemMsg(      /* Send message to Y entryfield */
                    hwndDlg,            /* Handle of dialog window */
                    PIEF_Y,             /* Program size: Y entryfield */
                    EM_SETREADONLY,     /* Set to enable readonly */
                    MPFROMSHORT(TRUE),
                    (MPARAM)NULL);
                WinSendDlgItemMsg(      /* Send message to Size X entryfield */
                    hwndDlg,            /* Handle of dialog window */
                    PIEF_XSIZE,         /* Program size: Size X entryfield */
                    EM_SETREADONLY,     /* Set to enable readonly */
                    MPFROMSHORT(TRUE),
                    (MPARAM)NULL);
                WinSendDlgItemMsg(      /* Send message to Size Y entryfield */
                    hwndDlg,            /* Handle of dialog window */
                    PIEF_YSIZE,         /* Program size: Size Y entryfield */
                    EM_SETREADONLY,     /* Set to enable readonly */
                    MPFROMSHORT(TRUE),
                    (MPARAM)NULL);
            }
            break;

        case PIRB_DOSFULLSCREEN:
        case PIRB_DOSWINDOW:
            WinSetWindowPos(            /* Show DOS Settings window */
                WinWindowFromID(hwndDlg, PIEF_DOSSETTINGS), 0, 0, 0, 0, 0,SWP_SHOW);
            break;

        case PIRB_SHELL:
        case PIRB_OS2FULLSCREEN:
        case PIRB_OS2WINDOW:
        case PIRB_PM:
            WinSetWindowPos(            /* Hide DOS Settings window until the application
                                           type is DOS Window or DOS Fullscreen */
                WinWindowFromID(hwndDlg, PIEF_DOSSETTINGS), 0, 0, 0, 0, 0,SWP_HIDE);
            break;
        }
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case PIPB_WINFILEDLG:               /* Locate file by standard file dialog */
/*                                                                                      *\
 * The user selected the File Find pushbutton to get the standard file dialog to find   *
 * the program he wants to install.                                                     *
\*                                                                                      */
        {
        FILEDLG fdFileDlg;              /* Standard file dialog control */
        HWND    hwndFileDlg;            /* Handle of standard file dialog */

                                        /* Clear out structure */
        memset(&fdFileDlg, 0, sizeof(FILEDLG));
                                        /* Structure size */
        fdFileDlg.cbSize=sizeof(FILEDLG);
                                        /* FDS_* flags */
        fdFileDlg.fl=FDS_CENTER | FDS_OPEN_DIALOG | FDS_PRELOAD_VOLINFO;
                                        /* Dialog title string */
        fdFileDlg.pszTitle="PC/2 File Search";
                                        /* Initial path, filename or file filter */
        strcpy(fdFileDlg.szFullFile, "C:\\*");
                                        /* Open the standard file dialog ...*/
        hwndFileDlg=WinFileDlg(HWND_DESKTOP, hwndDlg, &fdFileDlg);
        if(hwndFileDlg && (fdFileDlg.lReturn==DID_OK))
            {                           /* Load the values of the standard file dialog to
                                           the corresponding entryfield in the Program
                                           installation dialog */
            UCHAR       *pucTemp;
            UCHAR       ucBuffer[256];
            BOOL        bBatchFile=FALSE;

                                        /* Get filename and convert is to uppercase */
            strcpy(ucBuffer, fdFileDlg.szFullFile);
            strupr(ucBuffer);
                                        /* Now test for a OS/2 batch file */
            if(strstr(ucBuffer, ".CMD")!=NULL)
                {
                bBatchFile=TRUE;
                if(strchr(ucBuffer, ' ')!=NULL)
                    {                   /* If path and filename contains spaces, insert
                                           two quotation marks */
                    strcpy(ucBuffer, "/c \"\"");
                    strcat(ucBuffer, fdFileDlg.szFullFile);
                    strcat(ucBuffer, "\"\"");
                    }
                else
                    {                   /* Else add just /c to [path]filename.cmd */
                    strcpy(ucBuffer, "/c ");
                    strcat(ucBuffer, fdFileDlg.szFullFile);
                    }
                }
                                        /* Now test for a DOS batch file */
            if(strstr(ucBuffer, ".BAT")!=NULL)
                {
                bBatchFile=TRUE;
                                        /* Add just /c to [path]filename.cmd */
                    strcpy(ucBuffer, "/c ");
                    strcat(ucBuffer, fdFileDlg.szFullFile);
                }
            if(bBatchFile==TRUE)
                WinSetDlgItemText(      /* Set batchfile as parameter */
                    hwndDlg,
                    PIEF_PARAMETERS,
                    ucBuffer);
            else
                WinSetDlgItemText(      /* Set full qualified path */
                    hwndDlg,
                    PIEF_PATHFILENAME,
                    fdFileDlg.szFullFile);
                                        /* Get filename */
            pucTemp=fdFileDlg.szFullFile+strlen(fdFileDlg.szFullFile);
            for( ; (*pucTemp!='\\') && (pucTemp>=fdFileDlg.szFullFile); pucTemp--);
            WinSetDlgItemText(          /* Set filename */
                hwndDlg,
                PIEF_PROGRAMTITLE,
                (pucTemp+1));
            *pucTemp='\0';              /* Get path as working directory */
            WinSetDlgItemText(          /* Set working directory */
                hwndDlg,
                PIEF_DIRECTORY,
                fdFileDlg.szFullFile);
            }
        }
                                        /* Prevent to dismiss program installation dialog
                                           by exiting switch via a break statement */
        return((MRESULT)FALSE);

    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query the Program Title, Filename, Parameters and DOS Settings and copy them to the  *
 * corresponding entries in the StartSession structure.                                 *
\*                                                                                      */
        WinQueryWindowText(             /* Query data entered in Program title entry */
            WinWindowFromID(hwndDlg, PIEF_PROGRAMTITLE),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmTitle),
            SessionData.PgmTitle);
        WinQueryWindowText(             /* Query data entered in Path and Filename entry */
            WinWindowFromID(hwndDlg, PIEF_PATHFILENAME),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmName),
            SessionData.PgmName);
        WinQueryWindowText(             /* Query data entered in working Directory entry */
            WinWindowFromID(hwndDlg, PIEF_DIRECTORY),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmDirectory),
            SessionData.PgmDirectory);
        WinQueryWindowText(         /* Query data entered in Parameters entry */
            WinWindowFromID(hwndDlg, PIEF_PARAMETERS),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmInputs),
            SessionData.PgmInputs);
        WinQueryWindowText(             /* Query data entered in DOS Settings MLE */
            WinWindowFromID(hwndDlg, PIEF_DOSSETTINGS),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmDosSettings),
            SessionData.PgmDosSettings);
/*                                                                                      *\
 * Query the Program Type radiobuttons and set the corresponding bit into the           *
 * StartSession structure. No change or the default selection are preselected during    *
 * WM_INITDLG. It must be one of them set, so we don't need else parts for if-else.     *
\*                                                                                      */
                                        /* Program type: WPS default */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_SHELL))
            SessionData.SessionType=SSF_TYPE_DEFAULT;
                                        /* Program type: OS/2 Fullscreen */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_OS2FULLSCREEN))
            SessionData.SessionType=SSF_TYPE_FULLSCREEN;
                                        /* Program type: OS/2 Window */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_OS2WINDOW))
            SessionData.SessionType=SSF_TYPE_WINDOWABLEVIO;
                                        /* Program type: PM */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_PM))
            SessionData.SessionType=SSF_TYPE_PM;
                                        /* Program type: DOS Fullscreen */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_DOSFULLSCREEN))
            SessionData.SessionType=SSF_TYPE_VDM;
                                        /* Program type: DOS Window */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_DOSWINDOW))
            SessionData.SessionType=SSF_TYPE_WINDOWEDVDM;
/*                                                                                      *\
 * Query Program Style radiobuttons and set the corresponding bits in the StartSession  *
 * structure. No change or the default selection are preselected during WM_INITDLG.     *
\*                                                                                      */
                                        /* Program style: Maximized */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_MAXIMIZED))
            SessionData.PgmControl|=SSF_CONTROL_MAXIMIZE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_MAXIMIZE);
                                        /* Program style: Minimized */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_MINIMIZED))
            SessionData.PgmControl|=SSF_CONTROL_MINIMIZE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_MINIMIZE);
                                        /* Program style: Invisible */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_INVISIBLE))
            SessionData.PgmControl|=SSF_CONTROL_INVISIBLE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_INVISIBLE);
                                        /* Program style: No autoclose */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_NOAUTOCLOSE))
            SessionData.PgmControl|=SSF_CONTROL_NOAUTOCLOSE;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_NOAUTOCLOSE);
                                        /* Program style: Background */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_BACKGROUND))
            SessionData.FgBg|=SSF_FGBG_BACK;
        else
            SessionData.FgBg&=(~SSF_FGBG_BACK);
/*                                                                                      *\
 * Query Size & Position radiobutton, set the corresponding bit, and load the values    *
 * from the corresponding entryfields for the StartSession structure.                   *
\*                                                                                      */
        {
        UCHAR   Buffer[4];

        if(WinQueryButtonCheckstate(hwndDlg, PIRB_SIZEPOSITION))
            SessionData.PgmControl|=SSF_CONTROL_SETPOS;
        else
            SessionData.PgmControl&=(~SSF_CONTROL_SETPOS);
        WinQueryWindowText(             /* Query data entered in Parameters entry */
            WinWindowFromID(hwndDlg, PIEF_X),
                                        /* into temporary structure */
            sizeof(Buffer),
            Buffer);
        SessionData.InitXPos=(USHORT)atol(Buffer);
        WinQueryWindowText(
            WinWindowFromID(hwndDlg, PIEF_Y),
            sizeof(Buffer),
            Buffer);
        SessionData.InitYPos=(USHORT)atol(Buffer);
        WinQueryWindowText(
            WinWindowFromID(hwndDlg, PIEF_XSIZE),
            sizeof(Buffer),
            Buffer);
        SessionData.InitXSize=(USHORT)atol(Buffer);
        WinQueryWindowText(
            WinWindowFromID(hwndDlg, PIEF_YSIZE),
            sizeof(Buffer),
            Buffer);
        SessionData.InitYSize=(USHORT)atol(Buffer);
        }
/*                                                                                      *\
 * Query Program Priority radiobuttons and set the corresponding bits in the            *
 * StartSession structure. The default priority is No-Change. The listbox is also       *
 * queried and the Delta Priority is also set in the StartSession structure. It must be *
 * one of the radiobuttons, so else part of if-else is not required.                    *
\*                                                                                      */
                                        /* Program Priority: No-Change */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_NOCHANGE))
            SessionData.PriorityClass=PRTYC_NOCHANGE;
                                        /* Program Priority: Idle-time */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_IDLETIME))
            SessionData.PriorityClass=PRTYC_IDLETIME;
                                        /* Program Priority: Regular */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_REGULAR))
            SessionData.PriorityClass=PRTYC_REGULAR;
                                        /* Program Priority: Time-critical */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_TIMECRITICAL))
            SessionData.PriorityClass=PRTYC_TIMECRITICAL;
                                        /* Program Priority: Server */
        if(WinQueryButtonCheckstate(hwndDlg, PIRB_FOREGROUNDSERVER))
            SessionData.PriorityClass=PRTYC_FOREGROUNDSERVER;
                                        /* Query index of selected item on correct it */
        SessionData.PriorityDelta=(
            WinQueryLboxSelectedItem(
                WinWindowFromID(hwndDlg, PILB_DELTAPRIORITY))
            -PRTYD_MAXIMUM)*(-1);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Menu Installation dialog.                   *
 * Req:                                                                                 *
 *      SessionData ... a structure of type SESSIONDATA where the information entered   *
 *                      in the dialog is entered. If DID_OK is pressed this structure   *
 *                      is used to start the session and set its priority.              *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY MI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2,
        (swpScreen.cy-swp.cy)/2,
        0,
        0,
        SWP_MOVE);
/*                                                                                      *\
 * Set the maximum number of chars accepted from the entryfield (thus overwriting the   *
 * default number of 63.                                                                *
\*                                                                                      */
    WinSendDlgItemMsg(                  /* Send message to dialog window */
        hwndDlg,                        /* Handle of dialog window */
        MIEF_MENUTITLE,                 /* Program submenu title entryfield */
        EM_SETTEXTLIMIT,                /* Set text limit to 60 */
        MPFROMSHORT(EF_SIZE60),
        (MPARAM)NULL);                  /* No additional parameter */
    WinSetDlgItemText(                  /* Set text of title entryfield */
        hwndDlg,
        MIEF_MENUTITLE,
        SessionData.PgmTitle);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(
        hwndHelp,                       /* Help window */
        HM_DISPLAY_HELP,                /* Display a help panel */
        MPFROMSHORT(MIID_MENUDIALOG),   /* Panel ID in ressource file */
        HM_RESOURCEID);                 /* MP1 points to the help window identity */
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
/*                                                                                      *\
 * Query the Submenu Title and copy it to the corresponding entry in the StartSession   *
 * structure.                                                                           *
\*                                                                                      */
        WinQueryWindowText(             /* Query data entered in Submenu title entry */
            WinWindowFromID(hwndDlg, MIEF_MENUTITLE),
                                        /* into SessionData structure */
            sizeof(SessionData.PgmTitle),
            SessionData.PgmTitle);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - ShutDown OS/2 dialog.                       *
 * Req: none                                                                            *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY SD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    WinQueryWindowPos(                  /* Query position of dialog window */
        hwndDlg,                        /* Handle of dialog window */
        &swp);                          /* Fill with position */
    WinSetWindowPos(                    /* Set dialog window position */
        hwndDlg,                        /* Handle of dialog window */
        HWND_TOP,                       /* Position on top and center of DESKTOP */
        (swpScreen.cx-swp.cx)/2,
        (swpScreen.cy-swp.cy)/2,
        0,
        0,
        SWP_MOVE);
    WinPostMsg(hwndDlg, WM_SHUTDOWN, NULL, NULL);
    break;
    }

/*                                                                                      *\
 * Syntax: WM_SHUTDOWN, NULL, NULL                                                      *
\*                                                                                      */
case WM_SHUTDOWN:
/*                                                                                      *\
 * Wait for 2 seconds and then shut down OS/2.                                          *
\*                                                                                      */
    DosSleep(02000);
    DosShutdown(0);
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}

/*--------------------------------------------------------------------------------------*\
 * This dialog procedure handles the PC/2 - Startup Parameters dialog.                  *
 * Req: *PgmInputs .....A pointer to a string of commandline params of an application   *
\*--------------------------------------------------------------------------------------*/
MRESULT  EXPENTRY SU_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
static COMMANDLINEPARAMS        *pCLPParams;

switch(msg)
{
case WM_INITDLG:
    {
    SWP         swp;
    UCHAR       ucBuffer[EF_SIZE255+1];

    WinDefDlgProc(hwndDlg, msg, mp1, mp2);
    pCLPParams=PVOIDFROMMP(mp2);
/*                                                                                      *\
 * Load text from CLPParams into the dialog box text fields, and set the text limit of  *
 * the entryfield to 127.                                                               *
\*                                                                                      */
    sprintf(ucBuffer, "%s[...] %s", pCLPParams->ucPBefore, pCLPParams->ucPAfter);
                                        /* User information text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPINFO, pCLPParams->ucPUser);
                                        /* Current parameters text field */
    WinSetDlgItemText(hwndDlg, SUTF_STARTUPPARAMETERS, ucBuffer);
    WinSendDlgItemMsg(hwndDlg, SUEF_STARTUPPARAMETERS, EM_SETTEXTLIMIT,
        MPFROMSHORT(EF_SIZE60), (MPARAM)NULL);
    break;
    }

case WM_HELP:                           /* Help pressed */
    if(hwndHelp!=NULLHANDLE) WinSendMsg(hwndHelp, HM_DISPLAY_HELP,
        MPFROMSHORT(SUID_STARTUPDIALOG), HM_RESOURCEID);
    break;

case WM_COMMAND:                        /* Button pressed */
    switch(SHORT1FROMMP(mp1))
    {
    case DID_OK:                        /* Enter key pressed */
        WinQueryWindowText(WinWindowFromID(hwndDlg, SUEF_STARTUPPARAMETERS),
            sizeof(pCLPParams->ucPUser), pCLPParams->ucPUser);
        DialogResult=DID_OK;            /* Dialog terminated with DID_OK */
        break;

    case DID_CANCEL:                    /* Escape or Cancel pressed */
        DialogResult=DID_CANCEL;        /* Dialog terminated with DID_CANCEL */
        break;

    default:
        return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
    }
    WinDismissDlg(hwndDlg, TRUE);       /* Clear up dialog */
    break;

default:                                /* Default window procedure must be called */
    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
return((MRESULT)FALSE);                 /* We have handled the message */
}


