/***********************************************************************\
 *                                PC2.c                                *
 *                 Copyright (C) by Stangl Roman, 1993                 *
 * This Code may be freely distributed, provided the Copyright isn't   *
 * removed, under the conditions indicated in the documentation.       *
 *                                                                     *
 * PC2.h        Program Commander/2 header file.                       *
 *                                                                     *
\***********************************************************************/

#ifndef IPFC                            /* Don't include if we compile HLP files */
#define         INCL_WINDIALOGS         /* Environment include files */
#define         INCL_WIN
#define         INCL_DOSFILEMGR
#define         INCL_DOSSESMGR
#define         INCL_DOSPROCESS
#define         INCL_DOSERRORS
#define         INCL_DOSSEMAPHORES
#define         INCL_DOSMODULEMGR
#include        <os2.h>

#include        <stdio.h>               /* C Set/2 include files */
#include        <stdlib.h>
#include        <string.h>
#include        <ctype.h>
#endif

#define         EF_SIZE60       60
#define         EF_SIZE255      255

typedef void (EXPENTRY PFFUNCPTR1)(ULONG ulC, HWND hD, HWND hP);
typedef BOOL (EXPENTRY PFFUNCPTR2)(HAB hab, PQMSG pqmsg, ULONG option);
typedef struct _SESSIONDATA             SESSIONDATA;
typedef struct _MENUDATA                MENUDATA;
typedef struct _COMMANDLINEPARAMS       COMMANDLINEPARAMS;

#define         ENTRYSUBMENU    0
#define         ENTRYMENUITEM   1
#define         ENTRYEMPTY      2

struct _SESSIONDATA                     /* Control structure to start a new session */
{
ULONG           id;                     /* Session ID for menu ressources */
UCHAR           PgmTitle[EF_SIZE60+1];  /* Session title */
UCHAR           PgmName[EF_SIZE255+1];  /* Session path and filename */
                                        /* Session working directory */
UCHAR           PgmDirectory[EF_SIZE255+1];
                                        /* Session parameter */
UCHAR           PgmInputs[EF_SIZE255+1];
UCHAR           PgmDosSettings[2049];   /* DOS Settings for DOS sessions */
USHORT          SessionType;            /* Session type */
USHORT          PgmControl;             /* Session control */
USHORT          FgBg;                   /* Start session in foreground/background */
USHORT          InitXPos;               /* X position */
USHORT          InitYPos;               /* Y position */
USHORT          InitXSize;              /* X size */
USHORT          InitYSize;              /* Y size */
ULONG           PriorityClass;          /* Priority of started session */
LONG            PriorityDelta;          /* Delta priority of started session */
};

struct _MENUDATA                        /* Control structure to build popup menu */
{
USHORT          Item;                   /* MENUITEM or SUBMENU */
HWND            hwndItem;               /* Window handle within Popup-Menu */
ULONG           id;                     /* Session ID for menu ressources */
PSZ             PgmTitle;               /* Session title */
PSZ             PgmName;                /* Session path and filename */
PSZ             PgmDirectory;           /* Session working directory */
PSZ             PgmInputs;              /* Session parameter */
PSZ             PgmDosSettings;         /* Session settings for DOS applications */
USHORT          SessionType;            /* Session type */
USHORT          PgmControl;             /* Session control */
USHORT          FgBg;                   /* Start session in foreground/background */
USHORT          InitXPos;               /* X position */
USHORT          InitYPos;               /* Y position */
USHORT          InitXSize;              /* X size */
USHORT          InitYSize;              /* Y size */
ULONG           PriorityClass;          /* Priority of started session */
LONG            PriorityDelta;          /* Delta priority of started session */
MENUDATA        *Back;                  /* Pointer to previous menu */
MENUDATA        *Submenu;               /* Pointer to a submenu */
MENUDATA        *Next;                  /* Pointer to next menu */
};

struct  _COMMANDLINEPARAMS
{
UCHAR           ucPBefore[EF_SIZE60+1]; /* Parameters before user requested parameter */
UCHAR           ucPUser[128];           /* User requested parameter */
UCHAR           ucPAfter[EF_SIZE60+1];  /* Parameters after user requested parameter */
};

#define ID_PC2MAINWINDOW        256
#define ID_OS2LOGO              257

#define PC2_CLASSNAME           "PC2"

#define ID_PC2SETUP             300     /* Defines for PopUp Menu, that is popped up after
                                           the user presses mouse button 1 on DESKTOP */
#define ID_CONFIGDIALOG         301     /* User pressed Configure PC/2 */
#define ID_ABOUTDIALOG          302     /* User pressed About PC/2 */
#define ID_EXIT                 303     /* User pressed F3 to exit PC/2 */
#define ID_SHUTDOWN             304     /* User pressed ShutDown OS/2 */

#define PIID_PROGRAMDIALOG      500     /* Program installation dialog */
#define PIGRP_PROGRAM           501     /* Program data group */
#define PIEF_PROGRAMTITLE       502
#define PIEF_PATHFILENAME       503
#define PIEF_DIRECTORY          504
#define PIEF_PARAMETERS         505
#define PIEF_DOSSETTINGS        506
#define PIPB_WINFILEDLG         507

#define PIGRP_TYPE              510     /* Program type group */
#define PIRB_SHELL              511
#define PIRB_OS2FULLSCREEN      512
#define PIRB_OS2WINDOW          513
#define PIRB_PM                 514
#define PIRB_DOSFULLSCREEN      515
#define PIRB_DOSWINDOW          516

#define PIGRP_STYLE             520     /* Program style group */
#define PIRB_DEFAULTSTYLE       521
#define PIRB_MAXIMIZED          522
#define PIRB_MINIMIZED          523
#define PIRB_SIZEPOSITION       524
#define PIRB_INVISIBLE          525
#define PIRB_NOAUTOCLOSE        526
#define PIRB_BACKGROUND         527

#define PIGRP_SIZEPOSITION      530     /* User defined size & position */
#define PIEF_X                  531
#define PIEF_Y                  532
#define PIEF_XSIZE              533
#define PIEF_YSIZE              534

#define PIGRP_PROCESSPRIORITY   540     /* Process priority */
#define PIRB_IDLETIME           541
#define PIRB_REGULAR            542
#define PIRB_NOCHANGE           543
#define PIRB_TIMECRITICAL       544
#define PIRB_FOREGROUNDSERVER   545
#define PILB_DELTAPRIORITY      546
#define PICB_CHILDPROCESS       547

#define PIID_HELP_1             550     /* Help pages */
#define PIID_HELP_2             551
#define PIID_HELP_3             552
#define PIID_HELP_4             553
#define PIID_HELP_5             554
#define PIID_HELP_6             555


#define ADID_ABOUTDIALOG        600     /* About program dialog */

#define CDID_CONFIGDIALOG       700     /* Configuration menu dialog */
#define CDGRP_PROGRAM           701     /* Submenu/Program installation group */
#define CDLB_MENUPROGRAM        702
#define CDID_LEVELUP            703
#define CDID_LEVELDOWN          704
#define CDID_ADDMENU            705
#define CDID_ADDPROGRAM         706
#define CDID_CHANGEENTRY        707
#define CDID_REMOVEENTRY        708

#define CDID_HELP_1             710     /* Help pages */
#define CDID_HELP_2             711

#define MIID_MENUDIALOG         800     /* Menu installation dialog */
#define MIGRP_PROGRAM           801     /* Menu data group */
#define MIEF_MENUTITLE          802

#define MIID_HELP_1             810     /* Help page */

#define SDID_SHUTDOWNDIALOG     900     /* OS/2 ShutDown dialog */
#define SDID_SHUTDOWNMESSAGE    901     /* Message diaplayed a ShutDown */

#define SUID_STARTUPDIALOG      950     /* Request parameters from user before launching
                                           an application */
#define SUTF_STARTUPINFO        951     /* Info to the user what to do */
#define SUTF_STARTUPPARAMETERS  952     /* Info to the user of current parameters */
#define SUEF_STARTUPPARAMETERS  953     /* Entryfield for user data */

#define ID_POPUPMENU            1000    /* ID used by first user entered entry in the 
                                           popup menu. It is incremented by 1 by tracing
                                           through the linked list for each entry (submenu
                                           or menuitem). */
#define USERITEMFIRST           ID_POPUPMENU
#define USERITEMLAST            ID_POPUPMENU+100

#define ID_HELP                 2000    /* ID used for HELP panels */
#define MAIN_HELP_TABLE         2001
#define MAIN_HELP_SUBTABLE      2002
#define ID_GENERALHELP          2003
#define ID_CONCEPTSHELP         2004
#define ID_USINGHELP            2005
#define ID_ERRORHELP            2006
#define ID_ERRORHELP_1          2007
#define ID_INSTALLATIONHELP     2008

                                        /* New messages for the configuration menu dialog */
                                        /* Load the current level into configuration listbox */
#define WM_LOADPOPUPMENU        WM_USER+1
                                        /* Initialize the input queue hook */
#define WM_LOADHOOK             WM_USER+2
                                        /* Save Popup-Menu to Profile */
#define WM_SAVEPOPUPMENU        WM_USER+3
                                        /* Load Popup-Menu from Profile */
#define WM_SETPOPUPMENU         WM_USER+4
                                        /* Display Popup-Menu on Desktop */
#define WM_POPUPMENU            WM_USER+5

                                        /* Insert an item to the linked list */
#define MM_INSERTITEMMENUITEM   WM_USER+6
                                        /* Change the first item of a Submenu to an item */
#define MM_INSERTITEMSUBMENU    WM_USER+7
                                        /* ShutDown message to ShutDown dialog */
#define WM_SHUTDOWN             WM_USER+8

                                        /* Procedures */
extern int      main(int argc, char *argv[], char *envp[]);
extern BOOL     WinStartUp(HAB *pHab, HMQ *pHmq);
extern BOOL     WinStartHelp(HAB hab, UCHAR *pHelpfile, HWND *pHwndHelp);
extern BOOL     WinCloseDown(HWND *pHwndHelp, HAB *pHab, HMQ *pHmq);
extern void     StartSession(SESSIONDATA *SessionData);
extern BOOL     LoadMenuData2SessionData(BOOL Empty, MENUDATA *pMenuData, SESSIONDATA *pSessionData);
extern BOOL     LoadSessionData2MenuData(MENUDATA *pMenuData, SESSIONDATA *pSessionData);
extern MENUDATA *AllocateMenuData(void);
extern void     LoadMenu(MENUDATA *pMenuData);
extern void     SaveMenu(MENUDATA *pMenuData);
extern BOOL     SetPopupMenu(MENUDATA *pMD, ULONG msg, LONG id);
extern MENUDATA *SearchItem(MENUDATA *pMD, ULONG *id);

                                        /* Window procedures */
extern MRESULT  EXPENTRY PC2_MainWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY PI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY AD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY MI_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY CD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SD_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);
extern MRESULT  EXPENTRY SU_DialogProcedure(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);

extern HAB              hab;            /* Handle of PM anchor block */
extern HMQ              hmq;            /* Handle of message queue */
extern HWND             hwndFrame;
extern HWND             hwndClient;
extern HWND             hwndPopupMenu;  /* Handel of popup menu window */
extern HWND             hwndHelp;
extern SESSIONDATA      SessionData;
extern MENUDATA         *pPopupMenu;    /* First entry of linked list of menus */
extern USHORT           DialogResult;   /* Result of last dialog */
extern USHORT           MenuDataId;     /* Id of the items in the Popup-Menu and linked list */
extern FILE             *Pc2Profile;    /* Profile filename */
extern SWP              swpScreen;      /* The screen dimensions */

