/****************************************************************************
*
*   cbrief.h                                            21Apr91
*
*   Standard definitions for Brief macros
*
*   Copyright (c) 1990 B. Goldstein -- Pequod Software
*
*   Change History:
*   Date    Who What
*   12Mar90 BAG First draft
*   21Apr91 BAG Added defines for _save_mode
*
****************************************************************************/

/* mark types */
#define NORMAL_MARK       1
#define COLUMN_MARK       2
#define LINE_MARK         3
#define NONINCLUSIVE_MARK 4

/* register macro types */
#define NEW_CHAR_MACRO       0
#define ALT_N_MACRO          1
#define ALT_H_MACRO          2
#define UNASSIGNED_KEY_MACRO 3
#define IDLE_MACRO           4
#define EXIT_MACRO           5
#define ALT_E_MACRO          6
#define CTRL_BREAK_MACRO     7
#define INVALID_CHAR_MACRO   8

/* regular expression types */
#define RE_OFF   0
#define FWD_MIN  1
#define DEF_MIN  2
#define BWD_MIN  3
#define FWD_MAX -1
#define DEF_MAX -2
#define BWD_MAX -3  

/* search and translate flags */
#define CASE_SENSITIVE   1
#define CASE_INSENSITIVE 0
#define CASE_DEFAULT     NULL
#define BLOCK_SEARCH  1
#define BUFFER_SEARCH 0
#define GLOBAL_TRANSLATE 1
#define SINGLE_TRANSLATE 0
#define RET_TOTAL_LENGTH 1

/* translate directions */
#define FORWARD  1
#define BACKWARD 0

/* keyboard states */
#define RIGHT_SHIFT 0x0001
#define LEFT_SHIFT  0x0002
#define CTRL        0x0004
#define ALT         0x0008
#define SCROLL_LOCK 0x0010
#define NUM_LOCK    0x0020
#define CAPS_LOCK   0x0040

/* window directions */
#define ABOVE 0
#define RIGHT 1
#define BELOW 2
#define LEFT  3

/* shift directions */
#define UP   1
#define DOWN 2

/* for use with restore_position */
#define MOVE     1
#define DONTMOVE 0

/* buffer types */
#define SYSTEM_BUFF 1
#define NONSYS_BUFF 0
#define ALL_BUFFS    1
#define NONSYS_BUFFS 0

/* push_back flags */
#define FIFO 1
#define LIFO 0

/* dos flags */
#define USE_SHELL 1
#define NO_SHELL  0
#define WAIT      0
#define NO_WAIT   1 

/* cut, copy */
#define REPLACE 0
#define APPEND  1

/* atoi flag */
#define STANDARD    1
#define SINGLE_CHAR 0

/* message levels */
#define ALL_MESSAGES    0
#define NO_MESSAGES     1
#define NO_ERRORS       2
#define NO_MSGS_OR_ERRS 3

/* search_case settings */
#define SET_CASE_SENSITIVE   0
#define SET_CASE_INSENSITIVE 1

/* insert_mode */
#define INSERT_MODE     1
#define OVERSTRIKE_MODE 0

/* pause_on_error */
#define PAUSE_ON  1
#define PAUSE_OFF 0

/* keyboard_pop */
#define SAVE_MAP 1

/* drop_bookmark */
#define OVERWRITE_YES "y"
#define OVERWRITE_NO  "n"

/* playback */
#define PLAY_NOW  1
#define LOAD_ONLY 0

/* exit (are you sure (ynw)? */
#define EXIT_NOWRITE "y"
#define EXIT_WRITE   "w"

/* edit_file returns */
#define OLD_BUFFER 1
#define NEW_BUFFER 2

/* Miscellaneous */
#define FOREVER 1
#define TRUE 1
#define ON   1
#define YES  1
#define FALSE 0
#define OFF   0
#define NO    0

#define bool int

/* for _save_mode (see backup.cb, restore.cb, bag.m) */
#define SAVE_NO    0
#define SAVE_BTMP  1
#define SAVE_BFILE 2

/************************* end of cbrief.h file ****************************/
