//		Test NDX v3.0

#include	"ndx.h"
#include	<stdlib.h>

void Index::print(char *filename)
{
    Node *node = new Node;
    unsigned long *blocks;
    int cblock = 0, last_block = 1;
    FILE *file = fopen(filename? filename: "CON", "w");

    blocks =(unsigned long *)calloc(20, sizeof(long));
	*blocks = root;
    if (! *blocks) {
        fputs("Empty index\n", file);
        return;
    }
    for (; cblock < last_block; cblock++) {
        Key *kp, *end;

        read(blocks[cblock], node, nodesize);
        kp = (Key *)node->keys;
        end = (Key *)(node->keys + node->endkeys);

		fprintf(file, "\nBlock at %lu\n", blocks[cblock]);
        for (; kp < end; (char *)kp += 2*sizeof(long) + strlen(kp->data)
            + 1) {
            if (kp->lson)
                blocks[last_block++] = kp->lson;
            fprintf(file, "         %-8lu %-8s %-8lu\n",
                kp->lson, kp->data, kp->offset);
        }
        if (kp->lson) {
            blocks[last_block++] = kp->lson;
            fprintf(file, "         %-8lu\n", kp->lson);
        }
	}
    free(node);
    free(blocks);
    fclose(file);
}

Index *index;
Key *entry = new Key;
int seed = 16383;
unsigned rval[10000];

void output()
{
	index->print("t.tmp");
}

void check(int i, int j, int last)
{
    while (j--) {
        printf("%5u\r", j);
        if (! i++) index->first(last);
        else if (! (last? index->prev(): index->next())) {
            printf("Key <%u, %u> not found\n", last? j + 1: i,
					rval[last? j: i - 1]);
            output();
			exit(-1);
            }
        }
    printf("All keys accessible on %s scan\n", last? "backward":
            "forward");
}

main(int argc, char **argv)
{
    int n = atoi(argv[1]), i, j, m = (argc >= 2? atoi(argv[2]): 0);
    int fault = 0;

	if (argc < 2) {
        puts("\n\tUsage: NDX <number of keys> [<modulus>] [print]\n\n"
            "\tAny third argument causes the index to be printed\n"
            "\tUse of the second argument exercises the ISAM feature\n"
            "\n\tTry NDX 200 10 0, for instance\n");
        exit(-1);
        }
    srand(seed);
	for (i = 0; i < n; i++) rval[i] = m? rand() % m: rand() + 1;
	index = new Index("T.NDX", FIFO);
    entry->lson = 0L;
    for (i = 1; i <= n; i++) {
		sprintf(entry->data, "%u", rval[i - 1]);
		entry->offset = i;
        index->insert(entry->data, entry->offset);
        }
    puts("Keys written");
    if (!index->isvalid()) return puts("Index is not valid");
    delete index;
    index = new Index("t.ndx");
    check(0, n, 0);
    check(0, n, 1);
    if (argc > 3) {index->print(NULL); return 0; }
    for (i = 1; i <= n; i++) {
		sprintf(entry->data, "%u", rval[i - 1]);
        entry->offset = i;
        if (! index->remove(entry->data, entry->offset)) {
            printf("Delete failure: record %-u, data %-s\a\a\n", i, entry->data);
            output();
            fault++;
            break;
            }
		  else if (index->findkeyrec(entry->data, entry->offset)) {
			printf("Key <%u, %u> not deleted!\n", i, rval[i - 1]);
            output();
            fault++;
            break;
            }
    }
    output();
    delete index;
    if (! fault) puts("All keys successfully deleted");
    return fault;
}
