









                                                (tm)
                                    AS-EASY-AS...
                                   Version  5.5







                                   USER'S MANUAL
                                   ~~~~~~~~~~~~~







                                     TRIUS, Inc.
                                    P.O. Box 249
                            N. Andover, MA  01845-0249

                                 Tel. (508) 794-9377
                                 Fax. (508) 688-6312
                                 BBS  (508) 794-0762
                                 CIS. 71333,103








                         Copyright 1985 - 1992, TRIUS, Inc.
                           All Rights Reserved Worldwide

      +-------------------------------------------------------------------+
      | This document is for evaluating the Shareware copy of AS-EASY-AS! |
      |   Use of the software package and this document beyond a 30-day   |
      |             evaluation period requires registration!              |
      |             ----------------------------------------              |
      |    Distribution of printed copies of this manual is Prohibited!   |
      +-------------------------------------------------------------------+


    COPYRIGHT NOTICE
    ~~~~~~~~~~~~~~~~
    AS-EASY-AS(tm) is a copyrighted software product developed and owned
    by TRIUS, Inc. located in North Andover, Massachusetts, U.S.A.

    You may make and keep back-up copies of the software for your personal
    use, provided that you copy all the copyright, trademark, and other
    information indicated on the initial screen display, on each backup
    copy label.

    The rights to receive any financial or other benefit, and to modify
    the product or employ its components in any kind of derivative work,
    are reserved exclusively by TRIUS, Inc.

    You may not reverse-engineer, disassemble, modify, decompile or create
    derivative works of the product.  You acknowledge that the product
    includes certain trade secrets and confidential information, all of
    which is the copyrighted intellectual property of TRIUS, Inc.

    AS-EASY-AS is a trademark of TRIUS Inc. and the TRIUS Logo is a
    trademark of TRIUS, Inc.  All rights are reserved worldwide.

    The AS-EASY-AS User's Manual is copyrighted and all rights are
    reserved. The reproduction of this document, in whole or part, its
    conversion to electronic medium or its distribution in printed form
    (hard copy) are prohibited unless prior consent, in writing, has been
    given by TRIUS, Inc.

        EPSON is a trademark of Epson America Inc.
        IBM is a trademark of International Business Machines, Inc.
        LOTUS 1-2-3 is a trademark of Lotus Development Corporation
        HERCULES is a trademark of Hercules Corporation
        MS-DOS is a trademark of Microsoft Corporation.
        SYMPHONY is a trademark of Lotus Development Corporation
























    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [2] 
    LIMITED WARRANTY
    ~~~~~~~~~~~~~~~~
    This program is provided on an "as is" basis without warranty of any
    kind, expressed or implied, including but not limited to the implied
    warranties of merchantability and fitness for a particular purpose.
    The entire risk as to quality and performance of these programs is
    with you.  Should the program prove defective, you (not TRIUS, Inc.)
    assume the entire cost of all necessary repair, servicing, or
    correction.  In no event will TRIUS, Inc. be liable to you for any
    damages, including any lost profits, lost savings, or other incidental
    or consequential damages arising out of the use or inability to use
    these programs, even if TRIUS, Inc. has been advised of the
    possibility  of such damages.  This warranty gives you specific legal
    rights, and you may also have other rights which vary from state to
    state.  Some states do not allow the exclusion of implied warranties
    or exclusion of liability for incidental or consequential damages so
    the above may not apply to you.  You acknowledge that you have read
    this agreement, understand it, and agree to be bound by its terms and
    conditions.  You further agree that it is the complete and exclusive
    statement of the  agreement between us, which supersedes any proposal
    or prior agreement, oral or written, and any other communications
    between us.




































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [3] 

    TABLE OF CONTENTS                                            Page
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       COPYRIGHT NOTICE.........................................   2
       LIMITED WARRANTY.........................................   3
    1. INTRODUCTION.............................................   6
       WHAT IS A SPREADSHEET....................................   7
    2. OPERATING REQUIREMENTS...................................   7
       PROGRAM INSTALLATION.....................................   8
       MOUSE INTERFACE..........................................   8
       STARTING THE PROGRAM.....................................  10
       COMMAND LINE SWITCHES....................................  10
       STARTING AS-EASY-AS FROM ANY DIRECTORY...................  13
       MENUS....................................................  14
       VIEWS/WINDOWS............................................  16
       SMART CURSOR.............................................  18
       FUNCTION KEYS............................................  18
    3. BASICS...................................................  21
       ENTERING LABELS..........................................  21
       ENTERING VALUES..........................................  21
       ENTERING FORMULAS........................................  21
       ENTERING GRAPHICS CHARACTERS.............................  22
       EDITING A CELL...........................................  23
       METHODS FOR ENTERING FORMULAS............................  23
       WHAT IS A RANGE..........................................  24
       DEFINING A RANGE.........................................  25
       POINTING WITH THE ARROW KEYS.............................  25
       POINTING WITH THE MOUSE..................................  25
       TYPING...................................................  26
       NAMING A RANGE...........................................  26
       SETTING FORMATS..........................................  27
       WHY DO YOU NEED FORMATS?.................................  27
       RELATIVE VERSUS ABSOLUTE ADDRESSES.......................  27
       COPY VALUES..............................................  29
       MOVE VALUES..............................................  29
       MOVE FORMULAS............................................  30
       RECALCULATION MODES......................................  30
       CIRCULAR REFERENCES......................................  31
       SAVING THE WORKSHEET.....................................  31
       SAVING PART OF THE WORKSHEET.............................  32
       RETRIEVING THE WORKSHEET.................................  32
       COMBINING WORKSHEETS.....................................  33
       IMPORTING FILES..........................................  33
       LEAVING THE WORKSHEET....................................  37
    4. PRINTING.................................................  38
       PRINTER BORDERS..........................................  39
       MARGINS & PAGE LENGTH - PRINTER OPTIONS..................  39
       PRINTER OPTIONS - HEADERS & FOOTERS......................  41
       PRINTER OPTIONS - EMBEDDED CODES.........................  42
       PRINTER OPTIONS - TYPE...................................  42
       CONTROLLING THE PRINTER..................................  43
       ASEASY.PRT...............................................  43
       PRINT TO A FILE..........................................  44
       PRINTING COMBINED TEXT AND GRAPHICS......................  45
       USING PRINT VIEW.........................................  45
    5. GRAPHICS COMMANDS........................................  46
       GRAPH RANGES.............................................  47

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [4] 

    TABLE OF CONTENTS (continued)                                Page
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       FORMAT...................................................  47
       OPTIONS..................................................  47
       CUSTOM...................................................  47
       COMBINING TEXT AND GRAPHICS..............................  51
       SAVING A GRAPH...........................................  51
    6. DATA COMMANDS............................................  53
       DATA FILL................................................  53
       DATA TABLE...............................................  53
       DATA TABLE - 1 INPUT.....................................  53
       DATA TABLE - 2 INPUTS....................................  54
       DATA SORT................................................  54
       DATA BIN.................................................  55
       DATA GOAL SEEK...........................................  55
       DATA REGRESSION..........................................  56
       DATA INPUT RANGE.........................................  57
       DATA INPUT FORM..........................................  57
    7. DATABASE OPERATIONS......................................  59
       INPUT RANGE..............................................  59
       CRITERION RANGE..........................................  59
       OUTPUT RANGE.............................................  60
    8. MATRIX OPERATIONS........................................  61
       MATRIX EQUATION..........................................  62
    9. FUNCTIONS................................................  63
       STRING FUNCTIONS.........................................  63
       MATH FUNCTIONS...........................................  69
       FINANCIAL FUNCTIONS......................................  72
       LOGICAL FUNCTIONS........................................  77
       STATISTICAL FUNCTIONS....................................  79
       SPECIAL FUNCTIONS........................................  83
       DATE AND TIME FUNCTIONS..................................  89
    10.MACROS...................................................  92
       DEFINING A MACRO.........................................  92
       EXECUTING A MACRO........................................  93
       MACRO MENU ESCAPE SEQUENCE...............................  94
       MACRO KEYWORDS...........................................  94
       ADVANCED MACROS..........................................  94
       CONFIGURATION FILE....................................... 106
       INDEX  .................................................. 111
       ORDER FORM............................................... 119
















    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [5] 
    1. INTRODUCTION
    ~~~~~~~~~~~~~~~
    Thank you for trying out AS-EASY-AS, an excellent spreadsheet program,
    packed with features that can't be found in other packages that cost
    many times more.  Before you rest your fingers on the keyboard and
    start using AS-EASY-AS, its useful to have an overview of the
    capabilities of the program.  Of course, the list below represents
    just a sampling of the many features.  However, it will give you an
    idea of the versatility of AS-EASY-AS:

    *  Large size (8,192 Rows by 256 Columns)
    *  Easy to use, Pull Down Menu Interface
    *  Significantly Enhanced dBASE file querying capabilities
    *  Math, Statistical, Logical, Financial, String, Date, Time,
       File, Status and User Definable Functions
    *  Matrix Operations, Frequency Distribution Tables (Bins)
    *  File Linking for worksheet consolidation
    *  Powerful Graphics Capabilities
    *  Bar, Line, X-Y, Pie, Stacked Bar, Hi-Lo, Polar, Area, Delta,
       Cumulative, Strip, Wall, Semi-Log, Contour and Log-Log Graphs
    *  X-Y Data Regression (Up to 5-th order, Ln[x], Exp[x] and Sqrt[x])
    *  Keyboard and Mouse-based Operation
    *  Multiple Graphics modes (Display Text & Graphics)
    *  Preview Mode With Combined Text and Graphics, Page Breaks, etc
    *  9/24-pin dot matrix pin, HP Laserjet and Postscript Support
    *  Windows!  Up to six resizeable and moveable spreadsheet views
    *  Database Operations, Data Input Forms, Read/Write dBASE Files
    *  Text Search, Replace, Justify
    *  Goalseeking - Need an answer? AS-EASY-AS will solve for the input value!
    *  User-configurable Printer Setup File
    *  Spreadsheet Auditing Capabilities
    *  Named Range, Function, Macro Selection Lists
    *  Multiple Planes (3-D Simulation)
    *  Macro Programming Language (over 70 powerful macros)
    *  Macro Record/Playback Capability and Single Stepping Through Macros
    *  Support of Hercules/CGA/EGA/AT&T/VGA, and SVGA graphics cards






















    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [6] 
    2.  OPERATING REQUIREMENTS
    ~~~~~~~~~~~~~~~~~~~~~~~~~~
    HARDWARE
     AS-EASY-AS is designated to operate on any IBM PC, XT, AT, PS/2 or
     fully compatible computer, as described below:

    OPERATING SYSTEM
     AS-EASY-AS will operate using DOS Version 2.11 or later.  It has also
     been tested and works under Windows 3.0/3.1 as a DOS application.

    MEMORY REQUIREMENTS
     384k minimum RAM.  Spreadsheet data is stored using a sparse matrix
     technique which only allocates space required by each cell.

     Expanded Memory is automatically detected and used by AS-EASY-AS.
     If you don't have EMS, you can instruct AS-EASY-AS to use Virtual
     Memory, whereby a hard disk or diskette may be used to emulate EMS.
     If you don't have EMS memory and don't use virtual memory, only
     conventional DOS memory will be used.

    DISK DRIVE
     The minimum files required to run AS-EASY-AS are listed under
     file installation, in this section and require less that 360K.
     As a result, AS-EASY-AS will run on single floppy (720K
     minimum), dual floppy, or hard disk system.  This enables AS-
     EASY-AS to run on older PCs and laptops without hard disks.

    VIDEO CARD/MONITOR
     MONOCHROME  - 80x25 text resolution.
     HERCULES - 720x348 resolution.
     COLOR GRAPHICS ADAPTER (CGA) - 640x200 resolution.
     ENHANCED GRAPHICS ADAPTER (EGA) - 640x350 resolution.
     VIDEO GRAPHICS ARRAY (VGA) - 640x480 resolution.
     SUPER VIDEO GRAPHICS ARRAY (SVGA) - 800x600 resolution.

    PRINTERS
     AS-EASY-AS will print text and graphics to Epson and compatible 9/24-
     and, Okidata 24-pin dot matrix printers, Hewlett Packard
     LaserJet II and compatible laserjet printers, Toshiba P1351, and
     Postscipt printers (Graphics Only).  It will also work with daisy
     wheel printers, but they will not be able to print graphics.

    MOUSE
     AS-EASY-AS may optionally be used with a Microsoft or compatible
     mouse.













    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [7] 
    PROGRAM INSTALLATION
    ~~~~~~~~~~~~~~~~~~~~
    Before using AS-EASY-AS, we recommend that a working copy of the
    program be made either on your hard disk or on a separate floppy
    diskette. An installation program provided on the AS-EASY-AS diskette
    makes the process simple.  It will transfer the necessary files from
    the original diskette to your working disk/directory.  There are no copy
    protection schemes or hidden files to wrestle with.

    If you are making a working disk, first format two blank diskettes and
    label them AS-EASY-AS #1 and #2.

    To make a working copy of the program:

     1.  Place the AS-EASY-AS program disk in drive A:
     2.  At the DOS prompt, type A: and press [ENTER]
     3.  Type INSTALL and press [ENTER].

    Follow the simple on-screen instructions to specify where to
    install the program.  If you are installing the program on 360K
    diskettes, you will be prompted to change the diskettes as
    needed.

    When the operation is complete, the DOS prompt will reappear on your
    screen.  Place the original diskette in a safe place.  If your working
    diskette later becomes damaged, repeat the above process to make a new
    working disk.

    The following files are the minimum required to run AS-EASY-AS:

        ASEASY.EXE     ASEASY.MSG      ASEASY.MNU    ASEASY.FNT

    The rest of the files do not need to be present in your working
    disk/directory to run the program.


    MOUSE INTERFACE
    ~~~~~~~~~~~~~~~
     AS-EASY-AS may be used with a Microsoft or compatible 2 or 3 button
     mouse.  Some mice have three buttons, while others have two.  AS-
     EASY-AS uses only two buttons on the mouse.  The left button is
     functionally equivalent to the [ENTER] key on the keyboard, and the
     middle and/or right mouse buttons both represent the [ESC] key.  You
     can use the keyboard and mouse equivalents interchangeably.

     In text modes, the mouse cursor appears on the AS-EASY-AS screen as a
     block one character in width and height.  The cursor may be moved
     around the screen through corresponding movement of the mouse.

     If the left mouse button is "tapped" or "clicked" while on a
     worksheet cell, the worksheet cell pointer will relocate to the cell
     occupied by the mouse cursor.

     If the left button is held down while moving the mouse, and the mouse
     cursor reaches a border, the worksheet will start scrolling in the
     direction of mouse movement.  This motion will continue until the
     outer limits of the worksheet are reached.  The cell pointer will be

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [8] 
     positioned in the last cell where movement was stopped.

     The sensitivity of the mouse while scrolling may cause overshoot of
     the desired window on some fast computers.  If this happens, you can
     move the cell pointer one cell at a time by clicking on the scroll
     bar pointers in the right and bottom borders.

     Throughout this manual, when a reference is made to the [ENTER] key,
     the left mouse button will also be implied.  Similarly, when
     reference is made to the [ESC] key, the right mouse button should be
     assumed to perform the same function.















































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [9] 
    STARTING THE PROGRAM
    ~~~~~~~~~~~~~~~~~~~~
    The system configuration and certain default parameters can be
    specified when the program is started.  Various configuration options
    can be invoked by a number of command line switches (each switch is
    preceded by a slash [/] character).  Note that most of the same
    defaults can also be changed in the AS-EASY-AS Configuration file.
    See User, Install in Section 11 for further information.

    The general form to start the program is:

        ASEASY /switch1/switch2/switch3...
               where switch1, switch2,... are explained below


    COMMAND LINE SWITCHES
    ~~~~~~~~~~~~~~~~~~~~~
    Switches are limited to a maximum of 47 characters on the command line.
    The following command line switch options can appear in any order.


    ATT - AT&T Monochrome System.
     Set this switch if you are using AS-EASY-AS on an AT&T System to
     produce graphics with a resolution of 640x400 (video mode $48)

    ATT2 - AT&T Monochrome System.
     Set this switch if you are using AS-EASY-AS on some Toshiba laptops
     (and some Olivetti systems) to produce graphics with a resolution of
     640x400 (video mode $40).

    AUTO=Filename - Autoload Worksheet.
     This switch instructs AS-EASY-AS to automatically load a worksheet
     upon program startup.  Be sure to specify the file's .WKS extension
     and path, if the file is not located in the default directory.

     Note: File names containing a hyphen "-" can not be auto-
           loaded. However, the underscore character "_" is
           acceptable.

    BM - Bypass Mono
     This switch overrides the equipment autodetection and is used in
     combination with /EM or /EVM.

    BK=X  - Screen Blanking Time
     This switch sets the screen blanking time.  If your computer is left
     inactive (no key pressed) for X-seconds, the screen will blank out to
     prevent phosphor burnout due to long periods of reverse video (i.e.
     the BORDERS). Pressing any key will re-display the sheet. (We suggest
     using the ESCAPE key).

     The default blank out time is set to 5 minutes (i.e., X=300).  If a
     blanking time of 0 is used, screen blanking will be disabled.

    CFG=Path\File - Specifies the configuration file to be used.
     This allows using multiple configuration files for specific
     applictions, or different users on a network.
     Ex.  /cfg=d:\DATA\MYCONFIG.CFG

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [10] 
    CTR - Center the letters identifying the spreadsheet columns.

    DIR=Path - Sets the Default Directory/Data Path
     The default data drive and subdirectory is the drive and subdirectory
     from which the program was started.  This switch allows you to change
     the default drive/directory.

    DW - Highlight Unprotected Cells
     Highlight cells which have been formatted as unprotected (/Range Lock
     No), whether worksheet protection has been enabled or not.  Normally
     unprotected cells are highlighted only if protection has been enabled.

    E - Enhanced Graphics Adaptor
     This switch specifies an IBM Enhanced Graphics Adaptor or equivalent
     available for graphics.  The resolution on the EGA screen is 640x350
     pixels with multiple colors.

    EM - Monochrome EGA Monitor/Card (640x350)
     Specifies that your computer is equipped with a monochrome EGA
     monitor and adapter card, capable of displaying at a 640x350 pixel
     resolution.

    EV - VGA Monitor/Card (640x480)
     Specifies that your computer is equipped with a VGA monitor and
     adapter card, capable of displaying at a 640x480 pixel resolution.
     If your system is equipped with such a monitor/card combination and
     the /EV switch is not used, the program will most likely start up in
     EGA or CGA mode.

    EVM - Monochrome VGA Monitor/Card (640x480)
     Specifies that your computer is equipped with a monochrome VGA
     monitor and adapter card, capable of displaying at a 640x480 pixel
     resolution.

    H - Hercules System
     This switch specifies that you are using a Hercules Mono-Graphics
     board or clone.  The resolution of the screen, when plotting
     graphics, is 720x348 pixels and will use the first graphics page at
     $b000.  To force graphics to the second graphics page at $b800 follow
     the H with a 2, i.e., H2.

    H2 - Hercules Card, Page #2 (720x348)
     This switch instructs the program to use the second video page at $b800
     for graphics when using a Hercules Mono-Graphics board or clone.

    MONO  - Monochrome (B&W)
     Change all colors to a white/black color scheme.  This can be used on
     monitors which do not display all colors visibly, such as LCD
     monitors found on most laptops.

    NE - Don't Use Expanded Memory
     Do not use expanded memory, even if it is found on your computer.
     AS-EASY-AS will automatically use all the expanded memory it detects
     unless this switch is used.

    NR - Force Manual Recalculation
     Forces recalculation to be set to manual mode and disables Recalc

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [11] 
     Linking when a worksheet file is loaded.  This results in significantly
     decreased time for loading complex worksheets.

    NT - Non-Turbo Keyboard
     Cursor movement using the keyboard cursor keys defaults to a "turbo"
     mode.  Turbo speeds up cursor movement on 286 ATs and above.  It may
     not be compatible with some types of computers, such as the PCjr.
     Therefore, the turbo feature may be disabled by use of the NT switch.

    NW - Change Data Bin Boundary Values
     This switch changes the boundary values for the Data Bin operation.
     Without this switch, the criterion used for assigning a sample to a bin
     is LIMIT1  VALUE < LIMIT2, which results in the value being
     assigned to the LIMIT2 bin.

     If the command line switch /NW is used, the criterion for being assigned
     to the LIMIT2 bin becomes LIMIT1 > VALUE  LIMIT2.

    P  - Use Alternate Menu
     Use the alternate menu definition file that makes AS-EASY-AS
     menu commands compatible to version 4 of the program.  Note that
     in order for this to work, the ASEASY.MN2 file NEEDS to be
     present in the ASEASY directory!

    RA - Round Absolute
     By setting this switch, the absolute value of negative numbers is
     used when rounding.  If the RA switch is NOT used @Round(1.6,0)=2 and
     @Round(-1.6,0)=1.  If AS-EASY-AS is started with the RA switch,
     @Round(1.6,0)=2 and @Round(-1.6,0)=-2.

    UK - UK Punctuation Switch
     Starting the program with this switch sets the pound as the default
     currency symbol and modifies the @DATEVAL function to accept
     arguments in the form: @DATEVAL(DD,MM,YY)

    V1 - CGA Mode
     Force EGA/VGA cards operation to CGA mode.  This might be necessary
     for some non-standard EGA/VGA monitors and video card combinations.

    VM=XXX - Use Virtual Memory
     This command line switch instructs AS-EASY-AS to use a disk drive to
     emulate EMS RAM.  XXX represents the maximum number of 4K packages to
     use as EMS memory.

     NOTE:      XXX is limited to a maximum of 500 pages, which is the
                equivalent of 2,000K of EMS.  This allows for even
                larger worksheets to be created, limited possibly by the
                size of your hard disk or diskette.

    VP=Drive\Path; - Path for Virtual EMS
     Specifies the drive and subdirectory to by used by AS-EASY-AS when
     the /VM switch is used.  The default is the start-up drive\directory.
     You may specify another drive which has more available space to be
     used for the temporary files.  Note the ";" at the end of the path
     name.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [12] 
    XM-nnn - Limit the use of EMS
     Specifies the number of 16K pages of EMS to be used by the
     program (rather than using all available EMS.  The limit is 500
     pages (8 Mb).


    Any combination of valid switches (depending on your system) can be
    used.

    As an example, ASEASY/E/NE/DIR=C:\DATA instructs AS-EASY-AS to start
    in EGA mode, not to use expanded memory, and set the default data
    drive and directory to C:\DATA.

    By creating individual batch files, you could start AS-EASY-AS on a
    number of different systems, without having to remember all the
    switches required.


    Math Coprocessor
    ~~~~~~~~~~~~~~~~
    AS-EASY-AS will try to detect if a math coprocessor chip (8087,
    80287, 80387,..) is installed in your computer and if so, it will
    automatically use it to speed up calculations.

    It is possible, however, that for specific applications, or if
    you are experiencing problems (with some generic coprocessor
    chips, under windows, etc), that you want to temporarily disable
    the math coprocessor.

    In order to do that, before starting AS-EASY-AS, at the DOS
    prompt, type

                    SET 87=N

    and press [ENTER].  If, after running AS-EASY-AS, you want to
    enable the coprocessor again, then simply type,

                    SET 87=

    and press [ENTER] at the DOS prompt.


    STARTING AS-EASY-AS FROM ANY DIRECTORY
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    AS-EASY-AS can be started from any drive/directory on your hard disk
    simply by typing ASEASY.  To do so, you must make sure that the
    directory, where the ASEASY program files are located, is in your DOS
    path.

    Consult your DOS manual for more information on the PATH and SET
    statements.







    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [13] 
    MENUS
    ~~~~~
    All AS-EASY-AS commands are accessed through menus which are invoked
    by pressing the [/] key.  This key is usually located on the lower
    right side of the keyboard, just above the space bar.  An alternate
    key may be specified, refer to User, Install, Punctuate, Menukey for
    details.

    If you use a mouse, command menus are invoked by pressing the right
    mouse button when the program is in the Ready! mode.  The main command
    menu will drop down and provide access to all other menu commands.  If
    the right button was selected in error, tapping the right button again
    will return you to the Ready! mode.

    In order for your mouse to be operational, your mouse driver needs to
    be loaded prior to starting AS-EASY-AS (see Section 2 on using the
    mouse).

    When the [/] key is pressed, the main menu will appear in the
    top left corner of the screen.  As you will see later, window menus
    provide you with a useful trail through the different levels of menus
    in the program.

    The first option in the menu will be indicated by a moveable pointer.
    The command area line, on the top of the screen, will display
    additional information about the option or menu choice.

    The pointer can be moved by pressing the cursor arrow keys or by
    moving the mouse pointer, if your mouse is active.  [HOME] will move
    the selection bar to the first menu option, while [END] will move it
    to the last one. Pressing [LEFT], [UP] or [BACKSPACE] will move the
    selection bar up. Pressing [RIGHT], [DOWN] or [SPACE] will move the
    selection bar down.

    To select a command or sub menu, use the cursor keys to highlight the
    command you want and press the [ENTER] key.  An alternative way is to
    press the key corresponding to the first letter of the desired option.
    For example, when the main menu is displayed, pressing S gets you in
    the Sheet menu, or pressing R gets you in the Range menu, etc.
    Tapping the left mouse button will select the highlighted command.
    Continue the process until the desired command is reached.  Tapping
    the right button once is the equivalent of hitting [ESC], and will
    return you to the previous menu.

    Once a selection is made, a new menu window appears in the same
    location. This window is actually made up of two parts. The top part
    displays the option you selected in the previous menu. The bottom part
    is a menu, with the last option selected highlighted.  You can select
    an option from this menu either by highlighting the choice and
    pressing [ENTER] or by pressing the key corresponding to the first
    letter of the option.

    To facilitate repetitive tasks, AS-EASY-AS remembers the last sequence
    of menu commands used.  If the main menu is selected a second time,
    you will notice the command last used is highlighted.  To reuse the
    same command, simply press [ENTER] or click the left mouse button to
    select the command, and continue likewise through the submenus.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [14] 
    The display menu window can be shifted between the left and right
    sides of the screen by pressing the period [.] key.  Press period (.)
    again and it returns to its original position.  Once the menu window
    has been placed either on the left or the right side of the screen, it
    will appear there every time the menu is accessed until it is moved
    again or until the program is exited.

    Both the width and the position of the menu window can also be
    adjusted by macro commands.

    When the number of selection items is too large, (such as filename in
    a directory) to be displayed on a single screen as may occur during
    /File Retrieve, only a single page at a time is presented.  Viewing
    successive pages can be achieved by moving the cursor past the bottom
    row or using the [PgUp] and [PgDn] keys.

    As you can see, with this menuing technique, at any time you can tell
    exactly what you are doing.  If you don't think that this is
    important, consider the following:

     Assume that your current menu is displaying the menu of cell FORMAT
     options.  Unless you have kept track of all your previous keystrokes, it
     is very hard to tell exactly what you are trying to format.  This is
     because the FORMAT menu can be accessed from a number of different
     menus.

































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [15] 
    VIEWS/WINDOWS
    ~~~~~~~~~~~~~
    AS-EASY-AS has the ability to open up to six windows or views of the
    worksheet at one time.  Worksheet views can be arranged and resized on
    the screen according to your preference.  When multiple views are
    created, only one window can be worked on at a time.  This is called
    the active window and is identified by a blinking cursor.  The [F7]
    key is used to toggle between worksheet views.  The cell pointer
    identifies which view is active.

    The windows can be manipulated by using a mouse, or through the View
    menu command.

    With a mouse, to resize the window, position the mouse pointer on the
    character in lower right corner of the window.  Depress the left button
    and drag the mouse to the desired size.  Dragging the upper right
    corner of the window will move the window.  Positioning the mouse
    pointer on any portion of an inactive window and clicking the left
    button makes that window active.

    The following View menu subcommands allow manipulation of the windows.

    OPEN - creates a new view based on the active window.  If this process
    is continued, multiple views of the worksheet will be created.  Up to
    six worksheet views can be created at one time.  Worksheets will
    overlap each other (layer) when opened.  If an attempt is made to open
    a seventh window, an error message will appear warning that the
    maximum number of windows has been exceeded.

    CLOSE - will terminate the current worksheet view.  This command can
    be repeated until all views are removed.  Closing a middle view will
    result in the windows being renumbered accordingly.  For example, if
    six window views are created (1,2,3,4,5,6) and window number three is
    closed, windows 5 and 6 will automatically renumber to read
    (1,2,3,4,5).

    LAYER - will arrange all the open windows on the screen at once.  [F7]
    is used to toggle between worksheets and is used to select the active
    window.  Each time a new window is opened, it is layered below and to
    the right of the previous window.

    ZOOM - will expand the active window to fill the entire screen.  This
    command will allow you to take a closer look at the worksheet.

    SIZE - changes the width and/or height of the window.  The smallest
    view size is 22 character columns by 4 character rows. The number of
    columns and rows is dependant on the type of graphics text selected.
    The [up], [down], [left], [right], [home], arrow keys can be used to
    reduce and enlarge the worksheet view.

    MOVE - repositions the window on the screen.  To move the worksheet,
    the size of the window must first be reduced to less than full-size.
    Use the cursor keys to move the active window.





    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [16] 

    MOVING AROUND THE SHEET
    ~~~~~~~~~~~~~~~~~~~~~~~
    For keyboards with a combined cursor/number key pad, first make sure
    the NUM status indicator is NOT displayed on the status line.  This
    means that the cursor key pad is active.  Next, take a close look at
    the cursor key pad (usually located on the right side of your
    keyboard).  Each key performs the following action:


     [HOME]          Move the cursor to cell position A1 or the
                     border boundary
     [UP]            Move the cursor up one row
     [PGUP]          Move the cursor up one screen page
     [DOWN]          Move the cursor down one row
     [PGDN]          Move the cursor down one screen page
     [LEFT]          Move the cursor left one column
     [RIGHT]         Move the cursor right one column
     [END]           This key acts in combination with the next
                     cursor key pressed.  It causes the spreadsheet to
                     scan in the indicated direction until a change of
                     state occurs.  For example, a column of numbers
                     with a blank cell in the middle will result in the
                     cursor stopping at the blank cell.  Subsequent
                     [END] [DOWN] will jump to the bottom of the
                     column.
     [END][UP]       Move to far top of range
     [END][DOWN]     Move to far bottom of range
     [END][LEFT]     Move to far left of range
     [END][RIGHT]    Move to far right of range
     [END][HOME]     Move to lower right corner of sheet

    Other movement keys:

      [TAB]            Move one page right
      [CTRL] [RIGHT]

      [SHIFT][TAB]     Move one page left
      [CTRL] [LEFT]

      [F5]             Go to specified cell

      [F6]             When the /Sheet Window option has been
                       selected, pressing F6 moves the cursor between
                       the two windows. With only one window active,
                       pressing F6 toggles between the current and the
                       last position of the cursor.

      [F7]             The F7 function key is used to toggle between
                       worksheet views when multiple windows are
                       created.







    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [17] 

    SMART CURSOR
    ~~~~~~~~~~~~
    Smart Cursor will automatically move the cell pointer one cell in the
    direction of the last cursor movement after the [ENTER] key has been
    pressed.  Smart Cursor is toggled on/off by pressing the [SCROLL LOCK]
    key.  "SCR" displayed in the status line indicates Smart Cursor is
    active.

    When active, if a number is typed into a cell, followed by [ENTER] and
    a cursor key, Smart Cursor remembers the direction of movement.
    Subsequent input of data, followed by [ENTER], will place the data in
    the cell, and move the cursor one cell in the established direction of
    movement.  If a cursur key is again pressed, that direction becomes
    the new direction of movement.

    For example, when you type the number 1 in cell A1 and press [ENTER],
    the cursor remains in cell A1.  If you move the cursor to cell A2 and
    type the number 2, the cursor will automatically move to cell A3 after
    [ENTER] has been pressed.



    FUNCTION KEYS
    ~~~~~~~~~~~~~
    F1 - Help Function Key (when ready mode is active)
     To choose among the help topics, press the up/down cursor keys to move
     the highlighted cursor to the one desired.
        [HOME] brings you to the top of the list;
        [END] to the bottom;
        [PAGE UP]  to the top of the screen;
        [PAGE DOWN] to the bottom of the screen.
        A letter key searches for a topic starting with that letter
        [ENTER] selects the topic.

     Once a help topic has been chosen and entered, use the up/down cursor
     keys to scroll through the file.  The highlighted bottom boundary of
     a file disappears when the end of the file has been reached.

     To exit one help topic and return to the topics list, press [ESC].

    F1 - Help When Entering a Macro
     If you are typing a macro and the last key typed was the "{" key,
     pressing [F1] will open a pick window in the middle of your screen,
     displaying all the macro commands available to you.  Move the cursor
     using the arrow keys, select the macro command you want and press
     [ENTER].  The macro command is inserted, at the cursor position, and
     you are ready to continue typing.

    F1 - Help When Entering an Equation
     If you have just entered a valid operator (+, -, *, or /), pressing
     F1 will display all named ranges defined in the spreadsheet. Select
     the one you want, using the cursor, press [ENTER] and the named range
     is inserted in your equation.

    F1 - HELP When Entering a Function
     If you have just pressed the "@" key, pressing F1 will open a

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [18] 
     selection window in the middle of your screen, and will display all
     the @-Functions available to you.  When the function list appears,
     move the cursor using the arrow keys, pick the function you want and
     press [ENTER]. The function is inserted and you are ready to continue
     typing.  Pressing the [ESC] key, when the function list appears, will
     cancel the operation but still leave you in the edit mode.

    F1 - HELP When Entering a Printer Setup Code
     If you are in the PrintTo Printer Options Setup submenu and are
     trying to remember a printer setup code, all you need to do is press
     [\] followed by F1. A selection window displays the setup codes that
     you have placed in your printer set-up file (see section on Printer
     Options).  Move the cursor with the arrow keys, select the setup code
     that you want, and press [ENTER].   AS-EASY-AS will insert the
     selected printer setup code and you can continue with your next
     operation.

     This is a great feature for those who have to use complicated lengthy
     laser printer setup strings.

     The F1 option is also available when embedding setup codes directly
     in a print range (see section on Printer Options).


     NOTES:  1.  You can still manually enter the setup codes if you prefer.

             2.  The printer setup file has the name ASEASY.PRT and must
                 be in the default directory.

    F2 - Edit Function Key
     Pressing the F2 function key places a copy of the contents of the
     current cell on the second line of the command panel area, and
     invokes the edit mode. For more information about the edit mode
     options, refer to Section 3.2.

    F3 - Macro Function Key
     The F3 function key allows execution of a macro by name or by cell
     reference. When F3 is pressed, a prompt appears requesting the name
     of the macro that you want to execute.  The default address is the
     cell reference specified the last time F3 was invoked during the
     current session.  You can either type the name of the macro you want
     to execute and press [ENTER] or press [ESC].

     Pressing [ESC] in response to the prompt will display a pick list of range
     names to choose from.  Move the cursor to the desired macro name and
     press [ENTER].

     NOTE:  This is the equivalent to the {JUMP NAME} macro command.

    F4 - Absolute Address Function Key
     Pressing F4 when in the middle of entering a formula, makes the
     address of the current cell absolute (both row and column).  Pressing
     F4 once more makes only the column of the current cell absolute and
     pressing it for the third time makes the reference relative.

     NOTE: This function key is only active when entering an equation
           in the pointing mode.  It is not active when editing a cell.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [19] 
    F5 - GoTo Function Key
     The GOTO function key allows you to position the cursor on a cell
     indicated by name or by reference.  When the prompt for the
     destination appears, pressing [ESC] will present a window of range
     names from which to choose. The default address is the address
     specified last time F5 was invoked during the current session.

    F6 - Window/Location Function Key
     The F6 function key toggles the cell cursor between the current
     location and the last location the cell cursor occupied.  When the
     Sheet, Windows command has been invoked, pressing the F6 key will
     toggle the cursor between the two windows.  When the Sheet, Borders
     command has been invoked, pressing the F6 key will toggle the cursor
     into and out of the border area (only if a border was assigned to one
     window).

    F7 - View Key
     The F7 function key is used to toggle between worksheet views when
     multiple windows are created.  Up to six window views can be opened
     but only one window can be worked on at a time.  This is called the
     active window and is identified by a visable cell pointer.

    F9 - Calculate Function Key
     When the ready mode is active, pressing F9 results in all cells being
     recalculated.

     Another feature of the F9 key is that it performs the calculation of
     any equation, at any point in an editing AS-EASY-AS operation.  When
     editing a formula, pressing F9 replaces the entire formula with its
     evaluated result.

     Example:  Cell A1 contains the value 1, and
               Cell A2 contains the value 2

     Place the cursor in cell B1 and press the following keys:

        /scsA1+A2 [F9] [ENTER]
                    |
               Function Key

     This will set the width of column B to 3, i.e., the value of cell A1
     plus the value of cell A2.

    F10 - Graph Function Key
     Pressing F10 displays the currently defined graph.  If no graph has
     been defined, a beep will sound and an error message will be
     displayed.











    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [20] 
    3. BASICS
    ~~~~~~~~~
    This section provides information necessary to perform basic
    functions, such as entering text, values, and formulas, and editing
    data once it has been entered.  It also describes basic skills and
    concepts, such as copying and moving cells, inserting and deleting
    rows and columns, creating and using range names, and file management.


    ENTERING LABELS
    ~~~~~~~~~~~~~~~
    A label is any sequence of characters which is not preceded with a
    digit or mathematical operator.  Digits may be entered as labels if
    they are preceded with an apostrophe ['], a caret  [^], a quote  ["],
    a backslash [\], or a pipeline [|] character.  These label prefix
    characters are special formatting characters which perform the
    following:

     [']     Left justifies the label within the column
     [^]     Centers the label within the column.  If the label is
             wider than the column, the result is left justified.
     ["]     Right justifies the label within the column.  If the label
             is wider than the column, the result is left justified.
     [\]     Repeats the character which follows, the width of the column.
     [|]     Sends the characters that follow to the printer as a setup
             string. (The "|" character is not displayed on screen).
     []     (Alt-174 on keypad) Pad string with periods on the left side.
     []     (Alt-175 on keypad) Pad string with periods on the right.

    The default prefix character is an apostrophe ['] which will
    automatically be inserted as the first character.  Prefix characters
    are interpreted as text if they appear other than in the first
    position of the label.

    NOTE: Digits that have been entered with a label prefix character are
    labels.  As a label, the digits will be evaluated as having a value of
    zero.  Therefore, it is not possible to left or center justify numbers
    and be able to use them in equations.


    ENTERING VALUES
    ~~~~~~~~~~~~~~~
    A value is any sequence of digits.  AS-EASY-AS supports 11 significant
    digits.  Large numbers are entered by using exponential notation.

    For example, the number 2.3x1015 would be entered as 2.3E15 [ENTER].

    All entries must be completed by pressing the [ENTER] key or one of
    the direction keys.  If one of these keys has not been pressed, the
    [BackSpace] key may be used to delete the previously entered digit.

    If a cell contains only asterisks, "*********", it's an indication
    that the width of the column is insufficient to hold all the
    characters required to display the number.  To make the value visible,
    either expand the column width or change the format of the
    cell.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [21] 
    ENTERING FORMULAS
    ~~~~~~~~~~~~~~~~~
    The power of a spreadsheet stems from its ability to interrelate the
    contents of its cells.  These relationships are set through the use of
    formulas that are entered directly into the cells. Once entered, the
    formulas may be saved with the spreadsheet, copied, edited, or moved
    etc.  Relationships between cells are formed using algebraic,
    statistical or logical expressions. Once a formula is typed in and
    [ENTER] is pressed, it is evaluated and the result is placed in the
    cell.  The following operators are available for use in cell formulas:

        [-]     -  negation
        [+]     -  addition
        [-]     -  subtraction
        [*]     -  multiplication
        [/]     -  division
        [!]     -  factorial
        [%]     -  percent
        [^]     -  exponentiation
        [>]     -  greater than
        [<]     -  less than
        [=]     -  equal to
        [<=]    -  less than or equal
        [>=]    -  greater than or equal
        [<>]    -  not equal to
        [()]    -  parentheses

    A formula must be preceded by one of the following characters:
                     -  +  (  @   or a digit.

    The following examples assume that cell A1 contains the value 4.

        Type           Result   Comment
        ~~~~~~~~~~~    ~~~~~~   ~~~~~~~~~~
        1.1+2*3+5^2    32.1     --
        +A1*2+5.5      13.5     --
        @SQRT(A1)+5     7.0     --
        (2*A1+3)*3     33.0     --
        -5.1+2         -3.1     --
        2>3               0     Result is False
        3>2               1     Result is True
        5<>4              1     Result is True
        6=5               0     Result is False

    Parenthesis are used to group calculations and force a specific order
    of evaluation.  AS-EASY-AS will first evaluate the expression in
    parentheses, then continue in order of operator precedence.  As an
    example:

        (2+3)*6 evaluates to 30, while 2+(3*6) evaluates to 20.

    Quotes must be used to indicate string arguments.  For example:
        +"Hello"&" Tom!" will display   Hello Tom!   in a cell.





    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [22] 
    ENTERING GRAPHICS CHARACTERS
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    AS-EASY-AS permits entry of high bit ASCII characters (sometimes
    referred to as graphics or box characters).  To create one of these
    characters, hold the [ALT] key down and enter the decimal code of the
    character you want using the numeric pad (on the right side of your
    keyboard).  When you let go of the [ALT] key, the specified character
    will appear.  For example, if you type 195 (while holding down the
    [Alt] key) the character  will appear on your screen.

    NOTE:   Some graphics characters can be printed only if they are
            supported by your printer.



    EDITING A CELL
    ~~~~~~~~~~~~~~
    Changes to the contents of a cell may be made by retyping the contents
    and pressing [ENTER] or by invoking the Edit Mode, using the Edit
    Function Key [F2].

    Pressing [F2] causes the contents of the current cell to be placed on
    line 1 of the command panel.  The mode indicator is changed to EDIT.
    The character cursor is positioned at the end of the line.  Make
    changes by moving the character cursor to the desired position and
    start typing.

    When in the edit mode with insert active, text under and to right of
    the cursor will be shifted to the right as characters are typed.
    Insert can be toggled on/off by pressing the insert [INS] key.  The
    opposite of insert mode is overwrite mode which is indicated by an
    increase in cursor size and the display of the OVR status indicator
    (text will be overwritten by new typing).

    The following keys may be used to edit:

        [LEFT]          Move cursor one position to the left
        [RIGHT]         Move cursor one position to the right
        [HOME]          Move cursor to the first character position
        [END]           Move cursor to the last character position
        [INS]           Toggle between overwrite and insert mode
        [DEL]           Delete the character underneath the cursor
        [BACKSPACE]     Delete the character left of the cursor
        [TAB]           Move 8 positions to the right
        [SHIFT][TAB]    Move 8 positions to the left
        [CTRL][RIGHT]   Move to the beginning of the next word
        [CTRL][LEFT]    Move to the beginning of the previous word
        [ESC]           Cancel all editing and leave original cell contents

    After all changes have been made you must press the [ENTER] key to
    insert the changes into the current cell in the worksheet.







    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [23] 
    METHODS FOR ENTERING FORMULAS
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    There are two ways to enter a formula into an AS-EASY-AS cell.  One is
    to type the whole formula and the second is to point to the referred
    cells.

    For example let's say that you want to enter the following formula in
    cell B6.

        @SUM(A5..A12)+A1/(C6*C8)

    This could be accomplished in two ways as shown below (assuming that
    the cursor is already in cell B6).

    POINTING METHOD:
    ~~~~~~~~~~~~~~~~
    TYPE   PRESS               SHOWN ON CONTROL PANEL
    ~~~~   ~~~~~               ~~~~~~~~~~~~~~~~~~~~~~
    @SUM(                      @SUM(
           [LEFT]              @SUM(A6
           [UP]                @SUM(A5
           (period).           @SUM(A5..A5
           [DOWN](7 times)     @SUM(A5..A12
           )+                  @SUM(A5..A12)+
           [HOME]              @SUM(A5..A12)+A1
           /(                  @SUM(A5..A12)+A1/(C6
           [RIGHT]             @SUM(A5..A12)+A1/(C6
           *                   @SUM(A5..A12)+A1/(C6*
           [RIGHT]             @SUM(A5..A12)+A1/(C6*C6
           [DOWN]              @SUM(A5..A12)+A1/(C6*C7
           [DOWN]              @SUM(A5..A12)+A1/(C6*C8
           )                   @SUM(A5..A12)+A1/(C6*C8)
           [ENTER]             @SUM(A5..A12)+A1/(C6*C8)

    And the calculated value is displayed in cell B6.


    TYPING METHOD:
    ~~~~~~~~~~~~~~
    With the cursor positioned on cell B6, type:

        @SUM(A5..A12)+A1/(C6*C8)

    and press [ENTER].  The calculated value will appear in cell B6, and
    the above equation will show on the control panel.

    Cell references can be either absolute or relative.  An absolute cell
    has the row or column to be fixed preceded by a '$', i.e. $A1 fixes
    the column portion of the cell reference.  A block copy of a formula
    with this cell reference will not alter the 'A' portion of the cell.
    $A$1 fixes both the row and column portion of the cell.  Without the
    '$' all copies of the cell formula will result in a translation of the
    cell reference which maintains the relative reference. Cell references
    must be preceded by either a '+' or '-' sign or a parenthesis.

    See the section on copying and moving for more information on relative
    and absolute references.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [24] 
    WHAT IS A RANGE
    ~~~~~~~~~~~~~~~
    A range is defined as any rectangular group of cells in the
    spreadsheet.  A range can be as narrow as a single row in depth or as
    deep as all the rows in the spreadsheet.  Similarly a range can be as
    narrow as a single column in width or as wide as all the columns in
    the spreadsheet (256).

    A range is described by specifying the upper left cell and lower right
    cell of the range.  The cells must be separated by two periods '..' .
    An example of this is A1..D5.  This includes all cells in columns A,
    B, C and D and rows  1, 2, 3, 4 and 5.

    The entire group of cells looks like this:

       A1     B1     C1     D1
       A2     B2     C2     D2
       A3     B3     C3     D3
       A4     B4     C4     D4
       A5     B5     C5     D5


    DEFINING A RANGE
    ~~~~~~~~~~~~~~~~
    Ranges can be defined by using one of two possible methods:  pointing
    to the cell or range of cells, or actually typing in the range (upper
    left cell followed by two periods and then the lower right cell) or
    range name.



    POINTING WITH THE ARROW KEYS
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Pointing to a cell simply involves moving the cursor.  It is best to
    use this method in response to COPY or MOVE commands.  When asked for
    a range, move the pointer.  Notice that the pointer expands on the
    screen.  In the middle of the leading edge of the pointer you will see
    a small blinking cursor. This indicates the corner of the range which
    you can expand or contract.  To switch to the next corner press the
    period [.].  If you press the period 4 times, you will return to your
    starting position. When the range has been completely highlighted,
    press the [ENTER] key. This fixes the range and allows any action to
    continue. For example, if the range was entered in response to a COPY
    command, the copy operation be initiated.


    POINTING WITH THE MOUSE
    ~~~~~~~~~~~~~~~~~~~~~~~
    The mouse may be used when building ranges in AS-EASY-AS.  The process
    of pointing with the mouse is similar to that pointing with the arrow
    keys. (Note that in order to use the mouse, your mouse driver needs to
    be loaded prior to starting AS-EASY-AS).

    When prompted for a cell range, position the mouse pointer at one
    corner of the range and press the left mouse button.  Keep it
    depressed as you move the mouse until the desired range is
    highlighted.  Release the button to signify the end of the range and

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [25] 
    click the left mouse button again to confirm the selection (similar to
    pressing the [ENTER] key at the end of the range definition).  To
    change the range a second time, hold the mouse button down and repeat
    the previous step.

    If you wish to cancel a range or stop the process, tapping the right
    mouse button will back you through the command.

    When using the right mouse in conjunction with AS-EASY-AS functions,
    such as @SUM, the function name and left parenthesis must be typed
    first,e.g., "@SUM(".  To build the range, position the mouse cursor at
    the top left cell of the range, depress the left mouse button and
    build the range. When the range is completed, type the remainder of
    the function, in our example, this would be the right parenthesis")",
    and hit [ENTER].  Again, you can proceed back through the range
    building process by pressing the right mouse button.

    TYPING
    ~~~~~~
    Typing a range may be done by specifying diagonally opposite cell
    corners of the range.  Each cell reference is separated by one or two
    periods [.].

    Example: A1..D5 defines the same range as D1..A5.  When the entry is
             complete press the [ENTER].

    NAMING A RANGE
    ~~~~~~~~~~~~~~
    A powerful AS-EASY-AS feature is the ability to refer to a range of
    cells using a name assigned to that range.  Such range names may be
    used anywhere a cell reference is expected by AS-EASY-AS.  Since a
    range can also consist of a single cell, this naming ability can be
    used to create applications and formulas that are easy to understand.

    For example, let us say that cell A1 contained total income for the
    month and cell A5 contained total expenses.  If cell A10 contained a
    formula to calculate the monthly balance, i.e. +A1-A5, then, when you
    placed the cursor on cell A10, the input line would display  A10:
    +A1-A5.  If, on the other hand, you had named A1 as INCOME and A5 as
    EXPENSES, when on A10, the input line would display A10:  +INCOME-
    EXPENSES, which is much more informative.

    When entering the formula in A10, with the cells named as above, you
    could use either the named range or the actual reference.  The
    keystroke sequences below would yield identical results (assuming the
    cursor is currently at A10):

            +A1-A5 [ENTER], or
            +INCOME-EXPENSES  [ENTER]

    Ranges are assigned names using the /Range, Name, Create command
    sequence.

    Up to 250 named ranges may be defined in a single worksheet.  Each
    range name can be up to 11 characters long.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [26] 
    SETTING FORMATS
    ~~~~~~~~~~~~~~~
    Format refers to the appearance of a cell.  There may be a big
    difference between the way the contents of a cell is displayed and the
    way the value of that cell is stored internally.  It helps to keep
    that in mind at all times.


    WHY DO YOU NEED FORMATS?
    ~~~~~~~~~~~~~~~~~~~~~~~~
    Imagine that a cell contains the result of a calculation where you are
    trying to figure out the monthly payments on a loan.  Let's say that
    the calculated payment was 657.17625412 per month.

    Do you really want to see 8 digits after the decimal point?  Most
    likely not, and that's where formats come in.

    A better way to format the payment amount would be:

         657.18   (rounded to two decimals, cents)

    or better yet,

        $657.18

    NOTE:  Even though the value is displayed as 657.18, the value stored
           in the cell and used in any calculations involving that cell is
           657.17625412.

    Applying a format to a single cell or to a whole range of cells may be
    done with the /Range, Format command.  Setting the default format for
    the entire worksheet is done using the /Sheet, General, Format
    command.


    RELATIVE VERSUS ABSOLUTE ADDRESSES
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    AS-EASY-AS does all the work required to keep track of the cells you
    refer to in formulas:

        If you move the cells referenced in a formula to another place in
        the worksheet, AS-EASY-AS automatically adjusts the references in
        the formula.

        If you move a formula from one cell to another, cell references in
        the formula remain unchanged.

        If you insert a column or row within a specified block, any
        formula that references the block is automatically adjusted to
        include it.

        If you delete a row or column within a block, any formula that
        references the block is automatically adjusted to exclude it.  An
        important exception is if you delete a row or column that contains
        one of the corner cells included in the range reference, an ERR is
        entered in the formula cell.  If this occurs, you must reenter the
        formula with the correct range.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [27] 
        If you copy a block of cells that include a formula but not the
        cells referenced in the formula, the formula is updated to
        reference new cells which have the same position in relation to
        the formula's cell.  (Cells viewed this way are called relative
        cells).

        If you want to copy a formula and maintain the original cell
        references, you must specify those references as absolute before
        copying the formula. This is done by inserting the dollar sign
        before the cell coordinates.

            $A$2 -  Makes the entire address absolute
            $A2  -  Makes the column absolute
            A$2  -  Makes the row absolute

        Named ranges operate just like all references and will translate
        when copied or moved.  To make a named range absolute, you must
        preface the range name with a dollar sign.








































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [28] 
    COPY VALUES
    ~~~~~~~~~~~
    Using the copy command on a value duplicates the value in the "FROM"
    cell into the "TO" cell.

    For example, to copy the value from cell B5 to cell C6, simply enter
    the following sequence of commands (assuming the pointer is already on
    cell B5):

        /c [ENTER] [RIGHT] [DOWN] [ENTER]     (Pointing Method)
                          or
        /c B5 [ENTER] C6 [ENTER]              (Typing Method)



    COPY FORMULAS
    ~~~~~~~~~~~~~
    Let's take an example of three cells containing the following:

            cell    B1      contains    +A1+A2
             ''     B2         ''       +A1+$A2
             ''     B3         ''       +A1+$A$2

    The value result in cells B1, B2 and B3 should be identical.

    Now copy the cells B1, B2 and B3 to C2, C3 and C4 respectively, and
    let's see what the new cells contain.

        cell C2:        +B2+B3

    Copied from an original formula, in B1, that said:  "Add the contents
    of the cell one column to the left (A1) to the contents of the cell
    one column to the left and one row down (A2)."

        cell C3:        +B2+$A3

    Copied from an original formula, in B2, that said:  "Add the contents
    of the cell one column to the left (A1) to the contents of the cell in
    absolute column A ($A) and one row down."

        cell C4:        +B2+$A$2

    Copied from an original formula, in B3, that said:  "Add the contents
    of the cell one column to the left (A1) to the contents of the cell in
    absolute column A ($A) and in row 2 ($2)."


    MOVE VALUES
    ~~~~~~~~~~~
    Moving values is a simple operation that relocates the value from a cell into
    another specified cell.

    For example, to move the value from cell B5 to cell C6, simply enter the
    following sequence of commands (assuming the pointer is already in cell B5):




    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [29] 
        /m [ENTER] [RIGHT] [DOWN] [ENTER]    (Pointing Method)
                     or
        /m B5 [ENTER] C6 [ENTER]             (Typing Method)



    MOVE FORMULAS
    ~~~~~~~~~~~~~
    The rules that apply to copying formulas also apply to moving
    formulas. Let's consider the same example of the three cells
    containing the following:

        cell    B1      contains    +A1+B4
          ''    B2          ''      +A1+$B4
          ''    B3          ''      +A1+$B$4
          ''    B4          ''      5

    The values displayed in cells B1, B2, B3 and B4 should be identical.
    Now move the cells B1, B2, B3 and B4 into C1, C2, C3 and C4
    respectively.  Let's see what the new cells contain.

        cell C1:        +A1+C4

    Notice the translation of B4 to C5.  This occurred because B4 was
    within the moved block.  The reference to A1 remains unchanged because
    it was outside the block.

        cell C2:        +A1+$C4

    Absolute symbol does NOT keep column reference from changing for the
    move operation because the reference was inside the moved block.

        cell C3:        +A1+$C$4

    Moved from original location but the formula changes the same as in
    cell C2.

    As you can see, NO translation occurs for cell references OUTSIDE the
    block being moved.  References to cells inside the block ARE
    translated during a move to reflect the new position.


    RECALCULATION MODES
    ~~~~~~~~~~~~~~~~~~~
    Recalculation refers to the manner in which all formulas within a
    spreadsheet are calculated.  As formula references get complex, the
    number of required calculations increases.  If every cell within the
    spreadsheet were calculated each time a cell was updated, it could
    take a while just to make a minor change.

    An alternate method is to calculate only those cells which are
    dependent on the updated cell.  Each dependent cell may have multiple
    dependent cells which must also be calculated, and so on until a root
    cell (a cell with no dependant references to it) is reached and the
    calculation sequence stops. This method is called AUTOMATIC
    recalculation, and is the default mode when AS-EASY-AS is first
    started.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [30] 
    To activate AUTOMATIC recalculation press the following sequence of
    keys.

        /sgra

    Which stands for the following commands.

        Menu, Sheet, General, Recalc, Auto.

    In some cases, a linked recalculation sequence may require too much
    time to recalculate after entry of new data.  Therefore, the
    calculation sequence can be turned off while a series of changes are
    being made to the spreadsheet. This method is called MANUAL
    recalculation.  After the changes are completed, the spreadsheet may
    be updated by pressing the CALC function key [F9].

    To activate MANUAL recalculation press the following sequence of keys.

        /sgrm

    Which stands for the following commands:

        Menu, Sheet, General, Recalc, Manual.

    When manual recalculation has been selected, the indicator 'MAN' will
    appear on the status line.


    SAVING THE WORKSHEET
    ~~~~~~~~~~~~~~~~~~~~
    To save the entries you have made in the worksheet, press the [/] key
    to bring up the main menu.  Select the FILE command choice by pressing
    "F" or by moving the cursor to highlight that word and pressing
    [ENTER].  You will see a new menu of file command choices.

    If you wish to save the file to a drive or directory other than the
    default drive/directory, you must change the data directory to the
    desired drive. This can be done by selecting the FILE DIRECTORY
    command and typing in the new path.  The path can be changed by typing
    in the new path at the "PATH:" prompt.  You can also change the
    drive/directory when specifying the file name by including the path
    with the file name.

    If you are using a diskette to store your worksheets, make sure the
    diskette is in the specified drive.  You should always have a
    formatted disk with room for extra worksheet files available.

    Select the STORE command.  If the worksheet is new, you will be
    prompted for the name of your worksheet.  A name is valid if it has up
    to 8 characters and does not contain any of the following characters:

        ","     "*"     "/"     "?"     "#"     " "     "'"     "|"

    Confirm the typed name by pressing [ENTER].

    Examples of valid file name inputs:


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [31] 
        SAMPLE1            Saves data in SAMPLE1.WKS in current path

        \DATA\SAMPLE1      Saves data in file SAMPLE1.WKS. in directory
                           \DATA of the current drive.  A beep will sound
                           and an error message will appear if the
                           requested directory does not exist.

                           NOTE:       The default path will now be
                                       \DATA of the current drive.

        D:\MINE\SAMPLE1    Saves data in file SAMPLE1.WKS in directory
                           \MINE of drive D:

                           NOTE:       The default path will now be
                                       D:\MINE\

    If you try to save a worksheet that was previously retrieved from your
    current data disk, the name of that worksheet will automatically
    appear in the Name input field of the file window.  Pressing [ENTER]
    instructs the program to accept that name.

    If a worksheet with the same name already exists on your data disk,
    the program will ask if you want to "cancel", make a "backup" or
    "replace" the old file (on the disk) with the contents of the current
    worksheet in the computer.

    If you choose to make a backup, the file on disk will be renamed with
    the extension .WKB and the new file will be saved with an extension
    .WKS.

    NOTE: This method provides only a single level of bakckup protection.
          If you desire additional backups, it is recommended that you
          save your files using a number appended to the end of the file
          name, i.e., WORK1, WORK2, WORK3, etc.


    SAVING PART OF THE WORKSHEET
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Sometimes it may be appropriate to save only a small portion of the
    spreadsheet.  This may be achieved by using the /File Xport command.

    Once the Xport command has been selected, AS-EASY-AS will ask if you
    want to export to a WKS or a dBASE III file, and then it will prompt
    for the name of the file.  Type the name and press [ENTER].  Do NOT
    add an extension when you type the name as this is performed
    automatically by AS-EASY-AS.

    After you have specified the name of the file, the program asks for
    the range to be exported.  The range can be specified by either
    pointing or typing, or a range name can be used.

    The specified range will then be exported to either a .WKS or .DBF
    type file.





    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [32] 
    RETRIEVING THE WORKSHEET
    ~~~~~~~~~~~~~~~~~~~~~~~~
    To retrieve a worksheet select the /File, Retrieve command.

    A window will open in the middle of the screen displaying worksheet
    files present in the default directory.  Only one page of names is
    displayed at a time.  To view subsequent pages press the [PGDN] or
    [PGUP] keys.

    Select your file by moving the pointer to highlight the file, or type
    the file name at the name prompt and then press [ENTER].  To change
    the path, you may type in the new path in the "PATH:" field, or
    include the path as part of the file name.  This new path will become
    the default path.


    COMBINING WORKSHEETS
    ~~~~~~~~~~~~~~~~~~~~
    The /FILE MERGE command will combine any designated worksheet file
    with the current file starting at the position occupied by the
    spreadsheet pointer.  The information merged from the new file will
    overwrite any information present in the cells.

    WARNING:   Information in cells overwritten cannot be recovered.

    When /File Merge is selected, choose either to merge the whole file or
    a named range from a specified file.  Once this choice has been made,
    you are asked to specify whether to merge the formulas in the named
    range or file or just the calculated values in the range.

    NOTE:   When the Merge-Range-Formulas is selected, the cell
            relationships are retained in the new worksheet.

    If a cell of the file being merged (from disk), contains a formula,
    and you selected /File, Merge, [All/Range], Value, then the last
    values contained in the cells when the worksheet was saved will be
    used in the merge operation.

    If you selected /File, Merge, [All/Range], Formula, then for cells in
    the file on disk that contained values, those values will be used in
    the merge operation.  For cells that contained formulas, however, the
    contents of the current cells will be replaced with the formulas from
    the file on disk.

    You will now be provided with three options for the merged
    information; SUM, DIFF, and REPLACE.


    SUM - will cause the cell contents of the file being merged to be
    added to the contents of the current file cells.

    DIFF - will cause the cell contents of the file being merged to be
    subtracted from the contents of the current file cells.

    REPLACE - will cause the cell contents of the file being merged to
    replace the contents of the current file cells.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [33] 
    IMPORTING FILES
    ~~~~~~~~~~~~~~~
    The File, Import command is different than the File, Merge
    command in that it allows the user to import data that is not in
    worksheet (WKS) format.

    Dbase
    ~~~~~~
    This command invokes a unique menu of commands that allow you to
    directly access database files created with dBASE III/Iv program
    (DBF).  The DBF operations that are supported in AS-EASY-AS are
    described below:

    ALL  -   Import ALL the data contained in the database file into
             the current worksheet, starting at the current cursor
             location.   Once this command is invoked, a file
             selection menu appears, similar to the File, Retrieve
             command. After the file is selected, a status window
             appears that reports the status of the file import
             operation.  The data is imported in AS-EASY-AS database
             format.  The field names become column headings and the
             data in each record is placed below the corresponding
             heading, one record per row.

    RANGE -  Import a range (portion) of the database by specifying
             the first and last record number of the desired range.

    BROWSE - This command allows you to look at all the records in a
             specified dBASE data file.  After the desired file is
             selected, the program enters the dBASE browse mode. The
             field names are displayed as column headings and the
             data in each record is placed below the corresponding
             heading, one record per row.  While in this mode, the
             following keys are active.

             [F2]  - Find    Find the first record that contains the
             specified search string.  Note that the search is
             performed only on the field that the cursor is currently
             located in.

             After you specify the string to search for, you are
             prompted to confirm that the search operation will be
             case insensitive (U).  If you want the search to be case
             sensitive, make sure you delete the U when the
             confirmation window opens.

             A sequential search is performed until a record is found
             that contains the specified search string in the current
             field.  The cursor will then be placed on the record and
             the search will stop.

             [F3] - Find Next    Find the next record that contains the
             specified string in the current field.

             [F4] - Mark     Mark a block of records to be imported to
             AS-EASY-AS.  Move the cursor to the first record to be
             imported.  Press [F4] to mark the record.  The marked

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [34] 
             record will appear highlighted.  Move the cursor down
             to mark (highlight) the records to be imported.  When
             completed, press [F6].  The marked records will be
             imported with the first record placed at the current
             cursor location.

             [F5] - GOTO     Move the cursor directly to a specified record
             number specified by the user.

             [F6] - Import highlighted block

             [HOME]      Move the cursor to the first record in the
             database.

             [END]   Move the cursor to the last record in the database.

             [Left, Right, Up, Down]   Move the cursor one field to
             the left, right, up, or down, respectively.

             [PgUp, Pgdn]    Move the cursor 20 records up, or down.

    CRITERION - This command allows you to selectively import those
             records in a dBASE III data file which match a specified
             criteria.  Once the command is invoked, a file selection
             menu appears, similar to the File, Retrieve command.

             After the desired file is selected, the program displays
             a window of the dBASE field names.  Use the cursor keys
             to select the desired field name for which the criteria
             is to be applied.  Pressing the first letter of a field
             name will move the cursur down the listing to field
             names which start with that letter.  Press [ENTER] to
             confirm the field name selection.

             If the field selected is a numeric field (signified by
             an N next to the field name), then a secondary selection
             window will appear with the following match options:


             1) Querry<=Db - Import files where field data is less
                than or equal to the match criteria.

             2) Querry<Db - Import files where field data is less
                than the match criteria.

             3) Querry=Db - Import files where field data is equal to
                the match criteria.

             4) Querry>Db - Import files where field data is
                greater than the match criteria.

             5) Querry>=Db - Import files where field data is greater
                than or equal to the match criteria.

             6) Querry<>Db - Import files where field data is not
                equal to the match criteria.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [35] 
             Highlight or select the appropriate match option and
             press [ENTER].  You will then be prompted to enter the
             match cirteria.  For string matches, you will be given the
             option of an exact, appear anywhere, or case insensitive
             match.  For numerical matches, enter the appropriate
             number or valid formula.  For date matches, enter the
             date using the @DATE(YY,MM,DD) function.

             Press [ENTER] to complete the selection.  Records
             which meet the criteria will be imported with the field
             names placed at the current cursor location.

             If the selected field is a character field (signified by
             C next to the field name), then a secondary window will
             appear with the following two options:

             1. Include - Import all records where the specified
             string exists ANYWHERE in the selected field.  For
             example, if this option was selected and the specified
             string was  "ic"  (without the quotes), then records
             that contained   Michael, Nick, Michelin,... would meet
             the criterion.

             2. Exact - Import records ONLY of the specified string
             matches the selected field EXACTLY.  For example, if the
             specified string was  "First"  (without the quotes),
             then a record that contained  "First", in the respective
             field would meet the criteria, while a record that
             contained "First Street", would NOT.


    List
    ~~~~
      Loads all files matching the search specification and present
      in the current directory.  The information includes filename,
      extension, size and date of creation, and is similar to the
      listing provided by the DOS DIR command.


    Text
    ~~~~
      Load a text file into the worksheet as text.  All digits and
      characters will be entered as labels (text).

      If no file extension is specified, the program assumes that the
      file that you want to import has the extension PRN, therefore,
      if you specify the name of the file without the extension, and
      the extension is other than PRN, it will not be found.

      Example:  The line 1,2,3,4,5 imported from a file as text would
      be stored in the corresponding cell as the string '1,2,3,4,5.

    Values
    ~~~~~~
      Load a text file into the worksheet and parse each line as
      values or as text.  Valid delimiters are spaces and commas. To
      keep a text string intact, enclose it in double quotes before

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [36] 
      importing it into the worksheet.

      Examples:

      Lines Imported      Stored in Worksheet as:
      1 2 3 4 5           Values 1 through 5 in 5 consecutive cells.
      1,2,3,4,5           Values 1 through 5 in 5 consecutive cells.
      1/2/3/4/5           Value 0.008333, i.e., the expression was
                          evaluated.
      1,A,2,B,3           Values 1, 2, 3 and strings A, B, in
                          consecutive cells.


    LEAVING THE WORKSHEET
    ~~~~~~~~~~~~~~~~~~~~~
    You have just completed your masterpiece spreadsheet and are now ready
    to call it quits for the day.  FIRST, MAKE SURE THAT YOU SAVED YOUR
    LATEST VERSION OF THE WORKSHEET (see previous section on saving your
    worksheet).

    Access the command menu by pressing the [/] key.  Select the EXIT
    command.  You will be given a second chance to change your mind when
    AS-EASY-AS asks if you want to quit, YES or NO.  Highlight the word
    YES or type the letter "y".  AS-EASY-AS will prompt you one last time,
    asking if you have saved your worksheet.  If you wish to return to the
    worksheet, press [ESC], otherwise press [ENTER].  The program will now
    return to DOS.

    If you performed the above keystrokes by accident and did not intend
    to leave the spreadsheet, you are out of luck because all spreadsheet
    information in the computer memory has been lost.

    Remember, save your data frequently as you work, and make back-up
    copies of your files!

    You can print any portion of the spreadsheet to either a PRINTER or a
    print FILE (on your disk) or append to a print file by selecting the
    "PrintTo" option from the main menu.

    If you are printing to a printer for the first time, you need to
    install your printer type.  This is done by the /User Install Printer
    command.  Once the selection is made, make sure to save your
    configuration file (see User Install for more information).















    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [37] 
    4.  PRINTING
    ~~~~~~~~~~~~
    To get into the printer menu, press the following sequence of keys.

        /pp

    Which stands for /PrintTo Printer.

    You are now in the print menu where all the print variations are
    defined. You will see the following selections on the command line:

    Range  Border  LineFeed  PageAdv  Options  Adjust  Go  View  Quit

    Range       Stands for the rectangular area of the spreadsheet which
                is to be printed.  This must be defined prior to printing.
    Border      Print specified row(s) and/or column(s) on every page of
                the output.
    LineFeed    Advance the paper in the printer a single line.
    PageAdv     Advance the paper in the printer to the top of the next
                page.
    Options     Allows access to Sub-menu of printer options; margins,
                pitch, header, footer, format type and printer setup
                string. (See print menu explanations for further
                details).
    Adjust      Synchronize the program's top-of-page with the printer
                top-of-page.  The page and line counters are reset to 1.
                Note:  If this synchronization is not done, you may get
                several blank lines in the middle of the printed page.
                This is the gap allotted to skip over sheet perforation.
    Go          Starts the printer printing.
    View        Preview the selected range before printing

    All print output is directed to the printer attached to the parallel
    port LPT1, or LPT2, as selected under the User, Install, Device
    menu.  To direct information to be printed to alternate ports
    use the Print, File command.  As an example, to send output to serial
    port #1 (COM1), type:

        /PrintTo File COM1. [ENTER]

    and execute the Adjust Go commands.

    NOTE:   You must preset the Baud Rate using the DOS MODE command.















    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [38] 
    PRINTER BORDERS
    ~~~~~~~~~~~~~~~
    The PrintTo Printer Borders command allows you to select row(s) and/or
    column(s) from your worksheet that you wish to have printed on every
    page. This is especially useful for large multi-page spreadsheets
    where you need to have column headings or row descriptors printed on
    your output.  The Printer Borders command operates similar to Sheet
    Borders.

    The print range need not be adjacent to the borders you've selected.
    This allows you to print part of a ledger complete with row and column
    headings.

    When Printer Borders is used, you must be careful when specifying the
    ranges.  The rows and columns specified as your print border SHOULD
    NOT be included as part of your print range:  you may end up with
    duplicate rows or columns in your output.

    To clear Printer Borders, select None under the Borders menu.


    MARGINS & PAGE LENGTH - PRINTER OPTIONS
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    AS-EASY-AS default margin settings are 0 for the left margin and 80
    for the right margin.  Both margins are measured in characters from
    the left edge of the page.  Using the default settings, you are able
    to print a range of up to 80 characters wide.  Setting the left margin
    to 10 allows you to print a range 70 (80 minus 10), characters wide.

    If your spreadsheet will not fit across a page, AS-EASY-AS prints the
    left part (on a page) then prints the next section on a new page, and
    so on until the entire spreadsheet is printed.  You can combine these
    printed pages to create one wide spreadsheet.

    If you are using wide paper, or other than 10-pitch print, and you are
    printing more than 80 characters wide, you will need to change the
    right margin.

    If you've selected condensed print and your output continues to print
    additional pages while leaving a large right margin, chances are your
    right margin needs to be increased to accommodate the width of your
    print range.

    The print margins that can be set in AS-EASY-AS are described below:

    Page Length (0-1024) determines the number of lines printed on each
        page. The default, 66, is the correct setting for a printer that
        prints six lines per inch (the standard setting) on 11-inch paper.
        If your printer is set to a different lines-per-inch value, or if
        your paper is a different length, change this setting accordingly.
        To calculate the page length, multiply the lines-per-inch value by
        the number of inches on a page.  This setting is unaffected by
        headers, footers, or top or bottom margins.

    Left (0-240) determines the amount of space to leave between the left
        edge of the paper and the first column of data.  The default, 0,
        leaves no left margin.  Depending on the width of your

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [39] 
        spreadsheet, you may want to lengthen this margin.

    Top (0-30) determines the number of blank lines to leave at the top of
        each page.  The default, 2, leaves a margin of approximately one-
        half inch. If you include a header in your printout, it is printed
        underneath this margin with one blank line between it and the
        spreadsheet data.

    Right (0-240) determines the amount of space to leave for a right
        margin. spreadsheet data. This value is the number of spaces
        between the left edge of the paper and the beginning of the right
        margin - like the margin settings on a typewriter.  The default,
        80, begins the right margin at the 80th character space, leaving
        no right margin.

    Bottom (0-32) determines the number of blank lines to leave at the
        bottom of each page.  The default, 2, leaves approximately one-
        half inch.  If you include a footer in your printout, it is
        printed above this margin with one blank line between it and the
        spreadsheet data.

    In setting the correct page length for your printer, please note the
    following pointers:

        The default page length is set to 66 lines.  Most dot matrix
        printers default to 6 lines per inch, so no changes are required
        if you are printing on 11 inch long paper.  If you wish to change
        the lines per inch spacing to 8, you must also change the lines
        per page to 88 (8 lpi X 11 inches) for headers, footers, and page
        breaks to work properly.

        Most laserjet printers default to a value of 60 lines per inch.
        If this is the case, you must adjust the page lines accordingly.

        If you have set your top and bottom margins equal to 0 and your
        page length equal to 66 lines, you are able to print a range of 60
        rows on a page before the program will skip to a new page.  One
        line at the top and bottom of the page is reserved for the perf-
        skip feature.  Two lines each are reserved for headers and
        footers; one for the line of text and the second line serves as a
        spacer between the header or footer and the body of the text.

    To figure out the correct number of lines that will be printed by AS-
    EASY-AS on a single page, do the following:

        Get the lines per page setting of your printer (for the current
        pitch and line spacing).  Note that this setting should match the
        page length setting specified in AS-EASY-AS.

        Subtract the AS-EASY-AS settings for top and bottom margin

        Subtract 4 lines (header, footer and lines between the header, the
        footer and the text body).

        Subtract 2 lines (top and bottom skip perforation).



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [40] 
    In other words, the number of text lines that will be printed on a
    single page is given by:


        Page Length - Top Margin - Bottom Margin - 6.


    INSERTING PAGE BREAKS
    ~~~~~~~~~~~~~~~~~~~~~
    AS-EASY-AS automatically inserts page breaks where needed (as
    specified by the Pagelength command setting).  You may also specify
    "hard page breaks", i.e., force a page break, manually, using one of
    two methods.

        By typing a hard page break into the first cell of a blank row.
        The hard page break is the vertical piping character, followed by
        two colons (|::). If there is any other data in that row it will
        be ignored.

        By using the /Sheet Insert Page command while in the left most
        cell of the print range.  This command sequence automatically
        inserts a blank row and the "|::" character sequence for you.

    NOTE: The hard page break character sequence must be placed in the
          left-most column of the print range in order to be recognized by
          AS-EASY-AS.


    PRINTER OPTIONS - HEADERS & FOOTERS
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Centering headers and footers can be performed by separating pieces of
    text with the "|" character. i.e., if you have the following in your
    header line:

        PAGE|TITLE|DATE

    This will be translated into:

    PAGE                    TITLE                       DATE

    The first word, "PAGE", is left justified since it is not preceded by
    a "|" character.

    The second word, "TITLE", is centered since it is preceded by the
    first "|" character.

    The third word, "DATE", is right justified since it is preceded by the
    second "|" character.

    -  Sequential page numbering can be achieved by placing the "#"
       character in the header/footer line.

    -  Placement of the current date on the top/bottom of a printed page
       can be achieved by placing the "@" character in the header/footer
       line.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [41] 
    PRINTER OPTIONS - EMBEDDED CODES
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    You can place text enhancement printer control codes directly into a
    print range.  This can be achieved by placing:

        |\xxx\yyy

    in the first column of the print range, where xxx and yyy are your
    printer's control codes.

    For example, if your print range was A1 to H20, by putting the
    following in the FIRST column (A1) of the print range,

     |\027\069   (This is the setup string for emphasized print on an EPSON
            printer.  Note that the prefix character [|] will not be
            displayed).

    the result is emphasized text on an Epson printer.

    NOTE:  Any remaining data on line containing the printer control
           codes will not be printed.  An entire line may be hidden
           during printing if a single "|" is placed in the first column.

    If you try to enter text-enhancing control codes inside a label,
    you'll find that when you enter Alt 027, you exit the edit mode.
    That's because control characters (ASCII less than 32), are translated
    by the program into special editing keys such as Arrow keys, [ESC]
    key, etc.

    To enter control characters, you need to use the Edit Bypass Function
    key, [F3].  The sequence is:  F3 Alt nnn.  F3 is only active for one
    control character and must be pressed every time additional control
    characters are to be embedded.

    For example, if you want to print "This is a CONTROL code sample" on
    an EPSON  printer with only the word "CONTROL" in condensed mode, the
    following keystrokes should be used:

    This is a F3 [Alt] 015 CONTROL F3 [Alt] 018 code sample.

    The 015 code turns the condensed print mode on and the 018 code turns
    the condensed print mode off.

    Page breaks can be forced by placing a single "|" followed by two
    colons "::" in your text.  This must be placed in a cell that is in
    the left-most column of your print range.  Information in cells to the
    right of the page break command will not be printed.

    A page break can also be inserted into your worksheet by using the
    following command:

        /Sheet Insert Page

    This command will insert a new row and place "|::" in the cell at the
    current cursor location.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [42] 
    PRINTER OPTIONS - TYPE
    ~~~~~~~~~~~~~~~~~~~~~~
    The output can be printed (to printer or file) in one of the following
    formats.

     AS SEEN    Prints the output in row and column format (as
                displayed on screen) with headers, footers, and page
                breaks.

     CONTENTS   Prints a columnar listing of all non-blank cells and their
                contents.  Useful for printing cell formulas and
                documentation of calculation templates.

     NOFORM     Prints the output without header and footer information
                and suppresses page breaks.


    CONTROLLING THE PRINTER
    ~~~~~~~~~~~~~~~~~~~~~~~
    Most printers can be controlled by sending a sequence of ASCii control
    codes to your printer.  (For details and control codes, refer to your
    printer's user's manual).

    Commonly used codes for the EPSON series of printers are:

        \027\069    Turn on  Emphasized text (or \027E)
        \027\070    Turn off Emphasized text (or \027F)
        \015        Turn on  Condensed  text
        \018        Turn off Condensed  text


    The three digit number 027 stands for the [escape] code and the three
    digit number 069 stands for the capital letter 'E'.

    Printer codes may be entered by selecting PrintTo Printer Options
    Setup. The spreadsheet accepts codes only if they are separated by the
    back-slash character [\] .  To select the emphasized text mode, type
    the following in response to the prompt for the setup string (remember
    to use 3 digits):

        \027\069   [enter]

    To change the string, re-select the SETUP option.

    ASEASY.PRT
    ~~~~~~~~~~
    To make life easier so you don't have to manually enter printer setup
    codes or look up an infrequently used setup code, simply type the [\]
    character when entering a printer setup code and press F1.

    A listing of predefined setup codes from ASEASY.PRT will pop-up in a
    pick window on your screen.  By highlighting the desired function, the
    appropriate printer code will be entered into the setup string.

    Any control codes supported by your printer can be incorporated in the
    file ASEASY.PRT, an ASCII text file, which has the following
    structure:

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [43] 
      - Each control code consists of two lines.

      - The first line contains a description of the print enhancement
        (eg. Emphasized, Underline, ....).  Description  names should not
        be separated by spaces,  e.g. 'Dbl_Strike'  NOT  'Dbl Strike'.
        Note that this description name must not exceed 11 characters.

      - The second line contains the decimal setup code for the described
        print enhancement.

            e.g.   027\015    -  condensed for EPSON printers


    NOTE: There is no leading backslash in the setup codes in the
          ASEASY.PRT file (i.e.  027\015,  NOT \027\015)

    You can create or edit ASEASY.PRT with any word processor/text editor
    that generates ASCII files.

    Let's say you want to incorporate the following codes supported by
    your EPSON compatible printer in an ASEASY.PRT file:

        Decimal Control Codes             Print            ASEASY.PRT
        From Printer User's Manual      Enhancement            Code
        ~~~~~~~~~~~~~~~~~~~~~~~~~~      ~~~~~~~~~~~         ~~~~~~~~
            27, 77                      Elite Pitch         027\077
            27, 72                      Double Strike       027\072
            27, 69                      Emphasized          027\069

    The ASEASY.PRT file generated for the codes should look something like
    the one presented below:

        Elite           <-----   First line of the file
        027\077                     .  (Up to 240 characters long)
        Dbl_strike                  .
        027\072                     .
        Emphasized                  .
        027\069         <-----   Last  line of the file


    PRINT TO A FILE
    ~~~~~~~~~~~~~~~
    To create an ASCII file (which contains the print range) for transfer
    to other programs (like databases or word processors) use the
    following procedure.

    Type:   /pfTEST   [ENTER]

    Which stands for /PrintTo File.  At this point the program asks for
    the name of the print file.  Type the name of the print file (in this
    case TEST) and press ENTER.  If no extension is specified, an
    extension of ".PRN" will automatically be attached to the file name.
    If you have already sent output to the print file during the current
    AS-EASY-AS session, the name of the print file will appear at the
    prompt line.  You can select it by just pressing ENTER.

    If you wish to append an existing ASCII print file, select /PrintTo

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [44] 
    Append. This command will print the selected range to the end of the
    specified print file.


    PRINTING COMBINED TEXT AND GRAPHICS
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    AS-EASY-AS has the ability to print combined spreadsheet data and
    graphs on dot matrix and laserjet printers.  To print a graph from
    spreadsheet data, you must have first created the graph and formatted
    a range to display the graph (see Section 5.4, Combining Text and
    Graphics).

    To print the combined data graph, first select /PrintTo Graphics.
    Select Range and highlight the area you would like to print.  Make
    sure the entire graph is contained within the print range.



    USING PRINT VIEW
    ~~~~~~~~~~~~~~~~
    It is possible to preview the layout and organization of data, page
    breaks and margin settings in the spreadsheet through the use of the
    view command. AS-EASY-AS will display either a full page of text (by
    pressing [F2]) or a 200% zoom of a half page (by pressing [F1]).

    To advance through the print range use the [PGUP] or [PGDN] keys.  Any
    graphs inserted will be displayed in their correct position on the
    page.






























    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [45] 

    5  GRAPHICS COMMANDS
    ~~~~~~~~~~~~~~~~~~~~
    AS-EASY-AS provides you with the capability to create high-quality
    graphs from your spreadsheet data.  Hardcopy output can be generated
    on 9- or 24-pin dot matrix printers, laserjet or Postscipt printers.
    A .PIC or PCX file can be created for use with your word processing
    or graphics programs.

    Fourteen types of graphics can be created:

        X-Y             Bar                 Delta           Area
        Line            Stacked Bar         Cumulative      HLoc
        Polar           Strip               Wall            Pie
        Radar           Contour

    Many options are available to customize graphs for business graphics
    as well as for engineering and scientific analyses, etc.  Titles and
    legends can be added with user-specified type size.  The user can also
    specify fill patterns, colors, line styles, and tick mark styles.

    Graphs can be scaled on both the X (horizontal) axis and the Y
    (vertical) axis so that the entire graphed range (or a portion of the
    range) may be displayed.  A logarithmic adjustment to either or both
    of the X and Y scales may be performed to produce semi-log or log-log
    graphs.

    All data points are specified by ranges in the spreadsheet.  Up to six
    curves may be displayed on a single graph, with an additional six if
    two graphs are merged.

    The user should keep in mind that the Contour graph-type is
    drastically different than the other graph types.  This unique
    graph uses a different type of data range definition.  When
    requested for the X-Range, you need to specify a block of data
    (i.e., more than one row or column).  Each row of data is
    displayed as a contour of relative data, using a different color
    and/or fill pattern.   The Z-Scale Step parameter may be used to
    set the number and range of contour lines.

    To create a sample pattern, enter the data below in your
    worksheet (one value in each adjacent cell), highlight the whole
    block as the X-range, select CoNt type graph and then VIEW.


    100         100     100     100     100
    100          93      87      93     100
    100          87      60      87     100
    100          93      87      93     100
    100         100     100     100     100

    The data presented above represents the temperature profile of a
    metal plate.  When the data is plotted, each color contour
    represents a given temperature range. It is very clear, for example,
    that there is a low 60 degree temperature core, surrounded by an
    isothermal area of 87 degrees, which is surrounded by an isothermal
    area of 93 degrees, which is surrounded by the outer isothermal area

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [46] 
    of 100 degrees.

    To demonstrate the effect of the Z-Scale Step parameter,
    set the Z-Scale Step value 10 and view the graph again.

    The following section provides details on the graphics commands to
    allow you to create customized graphs.



    GRAPH RANGES
    ~~~~~~~~~~~~
    Specify the X range and up to six Y ranges (A through F) for the
    graph. Ranges can be specified either by the pointing or typing
    method, or by using a predefined range name.

    A basic difference between X-Y type graphs and other types of graphs
    should be remembered.  Line graphs and bar graphs represent a set of
    values as vertical distances.  The only numeric scale in this type of
    graph is the one along the vertical axis.  The horizontal axis
    displays all items in the X range in a non-numeric, equally spaced
    sequence of text, (e.g. dates, names of cities, etc.).

    The X-Y type graphs are two-dimensional.  They represent pairs of
    values as a function of their horizontal and vertical coordinates.

    Note that there should be a one-to-one correspondence between the
    elements of the X-range and Y-range(s).




    LABELS
    ~~~~~~
    Define a range of labels that are to be used to mark each of the data
    points on the specified graph range.  A one-to-one correspondence is
    needed between the range being plotted and the labels for that range.
    The data labes may be placed Above, Below, to the Left or to the Right
    of the data points.


    CUSTOM OPTIONS
    ~~~~~~~~~~~~~~
    Customize the colors of the graph series, and the inner and outer
    portions of the graph in one of 16 colors.  The following colors are
    available (on monitor/card combinations that support them):  Black,
    MidBlue, Green, Cyan, Red, Magenta, Brown, Gray, Smokey, Blue,
    HiGreen, LightBlue, Scarlet, Violet, Yellow,  and White.  Each data
    range may be assigned a color.  In addition, the following colors may
    be specified:

      INNER: Color of the graph screen.
      OUTER: Outer color of the graph screen.
      TITLE: Title color of the graph screen.
      VALUE: X- and Y-Axis scale labels.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [47] 
    LEGEND
    ~~~~~~
    Set the graph legend and its location.  An input window is used to
    display the legend options.  The Legend option allows the user to
    enter text which describe the ranges of A through F.  Legends may be
    placed below the graph (Line) or to the right of the graph (Box).


    TITLES
    ~~~~~~
    Specify the title strings on graph.  The Main title, Second title and
    X and Y axes titles may be entered. Preceding the main title with the
    "#" character will create a framed title box.


    GRID
    ~~~~
    Select a horizontal and/or vertical grid at each scale division on
    your graph with a solid or dotted line.  Other options include
    specifying a dotted or a solid grid line, and whether or not to use
    grid lines for the minor axis divisions.


    FONT TYPE
    ~~~~~~~~~
    AS-EASY-AS 5.5 gives you the ability to use either a bitmapped, or a
    stroked font in the graphs created by the program.  Which one to use
    will probably depend on your output devise.  Note, however, that
    stroked fonts generally have better definition at smaller sizes.


    FONT SIZE
    ~~~~~~~~~
    Relative size of the font used in graph titles, legends, values, and
    labels.  The available sixes range from 4 to 36.  These are
    internal point sizes.  Once you select the entity to change, you
    are presented with a pick window contain all available sizes.
    Simply move the pointer to the desired point and press [ENTER].
    Alternatively, press [ESC} once and then type in one of the
    allowable sizes and press [ENTER].


















    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [48] 

    The text sizes which may be changed, along with their default values,
    are listed below:

    MAIN            18           LEGEND          9
    SECOND          14           VALUES          9
    X-AXIS          14           LABELS          9
    Y-AXIS          14


    CLEAR
    ~~~~~
    Reset all the options for the entire graph or for a selected range
    back to the default settings.


    NAME
    ~~~~
    This option allows you to define multiple graphs and associated
    settings and titles in a single worksheet.  One named graph may be
    superimposed on the main graph, or they may be displayed as two
    separate graphs, one above the other.  You may also insert a graph
    into the worksheet.

    INSERT
      Place either the MAIN or a named graph into the spreadsheet.  The
      range enclosing the inserted graph appears in a highlighted color.

      The upper left cell of the range contains the graph name and the
      size of the display in columns and rows.  For example, "MAIN:2,7"
      will display the main (or current) graph in a range 2 columns wide
      and 7 rows deep.  The cell may be edited to change the name and size
      of the graph if desired.

      If you are currently in one of the graphics video modes, the
      inserted graph will be visible immediately, in the highlighted
      block.

      If you are not in a graphics video mode, The inserted graph
      will only be visible when it can fit entirely on the screen
      when previewing a print range with (PrintTo, Printer, View) and
      the page contains a graph.

      To print combined worksheet text and graphics see Section 5.4,
      Combining Text and Graphics.

      If any of the data ranges are altered, the inserted graph will
      reflect the changes next time the screen is updated (e.g., when
      PgUp, or PgDn is pressed), or when  manually recalculate the
      spreadsheet by pressing the [F9] calc function key.

    USE
      Select one of the previously named graphs and make it the current
      graph.  All current settings are replaced with the named graph's
      settings.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [49] 
    CREATE
      Create a named graph which saves the current graph settings.

    DELETE
      Delete one of the previously named graph settings.



    MERGE
      Merge two graphs (a NAMED graph and the currently defined graph).
      The NAMED graph will be superimposed on top of the MAIN graph and
      it will be scaled on the right side of the graph.  It can have its
      own set of scaling factors, limits, formats, etc.

      To disable the merge feature select  /Graphics, Name, Merge, Reset


    SPLIT
      Shows two graphs on the same screen [Viewing ONLY!].  The top
      graph is the graph currently defined (MAIN).  The second, named
      graph, occupies the bottom half (similar to the Graphics, Name,
      Merge Option).  Each graph will have its own set of scaling
      factors, limits, formats, etc.

      NOTE: To disable the split feature select:  /Graphics,
            Name, Reset

    RESET
      Reset the merge or split option so that only the main graph will be
      displayed.


    VIEW
    ~~~~
    View the graph currently defined.  The resolution depends on your
    graphics board:

        CGA         640 x 200  pixels, 2 colors
        Hercules    720 x 348  pixels, 2 colors
        EGA         640 x 350  pixels, 16 colors
        AT&T        640 x 400  pixels, 2 colors
        VGA         640 x 480  pixels, 16 colors
        SVGA        800 x 600  pixels, 16 colors

    NOTE:  Graphs cannot be viewed on a system having a non-Hercules
           monochrome display adapter.  If a message is received
           indicating a graph cannot be displayed because of an invalid
           monitor type, and you have one of the above graphics
           boards, AS-EASY-AS may not have auto detected the
           graphics card properly.

           Save your worksheet and restart the program with the
           appropriate command line switch found in Section 2.3,
           Starting the Program.




    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [50] 
    [PLOT] IMAGE
    ~~~~~~~~~~~~
    Specify the height and width for the graph.  Dimensions are in inches.

    HIGH
      Specify the vertical dimension of the graph to be generated on the
      printer.


    WIDE
      Specify the horizontal dimension width of the graph to be generated
      on the printer.

      NOTES: 1.  To adjust the left margin, which is the
                 distance between the left side of the paper and
                 the Y-scale title, use /PrintTo Printer Options
                 Margin Left.

             2.  To create a top margin, you must use
                 /PrintTo Printer and select LineFeed several times
                 until the desired top margin has been created.

    PORTRAIT
      Print graph oriented at zero degrees.

    LANDSCAPE
      Rotate output of the graph 90 degrees.

    DRAFT
      Specify single pass or low density mode for the printer. Selecting
      this option is recommended for plotting draft graphs because the
      printing speed is about twice as fast as NLQ.

    NLQ
      Specify a high resolution print option.  This option will produce a
      dark, high quality graph.


    COMBINING TEXT AND GRAPHICS
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~
    AS-EASY-AS can include graphs within your spreadsheet for printing
    combined data and graphics.  Create a graph as discussed previously.
    Select /Graphics Name Insert, and highlight the area in which the
    graph is to be placed (see Graphics Name Insert in this Section for
    more information).

    The formatted range appears in a highlighted color.  The upper left
    cell of the range contains the graph name and the size of the display
    in columns and rows.  The cell may be edited to change the size of the
    graph if desired.

    The graph will appear when previewing (PrintTo, Printer, View) the
    page containing the graph.  To print text and graphics together, see
    Section 4, Printing Text and Graphics.




    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [51] 
    SAVING A GRAPH
    ~~~~~~~~~~~~~~

    When a spreadsheet is saved, the current graph settings and named
    graph settings are saved with it.  When the file is retrieved, those
    graph settings are retrieved as well.  The user can then view the
    current graph by either pressing the [F10] function key from the ready
    mode, or by selecting the /Graphics, View command.

    Sometimes more than one graph might need to be created from the data
    in a worksheet.  That's no problem.  Instead of having to re-specify
    the settings every time you want to look at a previous graph, you can
    use the /Graphics, Name, Create and Use commands.

    When the /Graphics, Name, Create command is invoked, the program saves
    the current graph settings under the user specified name.  To select
    and view a named graph, select the /Graphics, Name, Use command and
    select or type the desired graph name.  The selected graph becomes the
    current or MAIN graph.







































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [52] 
    6. DATA COMMANDS
    ~~~~~~~~~~~~~~~~
    In addition to the typical spreadsheet format, AS-EASY-AS includes
    powerful DATA commands which enhance your ability to create
    sophisticated data management applications, what-if tables, etc.


    DATA FILL
    ~~~~~~~~~
    The Data-Fill command allows you to fill a range with an arithmetic
    sequence of equally spaced values.

    For example, assume that you want to fill a range of cells with real
    values that range from 3 to 43 in increments of two.

    Move the cursor to the beginning of the range.  Invoke the Data-Fill
    command (/df), enter range to fill, the starting value (in this case
    3), and the increment value (2).


    DATA TABLE
    ~~~~~~~~~~
    DATA TABLE - 1 INPUT
    ~~~~~~~~~~~~~~~~~~~~
    The Data Table-1 Input command permits you to do 'what-if' analysis by
    generating a table based on substituted values in an input cell.

    This command takes the input value from the first column, places the
    value in the model, calculates a result, extracts that value and
    places it in the table to the right of the input value.  The process
    is continued until the bottom of the table range is reached.

    For example, suppose that you want to borrow $1 million to start a new
    business.  Since you could borrow money from a number of different
    institutions with different interest rates, you want to compare your
    monthly payments for  different interest rates.  The payback period is
    10 years.

    To generate the comparison table, follow these steps:

        Enter the amount you want to borrow in cell B1
        Enter the starting interest rate in cell B2
        Enter the term of the loan (years) in cell B3

    Generate the following labels (using the /Range, Name, Create
    command) to help you identify the various inputs:

        Cell  B1  -  PRINCIPAL
        Cell  B2  -  INTEREST
        Cell  B3  -  TERM

    Enter the payment equation in cell B4:

        @PMT(PRINCIPAL,INTEREST/12,TERM*12)

    NOTE: INTEREST/12 and TERM*12 are used to obtain payments
          on a monthly basis.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [53] 
    Generate a column of interest rates in this example ranging from 9% to
    10.1% in cells A8 to A19.

    Tell the program which value to extract and place in the table by
    entering a reference to the payment formula (cell B4) in cell B7
    (+B4).

    Now you are ready to generate the desired table using the following
    commands:

      /dt1       -  Data, Table, 1-input
      A7..B19
      [ENTER]    -  The table range (it includes the input values that you
                    want to vary and the locations that you want the
                    calculated result to be placed in).
      B2         -  The input cell. This will be the value that will change
                    after each calculation, and it is the value that we want
                    to extract.

     NOTE:  Multiple extractions are allowed providing each output
            column has a cell reference at the top.



    DATA TABLE - 2 INPUTS
    ~~~~~~~~~~~~~~~~~~~~~
    Now, let's say that you want to generate a comparison table varying
    both the interest and the term of the loan.

    Leave the column containing the interest rates (A8..A19) unchanged.
    Place the different terms (number of years) that you desire in row 7
    (one entry in each column).  Place 10 in cell B7, 20 in cell C7 and 30
    in cell D7.  Enter the formula +B4 in cell A7 (this tells the program
    what cell you want to extract values from).  Now enter the following
    keystrokes:

        /dt2             -  Data, Table, 2-inputs
        A7..D19 [ENTER]  -  Table range
        B1 [ENTER]       -  First input (Interest rate will vary)
        B3 [ENTER]       -  Second input (Term will vary)


    DATA SORT
    ~~~~~~~~~
    The Data Sort command is used to rearrange the information in a
    worksheet in alphabetical or numerical order.  The sorting process
    operates on rows. Let's look at the following example.

    Assume that the range B4 to D15 contains some student informations as
    follows:

       column B - last name
       column C - first name
       column D - grade

    It would be nice to sort this information by the students' last name
    or by grade.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [54] 
    The following steps will sort the information by the students' last
    names (only).  Four sorting criteria can be specified (i.e. four
    different columns). This would be very useful in cases where, for
    example, two students had the same last name or two students had
    the same grade, i.e. a tie-breaker.

    1.  /ds               -   Invoke the Data, Sort menu
    2.  d                 -   Invoke the D-Range command to specify the
                              range to be sorted
    3.  B4..D15 [ENTER]   -   Specify the range to be sorted
    4.  p                 -   Invoke command to select the Primary sort key
                              (column)
    5.  B4 [ENTER]        -   Select Primary sort key.  Any cell in column B
                              would select Last Name as the primary sort key.
    6.  a [ENTER]         -   Accept the default, ascending order.  Typing d
                              [ENTER] would select descending order.
    7.  s                 -   Invoke command to select the Secondary sort
                              key (column)
    8.  D4 [ENTER]        -   Select Secondary sort key.  Any cell in column D
                              would select Grade as the secondary sort key.
    9.  a [ENTER]         -   Accept the default, ascending order.  Typing d
                              [ENTER] would select descending order.
    10. g                 -   Select Go to perform the sort.

    To sort on any other field (column), simply type in a new primary/
    secondary column.


    DATA BIN
    ~~~~~~~~
    The Data Bin command creates a frequency distribution table displaying
    the count of values in a range that falls within given ranges, bins,
    as well as the frequency of values within that range.  The bins are a
    block of values, in ascending order, placed anywhere in the worksheet.

    The requirements for setting up the bins are:

     1.   The bin values are contained in a single column block, and

     2.   There are two blank columns directly to the right of the bin
          range.  (This is the area that will be filled by the /db
          command).

    Once this command is invoked, the user is prompted to supply the
    "Analysis" range and the "Bin" range.

    ANALYSIS range, as the name indicates, is the range containing the
    values that the user needs to perform the frequency distribution on.
    BIN range is the column containing the bin (group) values, with two
    blank columns to the right.








    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [55] 
    DATA GOALSEEK
    ~~~~~~~~~~~~~
    The Data Goalseek command allows you to search for the input that
    would result in a desired output from a model.  Specify the INPUT
    cell, the OUTPUT cell and the DESIRED goal and AS-EASY-AS modifies the
    input cell by using a NEWTON-RAPHSON convergence technique until the
    specified output is reached.  If the desired result has not been
    reached by 25 iterations, the process stops, and the value plus @ERR
    is placed in the input cell.  If this happens try choosing an input
    closer to the desired input.

    When prompted for the desired goal, AS-EASY-AS requires you specify
    the tolerance limit.  You should be aware that the more restrictive
    (smaller) the tolerance is, the longer it will take the program to
    converge to the correct answer.

    For example try the following situation:

    You want to borrow $100,000 for 30 years, and you don't want your
    monthly payments to exceed $1,028.61.  You want to determine the loan
    interest rate which would meet the above restrictions.

    The steps required to solve this problem are presented below:

    a.  Enter the Loan amount in cell A1  -->  100000
    b.  Enter a reference interest rate in cell A2 (i.e. if you start with
        an annual interest of 18%, enter 0.18)
    c.  Enter the term of the loan (30 * 12 = 360 months) in cell A3.
    d.  Enter the Payment equation in cell A4 - @PMT(A1,A2/12,A3)
    e.  Invoke the DATA, GOALSEEK command
    f.  Specify cell A2 as the INPUT cell
    g.  Specify cell A4 as the OUTPUT cell
    h.  Specify 1028.61 as the DESIRE
    i.  Specify a tolerance of 0.001

    Cell A4 will display the amount you specified as the desired monthly
    payment (if solution convergence occurred), and cell A2 will display
    the interest rate required for the load to meet your restrictions,
    0.12 (or 12%).



    DATA REGRESSION
    ~~~~~~~~~~~~~~~
    The Data Regress command allows you to determine the coefficients
    which correspond to a least squares fit of a line to a set of
    X and Y data.

    Assume that you have a range of data as follows:

          A4..A9   -   X-Values
          B4..B9   -   Y-Values

    Now follow the sequence of keystrokes presented below:

        /drxA4..A9~yB4..B9~oD4~


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [56] 
    This will invoke the Data Regress command.  The program will prompt
    for the X (or independent) range, (A4..A9), the Y (or dependent)
    range, (B4..B9), and the location that you want the output to be
    placed, (D4).

    The Y-Intercept and slope of a straight line going through the data
    points will then be entered in cells D4 and D5.  Additionally, values
    for R squared, the sum of the X squared values, the sum of the Y
    squared values, and the sum of the X*Y values, X and Y standard
    deviations, Slope error, and count sample are also entered.

    Note that the above sequence of commands assume a linear regression
    model, i.e., the calculated coefficients assume that the function is
    of the form:
                     Y = a + b*X

    where (a) is the intercept and (b) is the slope.  AS-EASY-AS,
    however, provides you with the tools to perform much more
    sophisticated regression analyses by controlling the assumed
    function.  Under the /Data, Regression, Coefficients menu, you may
    select the type of function to use for the regression.

    For example, if you select the second (square), third (cubic) and
    fourth degree coefficients, the assumed function will be of the
    form:
                     Y = a*X^2 + b*X^3 + c*X^4

    where a,b,c are the calculated coefficients.  Details about the
    Least Squares Fit topic are beyond the scope of the user's manual.
    You should be familiar with the Least Squares Fit and
    regression concepts before using these capabilities.



    DATA INPUT RANGE
    ~~~~~~~~~~~~~~~~
    This powerful command is mainly for those who develop applications to
    be used by other individuals.  Once this option is invoked and a range
    is highlighted, cursor movement is restricted to the cells that were
    intentionally unprotected by the user using the /Range, Lock, No
    command.

    Example:
        /rlnC2..C4 [ENTER]          [Unlock Cells C2, C3, and C4]
        /sgpe                       [Turn On Protection]
        /dirA1..D8 [ENTER]          [Input Restricted Cells]

    would turn the global protection on and would only allow the user to
    move the cursor to cells C2, C3, and C4 (those specifically
    unprotected by the user).


    DATA INPUT FORM
    ~~~~~~~~~~~~~~~
    This powerful command allows a user to define a form that can be used for
    entering records, editing records, etc.  To create an input form:


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [57] 
    1.  Define a number of cells (in the same row) that contain the field
        headings for your database.
    2.  Format the field headings for the type of data each cell will
        contain/display.
    3.  Select Data Input Form, and highlight the range of field headings.

    AS-EASY-AS automatically takes the format of each field name cell and
    assigns it to new data input into that particular field.  It then
    creates an input/edit form, and locates the data base pointer at the
    first record of the database.  The user now has the option to enter a
    new record, edit the current record, move to the record ahead or
    before the current one, etc.

    NOTES:
      1.  All field names are left justified.  If the field names are to be
          right justified, they have to be padded with spaces.
      2.  A maximum of 15 input fields are supported.
      3.  The width of the column is used to set the data input field
          size.

      Example:
        Cells A2 through D2 contain the desired field names of an address
        database (First, last, Address, etc.)

    The keystrokes /difA2..D2[ENTER] will produce an AS-EASY-AS dtabase
    input form screen .

    To prepare the database to display the input data properly, the field
    names must first be formatted.  Since Name and Address will contain
    text, format these field names as "Label" (/Range Format Label).  This
    ensures that when a street number is entered, followed by the street
    name, the contents will be a label, rather than a value.

    Phone could also be formatted as "Label" in which case the user would
    need to provide the parenthesis and hyphen each time a phone number is
    entered.

    Format last call as date (/rfd) and select one of the date options.
    When entering the date, simply type "8/29/91".  AS-EASY-AS will
    convert the string to its date equivalent.

    If cell D2 had not been formatted with a date format, and the number
    was entered as 08/29/91 (no apostrophe), cell D3 would display
    0.0030315, i.e., the indicated division would have been performed; an
    action which was not intended.

    Note the description of the keys available in this mode displayed on
    the top line of the screen:

        PgUp          -  Go to the previous record
        PgDn          -  Go to the next record
        Ctrl-PgUp     -  Go to the beginning of the database (record #1)
        Ctrl-PgDn     -  Go to the end of the database

    The user can freely move up and down the fields using the arrow cursor
    keys.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [58] 
    7. DATABASE OPERATIONS
    ~~~~~~~~~~~~~~~~~~~~~~
    A database is information stored in a range of one or more rows and
    columns.  The information that can be stored in a database is almost
    anything that one normally keeps track of.

    Let's see how you might use database commands to keep track of a list
    of your customers, their addresses and telephone numbers (a function
    that is normally performed by a stack of index cards or a Rolodex).

    A spreadsheet, for example, holds a small database of customers.
    The database of customers is stored in the range A1..G7.  For each
    customer, you intend to keep track of the first and last name, street
    address, city, state and telephone number.  Each row (all the
    information for one customer) is called a record of the database.

    Each column has a heading identifying the information stored in the
    cells beneath it.  Each heading is called a "field" of the record.

    Once the information is stored in this database format, you can look
    at it many different ways and gain valuable information from it using
    the AS-EASY-AS database commands.

    There are three ranges in the Database Menu which must be defined. The
    INPUT range, the CRITERION range and the OUTPUT range.

    The operations that can be performed, based on the above ranges, are:

      FIND - Highlight records that match the criterion range.

      EXTRACT - Copy records that meet the criterion range into the
                output range.


    INPUT RANGE
    ~~~~~~~~~~~
    The input range is the entire area where the database information is
    stored. When the input range is specified, you must include the
    headings as the top row of the range.


    CRITERION RANGE
    ~~~~~~~~~~~~~~~
    The criterion range contains the criteria that will be used to perform
    the FIND or EXTRACT operations on the Input range of the database.
    The minimum number of rows that can be used to define the criterion
    range is two.

    The top row ALWAYS contains the field headings exactly as they appear
    in the database.  It is good practice to copy these headings from the
    database itself to assure that they are exactly the same.  Subsequent
    rows contain the actual criteria.  Criteria fall into two categories,
    character comparisons and numeric comparisons.

    Character comparisons can be performed by looking for an exact match
    or by using wildcard characters.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [59] 
    ?   Substitutes for any single character in the comparison string.

    *   Will match all characters to the right of the asterisk position.

    ... Ellipsis (3 dots) preceding a string will search each record for the
        occurrence of that string anywhere within the string.

    Numeric comparisons can be performed by using all of the logical
    operators defined in the Logical Operators section.

    Criteria placed in adjacent columns are treated as logical ANDs, while
    criteria placed in adjacent rows are treated as logical ORs.

    AS-EASY-AS provides you with the option to facilitate the inputting of
    criteria.  The command / Data Input Criteria operates similar to /
    Data Input Form described earlier. After the criteria range is
    selected, a criteria input form will appear in the middle of the
    screen.  The user can then enter the criteria for each field heading.
    If multiple matches for the same heading are desired, AS-EASY-AS will
    generate a second form once the first form has been completed.

    Although this might sound complicated, an example later on will
    demonstrate how all these rules work.


    OUTPUT RANGE
    ~~~~~~~~~~~~
    The EXTRACT command causes records that match the criteria to be
    placed in the output range.  The output range should contain the
    headings of the fields from which information is to be extracted.


    RESET
    ~~~~~
    The RESET command resets the data input, output and criteria ranges.























    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [60] 
    8.  MATRIX OPERATIONS
    ~~~~~~~~~~~~~~~~~~~~~
    Matrix is a notation that is commonly used in the field of mathematics
    to describe a table of numbers.  When dealing with matrices you should
    be familiar with basic terminology and rules for matrix manipulation.

    A matrix is an array of values with a number of rows (i) and a number
    of columns (j). Mathematically, a matrix is denoted by an uppercase
    letter enclosed in brackets.

        [A]  -  Matrix A

    The elements of the matrix are denoted by the equivalent lowercase
    letter and two subscripts referring to the position of the element
    (row, column).

        a1,2  - the element of matrix [A] located in the first row and the
                second column

    The transposition of a matrix [A] with size i,j (i-rows, j-columns) is
    a new matrix  [A]T with size j,i  (j-rows, i-columns).  After the
    transposition, the first row of [A] becomes the first column of [A]T,
    the second row of [A] becomes the second column of [A]T, etc.


      Example:

        ORIGINAL MATRIX                   TRANSPOSED MATRIX

            1   6   8                           1   5   9
            5   7   3                           6   7   1
            9   1   4                           8   3   4

    In operations involving two matrices, [A] (i,j) and [B] (k,n), the
    following rules must be observed:

        1.  The matrices can be added or subtracted only if:  i=k and j=n

        2.  The matrices can be multiplied only if:  i=n  and  j=k


    The inverse of a matrix [A] is a second matrix [A]-1, such that:

            [A] x [A]-1 = Identity matrix


    The identity matrix is a special matrix whose elements are:

            ai,j = 1.0      for any i=j
            ai,j = 0.0      for any i<>j

    That is, 1s appear along the diagonal of the matrix and all other
    values are zero.

    A matrix can be inverted only if the number of columns and rows are
    equal. This is called a square matrix.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [61] 
    AS-EASY-AS supports the following basic matrix operations:

       Addition, Subtraction, Multiplication, Inversion, Transposition,
       Equation Solve, Determinant

    In addition to those, the program has a built-in option for solving a
    set of simultaneous equations with an equal number of unknowns.  Note
    that prior to solving such a set of equations, the constants vector
    should be placed in the column immediatelly to the right of the
    coefficients matrix.
















































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [62] 
    9. FUNCTIONS
    ~~~~~~~~~~~~
    A function is denoted by an @ (at) character preceding a function
    keyword. The following functions act upon the argument (represented by
    'x') contained within the parentheses.  The argument may be a value or
    formula which refers to other cells within the spreadsheet.


    STRING FUNCTIONS
    ~~~~~~~~~~~~~~~~
    +Cell  (Where Cell contains a String)
    Syntax:  +Cell Address
       The addition sign has the same effect as when used with values. The
       above entry indicates that the current cell will always have the
       same contents as Cell, whether Cell contains a string or a value.

    & - Concatenation
       The ampersand (&) is used to add two string expressions together.
       Note that using the plus sign (+), when adding strings, would give
       erroneous results.

       Example: +"Abc"&"D2N" will produce AbcD2N

    @@
    Syntax:  @@(Cell)
       The @@ function is used to indirectly address the location
       described by the string in Cell (another spreadsheet cell).

       Examples:
        Assume the following cell contents:
            Cell A1 contains the string "Sample"
            Cell A5 contains the string "A1"  (Note that it must be
            uppercase)
        @@(A5) = the contents of the cell described in A5 = Sample

       NOTE:  If the indirectly referenced cell changes, you must
              refresh the value with the F9 key or the {CALC} macro.

    @CELL
    Syntax:  @CELL("Type",Cell)
       Operates the same as @CELLPT, but returns information about the
       referenced Cell.  See @CELLPT for "Type" descriptions.

    @CELLPT
    Syntax:  @CELLPT("Type")
       Type =  One of the predefined words described below.  Type
               MUST be enclosed in double quotes (only the first three
               characters of the type are required).

       Returns information about the current cell (i.e., the cell where
       the cursor is currently located).  The information returned depends
       on the function argument, as described below.  The function will
       return a value or a string, depending on specific Type.

       NOTE: A cell containing an @CELLPT command will only be
             updated when the sheet is re-calculated either with [F9]
             or a {CALC} macro.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [63] 
       Type = "FORm"  (String)
       Returns the format of the current cell (see Range Format for
       format descriptions).  The string returned is of the following:

       blank = Unformatted cell
       Sn =    Scientific with n decimals
       Fn =    Fixed with n decimals
       ,n =    Comma format with n decimals
       Cn =    Currency format with n decimals
       Dn =    Date format, type n (see date formats)
       %n =    Percent with n decimals
       + =     +/- format
       T =     Text format
       H =     Hidden format
       G =     General format
       bn=     Engineering format with n decimals
       L =     Label format
       X =     Box or line character format

       Type = "ADDress"  (String)
       Returns the address of the current cell, in the form of a string
      'ColumnRow'  (e.g.,  A1, C12, AF321).

       Type = "CONtents"  (String)
       Returns the physical contents of the current cell as a string.
       e.g., if the current cell contains +A1+1, the string "+A1+1" is
       returned.

       Type = "ROW"  (Value)
       Returns the row address of the current cell.

       Type = "COLumn"  (Value)
       Returns the column address of the current cell as a value,
       (e.g., A=1, B=2, C=3, etc.)

       Type = "WIDth"  (Value)
        Returns the column width of the current cell.

       Type = "TYPe"  (Value)
       Returns one of the following values depending on the contents of
       the current cell:

        0 - String Formula
        1 - Value Formula
        2 - Real/Value
        3 - Integer/Value
        4 - String/Label
        5 - Blank Cell
        6 - Virgin Blank cell
        8 - String formula error
        9 - Value formula error

       Type = "PREfix"  (Label)
       Returns the first character of the current cell's contents (',
       ", ^, +, -, i, @, P).  If the cell contains a value, the left-
       most digit will be returned. e.g., 456 will return the label 4.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [64] 
    @CHR
    Syntax:  @CHR(Num)
        Num = a value, or calculated variable, between 0 and 255
        Returns the ASCII character corresponding to Num (fractional
        values are ignored).  Refer to Appendix E of the AS-EASY-AS manual
        for a table of the ASCII character codes.

        Examples:
            @CHR(36) = $


    @CLEAN
    Syntax:  @CLEAN(String)
       Range = Any string
       Removes all high bit ASCII characters (>127) and control code
       characters (<32) from String.
       Example:
          @CLEAN("SAMPLE") = SAMPLE


    @EXACT
    Syntax:  @EXACT(String1,String2)
        Compares String1 to String2 to see if an exact match exists. If
        the strings are equal, the function returns the value 1 (true),
        otherwise it returns the value 0 (false).  Please note that this
        function is case sensitive so characters in the two strings have
        to match exactly (e.g., A=A, A<>a).

        Examples:
            @EXACT("This is an Example","This Is An Example") = 0 (not
            equivalent strings as "an" is different from "An")

    @FIND
    Syntax:  @FIND(String1,String2,Start)
        Returns the position of String1 in String2; Search starts at
        position Start of String2 (first character is assigned an index of
        1).

        Examples:
           @FIND("hello","Dave says hello",1) returns the value 11
           @FIND("e","Dave says hello",1) returns the value 4
           @FIND("e","Dave says hello",5) returns the value 12

    @LEFT
    Syntax:  @LEFT(String,Num)
        String = Any string,
        Num = Numeric value or value formula
        Returns a substring starting with the first character of String,
        Num characters long.


        Examples:
          @LEFT("This is an example",6)  = This i





    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [65] 
    @LENGTH
    Syntax:  @LENGTH(String)
        String = Any string
        Returns the number of characters in String.  Please note that
        spaces are also characters.  References to labels ignore the
        prefix character.

        Examples:
          @LENGTH("abcdefG") = 7
          @LENGTH("ABc"&"123") = 6


    @LOWER
    Syntax:  @LOWER(String)
        String = Any string
        Converts all characters in String to lower case.

        Examples:
          @LOWER("This is an Example") = this is an example
          @LOWER(@LEFT("This is an example",4)) = this

    @MID
    Syntax:  @MID(String,Start,Num)
        String = Any string
        Start, Num = Numeric values or value formulas
        Returns a substring from String Num characters long, starting at
        position Start (from the left).

        Examples:
          @MID("This is an example",2,3) = his

    @N
    Syntax:  @N(Cell)
        Similar to @S.  This function inspects Cell, and returns the value
        contained in it.  If the cell is blank, or contains a string, then
        the function returns zero.

        Examples:
           @N(C9) = 0 if C9 contains the string "Test"
           @N(B9) = 28 if B9 contains the value 28

    @ORD
    Syntax:  @ORD(String)
        String = Any string
        Returns the decimal ASCII code of first character of String.  All
        other characters in String are ignored.


        Examples:
           @ORD("215")     = 50
           @ORD("")       = 193

    @PROPER
    Syntax:  @PROPER(String)
        String = Any string
        Converts the first letter of each word in String to upper case,
        such as in a proper name.  Characters already in upper case are

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [66] 
        left unchanged.

        Examples:
           @PROPER("This example") = This Example

    @REPEAT
    Syntax:  @REPEAT(String,Num)
        String = Any string,
        Num = Any number or value formula
        Repeats the string argument Num times.


        Examples:
           @REPEAT("Sample",3) = SampleSampleSample
           @REPEAT("This"&" Sample",2) = This SampleThis Sample

    @RIGHT
    Syntax:  @RIGHT(String,Num)
        String = Any string
        Num = Numeric value or value formula
        Similar to @MID and @LEFT, this function returns a substring, Num
        characters long, starting from the right of String.

        Examples:
           @RIGHT("This Example",6) = xample
           @RIGHT(@MID("Example",2,3),2) = am

    @S
    Syntax:  @S(Cell)
        This function inspects Cell, and returns the string contained in
        it.  If the cell is blank, or contains a numeric value, a null
        string is returned.

        @S acts as a filter and will only return a string reference.  It
        may be used in cases where a referenced cell may contain either a
        value or a string, without generating an error condition.

        Examples:
           @S(C9) = "Test" if C9 contains the string "Test"
           @S(B9) = Null string if B9 contains the value 28

    @STR
    Syntax:  @STR(Value,Num)
        Value = Any value or calculated variable
        Num = Number of decimal digits to retain
        Returns a string made up of Value with Num digits after the decimal.

        Example:
           @STR(1234.12345,3) = "1234.123"

    @TRIM
    Syntax:  @TRIM(String)
        String = Any string
        Trims multiple blank spaces from String and replaces each
        occurrence with a single space character.  The effect is evident
        when such strings are used in subsequent string operations.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [67] 
        Example:
        @TRIM("  This is      an    example  ") = This is an example

    @UPPER
    Syntax:  @UPPER(String)
        String = Any string
        Converts all characters of String to upper case.  Numbers and
        special characters remain unchanged.

        Examples:
           @UPPER("Example") = EXAMPLE
           @UPPER(@LEFT("+example$",9)) = +EXAMPLE$

    @VAL
    Syntax:  @VAL(String)
        String = Any string
        Converts String into a numeric value.  String may also be a string
        function, but you cannot embed value formulas in the String. If a
        value formula is embedded, then the value of zero is returned.

        Note that this function will accept the decimal separator
        specified with the User, Install, Punctuation command.  The
        examples below assume that "." is the decimal separator.

        Examples:
           @VAL("123")     = 123
           @VAL("1.23")    = 1.23
           @VAL("4/2")     = 0
           @VAL("2..34")   = 0





























    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [68] 
    MATH FUNCTIONS
    ~~~~~~~~~~~~~~
    NOTES:
    1. The arguments for all trigonometric functions must be in radians.

    2. The arguments for all hyperbolic functions must be in
       hyperbolic radians.

    3. An out of range argument will result in ERR being
       displayed.

    @ABS
    Syntax:  @ABS(x)
        x = any value
        Returns the absolute value of the argument.

        Examples:
          @ABS(-10)  = 10
          @ABS(5)    =  5


    @ACOS
    Syntax:  @ACOS(x)
        x = any value where -1 < x < 1
        Arc cosine of value, returns radians.


    @ACOSH
    Syntax:     @ACOSH(x)
        x = any value where x > 1
        Arc hyperbolic cosine of value x, returns radians.


    @ASIN
    Syntax:  @ASIN(x)
        x = any value where -1 < x < 1
        Arc sine of value x, returns radians.


    @ASINH
    Syntax:     @ASINH(x)
        x = any value
        Arc hyperbolic sine of value x, returns radians.

    @ATAN
    Syntax:  @ATAN(x)
        x = any value
        Arc tangent of value, returns radians.


    @ATANH
    Syntax:  @ATANH(x)
        x = any value where -1 < x < 1
        Arc hyperbolic tangent of value x, returns radians.




    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [69] 
    @COS
    Syntax:  @COS(x)
        x = any value in radians
        Cosine of angle x in radians.


    @COSH
    Syntax:  @COSH(x)
        x = any value in radians where -88 < x < 88
        Hyperbolic cosine of angle x in radians


    @CSC
    Syntax:     @CSC(x)
        x = any value in radians where x <> 0, 
        Cosecant of angle x in radians.


    @CTN
    Syntax:  @CTN(x)
        x = any non-zero value where x <> 0, 
        Cotangent of value

    @EXP
    Syntax:  @EXP(x)
        x = any value where -88 < x < +88
        Exponential of x (raise 'e' to the 'x' power).


    @FALSE
    Constant which has a value of 0.


    @GAMMALN
    Syntax:  @GAMMALN(x)
        x = any positive value
        Returns the natural logarithm  of the Gamma function for the value
        x. The Gammaln function is the floating point equivalent of the
        factorial function, and is related by:

                     (N-1)! = @EXP(@GAMMALN(N))

        Example:
            @GAMMALN(6.5) = 5.662562


    @INT
    Syntax= @INT(x)
        x = any value
        Integer value of argument.  The fractional part of the number is
        truncated and the integer remainder is returned.  (See also
        command line switch /RA)

        Examples:
          @INT(10.60) = 10
          @INT(0.156) =  0


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [70] 
    @LOG
    Syntax:  @LOG(x)
        x = any value where x > 0
        Returns the logarithm to base '10' of the argument.


    @LN
    Syntax:  @LN(x)
        x = any value where x > 0
        Returns the natural Logarithm (base 'e') of the argument.

        Example:
           @LN(6)= 1.7917594692


    @MOD(x,y)
    x = any value
    y = any non-zero value
        Modulo division, returns the remainder of x divided by y.

            @MOD(10,3) = 1
            @MOD(8,2)  = 0


    @NA
    Constant which has a value of -1.


    @PI
    Constant which has a value of 3.1415926536


    @RAND
    Returns a new random number with each recalculation.


    @ROUND(x,y)
    x = any value
    y = any integer value where -11 < y < 11

        Rounds the value of x to y digits right of the decimal.  Negative
        numbers round to left of decimal.

            @ROUND(10.1234,1) = 10.1
            @ROUND(123.123,-2)= 100


    @SEC
    Syntax:     @SEC(x)
        x = any angle in radians where x <> pi/2, -pi/2
        Secant of angle x in radians.


    @SIN
    Syntax: @SIN(x)
        x = any value in radians
        Sine of angle x in radians.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [71] 
    @SINH
    Syntax:     @SINH(x)
        x = any value in radians where -88 < x < +88
        Hyperbolic sine of angle x in radians

    @SQRT(x)
    x = any value where x  0
        Returns the square root of argument, (a negative argument will
        result in an error).

            @SQRT(2) =  1.4142135624
            @SQRT(36) = 6


    @TAN
    Syntax:     @TAN(x)
        x = any value in radians where  x <> /2, -/2
        Tangent of angle x in radians


    @TANH
    Syntax:     @TANH(x)
        x = any value in radians where -88 < x < +88
        Hyperbolic tangent of angle x in radians


    @TRUE
    Constant has a value of  1.


    FINANCIAL FUNCTIONS
    ~~~~~~~~~~~~~~~~~~~

    NOTES:

    1. For financial functions, all interest rates must be expressed
       in decimal fractions, or followed by the % operator.  For
       example, 0.08 = 8%.

    2. The interest rate must be in the same units as the payment
       period.  If a monthly payment is desired, the interest rate
       must be expressed as a monthly rate (equal to the annual
       rate divided by 12).


    @ACI
    Syntax:  @ACI(Principal,Interest Rate,Period,PmtNumber)
        Principal       = Principal amount
        Interest Rate   = Periodic interest rate
        Period          = Number of periods
        PmtNumber       = Payment number
        Returns the accumulated interest on a loan after the
        specified payment has been made.

        Example:
            @ACI(10000,0.01,48,36) = 2444.07


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [72] 
    @BAL
    Syntax:  @BAL(Principal,Interest Rate,Period,PmtNumber)
        Principal       = Principal amount
        Interest Rate   = Periodic interest rate
        Period          = Number of periods
        PmtNumber       = Payment number
        Returns the unpaid balance on a loan after the specified
        payment has been made.

        Example:
            @BAL(10000,0.01,48,47) = 260.73


    @CTERM
    Syntax:  @CTERM(Int,FVal,PVal)
        FVal    = Future Value
        Pval    = Present Value
        Int     = Interest Rate per compounding period

        Returns the number of compounding periods required for a present
        value (PVal), invested at an interest rate (Int) per compounding
        period to reach a future value (FVal).



        Examples:
           @CTERM(0.1,100000,10000)        =  24.2
           @CTERM(0.08,400000,60000)       =  24.7


    @DDB
    Syntax:  @DDB(Cost,Salvage,Life,Period)
        Cost        =  Cost of a purchase
        Salvage     =  Value at the end of the depreciation
        Life        =  Number of periods for full depreciation
        Period      =  Current Period

        Returns the amount of depreciation allowed during the specified
        period, using the Double-Declining-Balance depreciation method.

        Example:  5-Year Depreciation Schedule
          @DDB(5000,1000,5,1)     =   2000.0
          @DDB(5000,1000,5,2)     =   1200.0
          @DDB(5000,1000,5,3)     =    720.0
          @DDB(5000,1000,5,4)     =     80.0
          @DDB(5000,1000,5,5)     =      0.0
          To Date Total               4000.0


    @FV
    Syntax:  @FV(Annuity,Interest Rate,Period)
        Annuity     =  Periodic payment amount
        Interest    =  Periodic interest rate
        Period      =  Number of periods

        Returns the future value corresponding to an annuity occurring
        over the specified period.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [73] 
        Example:
           @FV(700,0.0925,30) = 99979.77

    @IRR
    Syntax:  @IRR(Guesstimate Interest Rate,Range)
        Guesstimate Interest Rate =     Best guess at internal rate of return
                                        periodic interest rate
        Range =                         Cell range which contains the cash
                                        flow return values

        Returns the Rate of Return per period associated with a cash flow.
        The solution is iterative and may result in more than one correct
        answer, so a good guess is important.

        Example:

               A1      B1      C1      D1
            -1000      300     400     500

            @IRR(0.1,A1..D1) = 0.088963, or 8.9%






































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [74] 
    @NPV
    Syntax:  @NPV(Interest Rate,Range)
        Interest Rate   =   Periodic interest rate
        Range           =   Cell range which in which the series of cash
                            flows is to be stored

        Returns the net present value of a cash flow over interest period.

        Example:
           @NPV(0.0925,A1..A5)


    @PMT
    Syntax:  @PMT(Principal,Interest Rate,Period)
        Principal       =   Principal amount
        Interest Rate   =   Periodic interest rate
        Period          =   Number of periods

        Returns the amount of an annuity equal to the principal amortized
        over the period.

        Example:
           @PMT(75000,0.0925,30) = 7462.606


    @PMTP
    Syntax:  @PMTP(Principal,Interest Rate,Period,PmtNumber)
        Principal       = Principal amount
        Interest Rate   = Periodic interest rate
        Period          = Number of periods
        PmtNumber       = Payment number
        Returns the amount that, for a given loan payment, is used to
        reduce the principal, i.e, does not include the interest
        portion.

        Example:
            @PMTP(10000,0.01,48,5) = 169.97


    @PV
    Syntax:  @PV(Annuity,Interest Rate,Period)
        Annuity     =   Periodic payment amount
        Interest    =   Periodic interest rate
        Period      =   Number of periods

        Returns the present value corresponding to an annuity occurring
        over the specified period.

        Example:
           @PV(700,0.0925,30) = 7035.075


    @RATE
    Syntax:  @RATE(Fval,PVal,Nterm)

        FVal        =   Future value
        PVal        =   Present value

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [75] 
        NTerm       =   Number of compounding terms

        Returns the interest rate required for a present value PVal,
        invested for Nterm number of compounding periods to reach a future
        value FVal.

        Examples:
           @RATE(90000,20000,20)  =       0.078
           @RATE(190000,50000,20) =       0.069

    @SLN
    Syntax:  @SLN(Cost,Salvage,Life)
        Cost        =   Cost of a purchase
        Salvage     =   Value at the end of the depreciation
        Life        =   Number of periods for full depreciation

        Returns the amount of depreciation per period, using the straight
        line depreciation method.

        Examples:
           @SLN(5000,1000,5)       =    800.0
           @SLN(11000,1600,10)     =    940.0


    @SYD
    Syntax:  @SYD(Cost,Salvage,Life,Period)
        Cost    =  Cost of a purchase
        Salvage =  Value at the end of the depreciation
        Life    =  Number of periods for full depreciation
        Period  =  Current Period

        Returns the amount of depreciation allowed during the specified
        period, using the Sum-of-Years depreciation method.

        Example:  5-Year Depreciation Schedule
           @SYD(5000,1000,5,1)     =   1333.3
           @SYD(5000,1000,5,2)     =   1066.7
           @SYD(5000,1000,5,3)     =    800.0
           @SYD(5000,1000,5,4)     =    533.3
           @SYD(5000,1000,5,5)     =    266.7
               To Date Total           4000.0


    @TERM
    Syntax:  @TERM(Pmt,Int,FVal)
        FVal    = Future value
        Pmt     = Periodic payment
        Int     = Interest rate per compounding period

        Returns the number of compounding periods required for some
        periodic payment (Pmt), invested at an interest rate (Int) per
        compounding period to reach a future value (FVal).

        Examples:
          @TERM(100,0.15,1000)        =      6.6 periods
           @TERM(850,0.07,100000)      =     32.9 periods


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [76] 
    LOGICAL FUNCTIONS
    ~~~~~~~~~~~~~~~~~
    #OR# & #AND# Operators

    The #OR# & #AND# logical operators are used to combine simple logical
    criteria into complex logical expressions.  These two operators are
    evaluated according to the following logical table:

        ==============================================
            Test1      Test2       #OR#       #AND#
        ===============================================
            True       True       True        True
            True       False      True        False
            False      True       True        False
            False      False      False       False
        ==============================================

    Examples:
                       Expression               Result
                    ~~~~~~~~~~~~~~~~        ~~~~~~~~~~~~~~~~
                    +(0=0)#AND#(0=1)            0    (False)
                    +(0=0)#OR#(0=1)             1    (True)

    @IF(@MOD(5,2)=1#AND#@MOD(6,2)=0,1,0) returns 1 (true)

    NOTES:      1.  Spaces between the values and logical operators are
                    not allowed.
                2.  Use of parentheses is recommended for clarity.


    @IF
    Syntax:  @IF(Test argument,arg1,arg2)
        If the test is true, Arg1 is returned, otherwise Arg2 is returned.
        TEST can utilize logical operators '>,<,=,<>' etc., or refer to
        the result of a cell with a logical result in it.

        Examples:
          @IF(10>2,3*2,4+5) = 6
          @IF(10<2,3*2,4+5) = 9

        As an example of using a logical operation within a formula try
        the following:

        +(a1>2)*3+(a1<=2)*4

        This formula will yield a result of 3 if the value stored in cell
        A1 is greater than 2 and will yield a result of 4 if the value is
        less than 2.

        NOTE:  Up to 10 nested @IF statements are allowed providing
               internal limit of 240 bytes per formula is not exceeded.


    @ISNUM
    Syntax:  @ISNUM(Cell)
        This function is similar to the @ISSTR function.  It will return 1
        for TRUE if the cell contains a number or a formula, 0 for FALSE.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [77] 
    @ISSTR
    Syntax:  @ISSTR(Cell)
        This function checks to see if the specified cell contains a
        label. It returns 1 for TRUE if the cell contains a string or a
        label, 0 for FALSE.

        NOTE:  A blank cell is neither a string nor a number.


    @ISNA
    Syntax:  @ISNA(Cell)
        Tests for the special value of NA in cell.  If the cell contains
        NA it returns 1 (true); otherwise, it returns 0 (false).  Please
        note that if a cell contains the label "NA" (not produced by the
        @NA function), it is not recognized by the @ISNA function.


    @ISERR
    Syntax:  @ISERR(Expression)
             where expression can be a cell reference or any other valid AS-
             EASY-AS expression.

        This function is used to trap ERR displays and prevent propagation
        through the recalculation sequence.  A value of 1 (true) is
        returned if the cell contains ERR or the expression evaluates to
        an error condition.  A value of 0 (false) is returned otherwise.

        Examples:
           @ISERR(10/5)=0  (Not an error)
           @ISERR(10/0)=1  (Error in Expression)


    @ERR
    Syntax:  @ERR
        Returns the value ERR in the current cell and in any other cells
        that reference it directly or indirectly. The ERR value returned
        by this function is the same ERR value produced by AS-EASY-AS when
        it encounters an error.


    @NOT
    Syntax:  @NOT(Cell)
        Returns the value 0 if cell contains the value 1 and the value 1
        if cell contains 0 or any other value.  If cell contains a string,
        then the string is returned, unchanged.













    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [78] 

    STATISTICAL FUNCTIONS
    ~~~~~~~~~~~~~~~~~~~~~
    These functions operate on a range of values. A range specifies a
    rectangular block of data in the spreadsheet, i.e.  Range = A1..B10
    defines the block of data from:

                              a1...b1
                               .    .
                               .    .
                             a10...b10


    Presented below are the statistical functions.  To illustrate the use
    of each function, simple examples are provided.

    All examples will operate on the numbers contained in the portion of
    the spreadsheet duplicated below, A1..C3

          ........A/.......B/.......C/
        1       1.1      5.6      8.2
        2       2.3      7.5       10
        3       3.5      4.4        2


    @AVG
    Syntax:  @AVG(Range)
        Range =     Cell range to be averaged
        Returns the average of the range.

        Example:
           @AVG(A1..C3) = 4.955555


    @COMB
    Syntax:  @COMB(N,R)
        N,R = any integer value such that N  R

        Number of combinations of N distinct items taken R at a time.

        Example:    @COMB(6,2) = 15


    @COUNT
    Syntax:  @COUNT(Range)
        Range =     Cell range to be counted
        Returns the number of elements in the range, (blank cells and
        cells containing text are ignored).

        Example:
           @COUNT(A1..C3) = 9







    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [79] 

    @FACT
    Syntax:  @FACT(X)
        X = Numeric value where (0 < X < 33)
        Returns the factorial of X.  (See also @GAMMALN for floating point
        related function and "!" operator).

        Example:
          @FACT(6) = 720


    @MAX
    Syntax:  @MAX(Range)
        Range =     Cell range to be analyzed
        Returns the maximum value in the range.

        Examples:
          @MAX(A1..C3) = 10
          @MAX(A1..A3,15,C1..C3) = 15


    @MIN
    Syntax:  @MIN(Range)
        Range =     Cell range to be analyzed
        Returns the minimum value in the range.

        Examples:
          @MIN(A1..C3) = 1.1
          @MIN(A1..A3,1,C1..C3) = 1


    @PERM
        Syntax:  @PERM(N,R)
        N,R = any integer value such that N  R
        Number of permutations of N distinct items taken R at a time.

        Example:    @PERM(6,2) = 30



    @PSUM
    Syntax:  @PSUM(Range1,Range2)
        Range1 = Cell range to be evaluated
        Range2 = Cell range to be evaluated
        Returns the summation of the product of Range1 and Range2.
        Every element in Range1 is multiplied by the equivalent
        element in Range2, and the products are then summed.

        Range1 and Range2 must be the same length or an ERR condition
        will be returned by the function.


    SPECIAL NOTES
    ~~~~~~~~~~~~~
        1.  The following .... functions require the criterion  be a string
            argument.  References to string arguments are permitted.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [80] 
        2.  @X represents reference to cell in range upon which
            criterion is applied (required).


    @QCOUNT
    Syntax:  @QCOUNT("@X=Criterion",Range,Offset)
        Criterion = Value or formula to be used for match
        Range = Cell range
        Offset = Number of columns to the right/left on which to operate.

        Returns the number of those cells in the range that match
        the criterion.


    @QMAX
    Syntax:  @QMAX("@X=Criterion",Range,Offset)
        Criterion = Value or formula to be used for match
        Range = Cell range
        Offset = Number of columns to the right/left on which to operate.

        Returns the maximum value of those cells in the range that match
        the criterion.


        Example:   @QMAX("@X<2.5",A1..A3,1) = 7.5
                   @QMAX("@X<2.5",A1..A3,0) = 2.3


    @QMIN
    Syntax:  @QMIN("@X=Criterion",Range, Offset)
        Criterion = Value or formula to be used for match
        Range = Cell range
        Offset = Number of columns to the right/left on which to operate.
        Returns the minimum value of those cells in the range that match
        the criterion.

        Example:  @QMIN("@X>2.0",A1..A3,1) = 4.4


    @QSTD
    Syntax:  @QSTD("@X=Criterion",Range,Offset)
        Criterion = Value or formula to be used for match
        Range = Cell range
        Offset = Number of columns to the right/left on which to operate.
        Returns the standard deviation of those cells records in the range
        that match the criterion.


    @QSUM
    Syntax:  @QSUM("@X=Criterion",Range,Offset)
        Criterion = Value or formula to be used for match
        Range = Cell range
        Offset = Number of columns to the right/left on which to operate.
        Returns the sum of the records in the range that match the criterion.

        Example:    @QSUM("@X>5",A1..C3,0) = 31.3


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [81] 
    @QVAR
    Syntax:  @QVAR("@X=Criterion",Range,Offset)
        Criterion = Value or formula be used for match in top of row
        Range = Cell range
        Offset = Number of columns to the right/left on which to operate.
        Returns the population variance of the records in the range that
        match the criterion.



    @STD(Range)
        Range = Cell range to be evaluated
        Returns the standard deviation of the elements in the range.

        Example:
          @STD(A1..C3) =  2.904827

    @STDU
    Syntax:  @STDU(Range)
        Range = Cell range to be evaluated
        Returns the standard deviation of the elements in the range,
        based on the sample size, i.e., N-1 weighting.

        Example:
          @STDU(A1..C3) =  3.081035

































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [82] 

    @SUM
    Syntax:  @SUM(Range)
        Range = Cell range to be evaluated
        Returns the summation of the range.

        Examples:
          @SUM(A1..C3) = 44.6
          @SUM(A1..C3,R3,D9,X3..Y9) = 255.5


    @VAR
    Syntax:  @VAR(Range)
        Range =     Cell range to be analyzed
        Returns the population variance of the range.

        Example:
          @VAR(A1..C3) =  8.438024



    @VARU
    Syntax:  @VARU(Range)
        Range =     Cell range to be analyzed
        Returns the population variance of the elements in the range
        based on the sample size, i.e., N-1 weighting.

        Example:
           @VARU(A1..C3) =  9.492777


    SPECIAL FUNCTIONS
    ~~~~~~~~~~~~~~~~~

    @AUTO
    Syntax:  @AUTO     (no arguments)
        Checks the status of the recalculation mode.  Returns (1) if
        the recalculation mode is set to automatic, or (0) if the
        recalulation is set to manual.


    @CASE
    Syntax:  @CASE(Num,Arg2,....Argn)
        Num =  Any number or calculated value where Num > 0
        Arg1...ArgN =  Any number, string, character

        Returns the Numth argument from the argument list.











    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [83] 
        Examples:
          @CASE(2,"A",17,"ABC",4) = 17
          @CASE(3,"Abc"&"d",129/4,@LEFT("Example",5),123) = Examp
                     |.........||....||......................||..|
                          :       :              :             :
                          :       :              :             :
                        First     :            Third           :
                       Argument   :           Argument         :
                                Second                       Fourth
                               Argument                     Argument


    @COLS
    Syntax:  @COLS(Range)
        Range = Any cell Range.
        Returns the number of columns in the specified range.

        Examples:
          @COLS(A1..E121) = 5
          @COLS(AA11..BB32) = 27
          @COLS(TEST) = 6  where TEST = named range of (C5..H21)

    @DEC
    Syntax:  @DEC(String)
        String = Any text string up to 10 characters long
        Returns the decimal value that corresponds to the hexadecimal
        String. The string is limited to the hexadecimal values 0000-
        FFFF.  If String is longer that 4 characters, then the four
        rightmost characters are used for the conversion.  If String
        is longer than 10 characters, ERR is returned).

        Examples:
          @DEC("12") = 18
          @DEC("0012") = 18
          @DEC("0123AB001A") = 26
          @DEC("AB1232GA1202") = ERR

    @DOSVER
    Syntax:  @DOSVER     (no arguments)
        Returns the current version of DOS running on your system.


    @FILEINFO
    Syntax:  @FILEINFO(String,Mode)
        String = File name specifications
        Mode = Type of Information Required
        Returns information about the specified file.  String can be
        any valid DOS file specification (it can include Drive/
        directory information, etc.) Mode, is an integer 1-3, as
        shown below:

        Mode = 1  -     File Size (bytes)
        Mode = 2  -     File existence.  Returns one of the following
                        values:
                             0  - File does not exist
                             1  - File exists
        Mode = 3  -     File Attribute.  Returns one of the following

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [84] 
                        values:
                             1  - Read Only  ($01)
                             2  - Hidden ($02)
                             4  - System File ($04)
                             8  - Disk Label ($08)
                            16  - Directory ($10)
                            32  - Archive ($20)

    @HEX
    Syntax:  @HEX(Value)
        Value = Any numeric value x where -65,535  x  65,535
        Returns the hexadecimal representation of Value as a string.
        Note that value is rounded and only integer hex numbers are
        returned.  Negative values are returned as hex compliments of
        2.  All hex values returned are preceded by the dollar sign
        which signified hex value.

        Examples:
           @HEX(12) = $000C
           @HEX(1125) = $0465
           @HEX(-2) = $FFFE


    @HTABLE
    Syntax:  @HTABLE(Criterion,Range,Offset)
        Criterion =     Value to be used for match in top row of range
        Range =         Cell range which contains criterion range as top row
                        and includes data value table
        Offset =        Number of rows down in data value table from
                        which to return a value

        Returns the value at a vertical offset in the column that matches
        the criterion.

        @HTABLE(5.6,A1..C3,1) = 7.5

        The @HTABLE function operates as follows:

        Search starts at the upper left cell and proceeds until a value is
        found which is greater than the criterion. The position of the
        previous value is then used as a starting offset into the table.
        The offset is added to the top row and the value at the offset
        position is returned by the function.



    @HTERP
    Syntax:  @HTERP(Cell,Range,Offset)
        Perform a straight-line interpolation based on table specified by
        Range. It operates similar to @HTABLE function, but returns a
        result based on the following:

                 (Xv - Xi)
        Yv      ----------- x (Yi+1 - Yi)  +  Yi
                (Xi+1 - Xi)

        Where X is the first row and Y is the offset row in the table.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [85] 
    @INDEX
    Syntax:  @INDEX(Range,Col,Row)
        Range = Any cell Range
        Col, Row = Numeric value or value formula
        Searches the specified range and returns the element located Col
        columns to the right and Row rows down from the top left corner of
        the range.  Element may be a string or a value.

        Examples:

            /........A/........B/........C/
          1
          2         22        RR        HH
          3          A         1         2
          4         21        23         9
          5          b         F         3

         @INDEX(A2..C5,2,2) = 1
         @INDEX(A2..C5,3,1) = HH
         @INDEX(A2..C5,1,3) = 21

         Note that Col and Row have to satisfy the criteria:
            0 < Row < 8,192
            0 < Col < 255


    @IORESULT
    Syntax:  @IORESULT     (no arguments)
        Returns a value indicating the status of the last file I/O
        operation.  If 0 is returned, then the last file I/O
        operation worked as expected.  If any other value is
        returned, then an error occurred during the last file I/O
        operation.  Please, note that this boolean function is reset
        to 0 when it is used.

        Some of the error codes that may be returned by @IORESULT are:

        2 - File Not Found
        3 - Path not found
        4 - Too many files open
        5 - File Access denied

    @LENGTH
    Syntax:  @LENGTH(Cell)
        Returns the length of the string in the referenced Cell (if the
        contents are a label), otherwise it returns zero if cell is empty.
        Note that the prefix character of a label is not considered in the
        length calculation.


    @LINK
    Syntax:  @LINK("Drive:\Path\Filename>Cell")
    NOTES: 1.  Double quotes and the '>' character are necessary.
           2.  If Drive:\Path are not specified, the search defaults to the
               the directory specified by the /Dir= command line switch,
               or with /File, Dir command.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [86] 
        As the name indicates, it links cells in the current worksheet to
        cells in a worksheet on disk.  Once this function is entered, a
        link is created but it is not updated.  As a result, as soon as
        this function is entered, the cell frequently displays "N/A".  Do
        not panic, a newly created link is not updated until the /File,
        Uplink command is executed.  At that time, any value or string
        variable in the referenced cell of the indicated sheet on disk is
        retrieved and placed in the calling cell.

        Updating occurs automatically when the spreadsheet is first retrieved.


    @MEMAVAIL
    Syntax:  @MEMAVAIL(X)
        X = Value representing type of memory to report, 0, 1 or 2.
            0 - Total Memory
            1 - Conventional Memory
            2 - EMS/VMS Memory
        Returns the amount of total, conventional, and EMS/VMS memory, in
        bytes, available at the time of call.

        Examples:
           @MEMAVAIL(0) = 864315
           @MEMAVAIL(1) = 205088
           @MEMAVAIL(2) = 659227

    @PATH
    Syntax:  @PATH  (no arguments)
        Returns the current data path, i.e., the current drive and directory.

        Example:
           @PATH = C:\ASEASY55\FILES


    @PROTECT
    Syntax:  @PROTECT     (no arguments)
        Checks the status of Global cell protection.  Returns (1) if
        Global protection is ON, (0) if it is not.

    @QVIEW
    Syntax:  @QVIEW(N)
        N = 0 = Number of open views
        N = 1 = Number of active view
        Returns a numeric value (1-6) that indicates either the total
        number of views open (if N=0), or the number of the current
        active view (if N=1).

        Example:
           @QVIEW(0) = 1 (when you first start AS-EASY-AS)



    @ROWS
    Syntax:  @ROWS(Range)
        Range = Any cell Range.
        Returns the number of rows in the specified range.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [87] 
        Examples:
          @ROWS(A1..E121) = 121
          @ROWS(AA11..BB132) = 122
          @ROWS(TEST) = 17  where TEST = named range of (C5..H21)

    @USER
    Syntax:  @USER(Arg1,Arg2,Arg3)
        USER = User provided name of function (any unique name)
        Arg1,Arg2,Arg3 = User provided numeric arguments
        This is a special function, defined by the user, which can have up
        to three numeric arguments.  The user specifies the formula which
        relates the arguments and creates a unique range name which
        includes the cells containing the formula and the arguments.  The
        function may then be used in the worksheet just as any other
        internal @ function.  To set up the function, perform the
        following steps:

        1.  Place up to three numeric arguments, Arg1, Arg2, Arg3, in a
        single row in adjacent columns.

        2.  Place the formula which relates the numeric values in the cell
        below Arg1, the leftmost argument.

        3.  Give a unique range name to the block which includes the
        arguments and the formula.  This range name will become the
        function name.

        4.  Use the newly defined function.

    @VERSION
    Syntax:  @VERSION     (no arguments)

    Returns the current version of AS-EASY-AS running on your system.

    @VTABLE
    Syntax:  @VTABLE(Criterion,Range,Offset)
        Criterion   =   Value to be used for match in left column of range
        Range       =   Cell range which contains criterion range as left
                        column and includes data value table
        Offset      =   Number of columns to the right in data value table
                        from which to return a value.  The first criterion
                        column in the range has an offset of zero.

        Returns the value at a horizontal offset in the row that matches
        the criterion.  The @VTABLE function operates as follows:

        Search starts at the upper left cell and proceeds downwards row by
        row until a value is found which is greater than the criterion.
        The position of the previous value is then considered as a match.
        The offset is added to the left column and the value at the offset
        position is returned by the function.

        NOTE: Table values outside the search region cause an error result.





    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [88] 
    @VTERP
    Syntax:  @VTERP(Cell,Range,Offset)
        Similar to @HTERP, but scans vertically (row by row).


    DATE AND TIME FUNCTIONS
    ~~~~~~~~~~~~~~~~~~~~~~~
    The functions below are based on the number of days elapsed since
    January 1, 1900. In order to have the value displayed in a date form,
    the cell(s) have to be formatted with one of the date formats (see
    formatting section).


    @DATE
    Syntax:  @DATE(Year,Month,Day)
        Year    =   Value corresponding to last two digits of year
        Month   =   Value corresponding to month of year, 1-12
        Day     =   Value corresponding to day of month, 1-31
        Returns a unique integer for each day since January 1, 1900.

        Example:
            @DATE(91,11,1) returns an integer of 33543.  If the cell is
            formatted as Date MM/DD/YY, then the date 11/1/91 is displayed.


    @DATEVAL
    Syntax:  @DATEVAL("MM/DD/YY")
        Convert the string argument to a date number representing the
        month(MM):day(DD):year(YY).  Note that the cell can be formatted to
        display the above VALUE in a date format.

        Examples:
          @DATEVAL("6/15/89")             = 32674  (Unformatted cell)
          @DATEVAL("6/15/89")             = 06/15/89  (Formatted cell)
          @DATEVAL("7"&"/6"&"/89")        = 07/06/89  (Formatted cell)
          @DATEVAL(A6)                    = 10/13/89  (Formatted cell)
                                            where cell A6 contains the
                                            string "10/13/89"

          NOTE: Spaces, colons, semicolons, and other non-numberic
                characters are acceptable delimeters.


    @DAY
    Syntax:  @DAY(x)
        x = the number of days since Jan. 1, 1900.
        Based on a unique day assigned to 'x', computes the day in the
        month of that date.

        Example:
          @DAY(33543) returns the number 1
          (The date number is equivalent to November 1, 1991)






    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [89] 
    @HOUR
    Syntax:  @HOUR(Value)
        Value   =   Any number or calculated value in fractional days
                    i.e., 1 day = 24 hours, 0.5 day = 12 hours
        Returns the hours corresponding to the fractional portion of
        Value.  The integer portion of Value (representing days) is
        ignored.

        Examples:
          @HOUR(0.5)      = 12
          @HOUR(3/4)      = 18
          @HOUR(0.25)     =  6
          @HOUR(9.25)     =  6


    @MINUTE
    Syntax:  @MINUTE(Value)
        Value = Any number or calculated value in fractional days
        Returns the minutes corresponding to the fractional portion of Value.
        The integer portion of Value (representing days) is ignored.

        Examples:
          @MINUTE(0.51)  = 14
          @MINUTE(0.33)  = 55
          @MINUTE(3.33)  = 55


    @MONTH
    Syntax:  @MONTH(x)
        x = the number of days since January 1, 1900.
        Based on a unique day assigned to "x", computes the month in which
        that day occurs.

        Example:
          @MONTH(33543) returns the number 11.
          (The date number is equivalent to November 1, 1991)

    @SECOND
    Syntax:  @SECOND(Value)
        Value = Any number or calculated value in fractional days
        Returns the seconds corresponding to the fractional portion of
        Value. The integer portion of Value (representing days) is
        ignored.

        Examples:
           @SECOND(0.511)      = 50
           @SECOND(0.541)      =  2
           @SECOND(9.541)      =  2

    @TIME
    Syntax:  @TIME(Hr,Min,Sec)
        Hr  = A number between 0 and 23, Hours
        Min = A number between 0 and 59, Minutes
        Sec = A number between 0 and 59, Seconds
        Returns a fractional time serial number represented by Hr:Min:Sec.
        Note that in order to have a cell display in time format, you have
        to format it using /Range, Format, Date 6 or 7.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [90] 
    @TIMEVAL
    Syntax:  @TIMEVAL("HH:MM:SS")
        HH =    Value representing number of hours
        MM =    Value representing number of minutes
        SS =    Value representing number of seconds
        Convert the string argument to a real number representing the
        hour(s):minute(s):second(s) as a fraction of a day.  Note that the
        cell can be formatted to display the above VALUE in a time format.

        Examples:
          @TIMEVAL("1:2:3")        = 0.04309027  (Unformatted cell)
          @TIMEVAL("1:2:3")        = 1:02        (Cell formatted for time)
          @TIMEVAL("1:2:120")      = 1:04                     ''
          @TIMEVAL("1:70:120")     = 2:12                     ''
          @TIMEVAL("25:2:120")     = 1:04                     ''

          NOTE: The time value is calculated using the following formula:

                Hour + Min/60 + Second/3600
                --------------------------
                           24


    @TODAY
        Returns the unique number corresponding to today's date and time
        referenced to January 1, 1900.

        @TODAY returns the number 33543 if today is November 1, 1991.  If
        the cell were formatted as Date D-M-Y, then the date 1-Nov-91 is
        displayed.

        If the cell were formatted as Date 6 (H:M:S), then the time
        associated with the fractional part of the date is displayed.

        NOTE:   @TODAY is NOT automatically updated when a spreadsheet
                is retrieved, even if the recalculation mode is set for
                automatic.  You must recalc the spreadsheet by manually
                pressing the [F9] function key or by macro command.


    @YEAR
    Syntax:  @YEAR(x)
        x = the number of days since January 1, 1900.
        Based on a unique day assigned to 'x', computes the year in which that
        day occurs.

        Example:
           @YEAR(33543) returns the number 91.










    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [91] 

    10.   MACROS
    ~~~~~~~~~~~~
    A macro is a sequence of keystrokes which may be activated by pressing
    the combination of the Alt key and a letter key or by using the [F3]
    key -macro execute.  An example macro would be the following:

         {RT}{RT}{DN}

    The words/letters in braces represent an action keystroke.  The above
    macro will move the pointer two cells to the right and one cell down.
    A macro may be placed in any cell.

    To activate a macro with the [ALT] key, it must have a special type of
    range name assigned to its location.  The special range name is the
    backslash [\] followed immediately by any letter from 'A' thru 'Z'.
    For example:

         \A

    This specific macro may be activated by pressing the [ALT] key and the
    letter 'A' simultaneously.  Therefore, even though the backslash is
    used to define the range name it actually represents the [alt] key.

    If you desire a macro to automatically execute upon retrieval of a
    spreadsheet, name your macro "\0" ( Zero).  When AS-EASY-AS retrieves
    your spreadsheet, it searches for a macro named "\0".  If one exists,
    it is automatically executed.  You can have only one auto-executing
    macro in a spreadsheet.

    NOTE: To edit an auto-executing macro, it may be necessary to use the
          /File Merge command to keep the macro from auto-executing as
          it would if /File Retrieve were used.


    DEFINING A MACRO
    ~~~~~~~~~~~~~~~~
    The powerful macros that are supported by AS-EASY-AS provide a
    complete programming environment for most applications.  Macros can be
    chained together to provide self running applications that do
    virtually anything that can be done manually through the command mode.

    Macro commands can be typed in directly from the keyboard.  This
    requires that you know the exact sequence of macro commands to perform
    the desired action ahead of time.

    For short macros, this method is acceptable.  However, if you have a
    long macro to create, or if you are unfamiliar with the sequence of
    commands needed, AS-EASY-AS provides an alternative method for
    creating macros.

    AS-EASY-AS has the ability to learn by example, it records your
    keystrokes as you perform the desired task, and writes them out to the
    sheet as macro commands.  To access this macro recording ability,
    select /Sheet, Macro, Compose.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [92] 
    When you first select Compose, AS-EASY-AS starts recording all your
    keystrokes.  The macro compose buffer is capable of storing 2048
    characters. When you have completed your macro, reselect /Sheet,
    Macro, Compose a second time.

    AS-EASY-AS will prompt you for the cell location in which to place the
    macro commands.  Simply point to a vacant cell or type in the cell
    location and hit [ENTER].  The macro commands will be entered,
    continuing to the next rows below as necessary, writing over any
    information currently in the cells.


    EXECUTING A MACRO
    ~~~~~~~~~~~~~~~~~
    There are several ways to execute your macro.  The first step is to
    name your macro.  To define a range name, type the following:  /rnc
    which stands for /RANGE, NAME, CREATE.

    After you press the letter 'c'(for Create) the spreadsheet will prompt
    YOU for the name of the range.  Now type the range name and then press
    the [ENTER] key.  (Be careful, don't include any spaces in the range
    name).

    The next step involves typing (or pointing) the cell which the macro
    occupies. If the macro was in cell A1, then type A1 [ENTER].  The
    simplest method of executing macros is to name your macro using the
    special range name character \ followed by a single letter as
    discussed previously.

    Pressing the [ALT] key and the letter name of your macro
    simultaneously will execute your macro.  Naming your macro \0 (zero)
    will create a macro that will auto execute each time the spreadsheet
    is retrieved.

    A second execution method is to press the [F3] Macro Execute function
    key. Type in the name of your macro and hit [ENTER], and AS-EASY-AS
    will execute your macro.

    If you can't remember your macro name, press [F3] then [F1].  A pick
    window of all the range names will appear in the middle of your
    screen. Highlight the name of your macro and hit [ENTER] to execute
    the macro.

    A third method to execute your macro is by selecting /Sheet, Macro,
    Execute. You are allowed to specify a cell address, a named range,
    etc. Again, pressing [F1] after this option has been selected will
    display all named ranges in a pick window on the screen.

    Because of its execution speed, it may be difficult to follow your
    macro commands to determine if your macro is performing as planned.
    To assist you in your debugging efforts, AS-EASY-AS provides the
    ability to execute your macro one command at a time.

    /Sheet, Macro, Step toggles the macro step execution on and off.  If
    the option Yes is selected, you are asked to specify the number of
    msec of delay between macros ( 0 < D < 5000 msec).  If a delay of
    zero, (D=0), is specified, the program will pause after each macro

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [93] 
    command, until you press any key to continue.  The currently executing
    macro command will also be displayed at the bottom of the screen.



    MACRO KEYWORDS
    ~~~~~~~~~~~~~~
    All menu commands in AS-EASY-AS can be invoked from within a macro
    with the key-letter (the first letter in the command).  In addition,
    the following cursor movements have macro keywords:

     MACRO
     COMMAMD             MEANING
    ~~~~~~~~~            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {LT  X}         -    Move cursor X cells to the Left
    {RT  X}         -    Move cursor X cells to the Right
    {DN  X}         -    Move cursor X cells Downward
    {UP  X}         -    Move cursor X cells Upward
    {PGUP  X}       -    Move cursor X pages Up
    {PGDN  X}       -    Move cursor X pages Down
    {PGRT  X}       -    Move the cursor X pages to the Right
    {PGLT  X}       -    Move the cursor X pages to the Left
    {DEL  X}        -    Delete X characters to the right of cursor
    {BS  X}         -    Backspace X characters to the Left of the cursor
    {INS}           -    Same cursor as the [INS] key.  Toggles between
                         Insert and Overtype modes
    {HOME}          -    Move cursor to cell A1
    {END}           -    Same as the [END] key
    {EDIT}          -    Places the current cell in the Edit mode [F2]
    {NAME}          -    Name, show matrix of names same as [F3]
    {ABS}           -    Make cell reference absolute [F4]. Toggles
                         between ABS modes.
    {GOTO cell}     -    GoTo a specified cell, [F5]
    {WINDOW}        -    If window active toggles the cursor between
                         windows otherwise toggle the cursor between
                         the current and previous cursor locations, [F6]
    {VIEW}          -    Toggle the current view between the opened
                         windows, same as [F7]
    {CALC}          -    Recalculate all cells, [F9]
    {GRAPH}         -    View the specified graph, [F10]
    {ESC X}         -    Represents the [ESC] (Escape) key (X is
                         optional).
         ~          -    Tilde (~), same as the [ENTER] key

    NOTES:
      The keystroke [ENTER] in a macro is represented by the
      tilde (~).

      All macro commands MUST be enclosed in curly braces {}.

      The X in the above listing is optional, i.e., {RT 5} moves the
      cursor to the right 5 cells, whereas {RT} moves the cursor
      to the right just one cell.

    Macros are executed from left to right in a given cell and proceed
    downwards row by row until either a blank cell is reached, the [ESC]
    key is pressed, or the {QUIT} macro keyword is executed.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [94] 
    ADVANCED MACROS
    ~~~~~~~~~~~~~~~
    The advanced macro capabilities of AS-EASY-AS complete a powerful
    programming environment.  Using these macros, you can set up your own
    custom menus, set up programming loops, branching and execute sub-
    routines.

    NOTE:   All commands below may ONLY be used in an executing
            macro.

    {?}
        Pauses macro execution and awaits keyboard input.  Useful for
        interrupting macro to allow movement around sheet or entry of
        data. Macro execution continues only after [ENTER] or [ESC] is
        pressed.

        NOTE: [ENTER] and [ESC] characters will not appear in the macro
              stream.  You must provide them where required to terminate
              input in response to a prompt.


    {APPEND F#, "FileName"}
        F# - File Number (1, 2, 3, 4, or 5)
        Filename - Name of File, may include drive and path information

        Open FileName in Append mode. See {OPEN} command.  Subsequent
        WRITES to the file will cause text to be appended to the end of the file.

        NOTE:  Any file which is opened with {APPEND}, must be closed
               with the {CLOSE} macro command before exiting from AS-
               EASY-AS.  Failure to do so will result in the file information
               becoming corrupted and unusable.


    {BEEP X}
        Produces a beep sound.  This macro could be useful at the end of
        unattended macro(s) to signal the user that some task is
        completed, or to get the user's attention when a prompt for
        information is introduced. Also see {TONE X,Y}.


    {BLANK Range}
        Erases the cells in the range defined by 'Range'.  The effect is
        the same as when executing the /re command.  This method is
        sometimes more desirable than /re since it will not display the
        menus as does /re when it is used in a macro.



    {BORDEROFF}
        This macro command is used to turn the column and row borders off.
        It's function is the same as the /sbs menu command.  Once this
        macro is invoked, the borders of the sheet, i.e., the portion
        containing the row numbers, become invisible until a {BORDERON}
        command is invoked.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [95] 
    {BORDERON}
        This macro command  cancels the {BORDEROFF} macro.  You might note
        that the screen needs to be updated, using the {UPDATE} macro
        after {BORDERON} is invoked.


    {CALL Location}  or {RangeName}
        Call the subroutine identified by 'location'.  This is different
        than the {JUMP} command.  {JUMP} transfers execution of the macro
        to a given location but 'forgets' its current position.  {CALL},
        on the other hand, transfers execution to another location.

        When a {RET} command is encountered, it returns execution to the
        next command following the calling cell and continues with the
        macro. Subroutines may be nested (they can call more subroutines)
        up to 20 levels deep.

    {CHDIR "Path"}
        Change the current Data path to that specified by "Path".Its
        operation is similar to the RMDIR command in DOS.  Check your
        DOS manual for details.

    {CLOSE F#}
        F# - File Number (1, 2, 3,...)

        Close disk file F#.  See {OPEN}, {READ}, {WRITE}, and {APPEND}
        macro commands.

        As an example, {CLOSE 1} will close disk file #1.


    {CLRSCR}
        Clears the screen, so that a messages can be written for
        presentations, etc.  The screen remains in this mode until an
        {UPDATE} macro command is executed or the macro terminates.


    CURSOR
        This variable may only be used in edit or macro modes and refers to the
        cell occupied by the current position of the cursor.

        Example:
          Assume that cells A1 through A100 contain the values 1., 3., 4.5,
          and 8. randomly distributed.  Let's say that you want to replace
          all occurrences of the value 8. with 1.25.

        The following macro would do the trick for you:

        Cell    Contents                             Explanation
        ~~~~    ~~~~~~~~~~~~~~~~~~~~~~               ~~~~~~~~~~~
        B1      0                                    Set a counter cell
        B2      {LET B1,0}{GOTO A1}                  Go to beginning of
                                                     range
        B3      {If CURSOR=8}{LET CURSOR,1.25}       Set the criterion
        B4      {LET B1,B1+1}                        Increase counter by
                                                     1.
        B5      {IF B1=100}{JUMP OUT}                Check if all 100 cells

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [96] 
                                                     have been processed (if
                                                     the counter cell reached
                                                     100). If yes, jump out of
                                                     the loop.
        B6      {DN}                                 Move the cursor down
                                                     one cell.
        B7      {JUMP BEGIN}                         Repeat the loop
        B8      {QUIT}                               Stop executing macro.

        **  Don't forget to define the following range names:

        Range Name               Cell
        ~~~~~~~~~~               ~~~~
         BEGIN                    B3
         OUT                      B8
         \A                       B2 <-Press Alt-A to start macro


    {DELAY X}
        This macro command will halt program execution for  the specified
        (X) number of thousands of a second  within a macro, ONLY while
        displaying a graph or the Sheet Status screen.  A delay of X equal
        to 0 resets the pause mechanism to wait until a key has been
        pressed.  This could be useful in displaying a graph for a given
        amount of time, before continuing execution of the macro.


    {ESCON} and {ESCOFF}
        Disables/enables the escape key which would normally permit a
        macro to be aborted.

    CAUTION: {ESCOFF} should be used only if other provisions for
             exiting a macro have been made.  If no such provisions
             exist, you are liable to end up in an infinite loop, with
             the only way out being to reboot your computer.


    {EXIT}
        Cancels one/top level of subroutine calls and allows macro
        programming to continue.  This macro command was built into AS-
        EASY-AS to allow the user flexibility when a forced exit out of
        subroutines and loops is desired.


    {FOR COUNTER, START, STOP, STEP}
        Counter  =  Cell location which keeps track of the number of macro
                    iterations
        Start    =  The beginning value for the counter
        Stop     =  The end value for the counter
        Step     =  The incremental value to be added to counter after
                    each iteration
        Executes the macro commands which follow until {NEXT} is
        encountered.  The counter is increased by the value of step.  If
        the new counter value does not exceed the step value, the macro
        loop is repeated again.  This continues until the counter exceeds
        the stop value at which time execution transfers to the macro
        command cell below {NEXT}.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [97] 
        NOTES:  1.  If Stop is initially less than the Start value, the macro
                    loop will be skipped and execution transferred to the cell
                    below.

                2.  If Step is set equal to 0 (zero), an infinite loop will be
                    created as the counter will never exceed the Stop value.

               3.   A maximum of 4 nested {FOR}{NEXT} loops may be
                    created.


    {GET CELL}
        This command accepts the next character from the keyboard and
        places it in CELL. (This occurs as soon as you depress a keyboard
        key you do not need to press [ENTER]).  For example, {GET A13}
        stops and waits until a key is pressed.  If the Key "A" is
        pressed, then "A" is placed in cell A13.


    {GOTOXY A1,A2}
        Places the character cursor at the column and row screen
        coordinate specified by A1 and A2.  A1 is the column (1..80) and
        A2 is the row (1..25) of that coordinate.   Subsequent use of the
        {WRITE} macro will place text at the current cursor position.

        Example:       {Gotoxy 20,12}
                       {Write "This text is in the middle of the screen"}


    {IF Condition}Action...
        If the 'condition' is met, then proceed with the identified
        'action' in the same cell, otherwise continue with the macro in
        the cell below this command.  This macro command is very similar
        to the if-then-else structure found in many programming languages.

        It is important to remember, however, that the "then" action must
        follow in the same cell as the IF test.

        Example:       {goto A1}~Macro Example~
                       {IF Test>2}{JUMP A50}
                       {calc}

        Explanation:  Position cursor on cell A1. Place the string 'Macro
        Example' in that cell.  If the value of the cell named 'Test' is
        greater than 2, go  to cell A50 and start executing the macro in
        that cell.  If the value of 'Test' is less than 2, then
        recalculate the spreadsheet.



    {INDXY m,n}
        Sets the location of the mode indicator, to line (m) and column
        (n). (This is the area displaying the messages "Ready, Macro,
        Wait, etc.). The value for "m" must be 1-24 and that for "n" must
        be 1-80.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [98] 
    {INKEY CELL}
        Pauses execution of the macro and stores a single typed character
        in CELL. Macro execution continues after the key has been pressed.


    {INLABEL "Prompt", Location}
    {INVALUE "Prompt", Location}
        Display the text 'Prompt' on the control panel and pause for
        input.  The user can type a label (text string), or a value, and
        when [ENTER] is pressed, the label, or the value, is placed in the
        cell identified by 'Location'.

        Example:       {INLABEL "Enter Your Name",A5}
            Explanation:  Display the prompt 'Enter Your Name' in the
            control panel and pause.  When a user types his name and
            presses [ENTER], the name is placed in cell A5.


    {INRANGE "Prompt",Cell}
        This macro command prompts the user for a cell range.  The range
        can be defined using the pointing method (or the typing method)
        and the result is placed in cell.

        Example:
          The Macro {InRange " What is the Erase Range", d2} would place the
          prompt 'What is the Erase Range' in the panel area and wait for
          input.

          If the user presses:

              [HOME]
                .      <----- (Period)
              [DOWN]
              [DOWN]
              [RIGHT]
              [ENTER]

          The text A1..B3, representing the highlighted range, would be
          placed in cell D2.


    {IOINIT "COMn:Baud,PA,DB,SB,LEN,DL"}
         Initialize the serial port COMn where n=1,2,3,4.
         Baud      =    Baud Rate (300, 1200, 2400, .....)
         PA        =    Parity (E, O, N, ...)
         DB        =    Data Bits (Normally 7 or 8)
         SB        =    Stop Bits (Normally 1 or 2)
         LEN       =    Maximum length of string that will be transmitted or
                        accepted as input (Default is 80)
         DL        =    Delay in units of System Cycles.

        This macro command is used to initialize one of the computer's
        serial ports for subsequent use of the {IOVALUE} and {IOLABEL}
        macro commands.

        Example:
          {IOINIT "COM2:2400,N,8,1,80,2000"}

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [99] 
          Initialize serial port 2 for 2400 baud, No parity, 8 data bits, 1
          stop bit, a maximum string length of 80, and a delay of 2000
          system cycles.


    {IOLABEL "String",Range}
        Transmit String to the initialized communications port and store
        the received information, as a label, in Range.  You may leave
        String blank ('''')if you just want to get information from the
        port without sending anything.  Conversely, use the range name NUL
        if you are just sending information to the port.

        Example:       {IOLABEL "ATDT12345667&@CHR(13),NUL}
            Send the dial up sequence ATDT1234567, followed by CR to
            the initialized serial port.  No information expected to come
            back to AS-EASY-AS, Range = NUL.


    {IOVALUE "String",Range}
        Transmit String to the initialized communications port and store
        the received information, as a label, in Range.  You may leave
        String blank ('''')if you just want to get information from the
        port without sending anything.  Conversely, use the range name NUL
        if you are just sending information to the port.

        Example:  {IOVALUE "",A2}
            Receive information from the serial port (in this case from
            the other computer), and place it in Cell A2.

            {IF @FIND(":?",A2,1)>0}{IOVALUE +F1,NUL}
            Check to see if the string that was received from the serial
            port, and placed in cell A2, contains the substring ":?".  If it
            does, then transmit the value in cell F1 to the serial port.


    {JUMP Location}
        This macro instructs the program to continue executing at a new
        'location'.  The 'location' can either be a cell location (A1,
        B345, AG5) or a range name that was created with the /Range, Name,
        Create command.

        Be careful, this command is different than the {GOTO} macro
        command. {JUMP} simply tells the program which macro to execute
        next, whereas, {GOTO} transfers the cell pointer to the specified
        cell.

        Example:   {goto A1}~Macro Example~
                   {JUMP A50}


        Explanation:  Go to cell A1, place the string 'Macro Example' in
        that cell and then jump to cell A50 and execute the macro in that
        cell, while the cell pointer is still at A1.





    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [100] 
    {LET A1,EXPRESSION}
        Evaluates the formula "EXPRESSION", and places the value in A1.
        Use of this command does not require that you physically move the
        cursor to A1 before entering data, therefore, it can reduce
        moving back and forth between various portions of the worksheet.
        EXPRESSION can be any valid mathematical or logical expression.

        Example:  {Let A3,A3+1} increments the value in cell A3 by one.

        NOTE:  There is no space between the "," and "Expression".


    {MENUCALL Location}
        Transfers execution to macro menu at "Location".  Allows the user
        to make a menu selection, and then CALLS the macro identified by
        that menu selection.  When {RET} is encountered, macro execution
        continues with the command following the {MENUCALL}.

        See {MENUJUMP} for instructions on defining your own menu.


    {MENUJUMP Location}
        Transfers execution to the macro menu at "Location".  Allows the
        user to make a menu selection, and then executes the macro
        identified below that menu selection.

        The macro menu has to follow the guidelines given below:

         -    Two rows are used for the creation of the menu.  Each menu
              option can be up to 30 characters long.
         -    The cell to the right of the last item of the menu must be empty
              to indicate the end of the menu.

         -    Each selection is placed in an individual cell in the first row.

         -    Each cell in the second row contains the explanation of the
              command in the cell above it.  Whenever the user moves the
              cursor highlighting one of the menu options, the control panel
              displays the explanation for that menu selection.

    {MENUOFF}
        Disables the screen update of the panel and pop-up window menus.
        Invoking this command will speed the operation of macros that
        frequently update the screen.


    {MENUON}
        Restores screen update of the panel and pop-up window menus.  This
        command should be invoked at the end of a macro that used
        {MENUOFF}.


    {MENUWIDTH x}
        Specify a width of x (up to 28 characters) for the menu window.
        Once a menu width is specified, it stays in affect until a new
        {MENUWIDTH x} macro command is issued.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [101] 
    {MENUXY x,y}
        Specify the x,y coordinate of the upper left corner of menu
        window.  If the period key [.] is pressed while a menu is
        displayed at x,y, the menu position will toggle between the left
        and the right side of the screen, i.e., the x coordinate above
        will be overridden, but the vertical position of the menu will not
        change until a new {MENUXY x,y} macro command is used.

    {MKDIR "Path"}
        Create a new directory/sub-directory specified by the string
        "Path".  Its operation is similar to the RMDIR command in DOS.
        Check your DOS manual for details.

    {OPEN F#,M#,"Filename"}
         F# - File Number (1, 2, 3, 4, or 5)
         M# - Mode (1, 2 or 3)
              1 - Read -  Allows the file to be read.
              2 - Write -  Opens a new file.  If the file exists, current
                           information will be erased.
              3 - Append -  Opens an existing file and places the file
                            pointer at end of file.
         Filename - Name of File, may include drive and path information

        Open a disk file which is to be read, written to, or appended.
        See {READ}, {WRITE}, {APPEND}, and {CLOSE} macro commands.

        As an example, {OPEN 1,3,"C:\DATA\TRIDATA.DTA"}{WRITE...} will
        open TRIDATA.DTA located in C:\DATA, which is to be appended.  If
        the file does not currently exist, it will be created.

        NOTE:  Any file which is opened with {OPEN}, must be closed with
               the {CLOSE} macro command before exiting from AS-
               EASY-AS.  Failure to do so will result in the file information
               becoming corrupted and unusable.





    {PICK Range,Outcell}
         Range   = Cell range which contains listing of labels to appear in
                   pick list.
         Outcell = Cell which will contain picked selection

        PICK will create a pick window comprised of the labels contained
        in the specified RANGE.  Using the cursor keys, the user can move
        through the list and highlight the desired label.  When [ENTER] is
        selected, the highlighted choice is placed in OUTCELL.

        PICK is useful for situations where the user is to be prompted for
        data input, and there is a limited selection of valid or desired
        responses.

        Example:
           {PICK A1..A10,C1}
           When an executing macro encounters this command, a pick window
           will appear in the top left of the screen which is comprised of

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [102] 
           the labels in the range A1..A10.  The user will select a label
           by pressing [ENTER] and the result be placed in cell C1.


    {QUIT}
        Stops execution of the macro and returns to the 'Ready' mode.


    {READ F#, CellAddress}
         F# - File Number (1, 2, 3, 4, or 5)
         CellAddress -  Worksheet cell location (column & row) where read
                        information is to be placed.
        Read one line from disk file #, from the current pointer location
        up to the carriage return, and place it in CellAddress.
        Subsequent {READ}s will continue to read in one line at a time,
        until the end of file is encountered.  At that point, execution
        will continue with the macro in the current cell, or if
        unsuccessful, the macro command in the next row. See {OPEN},
        {CLOSE}, {WRITE}, and {APPEND} macro commands.

        As an example, {READ 1, D10} will read a line of information from
        file #1 and place it in cell D10 of the worksheet.

    {RECALC Range}
        Calculates only the specified range.


    {RESTART}
        This command clears all levels of the subroutine stack and
        continues execution of the macro commands.  If {RESTART} is
        encountered, AS-EASY-AS continues with the instructions that
        follow.  Upon completion of the subroutine, it will terminate and
        WILL NOT return to the calling routine.


    {RET}
        When this command is encountered, execution is returned to the
        cell just below the last {CALL} command, i.e., to the macro that
        called the subroutine terminated with {RET}.  If no {CALL} command
        exists, and a {RET} command is encountered, a macro error occurs.

    {RMDIR "Path"}
        Remove the disrectory specified by path.  Its operation is
        similar to the RMDIR command in DOS.  Check your DOS manual for
        details.

    {SCRNOFF}
        Disables the update of the screen.  Invoking this macro command
        will speed the operation of most of your macros since screen I/O
        is time consuming.  Remember to restore screen update after your
        macro is completed.

        NOTE:  When this macro is used, it will seem that your
               computer is not doing anything, i.e., the screen will not
               be updated until {SCRNON} and {UPDATE} macros
               are executed.


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [103] 
    {SCRNON}
        Enables the update of the screen.  This command should be invoked
        at the end of a macro that used {SCRNOFF}.


    {TONE  A1,A2}
        Generates a sound of frequency A1 (Hz) and duration A2 (milli-
        seconds). A1 and A2 can be values, results of a calculation or
        cell references.  This macro can also be used to cause a delay in
        macro execution without generating an audible tone, if desired.

         i.e. {TONE 0,5000} will create a silent delay of 5 seconds.


    {UPDATE}
        Refreshes the screen.  Useful after a {SCRNON} command.


    {WHILE Test,Action}
        Perform a subroutine call to the "Action" while the "Test" is
        true.  The subroutine must have a corresponding {RET} statement.
        Once the result of "Test" is false, continue execution of the
        macro command in the cell below.


    {WRITE "String"}
        Print the content of 'String' at the current character cursor
        screen coordinates, and leave the cursor at the end of the printed
        string.  It should be noted that this is only a temporary screen
        write.  If this was the last macro command in a sequence, it would
        disappear as soon as it was printed since the screen would be
        updated at the end of the macro sequence.

    {WRITE F#, "String"}
         F# - File Number (1, 2, 3,...)
         "String" -     Information to be written to the file.

        Writes "String" information to open disk file F#, starting from
        the current pointer location.  Subsequent {WRITE}s will continue
        to be appended to the file.

        If the {WRITE} fails, execution will continue with the macro
        command in the next row.  See {OPEN}, {CLOSE}, {READ}, and
        {APPEND} macro commands.

        As an example, {WRITE 1, "Test Data"} will write the string "Test
        Data" to file #1.


    {WRITELN "String"}
        Same as the {WRITE} macro, above, but places the cursor at the
        beginning of the next character row.


    {WRITELN F#, "String"}
        Same as the {WRITE F#, "String"} macro above, but writes String
        information to the file, starting from the current pointer

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [104] 
        location, as a single line, followed by carriage return and line
        feed characters.
























































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [105] 
    11. CONFIGURATION FILE
    ~~~~~~~~~~~~~~~~~~~~~~
    Certain system and user configuration parameters are stored in an
    external, binary file ASEASY.CFG.  This file is not present when you
    first install the program, it is created by the user, if desired, when
    some of the configuration paramters are modified.

    The parameters stored in the configuration file are accessed using the
    /User, Install command.  Here is a brief description of what may be
    modified/installed using the options under /User, Install.

    DO NOT forget to save the installed options if you don't want them to
    be lost when you exit AS-EASY-AS (/User, Install, Save Config).


    ADDINS
    ~~~~~~
      Create (install), or Delete an AS-EASY-AS add-in.  Add-ins are
      separate programs that may be used from withing AS-EASY-AS.  Note
      that any .EXE or .COM program may be installed as an add-in,
      provided there is enought RAM available to run it from withing AS-
      EASY-AS.  This option, however, was primarily developed for special
      add-in programs, created using the AS-EASY-AS Developer's Package,
      that may access the AS-EASY-AS data currently in memory.

      For more information on the AS-EASY-AS Addin Developer's Package and
      distribution of Addins you develop, please contact TRIUS, Inc.

      NOTE:Addins written for other products will not work with AS-EASY-AS.


    CMDSTR
    ~~~~~~
      Allows the user to specify a string containing any command line
      switches that should be automatically invoked next time the program
      is started, (e.g., /VM/E/NT).  These command line switches are saved
      with the user's ASEASY.CFG file, and are used every time the program
      is started.

      NOTE: Any command line switches specified when starting the program
      from DOS are ignored if a CMdStr string has been defined.  The only
      exception is the /CFG command line switch (which is ignored if it is
      placed in the CMdStr parameter string).


    COLORS
    ~~~~~~
      Customizes screen colors.  When a color option is selected, a matrix
      of colors appears and the cursor is located on the current color
      selection.  The panel area displays which color attribute you are
      changing (e.g., text, menu, border, etc.) and the current color
      number.

      As you move the cursor around, you can see the color combination
      selected the color number in the command panel area.  When you find
      the combination you want, press [ENTER] and the desired color is
      selected.  As soon as the selection is made, the appropriate color

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [106] 
      changes take effect.

      Alternatively, you can enter the color number directly in the command
      panel area (e.g., 23 = blue background and white foreground.

      CAUTION: Remember to save the config file if you don't want your
      color changes to be lost when you exit AS-EASY-AS.


    DEVICE
    ~~~~~~
      Select a printing device; LPT1, LPT2, or select to send the print
      output to a file (you will be prompted for a file name when you
      attempt to print, later).


    DIMENSION
    ~~~~~~~~~
      Divide the worksheet into a number of pages simulating a third
      dimension (depth).

      Each of the pages is identified by a letter A, B, C, ......, which
      appears on the top left corner of the worksheet, above the row
      numbers.  When the Dimensions command has been invoked and more than
      one page is specified, reference to cells in each of the pages is
      made with the addition of a page letter. (i.e. A:A1, AC:FF1  rather
      than A1, FF1, etc.).

      Each generated page is 256 columns wide and 8192/N rows long, where N
      is the number of pages specified.

      Movement from page to page can be accomplished by a number of
      different ways:

      1.  Using the [F5] (GOTO) key and the cell address.

      2.  With the arrow and the PgUp, PgDn keys. (The first row of
          panel B follows the last row of panel A, etc.)

      3.  Using the combination of the [Ctrl] (control) and [PgUp],
          [PgDn] keys.  [Ctrl] [PgDn] moves you to the next page, and
          [Ctrl] [PgUp] moves you to the previous page.

      When the multidimension option is canceled, the information contained
      in all other pages is retained in their relative positions in the
      worksheet.


    PRINTERS
    ~~~~~~~~
      Select output device for text and graphics.  Note that if all you are
      printing is text, and you have not selected any special pitch, then
      your output should be fine.  That's because AS-EASY-AS sends simple
      ASCII output to the device.  A printer device option SHOULD be
      installed, however, if you are trying to print graphics information.



    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [107] 
    PUNCTUATION
    ~~~~~~~~~~~
      Enters the Punctuation Installation menu. Through this menu, the user
      can set the ASCII characters to be used for separating decimals, the
      thousands delimiter, separating function arguments, prefacing
      currency values, etc.

      CAUTION:Do not forget to save the punctuation options, or they will
      be lost when you exit AS-EASY-AS.



    VIDEO
    ~~~~~
      This menu allows the user to specify the video mode to be used by AS-
      EASY-AS.  Note that in order for a video mode to become active, it
      has to be supported by the user's hardware, i.e., the video adapter
      and monitor.  The designation [Text]/[Graf] next to each mode below,
      refers to the main spreadsheet mode, not the mode when a graph is
      displayed.

      A:[DEF25x80]:Text
          Set the default text video mode, 25 lines by 80 columns.
          Selecting one of the other special modes might result in a
          scrambled display (if the selected mode is not compatible with
          the hardware).  If that happens, then you may immediately select
          this option to reset the video mode.

      B:[EVGA 43/50]:Text
          Depending on your video adapter/monitor combination, this option
          will set the monitor to 43 lines (EGA), or 50 lines (VGA).

      C:[CGA 25x40]:Text
          Set the 40 column by 25 rows CGA video mode.  When displaying
          graphs, only two colors (foreground and background) are
          available, since the high CGA resolution mode is used.

          This mode is very useful for individuals with visual impairment
          (very large characters).

      D:[X User Supplied]
          This is a special mode that requires some input from the
          user. Note that in order to use this mode, you have to be
          familiar with the various modes available for your hardware,
          i.e., you need to consult your video adapter card's user manual.
          When this option is selected, the user is asked to supply the
          hexadecimal value that the AX register needs to contain when the
          interrupt $10 call is made (consult your adapter's manual).

          Once the value is supplied, the user is asked to specify the
          number of rows and columns for this mode.  Note that such special
          modes might not be available on your hardware combination.

      E:[EGA 25x80]:Graphics
          Set the 25 row, 80 column EGA graphics mode (640x350).  If your
          video adapter has at least 256K of RAM, then up to 16 different
          colors are supported in this mode when displaying graphs.

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [108] 
      F:[EGA 43x80]:Graphics
          Set the 43 row, 80 column EGA graphics mode (640x350).  If your
          video adapter has at least 256K of RAM, then up to 16 different
          colors are supported in this mode when displaying graphs.
      G:[VGA 60x80]:Graphics
          Set the 60 line by 80 column VGA graphics mode.  If your video
          adapter card contains at least 512K, then up to 16 colors are
          available when displaying graphs.

      H:[HERC 25x90]:Graphics
          Sets the 25 row by 80 columns graphics mode for a Hercules
          monitor and video adapter combination.

      I:[HERC 43x90]:Graphics
          Sets the 43 row by 80 columns graphics mode for a Hercules
          monitor and video adapter combination.

      J:[MGA 25x80]:Graphics
          Set the 25 row, 80 column monochrome EGA graphics mode (640x350).

      K:[MGA 43x80]:Graphics
          Set the 43 row, 80 column monochrome EGA graphics mode (640x480).

      L:[SVGA 50x100]:Graphics
          Sets the 50-line Super VGA graphics display mode (800x600)
          resolution.  The default screen colors are set automatically when
          this mode is selected.


    SAVECONFIG
    ~~~~~~~~~~
      Save the defaults set through the Install menu in a file called
      ASEASY.CFG.  When AS-EASY-AS is first started, it looks for this file
      in the current directory.  If not found, it uses the internal
      defaults for the various options.


    USER, SHELL
    ~~~~~~~~~~~
      This command allows you to temporarily exit to DOS, while AS-EASY-AS
      remains resident in memory.  When the command is executed, another
      copy of the command processor (COMMAND.COM, or other command
      processor you might be using) is loaded, and the system behaves as if
      it was just booted up, with the exception that a portion of RAM is
      occupied by AS-EASY-AS.  The amount of RAM retained by AS-EASY-AS
      depends on the amount of information in the current worksheet.

      The user can return to AS-EASY-AS by typing "EXIT" (no quotes) and
      pressing [ENTER] at the DOS prompt.

      If you are using a different command processor, e.g., 4DOS.COM, then
      simply type in the appropriate path and file name when prompted
      (after /User, Shell).  The new command processor file name is
      retained if you save the configuration file (see command above).

      CAUTION: Although AS-EASY-AS can in no way harm your data or your
      system while you have shelled to DOS, the programs you execute during

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [109] 
      that time might.  We recommend that you save your data before you use
      the /User Shell command. This way, even if the programs you run,
      while in the shell, crash your system, you will not lose any of your
      valuable AS-EASY-AS data.

      If AS-EASY-AS was started with the /vm command line switch, you will
      see a file named ASEASY.TMP if you execute a ODS DIR command,
      when shelling to DOS.  DO NOT DELETE THIS FILE.  Deleting the temporary
      file will destroy your spreadsheet data.

















































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [110] 
    INDEX
    ~~~~~

       3D-SIMULATION                107

       ABSOLUTE ADDRESS              27
       ABSOLUTE ADDRESS FUNCTION KEY   19
       ADD-INS                      106
       ARROW KEYS                    14
       ASEASY.PRT FILE               43
       ASEASY.PRT FILE               44
       AT&T MONOCHROME               10
       ATT2 - MODE                   10
       AUTOEXEC MACRO                92
       AUTOLOAD                      10

       BIN BOUNDARIES                12
       BM - BYPASS MONO              10
       BOX CHARACTERS                23

       CALCULATE KEY                 20
       CFG - CONFIG FILE PATH        10
       CGA MODE                      12
       CGA MODE                     108
       CIRCULAR REFERENCES           31
       CMDSTR                       106
       COLOR SETUP                  106
       COLORS                       106
       COMBINING WORKSHEETS          33
       COMMAND LINE                 106
       CONDENSED PRINT               39
       CONFIGURATION                106
       COPY FORMULAS                 29
       COPY VALUES                   29
       CTR - CENTER COLUMN HEADINGS   11
       CURSOR                        96
       CURSOR KEY                    17

       DATA BIN                      55
       DATA COMMANDS                 53
       DATA DISTRIBUTION             55
       DATA FILL                     53
       DATA INPUT                    53
       DATA INPUT FORM               57
       DATA REGRESSION               56
       DATA SORT                     54
       DATABASE                      59
       DATABASE RANGE                59
       DATING A PAGE                 41
       DBASE IMPORT                  34
       DEFAULT DIRECTORY             11
       DEFAULT OPTIONS              106
       DEFAULT SETUP                108
       DIMENSIONS                   107
       DISTRIBUTION OF DATA          55
       DOS VERSION                    7
       DOT MATRIX                     7

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [111] 
       DOT MATRIX                    40
       DOT MATRIX PRINTERS           46
       DW - HIGHLIGHT CELLS          11

       EDIT                          23
       EDIT CELL                     19
       EGA GRAPHICS MODE            108
       EGA GRAPHICS MODE            109
       EGA TEXT MODE                108
       EM - MONOCHROME EGA           11
       EMBEDDED CODES                42
       EMS                            7
       ENHANCED GRAPHICS ADAPTOR     11
       ENTERING A MACRO              18
       ENTERING AN EQUATION          18
       ENTERING FORMULAS             22
       ENVIRONMENT VARIABLE          13
       EVM - MONOCHROME VGA          11
       EXIT                          37
       EXPANDED MEMORY                7
       EXPANDED MEMORY               11
       EXPORTING                     32
       EXTRACT CRITERION             59

       F1                            18
       F1                            18
       F2                            19
       F3                            19
       F4                            19
       F5                            20
       F6                            20
       F7                            20
       F9                            20
       FILE LIST                     36
       FILE OUTPUT                  107
       FOREIGN CURRENCY             108
       FORMAT                        27
       FORMULAS                      24
       FORMULAS - POINTING           24
       FORMULAS - TYPING             24

       GENERAL OPTIONS              106
       GOALSEEKING                   56
       GOTO KEY                      20
       GRAPH COMBINING TEXT AND GRAPHICS   51
       GRAPH FONT SIZE               48
       GRAPH FONT TYPE               48
       GRAPH FORMAT                  47
       GRAPH MERGE                   51
       GRAPH NAME                    49
       GRAPH OPTIONS                 47
       GRAPH PLOT                    50
       GRAPH RANGES                  47
       GRAPH SAVE                    52
       GRAPH TITLES                  48
       GRAPHICS                      46
       GRAPHICS CHARACTERS           23

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [112] 
       GRAPHICS MODE                108

       HARDWARE                       7
       HELP                          18
       HERC GRAPHICS MODE [25]      109
       HERC GRAPHICS MODE [43]      109
       HERCULES                      11
       HERCULES, PAGE #2             11

       IMPORT                        34
       IMPORT TEXT                   36
       IMPORT VALUES                 36
       INPUT FORM                    57
       INSTALLATION                   8

       KEYBOARD                      17

       LABEL                         21
       LARGE 40 COL MODE            108
       LASERJET                      46
       LASERJET PRINTERS             40
       LIMIT EMS USAGE               13
       LSF                           56

       MACRO COMMANDS                95
       MACRO DEFINITION              92
       MACRO EXECUTION               93
       MACRO KEY                     19
       MACRO KEYWORDS                94
       MACRO NAME                    92
       MACROS                        92
       MANUAL RECALC                 11
       MATH COPROCESSOR              13
       MATHEMATICAL OPERATORS        22
       MATRIX OPERATIONS             61
       MEMORY                         7
       MENUS                         14
       MONITOR (EGA)                  7
       MONITOR (SVGA)                 7
       MONITOR (VGA)                  7
       MONITOR HERCULES               7
       MONITOR MONOCHROME             7
       MONO EGA GRAPHICS MODE       109
       MONO VGA GRAPHICS MODE       109
       MONOCHROME (B&W)              11
       MOUSE                          7
       MOUSE                          8
       MOUSE POINTING                25
       MOVE FORMULAS                 30
       MOVE VALUES                   29

       NAMED GRAPH                   49,50,52
       NAMED RANGE                   18,26,28,33,84,93
       NON-TURBO KEYBOARD            12

       OPERATING SYSTEM               7
       OUTPUT DEVICE                107

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [113] 
       P  - USE ALTERNATE MENU       12
       PAGE BREAKS                   41
       PAGE FOOTERS                  41
       PAGE HEADERS                  41
       PAGE LENGTH                   39
       PAGE NUMBERS                  41
       PANELS                       107
       PIC FILE                      46
       PRINT CONTROL CODES           43
       PRINT ENHANCEMENT             44
       PRINT FILE                    44
       PRINT MARGINS                 39
       PRINT MENU                    38
       PRINT TO A FILE               44
       PRINT TYPE                    43
       PRINTER BORDERS               39
       PRINTER CODE                  43
       PRINTER CONTROL FILE          43
       PRINTER DRIVERS              107
       PRINTER ESCAPE CODE           43
       PRINTER INSTALL              107
       PRINTER SET-UP FILE           19
       PRINTER SETUP CODE            19
       PRINTER SETUP FILE            19
       PRINTER SETUP STRINGS         19
       PRINTERS                       7
       PRINTING                      38
       PRINTING COMBINED TEXT AND GRAPHICS   45
       PROTECT                       87
       PUNCTUATION OPTIONS          108

       RANGE                         26
       RECALCULATION                 30
       REGRESSION                    56
       RELATIVE ADDRESS              27
       RETRIEVING A FILE             33
       ROUND ABSOLUTE                12

       SAVE CONFIGURATION           109
       SAVING A FILE                 31
       SCREEN BLANKING               10
       SET ASEASY=                   13
       SETUP COLORS                 106
       SHELL TO DOS                 109
       SMART CURSOR                  18
       SORTING DATA                  54
       SPARSE MATRIX                  7
       STRING FUNCTIONS              63
       SUPER VGA - DEFAULT          109
       SUPER VGA MODE               108

       TEXT MODE                    108

       UK PUNCTUATION                12
       USER OPTIONS                 106
       USING PRINT VIEW              45


    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [114] 
       VALUE                         21
       VGA GRAPHICS MODE            109
       VGA MONITOR/CARD              11
       VIDEO MODES                  108
       VIEW KEY                      20
       VIEWS                         16
       VIRTUAL DRIVE PATH            12
       VIRTUAL MEMORY                 7
       VIRTUAL MEMORY                12

       WINDOW KEY                    20
       WINDOWS                       16
       WINDOWS 3.0                    7

      #OR# & #AND# OPERATORS         77
      @ABS                           69
      @ACI                           72
      @ACOS                          69
      @ACOSH                         69
      @ASIN                          69
      @ASINH                         69
      @ATAN                          69
      @ATANH                         69
      @AUTO                          83
      @AVG                           79
      @BAL                           73
      @CASE                          83
      @CELL                          63
      @CELLPT                        63
      @CHR                           65
      @CLEAN                         65
      @COLS                          84
      @COMB                          79
      @COS                           70
      @COSH                          70
      @COUNT                         79
      @CSC                           70
      @CTERM                         73
      @CTN                           70
      @DATE                          89
      @DATEVAL                       89
      @DAY                           89
      @DDB                           73
      @DEC                           84
      @DOSVER                        84
      @ERR                           78
      @EXACT                         65
      @EXP                           70
      @FACT                          80
      @FALSE                         70
      @FILEINFO                      84
      @FIND                          65
      @FV                            73
      @GAMMALN                       70
      @HEX                           85
      @HOUR                          90
      @HTABLE                        85

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [115] 
      @HTERP                         85
      @IF                            77
      @INDEX                         86
      @INT                           70
      @IORESULT                      86
      @IRR                           74
      @ISERR                         78
      @ISNA                          78
      @ISNUM                         77
      @ISSTR                         78
      @LEFT                          65
      @LENGTH                        66
      @LENGTH                        86
      @LINK                          86
      @LN                            71
      @LOG                           71
      @LOWER                         66
      @MAX                           80
      @MEMAVAIL                      87
      @MID                           66
      @MIN                           80
      @MINUTE                        90
      @MOD(X,Y)                      71
      @MONTH                         90
      @N                             66
      @NA                            71
      @NOT                           78
      @NPV                           75
      @ORD                           66
      @PATH                          87
      @PERM                          80
      @PI                            71
      @PMT                           75
      @PMTP                          75
      @PROPER                        66
      @PSUM                          80
      @PV                            75
      @QCOUNT                        81
      @QMAX                          81
      @QMIN                          81
      @QSTD                          81
      @QSUM                          81
      @QVAR                          82
      @QVIEW                         87
      @RAND                          71
      @RATE                          75
      @REPEAT                        67
      @RIGHT                         67
      @ROUND(X,Y)                    71
      @ROWS                          87
      @S                             67
      @SEC                           71
      @SECOND                        90
      @SIN                           71
      @SINH                          72
      @SLN                           76
      @SQRT(X)                       72

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [116] 
      @STD(RANGE)                    82
      @STDU                          82
      @STR                           67
      @SUM                           83
      @SYD                           76
      @TAN                           72
      @TANH                          72
      @TERM                          76
      @TIME                          90
      @TIMEVAL                       91
      @TODAY                         91
      @TRIM                          67
      @TRUE                          72
      @UPPER                         68
      @USER                          88
      @VAL                           68
      @VAR                           83
      @VARU                          83
      @VERSION                       88
      @VTABLE                        88
      @VTERP                         89
      @YEAR                          91
      {APPEND F#, "FILENAME"}        95
      {BEEP X}                       95
      {BLANK RANGE}                  95
      {BORDEROFF}                    95
      {BORDERON}                     96
      {CALL LOCATION}  OR {RANGENAME}   96
      {CHDIR "PATH"}                 96
      {CLOSE F#}                     96
      {CLRSCR}                       96
      {DELAY X}                      97
      {ESCON} AND {ESCOFF}           97
      {EXIT}                         97
      {FOR COUNTER, START, STOP, STEP}   97
      {GET CELL}                     98
      {GOTOXY A1,A2}                 98
      {IF CONDITION}ACTION...        98
      {INDXY M,N}                    98
      {INKEY CELL}                   99
      {INLABEL "PROMPT", LOCATION}   99
      {INRANGE "PROMPT",CELL}        99
      {INVALUE "PROMPT", LOCATION}   99
      {IOINIT "COMN:BAUD,PA,DB,SB,LEN,DL"}   99
      {IOLABEL "STRING",RANGE}      100
      {IOVALUE "STRING",RANGE}      100
      {JUMP LOCATION}               100
      {LET A1,EXPRESSION}           101
      {MENUCALL LOCATION}           101
      {MENUJUMP LOCATION}           101
      {MENUOFF}                     101
      {MENUON}                      101
      {MENUWIDTH X}                 101
      {MENUXY X,Y}                  102
      {MKDIR "PATH"}                102
      {OPEN F#,M#,"FILENAME"}       102
      {PICK RANGE,OUTCELL}          102

    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [117] 
      {QUIT}                        103
      {READ F#, CELLADDRESS}        103
      {RECALC RANGE}                103
      {RESTART}                     103
      {RET}                         103
      {RMDIR "PATH"}                103
      {SCRNOFF}                     103
      {SCRNON}                      104
      {TONE  A1,A2}                 104
      {UPDATE}                      104
      {WHILE TEST,ACTION}           104
      {WRITE "STRING"}              104
      {WRITE F#, "STRING"}          104
      {WRITELN "STRING"}            104
      {WRITELN F#, "STRING"}        104
      @@                             63
      {?}                            95









































    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [118] 

 

                    TRIUS PRODUCTS ORDER/REGISTRATION FORM
                    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        Name:________________________________  Title:________________

        Company:_____________________________________________________

        Address:____________________________ City:___________________

        State:___________   Zip:_____________  Country:______________

        Date:_____/_____/_____           (Fill out form completely)

        ---------------------------------------------------------------
        Product                     #     Price/ea     S&H       Total
        ---------------------------------------------------------------
        AS-EASY-AS 5 (Spreadsheet) ___    _$69.00_    _$6.00_   _______
        DRAFT CHOICE 2 (CAD)       ___    _$69.00     _$6.00_   _______
        PIVOT (Sideways Printing)  ___    _$15.00_    _$6.00_   _______
        ALITE (Spreadsheet)        ___    _$20.00_    _$6.00_   _______
        DCLIB1 (Symbol Libraries)  ___    _$19.00_    _$6.00_   _______
        XTRAN  (File Transfer)     ___    _$19.00_    _$6.00_   _______
        PRINT-GL (Plotter Util.)   ___    _$50.00_    _$6.00_   _______
        ODYSSEY (COMMUNICATIONS)   ___    _$89.00_    _$6.00_   _______
        ProtoCAD 3D (Rendering)    ___    _$59.00_    _$6.00_   _______
                                                          -------------

        * Canadian Orders, Add $2.50 per copy                   _______

        * International Orders, Add $6.50 per copy              _______

        * Mass Residents add appropriate sales tax              _______

                                         TOTAL ENCLOSED      __________

        Disk Size: [ ] 5-1/4"   [ ] 3-1/2"   [ ] Check  [ ] Visa  [ ] MC

        Card# __________________________________     Exp. Date ________

        Signature ______________________________

        How did you hear about our Products?    [ ] BBS   [ ] Friend
        [ ] Other _____________________________________________________

                      Mail Completed form with Payment to:
               TRIUS, Inc.,  P.O. BOX 249, N. Andover, MA 01845.
                       Orders ONLY, Call  1-800-GO-TRIUS
      Prices subject to change without notice [Not Valid After Jun 1993]
         For latest prices and information you may call: (508) 794-9377






    AS-EASY-AS 5.5 User's Guide - Copyright 1992, TRIUS, Inc.           [119] 

