unit globals;

interface
uses crt,emsalloc;

const
 numueqp=6;
 numudev=16;
 numdev=200;
 numobj=2048;
 numst=50;
 numprod=3;
 numbase=75;
 numspell=5;
 numbforsale=5;
 numquest=13;
 numterrain=50;
 hinc=45;

 maxmapx=125;
 maxmapy=125;
 maxmapz=1;
 numca=100;
 maxtav=50;
 numtcode=27;
 maxinclude=10;

 numpurparts=5;
 kirkpart=1;
 xebocpart=2;
 drakpart=3;
 xebpart=4;
 tranliuspart=5;

 ammomax=20;
 vortexbattmax=9999;

 maxteams=10;
 maxteamplayers=5;

 doauth: boolean=true;

 numland=30;
 maxmon=300;

 maxpmask=10;

 regfilename1: string[5] ='LO';

 gamename='Land Of Devastation';
 gamename3: string[32] = 'Land Of Devastation';
 authname='Scott M. Baker';
 vernum='3.70';

 regfilename3: string[5] ='G.DAT';
 gamename2: string[32] = 'Land Of Devastation';
 authfile1: string[5] = 'AUTH';
 regfilename2: string[5] = 'DRE';
type
 tpass = (Imp, Pass, Water);
 strptr=^string;
 storetype= (NoStore,Weap,Armr,Supp,Ammo,BaseReact,BaseComm,BaseDef,BaseMoat,
             BaseWeap,computer,weaplr,troysteak,troydisk,gsrz,BaseTele,EEEE,
             town2,town3,town4,town5,town6,town7,town8,town9,
             kill,
             sjunk1,sjunk2,sjunk3,sjunk4,sjunk5,sjunk6,sjunk7,endstore);

 maptype=   array[1..maxmapx,1..maxmapy] of byte;
 mapptr=    ^maptype;
 devapptype=(Radio,Medkit,Weapon,RangeWeapon,Armor,AML,BAD,LRScan,AmmoP,
             medline,rope,rations,scanner,stealth,gblaster,armorn,grenade,
             cyceye,deathbadge,warper,communicator,reactor,comm,deffield,
             moat,bweap,laptop,rom,troysteakp,tele,recharge,pylonkey,
             vortexbatt,unitran,mine,boat);

 puritronunit=record
               ishere: boolean;
               userrealname: string[25];
               reset: boolean;
               blah: array[1..24] of byte;
              end;

 puritrontype=record
               parts: array[1..numpurparts] of puritronunit;
               active: boolean;
               blah: array[1..99] of byte;
              end;

 CasinoUnit=record                        { 1 - Coin Flip    }
             timesplayed: longint;        { 2 - Guess number }
             timeswon: longint;           { 3 - Slot Machine }
             timeslost: longint;          { 4 - Trivia       }
             moneyspent: comp;
             moneywon: comp;
             moneylost: comp;
             lastplayer: string[25];
             blah: array[1..10] of word;
            end;

 CasinoType=record
             games: array[1..12] of casinounit;
             casblah: array[1..100] of byte;
            end;

 datasettype= record
               sdstart,sdend: word;
               name: strptr;
               author: strptr;
               prodname: array[1..3] of strptr;
               menustem: string[8];
               cityname: array[1..10] of strptr;
               hisstr: strptr;
               herstr: strptr;
               itsstr: strptr;
               hestr:  strptr;
               shestr: strptr;
               itstr:  strptr;
               mhimstr: strptr;
               fhimstr: strptr;
               ihimstr: strptr;
               obstart,obend: word;
              end;

 sysoptype=  record
              asciitop10: string[128];
              ansitop10: string[128];
              maxtime: word;
             end;

 generaltype=record
              startstr: word;            { New Player Starting values }
              startdex: word;
              startagl: word;
              starthp: word;
              startmoney: word;
              startdev1: string[25];
              startdev2: string[25];
              startdev3: string[25];

              basecost: longint;         { Cost of fortress           }
              lev2exp: longint;          { level 2 experience         }
              expmul: byte;              { Experience multiplier      }
              levlim: byte;              { Level repeate              }
              levpts: byte;

              basestartweap: string[25];
              basestartdef: string[25];
              basestartreact: string[25];
              basestartmoat: string[25];
              basestarttele: string[25];
              basestartene: longint;
              basemaxitems: word;
              playermaxbases: word;

              janitorpay: longint;
              killobj: boolean;

              statmodeavail: boolean;
              alphamodeavail: boolean;
              reflexmodeavail: boolean;

              reflexdelay: word;
              reflexhit: word;
              reflexincr: word;
              alphadelay: word;
              alphahit: word;

              LRAnsiLx: byte;
              LRAnsiLy: byte;
              LRAnsiGx: byte;
              LRAnsiGy: byte;
              LRAnsiTx: byte;
              LRAnsiTy: byte;
              LRAnsiBf: byte;
              LRAnsiBb: byte;
              LRAnsiCx: byte;
              LRAnsiCy: byte;
              LRAnsiCf: byte;
              LRAnsiCb: byte;

              minloanday: byte;

              FSAnsiFx: byte;
              FSAnsiFy: byte;
              FSAnsiFf: byte;
              FSAnsiFb: byte;
              FSAnsiTx: byte;
              FSAnsiTy: byte;
              FSAnsiTf: byte;
              FSAnsiTb: byte;

              loanint: byte;
              bankint: byte;
              gameint: byte;
              loanmax: byte;

              PTAnsiPx: byte;
              PTAnsiPy: byte;
              PTAnsiPf: byte;
              PTAnsiPb: byte;
              PTAnsiNxo: byte;
              PTAnsiNyo: byte;
              PTAnsiNf: byte;
              PTAnsiNb: byte;

              purmoney: array[1..numpurparts] of longint;
              purexp: array[1..numpurparts] of longint;

              daystodel: word;
              daystodeldead: word;

              inbankmax: longint;
              incasmax: longint;
              inloanmax: longint;

              monsellmult: real;

              vbattammoeff: array[1..ammomax] of byte;
              vbattammonames: array[1..ammomax] of string[20];
              numvbattammo: word;

              PTAnsinx: byte;
              PTAnsiny: byte;
              PTAnsiRx: byte;
              PTAnsiRy: byte;
              PTAnsiRf: byte;
              PTAnsiRb: byte;
              PTAnsiAx: byte;
              PTAnsiAy: byte;
              PTAnsiAf: byte;
              PTAnsiAb: byte;

              purquest: array[1..numpurparts] of word;

              taxlevel: byte;
              taxpercent: byte;

              maxfortattack: byte;

              trivia_cost,
              trivia_pay,
              caslimit: longint;

              porig: array[1..maxpmask] of byte;
              pnew: array[1..maxpmask] of byte;

              LRAnsiC2x: byte;
              LRAnsic2y: byte;

              maxtransport: byte;
             end;

 devdeftype=record
             num: byte;               { device number               }
             var1,var2: longint;      { start up variables          }
             x,y,z: byte;             { object x,y,z position       }
             devapp: devapptype;      { application type            }
             useleft: word;
             maxuse: word;
             decuse: boolean;
             name: string[18];        { device name                 }
             store: set of storetype; { store it sells at           }
             cost: comp;              { how much it costs           }
             usable: boolean;         { can it be used?             }
             pic: string[8];          { ansi picture identifier     }
             picnum: byte;
            end;

 devdeftptr=^devdeftype;
 devdefarray= array[0..numdev] of devdeftptr;

 devicetype=record
             num: byte;               { Device Numbers              }
             var1,var2: longint;      { generic variables           }
             x,y,z: byte;             { object x,y,z position       }
             devapp: devapptype;      { application type            }
             useleft: word;           { maximum uses and uses left  }
            end;

 sextype =  (male,female,other);

 devarray=  array[1..numudev] of devicetype;
 usertype=  record
             realname: string[35];    { real name of user           }
             alias: string[25];       { user's alias                }
             devices: devarray;
             weapon1: devicetype;     { Close combat weapon         }
             weapon2: devicetype;     { Ranged combat weapon        }
             auxweapon: devicetype;   { Auxilary close weapon       }
             armor: devicetype;       { armor                       }
             medline: devicetype;     { Automated medical lining    }
             bad: devicetype;         { B.A.D. - Brainwave Amp      }
             hitpts,hitmax: word;     { user's hitpoints and hitmax }
             badpts,badmax: word;     { Brainwave amp device        }
             str,dex,agl: word;       { strength, dexterity, agil   }
             lvl: word;               { level                       }
             exp: comp;               { experience                  }
             money: comp;             { money                       }
             bank: comp;              { money in the bank           }
             alive: boolean;          { alive ?                     }
             x,y,z: byte;             { x,y,z coords                }
             hunger: word;            { hunger points               }
             expert: boolean;         { expert on?                  }
             combat: longint;         { battles faught in           }
             flee: longint;           { battles fleed in            }
             surrender: longint;      { battles surrendered in      }
             kills: longint;          { number of monsters killed   }
             hits: longint;           { times he hit somebody       }
             misses: longint;         { times he missed somebody    }
             lastread: word;          { message base lastread ptr   }
             enhansi: boolean;        { used enhanced ansi if avail }
             clrmap: boolean;         { color map?                  }
             forceansi: boolean;      { force ansi on?              }
             compass: boolean;
             dietoff: boolean;
             products: array[1..numprod] of comp;
             buysteak: boolean;
             getdisk: boolean;
             didtetris: boolean;
             rent: longint;
             rentday: word;
             lastcity: byte;          { last city user was at       }
             combattext: byte;        { Entry in monsters.txt w/ combat txt }
             timetoday: word;
             sex: sextype;
             flags: byte;
             quests: longint;
             janitor: longint;
             casacct: longint;
             maintrun: word;
             loan: longint;
             maintdelcount: word;
             team: byte;
             fortattack: byte;
             combatmode: byte;
            end;

 clonetype=record
            realname: string[35];
            alias: string[25];
            hitmax: word;
            str,dex,agl: word;
            lvl: word;
            exp: comp;
            alive: boolean;
            blah: array[1..10] of byte;
           end;

 useridxtype= record
               x,y,z: byte;
               alive: boolean;
              end;

 useridxarray= array[1..255] of useridxtype;


 dstrarray= array[1..numst] of word;
 combattype=record
             player: usertype;        { player who is in combat     }
             typ: byte;
             talkto: word;
             dudepic: word;
             desc: dstrarray;         { description of player       }
             fleetxt: dstrarray;      { what to say when player runs}
             fleeran: dstrarray;      { random flee text            }
             killhim: dstrarray;      { when player kills monster   }
             disintequip: array[1..numueqp] of byte;
             disintinv: array[1..numudev] of byte;
             disintper: word;
             berserk: boolean;
             isreal: word;
             except0: boolean;
            end;
 combatptr= ^combattype;

 includetype=record
              code: string[2];
              guy1,guy2: byte;
             end;
 cstrtype=record
           numinclude: word;
           include: array[1..maxinclude] of includetype;
           numstr: word;
           strings: dstrarray;
          end;
 cstrptr=^cstrtype;
 cstrarray=array[1..numca] of cstrptr;

 monsterrec= record
              mindist: word;
              maxdist: word;
              origx: byte;
              origy: byte;
              origz: byte;
              line: word;
              str,dex,agl: byte;
              ifalive: byte;
              flags: byte;
             end;

 objptr= ^devicetype;
 objarray= array[1..numobj] of objptr;
 terraintype= record
               dng: word;
               typ: string[12];
               map: string[2];
               clr: byte;
               pas: tpass;
              end;
 terrainarray= array[0..numterrain] of terraintype;

 baserec = record
            x,y,z: byte;
            owner: byte;
            name: string[20];
            password: string[8];
            active: boolean;
            products: array[1..numprod] of longint; { Products on hand      }
            prodfs:   array[1..numprod] of longint; { Products for sale     }
            prodsp:   array[1..numprod] of word;    { Prod sell prices      }
            prodbp:   array[1..numprod] of word;    { Prod buy prices       }
            prodbm:   array[1..numprod] of longint; { Prod buy money        }
            med:      longint;                      { Medkit doses on hand  }
            medfs:    longint;                      { Medkit doses for sale }
            medprice: word;                         { Price of medkit dose  }
            energyfs: longint;                      { Energy for sale       }
            energyprice: word;                      { Energy price          }
            energy:  comp;                          { Energy on hand        }
            money:   comp;                          { money on hand         }
            teleprice: longint;                     { teleportation price   }
            moat:    devicetype;                    { Moat installed        }
            defense: devicetype;                    { Defense Field         }
            comm:    devicetype;                    { Comm station          }
            weapon:  devicetype;                    { Weapon                }
            reactor: devicetype;                    { Reactor               }
            Tele:    devicetype;                    { Teleporter            }
            basereg: boolean;
            forsale: array[1..numbforsale] of devicetype;    { Devices for sale      }
            saleprice: array[1..numbforsale] of longint;     { For sale prices       }
           end;

 basearray= array[1..numbase] of baserec;
 baseptr = ^basearray;
 routept=record
          x,y: byte;
         end;
 routetype = array[1..128] of routept;
 questtype= record
             award: longint;
             mask: longint;
             pts: byte;
            end;
 questarray = array[1..numquest] of questtype;

 taverntype= record
              personname: string[20];
              personnum: word;
              townnum: word;
             end;

 tavernptr = ^taverntype;

 tavernarray=array[1..maxtav] of tavernptr;

 telecodetype=record
               c: array[1..4] of byte;
               d: byte;
               z,x,y: byte;
              end;
 telearray=array[1..numtcode] of telecodetype;

 daystattype=record
              donations: comp;
              tax: comp;
              plays: word;
              timeused: word;
              datestamp: longint;
              blah: array[1..256] of byte;
             end;

 teamtype=   record
              players: array[1..maxteamplayers] of byte;
              numplayers: byte;
              name: string[30];
              pword: string[8];
             end;

 teamarray=  array[1..maxteams] of teamtype;
const
 prodbuy: array[1..numprod] of word = (10,10,10);
 citypricemul: array[1..10] of real = (1,1.25,2.13,3.75,4.22,4.75,5.11,5.30,5.75,6.91);

 quests: questarray= ((award: 5000;    {1 Get troy his steaks}
                       mask: 1;
                       pts: 1),
                      (award: 3000;    {2 Find location of BW}
                       mask: 2;
                       pts: 1),
                      (award: 15000;   {3 Get into Death Warrior city}
                       mask: 4;
                       pts: 1),
                      (award: 4000;    {4 Play tetris game}
                       mask: 8;
                       pts: 1),
                      (award: 5000;    {5 Find TADSU}
                       mask: 16;
                       pts: 1),
                      (award: 45000;   {6 Fight Xeboc}
                       mask: 32;
                       pts: 1),
                      (award: 30000;   {7 Fight Kirk}
                       mask: 64;
                       pts: 1),
                      (award: 50000;   {8 Talk to Cabal Warrior}
                       mask: 128;
                       pts: 1),
                      (award: 25000;   {9 Talk to spider droid}
                       mask: 256;
                       pts: 1),
                      (award: 5000;    {10 Macroswift windows}
                       mask: 512;
                       pts: 1),
                      (award: 5000;    {11 History}
                       mask: 1024;
                       pts: 1),
                      (award: 15000;   {12 Kill, Inc}
                       mask: 2048;
                       pts: 1),
                      (award: 2000;    {13 Freedom City}
                       mask: 4096;
                       pts: 1));
type
 laptoprec=record
            mask: longint;
            cmdname: string[8];
            cmdext: string[3];
            size: longint;
            date: string[8];
            time: string[6];
           end;
const
 sot=#1;
 ack=#6;
 nak=#21;
 numlapcmd=24;
 LapCmd: array[1..numlapcmd] of  laptoprec =
  ((mask:     0; cmdname: 'DIR';      cmdext: 'COM'; size:   13142; date: '04-27-12'; time: '10:04p'),
   (mask:     0; cmdname: 'EXIT';     cmdext: 'COM'; size:    2714; date: '04-27-12'; time: '10:04p'),
   (mask:     0; cmdname: 'CHKDSK';   cmdext: 'COM'; size:    9535; date: '04-27-12'; time: '10:04p'),
   (mask:     0; cmdname: 'COPY';     cmdext: 'COM'; size:   31244; date: '04-27-12'; time: '10:04p'),
   (mask:     1; cmdname: 'NOTES';    cmdext: 'EXE'; size:   41797; date: '08-12-13'; time: ' 3:39a'),
   (mask:     2; cmdname: 'AUTONAV';  cmdext: 'EXE'; size:  237421; date: '07-26-14'; time: ' 8:17a'),
   (mask:     4; cmdname: 'TRANSFER'; cmdext: 'EXE'; size:   77842; date: '11-09-13'; time: ' 2:32p'),
   (mask:     8; cmdname: 'RANKINGS'; cmdext: 'EXE'; size:   23292; date: '02-17-13'; time: ' 7:24a'),
   (mask:    16; cmdname: 'VIEWLOG';  cmdext: 'COM'; size:   10654; date: '09-30-13'; time: '11:24p'),
   (mask:    32; cmdname: 'EMWARP';   cmdext: 'EXE'; size:  139772; date: '03-11-14'; time: ' 2:49a'),
   (mask:    64; cmdname: 'FORTLIST'; cmdext: 'EXE'; size:   34229; date: '08-14-14'; time: ' 6:52p'),
   (mask:   128; cmdname: 'DIET';     cmdext: 'EXE'; size:  124772; date: '12-03-13'; time: '11:24a'),
   (mask:   256; cmdname: 'CSTATS';   cmdext: 'COM'; size:   27429; date: '07-22-13'; time: ' 3:33a'),
   (mask:   512; cmdname: 'LRSCAN';   cmdext: 'EXE'; size:  118245; date: '09-27-13'; time: ' 1:24p'),
   (mask:  1024; cmdname: 'SCANNER';  cmdext: 'EXE'; size:   96014; date: '04-26-14'; time: ' 7:30a'),
   (mask:  2048; cmdname: 'TROYINFO'; cmdext: 'EXE'; size:  107323; date: '07-19-14'; time: '10:29p'),
   (mask:  4096; cmdname: 'COMMLINK'; cmdext: 'COM'; size:   27094; date: '01-21-14'; time: ' 2:36p'),
   (mask:  8192; cmdname: 'TETRIS';   cmdext: 'EXE'; size:   63294; date: '03-18-13'; time: ' 7:14a'),
   (mask: 16384; cmdname: 'APPRAISE'; cmdext: 'EXE'; size:   72036; date: '04-13-14'; time: ' 9:15p'),
   (mask: 32768; cmdname: 'TCODE';    cmdext: 'EXE'; size:  102997; date: '04-26-14'; time: ' 6:39a'),
   (mask: 65536; cmdname: 'HISTORY';  cmdext: 'COM'; size:   56024; date: '04-23-14'; time: ' 7:04p'),
   (mask:131072; cmdname: 'WINDOWS';  cmdext: 'EXE'; size:69045234; date: '10-02-13'; time: ' 2:29p'),
   (mask:262144; cmdname: 'FORTINV';  cmdext: 'EXE'; size:   10324; date: '05-23-14'; time: ' 6:19a'),
   (mask:524288; cmdname: 'BARTALK';  cmdext: 'COM'; size:   25329; date: '01-19-14'; time: ' 2:22p')
   );
const
 roadtrans: array[0..13] of byte = (51,52,53,54,55,56,57,58,59,60,61,61,51,51);
 rivertrans: array[0..13] of byte = (62,63,64,65,66,67,68,69,70,71,72,72,62,62);
 laketrans: array[0..21] of byte = (73,84,85,86,87,88,89,90,91,74,75,76,77,78,79,80,81,82,83,83,73,73);
 flaglrscan=1;
 flagroaddata=2;
 flagbigdata=4;

 flaguserdull=1;         {not using the fancy character sheet}
 flagusersc=2;           {store colors disabled}
 flagusernodel=4;        {set if user is on No-Deletion status}
 flagusernodonate=8;     {set if user is on No-Donations status}
 flagusernorank=16;      {set if user should not be ranked}
 flaguserquick=32;       {set if user is using QUICK gterm}

 flagmonisreal=1;        {set if monster uses ISREAL}

 flagminesmart=1;        {set if smart mine}
 flagmineenergy=2;       {set if mine is energy drainer}
 flagmineteleport=4;     {set if mine is a teleporter mine}
type
 gmaptype=array[1..9,1..9] of byte;
 datype= array[1..21] of byte;
 miscdatatype= record
                datavalid: boolean;
                datainvalid: boolean;
                lodversion: string[5];
                username: string[35];
                useralias: string[35];
                sysopname: string[35];
                bbsname: string[35];
                regname: string[35];
                reg: boolean;
                hitmax: word;
                str,dex,agl: word;
                level: byte;
                ureg: boolean;
               end;

 gamedatatype= record
                map: gmaptype;
                z,x,y: byte;
                dist: byte;
                danger: byte;
                hitpts: word;
                exper: longint;
                money: longint;
                hunger: byte;
                devpic: datype;
                devusehi: datype;
                devuselo: datype;
                flags: byte;
                sfgmode: byte;
                bigpic: byte;
                timeleft: byte;
                mapflag: gmaptype;
                tername: string[12];
                blah2: array[1..32] of byte;
               end;

 nomapdatatype= record
                hitpts: word;
                exper: longint;
                money: longint;
                hunger: byte;
                devpic: datype;
                devusehi: datype;
                devuselo: datype;
                flags: byte;
                sfgmode: byte;
                bigpic: byte;
                timeleft: byte;
                blah: array[1..10] of byte;
               end;

 combatdatatype= record
                  monsterpic: byte;
                  playerpic: byte;
                  monsterhit: word;
                  playerhit: word;
                  monsterhp: word;
                  playerhp: word;
                  devpic: datype;
                  devusehi: datype;
                  devuselo: datype;
                  blah: array[1..10] of byte;
                 end;

 combatdatabigtype= record
                  monsterpic: byte;
                  playerpic: byte;
                  monsterhit: word;
                  playerhit: word;
                  monsterhp: word;
                  playerhp: word;
                  monsterhpmax: word;
                  playerhpmax: word;
                  hitf8: boolean;
                  unhitf8: boolean;
                 end;
 ansidatatype= record
                chk: word;
                name: string[8];
               end;
 rankrec=record
          name: string[14];
          flags: byte;
          percents: array[1..8] of byte;
          blah: array[1..10] of byte;
         end;
 rankdatatype=record
               numrank: byte;
               theuser: rankrec;
               theavg: rankrec;
               rankings: array[1..12] of rankrec;
              end;
 tbufftype=array[1..1024] of byte;
const
 oldgamedatasize=sizeof(gamedatatype)-32-sizeof(gmaptype);
 candobiggamedata: boolean = true;
type
 matrixtype=array[1..3,1..3] of byte;
const
 mapsize=sizeof(maptype);
 authfile3: string[5] = 'I.LOD';
 trivmax=200;
 numpk=20;
{ matrixtest: array[1..13] of matrixtype = (
              ((0,1,0),(1,1,1),(0,1,0)),
              ((2,0,2),(1,1,1),(0,1,0)),
              ((0,1,2),(1,1,0),(0,1,2)),
              ((0,1,0),(1,1,1),(2,0,2)),
              ((2,1,0),(0,1,1),(2,1,0)),
              ((0,0,2),(0,1,1),(2,1,0)),
              ((2,0,0),(1,1,0),(0,1,2)),
              ((2,1,0),(0,1,1),(0,0,2)),
              ((0,1,2),(1,1,0),(2,0,0)),
              ((2,0,2),(1,1,2),(2,0,2)),
              ((2,0,2),(2,1,1),(2,0,2)),
              ((2,2,2),(0,1,0),(2,1,2)),
              ((2,1,2),(0,1,0),(2,2,2))
               );}

 matrixtest: array[1..13] of matrixtype = (
              ((2,1,2),
               (1,1,1),
               (2,1,2)),

              ((2,0,2),
               (1,1,1),
               (2,1,2)),

              ((2,1,2),
               (1,1,0),
               (2,1,2)),

              ((2,1,2),
               (1,1,1),
               (2,0,2)),

              ((2,1,2),
               (0,1,1),
               (2,1,2)),

              ((2,0,2),
               (0,1,1),
               (2,1,2)),

              ((2,0,2),
               (1,1,0),
               (2,1,2)),

              ((2,1,2),
               (0,1,1),
               (2,0,2)),

              ((2,1,2),
               (1,1,0),
               (2,0,2)),

              ((2,0,2),
               (1,1,2),
               (2,0,2)),

              ((2,0,2),
               (2,1,1),
               (2,0,2)),

              ((2,2,2),
               (0,1,0),
               (2,1,2)),

              ((2,1,2),
               (0,1,0),
               (2,2,2))

               );

 matrixtest2: array[1..21] of matrixtype = (
              ((1,1,1),
               (1,1,1),
               (1,1,0)),

              ((1,1,1),
               (1,1,1),
               (0,1,1)),

              ((1,1,0),
               (1,1,1),
               (1,1,1)),

              ((0,1,1),
               (1,1,1),
               (1,1,1)),

              ((1,1,1),
               (1,1,1),
               (0,1,0)),

              ((0,1,1),
               (1,1,1),
               (0,1,1)),

              ((0,1,0),
               (1,1,1),
               (1,1,1)),

              ((1,1,0),
               (1,1,1),
               (1,1,0)),

              ((2,1,2),
               (1,1,1),
               (2,1,2)),

              ((2,0,2),
               (1,1,1),
               (2,1,2)),

              ((2,1,2),
               (1,1,0),
               (2,1,2)),

              ((2,1,2),
               (1,1,1),
               (2,0,2)),

              ((2,1,2),
               (0,1,1),
               (2,1,2)),

              ((2,0,2),
               (0,1,1),
               (2,1,2)),

              ((2,0,2),
               (1,1,0),
               (2,1,2)),

              ((2,1,2),
               (0,1,1),
               (2,0,2)),

              ((2,1,2),
               (1,1,0),
               (2,0,2)),

              ((2,0,2),
               (1,1,2),
               (2,0,2)),

              ((2,0,2),
               (2,1,1),
               (2,0,2)),

              ((2,2,2),
               (0,1,0),
               (2,1,2)),

              ((2,1,2),
               (0,1,0),
               (2,2,2))

               );

 authfile2: string[5] = 'ENT';
var
 nomap: nomapdatatype;
 combatdata: combatdatatype;
 combatdatabig: combatdatabigtype;
 lastgamedata,gamedata: gamedatatype;
 lastmiscdata,miscdata: miscdatatype;
 rankdata: rankdatatype;
 tbuffp: EAPointer;
type
 idrec=record
        poslo: word;
        poshi: byte;
       end;
 idarray=array[0..1] of idrec;
 idarrayptr = ^idarray;
var
 {GAME DEF STUFF}
 gamedef: text;
 gamebin: file;
 talkstart: word;
 trellstart, trellend: word;
 troystart, troyend: word;
 histstart, histend: word;
 dataset: datasettype;
 {OTHER STUFF}
 gterm_lastlr: gmaptype;
 gterm_lastlrz,gterm_lastlrx,gterm_lastlry: byte;
 gterm_needlrupdate: boolean;
 gterm_lrpresent: boolean;
 gterm_invscroll: word;
 gterm_comport: word;
 gterm_baud_rate: word;
 gterm_lodusername: string[40];
 gterm_local: boolean;
 sysopdata: sysoptype;
 telecodes: telearray;
 autonavx,autonavy,autonavz: byte;
 general: generaltype;
 terrain: terrainarray;
 devicedef: devdefarray;
 nummondef: word;
 mondef: array[1..maxmon] of EAPointer;
 filesopen: boolean;
 exitsave: pointer;
 usernum: byte;
 user: usertype;
 userfile: file of usertype;
 useridx: useridxarray;
 imap: array[1..numdev] of byte;
 numitems: byte;
 zmap: mapptr;
 clonefile: file of clonetype;
 objects: objarray;
 numolist: word;
 pchar,mchar,dchar: combatptr;
 needredraw: boolean;
 realansi: boolean;
 bases: baseptr;
 medcount: word;
 gtermon: boolean;
 lastmove: boolean;
 strdefbytes: word;
 dietcount: word;
 numgroups: word;
 groups: cstrarray;
 tavern: tavernarray;
 numtav: word;
 tryems: boolean;
 numstrdef: word;
 checkmulti: boolean;
 lokexitsave: pointer;
 automaint: boolean;
 usemod: boolean;
 moddev: integer;
 modqual: byte;
 forceremoteaudio: boolean;
 memstart: longint;
 purmask: array[0..numterrain] of byte;
 havepurmask: boolean;
 enhon: boolean;

 pkup: array[1..numpk] of word;
 pksend: array[1..numpk] of word;
 pkbyte: array[1..numpk] of longint;

 puritron: puritrontype;
 CasinoStats: EAPointer;
 DayStats: EAPointer;
 teams: EAPointer;

 timeusedstart: word;

 trivquest: array[1..trivmax] of byte;

 devfill,devgood,devnil: word;

 strdefid: pointer;
 didpause: boolean;

implementation

end.
