unit misco4;
{$O+,F+,V-,I+}

interface
uses dos, crt,

 {$IFDEF EGA}
 gtvideo,
 {$ENDIF}

 ddlod, gtscott, globals, misc, emsalloc, strio, setgen;

procedure ReadObjs;
procedure WriteObjs;
procedure OpenFiles;
procedure WriteBases;
procedure WritePuritron;
procedure WriteCasinoStats;
procedure WriteDayStats;
procedure WriteTeams;

implementation

procedure bwrite(s: string);
begin;
 swrite(#13+'  ');
 while length(s)<70 do s:=s+' ';
 swrite(s);
end;

procedure Error(s: string);
begin;
 {$IFDEF EGA}
  gtextcolor(15);
  gwriteln('');
  gwriteln(s);
 {$ELSE}
  textcolor(15);
  writeln;
  writeln(s);
 {$ENDIF}
 delay(5000);
 halt;
end;

procedure ReadObjs;
const
 numtoread=50;
type
 devarray=array[1..numtoread] of devicetype;
 daptr=^devarray;
var
 o: daptr;
 a: integer;
 objfile: file;
 numread: word;
begin;
 assign(objfile,'OBJECTS.DAT');
 reset(objfile,1);
 if filesize(objfile) mod sizeof(devicetype) <>0 then
  error('Error - OBJECTS.DAT is corrupted!');

 close(objfile);
 reset(objfile,sizeof(devicetype));

 new(o);
 blockread(objfile,o^,1);
 numolist:=0;
 numread:=numtoread;
 while (numread=numtoread) do begin;
  blockread(objfile,o^,numtoread,numread);
  for a:=1 to numread do if (o^[a].num<>0) and (numolist<numobj) then begin;
   inc(numolist);
   new(objects[numolist]);
   objects[numolist]^:=o^[a];
  end;
 end;
 close(objfile);
 dispose(o);
end;

procedure WriteObjs;
var
 o: devicetype;
 a,b: integer;
 objfile: file of devicetype;
begin;
 assign(objfile,'OBJECTS.DAT');
 rewrite(objfile);
 fillchar(o,sizeof(o),0);
 b:=0;
 write(objfile,o);
 for a:=1 to numolist do if objects[a]<>nil then begin;
  inc(b);
  write(objfile,objects[a]^);
 end;
 close(objfile);
end;

procedure blankbases;
var
 a: integer;
begin;
 fillchar(bases^,sizeof(bases^),0);
 for a:=1 to numbase do bases^[a].active:=false;
end;

procedure LoadStringDef;
type
 buftype=array[1..4096] of byte;
 bufptr=^buftype;
 indextype=array[0..4096] of word;
 indexptr=^indextype;
var
 buffer: bufptr;
 stn: word;
 index: indexptr;
 numindex: word;
 a: integer;
 b: longint;
 idxsize,bufsize,fsize: longint;
 strdefidp: idarrayptr;

 m: longint;
 ch1,ch2: char;
 s: string;
 posit,strdsize,stroffset: longint;
 bread: integer;

 f2: file;
 f3: text;
begin;
 bwrite('Loading String Definitions');
 seek(gamebin,0);
 blockread(gamebin,s,8);
 s[0]:=#7;
 val(s,stroffset,a);
 seek(gamebin,50);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,strdsize,a);
 seek(gamebin,stroffset);
 blockread(gamebin,ch1,1);
 blockread(gamebin,ch2,1);

 blockread(gamebin,numindex,2);
 fsize:=filesize(gamebin);
 idxsize:=(numindex+1)*2;
 getmem(index,idxsize);
 blockread(gamebin,index^,idxsize);

{ eaalloc(strdefid,(numindex+1)*sizeof(idrec));
 strdefidp:=eaaddr(strdefid);
 ealockvar(strdefid);}
 getmem(strdefid,(numindex+1)*sizeof(idrec)); strdefidp:=strdefid;

 b:=idxsize+4+stroffset;
 for a:=0 to numindex do begin;
  if index^[a]=0 then begin;
   strdefidp^[a].poshi:=0;
   strdefidp^[a].poslo:=0;
  end else if (index^[a] and 32768)<>0 then begin;
   stn:=index^[a] and 32767;
   strdefidp^[a].poshi:=strdefidp^[stn].poshi;
   strdefidp^[a].poslo:=strdefidp^[stn].poslo;
  end else begin;
   strdefidp^[a].poshi:=(b div 65536);
   strdefidp^[a].poslo:=(b and 65535);
   b:=b+index^[a];
  end;
 end;

{ eaunlockvar(strdefid);}

 freemem(index,idxsize);

{ bwrite('Extracting stringdef information');
 new(buffer);
 assign(f2,'TEMPSTR$.$$$');
 rewrite(f2,1);
 seek(f,longint(idxsize)+4+stroffset);
 bread:=sizeof(buffer^);
 posit:=longint(idxsize)+4+stroffset;
 while (bread=sizeof(buffer^)) and (posit<=strdsize+stroffset+1024) do begin;
  blockread(f,buffer^,sizeof(buffer^),bread);
  blockwrite(f2,buffer^,bread);
  posit:=posit+bread;
 end;
 close(f2);
 dispose(buffer);}

 m:=memavail;
 openstringcache;
 m:=m-memavail;
 strdefbytes:=m+(numindex+1)*sizeof(idrec);
 numstrdef:=numindex;
end;

procedure AddTeleCode(d: word; x,y: word);
var
 a,b,c: integer;
 c1,c2,c3: integer;
 bad: boolean;
 count: word;
begin;
 c1:=(x mod 3)+1;
 c2:=(y mod 3)+1;
 c3:=((x+y) mod 3)+1;

 c:=0;
 for a:=1 to numtcode do if (telecodes[a].d=0) and (c=0) then c:=a;
 if c=0 then exit;

 count:=1;
 repeat;
  bad:=false;
  for a:=1 to numtcode do if (telecodes[a].c[1]=c1) and (telecodes[a].c[2]=c2) and (telecodes[a].c[3]=c3) then bad:=true;
  if bad then begin;
   inc(c3);
   if c3>3 then begin;
    c3:=1;
    inc(c2);
    if c2>3 then begin;
     c2:=1;
     inc(c1);
     if c1>1 then c1:=1;
    end;
   end;
  end;
  inc(count);
 until (not bad) or (count=100);

 if not bad then begin;
  telecodes[c].c[1]:=c1;
  telecodes[c].c[2]:=c2;
  telecodes[c].c[3]:=c3;
  telecodes[c].x:=x;
  telecodes[c].y:=y;
  telecodes[c].z:=1;
  telecodes[c].d:=d;
 end;
end;

procedure maketelecodes;
var
 z,x,y: word;
begin;
 fillchar(telecodes,sizeof(telecodes),0);
 for z:=1 to maxmapz do for x:=1 to maxmapx do for y:=1 to maxmapy do if getmap(z,x,y) in [9,10] then begin;
  AddTeleCode(1,x,y);
 end;
 AddTeleCode(2,3,4);
 AddTeleCode(3,5,6);
end;

procedure SqrIt(var n: word);
begin;
 n:=n*n;
end;

procedure loaddevdef;
var
 devs: devdeftype;
 a,b: word;
 numread: word;
 devofs,devsize: longint;
 s: string;
 junk: integer;
begin;
 seek(gamebin,22);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,devofs,junk);
 seek(gamebin,43);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,devsize,junk);
 if (devsize mod sizeof(devdeftype))<>0 then error('Error - Fubar in dev def');
 devgood:=0;
 devfill:=0;
 devnil:=0;
 b:=0;
 seek(gamebin,devofs);
 for a:=1 to devsize div sizeof(devdeftype) do begin;
  blockread(gamebin,devs,sizeof(devdeftype));
  if (b<=numdev) then begin;
   if (b<>0) and (stu(devs.name)='NIL') and (devs.store=[]) and (ord(devs.devapp)=0) then begin;
    inc(devnil);
    devicedef[b]:=devicedef[0];
   end else begin;
    getmem(devicedef[b],sizeof(devdeftype));
    devicedef[b]^:=devs;
    devicedef[b]^.num:=b;
    inc(devgood);
   end;
   inc(b);
  end;
 end;

 if b<numdev then for a:=b to numdev do begin;
  devicedef[a]:=devicedef[0];
  inc(devfill);
 end;
end;

procedure loaddevdefs;
begin;
 bwrite('Loading device definitions');
 devgood:=0;
 devfill:=0;
 devnil:=0;
 loaddevdef;
end;

procedure LoadGameDef;
var
 gddone: boolean;
 linepos: word;
 donemonster: boolean;
 donecombat: boolean;
 donetalk: boolean;
 donetroy: boolean;
 donetrell: boolean;
 donehist: boolean;
 donetavern: boolean;
 donemisc: boolean;
 s: string;
 ofm: word;

procedure loadmisc;
var
 s,s2,s3,s4: string;
 done: boolean;
 a,n: integer;
begin;
 bwrite('Loading data set information');
 fillchar(dataset,sizeof(dataset),0);
 done:=false;
 n:=0;
 while (not eof(gamedef)) and (not done) do begin;
  inc(linepos);
  readln(gamedef,s);
  if s='&&&END' then begin;
   done:=true;
  end else begin;
   inc(n);
   case n of
    1: dataset.name:=newstr(s);
    2: dataset.author:=newstr(s);
    3: dataset.menustem:=s;
    4: val(s,dataset.sdstart,a);
    5: val(s,dataset.sdend,a);
    6: dataset.prodname[1]:=newstr(s);
    7: dataset.prodname[2]:=newstr(s);
    8: dataset.prodname[3]:=newstr(s);
    9..18: dataset.cityname[n-8]:=newstr(s);
    19: dataset.hisstr:=newstr(s);
    20: dataset.herstr:=newstr(s);
    21: dataset.itsstr:=newstr(s);
    22: dataset.hestr:=newstr(s);
    23: dataset.shestr:=newstr(s);
    24: dataset.itstr:=newstr(s);
    25: dataset.mhimstr:=newstr(s);
    26: dataset.fhimstr:=newstr(s);
    27: dataset.ihimstr:=newstr(s);
    28: val(s,dataset.obstart,a);
    29: val(s,dataset.obend,a);
   end;
  end;
 end;
 donemisc:=true;
end;

procedure loadmonster;
var
 done: boolean;
 s: string;
 b: integer;
begin;
 bwrite('Indexing monsters');
 nummondef:=0;
 done:=false;
 while (not eof(gamedef)) and (nummondef<maxmon) and (not done) do begin;
  inc(linepos);
  readln(gamedef,s);
  if s='&&&END' then begin;
   done:=true;
  end else if pos('NAME',s)=1 then begin;
   inc(nummondef);
   EAAlloc(mondef[nummondef],sizeof(monsterrec));
   fillchar(EAAddr(mondef[nummondef])^,sizeof(monsterrec),0);
   MonsterRec(EAAddr(mondef[nummondef])^).line:=linepos;
   MonsterRec(EAAddr(mondef[nummondef])^).origx:=255;
   MonsterRec(EAAddr(mondef[nummondef])^).origy:=255;
   MonsterRec(EAAddr(mondef[nummondef])^).origz:=255;
   MonsterRec(EAAddr(mondef[nummondef])^).mindist:=0;
   MonsterRec(EAAddr(mondef[nummondef])^).maxdist:=100;
  end else if (pos('MINDIST',s)=1) and (nummondef>0) then begin;
   delete(s,1,8);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).mindist,b);
   sqrit(MonsterRec(EAAddr(mondef[nummondef])^).mindist);
  end else if (pos('MAXDIST',s)=1) and (nummondef>0) then begin;
   delete(s,1,8);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).maxdist,b);
   sqrit(MonsterRec(EAAddr(mondef[nummondef])^).maxdist);
  end else if (pos('ORIGX',s)=1) and (nummondef>0) then begin;
   delete(s,1,6);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).origx,b);
  end else if (pos('ORIGY',s)=1) and (nummondef>0) then begin;
   delete(s,1,6);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).origy,b);
  end else if (pos('ORIGZ',s)=1) and (nummondef>0) then begin;
   delete(s,1,6);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).origz,b);
  end else if (pos('STR',s)=1) and (nummondef>0) then begin;
   delete(s,1,4);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).str,b);
  end else if (pos('DEX',s)=1) and (nummondef>0) then begin;
   delete(s,1,4);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).dex,b);
  end else if (pos('AGL',s)=1) and (nummondef>0) then begin;
   delete(s,1,4);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).agl,b);
  end else if (pos('IFALIVE',s)=1) and (nummondef>0) then begin;
   delete(s,1,8);
   val(s,MonsterRec(EAAddr(mondef[nummondef])^).ifalive,b);
  end else if (pos('ISREAL',s)=1) and (nummondef>0) then begin;
   MonsterRec(EAAddr(mondef[nummondef])^).flags:=MonsterRec(EAAddr(mondef[nummondef])^).flags or flagmonisreal;
  end;
 end;
 donemonster:=true;
end;

procedure loadtalk;
var
 a: word;
 done: boolean;
 s: string;
begin;
 bwrite('Processing dialog');
 talkstart:=linepos;
 done:=false;
 while (not eof(gamedef)) and (not done) do begin;
  inc(linepos);
  readln(gamedef,s);
  if s='&&&END' then begin;
   done:=true;
  end;
 end;
 donetalk:=true;
end;

procedure LoadCstr;
var
 f: text;
 s: string;
 s2,s3,s4: string[80];
 a,b: integer;
 done: boolean;
begin;
 bwrite('Loading combat string tables');
 done:=false;
 numgroups:=0;
 while (not eof(gamedef)) and (not done) do begin;
  inc(linepos);
  readln(gamedef,s);
  if s='&&&END' then begin;
   done:=true;
  end else if stu(s)='NEWGROUP' then begin;
   inc(numgroups);
   new(groups[numgroups]);
   fillchar(groups[numgroups]^,sizeof(groups[numgroups]^),0);
  end else if (pos('INCLUDE',stu(s))=1) and (numgroups>0) then begin;
   if groups[numgroups]^.numinclude<maxinclude then begin;
    delete(s,1,8);
    s2:='';
    s3:='';
    s4:='';
    inc(groups[numgroups]^.numinclude);
    while (s[1]<>' ') and (length(s)>0) do begin;
     s2:=s2+s[1];
     delete(s,1,1);
    end;
    while (s[1]=' ') and (length(s)>0) do delete(s,1,1);
    while (s[1]<>' ') and (length(s)>0) do begin;
     s3:=s3+s[1];
     delete(s,1,1);
    end;
    while (s[1]=' ') and (length(s)>0) do delete(s,1,1);
    while (s[1]<>' ') and (length(s)>0) do begin;
     s4:=s4+s[1];
     delete(s,1,1);
    end;
    while (s[1]=' ') and (length(s)>0) do delete(s,1,1);
    groups[numgroups]^.include[groups[numgroups]^.numinclude].code:=s2;
    val(s3,a,b);
    groups[numgroups]^.include[groups[numgroups]^.numinclude].guy1:=a;
    val(s4,a,b);
    groups[numgroups]^.include[groups[numgroups]^.numinclude].guy2:=a;
   end;
  end else if (numgroups>0) and (s<>'') and (s[1]<>';') then begin;
   inc(groups[numgroups]^.numstr);
   val(s,groups[numgroups]^.strings[groups[numgroups]^.numstr],a);
  end;
 end;
 donecombat:=true;
end;

procedure loadtroy;
var
 a: word;
 s: string;
begin;
 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 val(s,troystart,a);
 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 val(s,troyend,a);
 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 if s<>'&&&END' then exit;
 donetroy:=true;
end;

procedure loadtrell;
var
 a: word;
 s: string;
begin;

 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 val(s,trellstart,a);
 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 val(s,trellend,a);
 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 if s<>'&&&END' then exit;
 donetrell:=true;
end;

procedure loadhist;
var
 a: word;
 s: string;
begin;
 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 val(s,histstart,a);
 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 val(s,histend,a);
 if eof(gamedef) then exit;
 inc(linepos);
 readln(gamedef,s);
 if s<>'&&&END' then exit;
 donehist:=true;
end;

procedure loadtavern;
var
 a: word;
 done: boolean;
 s,s2: string;
 n1,n2: word;
begin;
 bwrite('Loading tavern data');
 numtav:=0;
 done:=false;
 while (not eof(gamedef)) and (not done) do begin;
  inc(linepos);
  readln(gamedef,s);
  if s='&&&END' then begin;
   done:=true;
  end else begin;
   while (s<>'') and (s[1]=' ') do delete(s,1,1);
   s2:='';
   while (s<>'') and (s[1]<>' ') do begin;
    s2:=s2+s[1];
    delete(s,1,1);
   end;
   val(s2,n1,a);
   while (s<>'') and (s[1]=' ') do delete(s,1,1);
   s2:='';
   while (s<>'') and (s[1]<>' ') do begin;
    s2:=s2+s[1];
    delete(s,1,1);
   end;
   val(s2,n2,a);
   while (s<>'') and (s[1]=' ') do delete(s,1,1);
   if (s<>'') and (n1<>0) and (n2<>0) and (numtav<maxtav) then begin;
    inc(numtav);
    new(tavern[numtav]);
    tavern[numtav]^.personnum:=n2;
    tavern[numtav]^.townnum:=n1;
    tavern[numtav]^.personname:=s;
   end;
  end;
 end;
 donetavern:=true;
end;

begin;
 donemonster:=false;
 donecombat:=false;
 donetalk:=false;
 donetrell:=false;
 donetroy:=false;
 donehist:=false;
 donetavern:=false;
 donemisc:=false;
 linepos:=0;
 gddone:=false;
 while (not eof(gamedef)) and (not gddone) do begin;
  inc(linepos);
  readln(gamedef,s);
  while (s[1]=' ') and (s<>'') do delete(s,1,1);
  while s[length(s)]=' ' do dec(s[0]);
  if (s<>'') and (s[1]<>';') then begin;
   if s='&&&MONSTER' then loadmonster;
   if s='&&&TALK' then loadtalk;
   if s='&&&COMBAT' then loadcstr;
   if s='&&&TROYINFO' then loadtroy;
   if s='&&&TRELLNOT' then loadtrell;
   if s='&&&HISTORY' then loadhist;
   if s='&&&TAVERN' then loadtavern;
   if s='&&&MISC' then loadmisc;
   if s='&&&DONE' then gddone:=true;
  end;
 end;
 if not donemonster then error('Error - could not load monster info from GAME.DEF.');
 if not donecombat then  error('Error - could not load combat info from GAME.DEF.');
 if not donetalk then    error('Error - could not load talk info from GAME.DEF.');
 if not donetroy then    error('Error - could not load troyinfo info from GAME.DEF.');
 if not donetrell then   error('Error - could not load trellnot info from GAME.DEF.');
 if not donehist then    error('Error - could not load history info from GAME.DEF.');
 if not donetavern then  error('Error - could not load tavern info from GAME.DEF.');
 if not donemisc then    error('Error - could not load dataset info from GAME.DEF.');
end;

procedure opengamedef;
var
 ofm: word;
 buf: array[1..1024] of byte;
 bread: word;
 f2: file;
begin;
 bwrite('Reading Master Game Definition');
 assign(gamebin,'GAME.DEF');
 reset(gamebin,1);
 assign(gamedef,'GAME.DEF');
 {$I-}
 reset(gamedef);
 {$I+}
 if ioresult<>0 then begin;
  bwrite('Data access fault: Duplicating GAME.DEF');
  assign(f2,'GAME.DE2');
  rewrite(f2,1);
  bread:=1024;
  while (bread=1024) do begin;
   blockread(gamebin,buf,1024,bread);
   blockwrite(f2,buf,bread);
  end;
  close(f2);
  assign(gamedef,'GAME.DE2');
  reset(gamedef);
 end;
end;

procedure fixmonsters;
var
 cz,cx,cy: byte;
 a: integer;
begin;
 findcity(1,cz,cx,cy);
 for a:=1 to nummondef do if MonsterRec(EAAddr(mondef[a])^).origz=255 then begin;
  MonsterRec(EAAddr(mondef[a])^).origz:=cz;
  MonsterRec(EAAddr(mondef[a])^).origx:=cx;
  MonsterRec(EAAddr(mondef[a])^).origy:=cy;
 end;
end;

procedure loadmap(n: word);
var
 a: integer;
 s: string[10];
 mapofs: longint;
begin;
 seek(gamebin,8);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,mapofs,a);
 seek(gamebin,mapofs);
 blockread(gamebin,zmap^,sizeof(zmap^));
end;

procedure loadterrain;
var
 a: integer;
 s: string[10];
 mapofs: longint;
begin;
 bwrite('Loading terrain definitions');
 seek(gamebin,15);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,mapofs,a);
 seek(gamebin,mapofs);
 blockread(gamebin,terrain,sizeof(terrain));
end;

procedure loadgeneral;
var
 a: integer;
 s: string[10];
 fsize, mapofs: longint;
 bread: word;
begin;
 bwrite('Loading general data');

 seek(gamebin,29);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,mapofs,a);

 seek(gamebin,36);
 blockread(gamebin,s[1],7);
 s[0]:=#7;
 val(s,fsize,a);
 if fsize>sizeof(general) then fsize:=sizeof(general);

 seek(gamebin,mapofs);
 blockread(gamebin,general,fsize,bread);
end;

procedure OpenFiles;
var
 a,b: integer;
 u: usertype;
 o: devicetype;
 f: file;
 basfile: file of basearray;
 genfile: file of generaltype;
 objfile: file of devicetype;
 dayfile: file;
 teafile: file;
 pfile: file;
 s: string[80];
 cz,cx,cy: byte;
 uidx: file of useridxarray;
 clone: clonetype;
 cfile: file;
begin;
 setgeneral;
 opengamedef;
 loadgeneral;
 loadgamedef;
 loadterrain;
 loadmap(1);
 loaddevdefs;

 assign(userfile,'USERS.DAT');
 {$I-}
 reset(userfile);
 {$I+}
 if ioresult<>0 then begin;
  rewrite(userfile);
  blankuser(u);
  u.x:=0;
  u.y:=0;
  u.z:=0;
  for a:=0 to 255 do write(userfile,u);
  reset(userfile);
 end;

 bwrite('Reading Objects');
 if not exist('OBJECTS.DAT') then begin;
  assign(objfile,'OBJECTS.DAT');
  rewrite(objfile);
  fillchar(o,sizeof(o),0);
  write(objfile,o);
  close(objfile);
 end;
 readobjs;

 bwrite('Reading Fortresses');
 assign(basfile,'BASES.DAT');
 {$I-}
 reset(basfile);
 {$I+}
 if ioresult<>0 then begin;
  BlankBases;
  rewrite(basfile);
  write(basfile,bases^);
  close(basfile);
 end else begin;
  close(basfile);
  assign(f,'BASES.DAT');
  reset(f,1);
  if filesize(f)<>22875 then
   error('Error - BASES.DAT has been corrupted!');
  close(f);
  reset(basfile);
  read(basfile,bases^);
  close(basfile);
 end;

 assign(uidx,'USERIDX.DAT');
 {$I-}
 reset(uidx);
 {$I+}
 if ioresult<>0 then begin;
  fillchar(useridx,sizeof(useridx),0);
  rewrite(uidx);
  write(uidx,useridx);
  close(uidx);
 end else begin;
  read(uidx,useridx);
  close(uidx);
 end;

 bwrite('Opening Clone File');
 assign(clonefile,'CLONES.DAT');
 {$I-}
 reset(clonefile);
 {$I+}
 if ioresult<>0 then begin;
  fillchar(clone,sizeof(clone),0);
  clone.alive:=false;
  rewrite(clonefile);
  for a:=0 to 255 do write(clonefile,clone);
  reset(clonefile);
 end;

 bwrite('Opening Puritron File');
 assign(pfile,'PURITRON.DAT');
 {$I-}
 reset(pfile,1);
 {$I+}
 if ioresult<>0 then begin;
  fillchar(puritron,sizeof(puritron),0);
  for a:=1 to numpurparts do begin;
   puritron.parts[a].ishere:=false;
   puritron.parts[a].reset:=false;
  end;
  rewrite(pfile,1);
  blockwrite(pfile,puritron,sizeof(puritron));
  close(pfile);
 end else begin;
  if filesize(pfile)<>sizeof(puritron) then
   error('Error - Puritron.dat has been corrupted.');
  blockread(pfile,puritron,sizeof(puritron));
  close(pfile);
 end;

 bwrite('Opening Casino Stats File');
 assign(cfile,'CASSTATS.DAT');
 {$I-}
 reset(cfile,1);
 {$I+}
 if ioresult<>0 then begin;
  fillchar(EAAddr(casinostats)^,sizeof(casinotype),0);
  rewrite(cfile,1);
  EABlockwrite(cfile,casinostats,sizeof(casinotype));
  close(cfile);
 end else begin;
  if filesize(cfile)<>sizeof(casinotype) then
   error('Error - Casstats.dat has been corrupted.');
  EABlockread(cfile,casinostats,sizeof(casinotype));
  close(cfile);
 end;

 bwrite('Opening Day Stats File');
 fillchar(EAAddr(daystats)^,sizeof(daystattype),0);
 assign(dayfile,'DAYSTATS.DAT');
 {$i-}
 reset(dayfile,1);
 {$I+}
 if ioresult=0 then begin;
  if filesize(dayfile)<>sizeof(daystattype) then
   error('Error - Daystats.dat has been corrupted.');
  EABlockread(dayfile,daystats,sizeof(daystattype));
  close(dayfile);
 end;

 bwrite('Opening Team File');
 fillchar(EAAddr(teams)^,sizeof(teamarray),0);
 assign(teafile,'TEAMS.DAT');
 {$i-}
 reset(teafile,1);
 {$I+}
 if ioresult=0 then begin;
  if filesize(teafile)<>sizeof(teamarray) then
   error('Error - Teams.Dat has been corrupted.');
  EABlockRead(teafile,teams,sizeof(teamarray));
  close(teafile);
 end;

 fixmonsters;
 maketelecodes;
 loadstringdef;

 bwrite('Startup completed');
 swriteln('');
end;

procedure WriteTeams;
var
 teamfile: file;
begin;
 assign(teamfile,'TEAMS.DAT');
 rewrite(teamfile,1);
 EAblockwrite(teamfile,teams,sizeof(teamarray));
 close(teamfile);
end;

procedure WriteDayStats;
var
 dayfile: file;
begin;
 assign(dayfile,'DAYSTATS.DAT');
 rewrite(dayfile,1);
 EAblockwrite(dayfile,daystats,sizeof(daystattype));
 close(dayfile);
end;

procedure WriteCasinoStats;
var
 cfile: file;
begin;
 assign(cfile,'CASSTATS.DAT');
 rewrite(cfile,1);
 EaBlockwrite(cfile,casinostats,sizeof(casinotype));
 close(cfile);
end;

procedure WritePuritron;
var
 pfile: file;
begin;
 assign(pfile,'PURITRON.DAT');
 rewrite(pfile,1);
 blockwrite(pfile,puritron,sizeof(puritron));
 close(pfile);
end;

procedure WriteBases;
var
 basfile: file;
begin;
 assign(basfile,'BASES.DAT');
 reset(basfile,1);
 blockwrite(basfile,bases^,sizeof(bases^));
 close(basfile);
end;

end.