TITLE "Capture New Files/QWK Transfer With ZyXEL USA"
;-----------------------------------------------------------------
; ZYXELBBS.RS -- MAIL run and new files capture for ZyXEL USA BBS
;.................................................................
;
; Author:  Bret Hawkins
; Version: 1.0
; Revised: 7/19/93
;
; IMPORTANT!!  You must have your NAME and PASSWORD set under the
; entry for U1496 (The ZyXEL BBS) in the BBS Systems screen in
; Robocomm.  You must also have U1496 set to Login Script Only as
; the BBS type.  Leave me a note on GROUPONE if you have any
; questions.
;-----------------------------------------------------------------
PARAMETER 1 "QWK directory (including ending \)"
PARAMETER 2 "REP directory (including ending \)"
ENDPARAMS

    ; Verify that the 2 necessary parameters were entered.
    IF EMPTY "%P1%" GOTO PARAM_ERROR
    IF EMPTY "%P2%" GOTO PARAM_ERROR
    
    ; Default to ten minutes to scan for mail.
    ; Edit this if desired.
    TIMEOUT 600

    ; Logon to the ZyXEL USA BBS
    WAITFOR "Press <ESC> twice for"
    SEND ""
    WHEN "[Hit a key]" SEND " "
    WAITFOR "NN:" 
    SEND "%BBS13%|"
    WAITFOR "PW:"
    SEND "%BBS7%|"
    WHEN "new messages (Y/n)" SEND "N"
    WHEN "messages to you (Y/n)" SEND "N"
    WAITFOR " Main "

    ; Capture a list of new files to U1496.CAP
    ; This is set to overwrite the file list each time
    ; This can be changed
    SEND "F"
    WAITFOR "for new files (Y/n) ?"
    SEND "Y"
    MESSAGE "Capturing new files list to U1496.CAP"

    ; Change the next line to APPEND instead of OVERWRITE if desired
    CAPTURE "U1496.CAP" OVERWRITE
    WAITFOR "Synchronet"
    CLOSE
    WAITFOR " File "

    ; Go to the QWK door
    SEND "Q"
    WAITFOR " Main "
    SEND "Q"
    WAITFOR "QWK:"
    WHEN "No new messages." GOTO NOQWK
    MESSAGE "Downloading %P1%U1496.QWK"
    SEND "D"
    WAITFOR "[Strip]:"
    SEND "|"
    WAITFOR "Protocol or Quit:"
    SEND "Z"
    WAITFOR "Hang up after transfer (Y/n) ?"
    SEND "N"
    WAITFOR "Start transfer now"
    DOWNLOAD "%P1%U1496.QWK" USING "ZMODEM"
    GOTO SENDREP

:NOQWK
    MESSAGE "No mail to download"  
    GOTO SENDREP

:PARAM_ERROR
    MESSAGE "^UERROR:^U Parameters 1 and 2 are required!"
EXIT 1

:SENDREP
    IF NOT EXIST "%P2%U1496.REP" GOTO NOREP
    MESSAGE "Uploading %P2%U1496.REP"
    WAITFOR "QWK:"
    SEND "U"
    WAITFOR "Protocol or Quit:"
    SEND "Z"
    WAITFOR "Hang up after transfer (Y/n) ?"
    SEND "N"
    WAITFOR "Start transfer now"
    UPLOAD "%P2%U1496.REP" USING "ZMODEM"
    ERASE "%P2%U1496.REP"
GOTO ENDRUN

:NOREP
    MESSAGE "No %P2%U1496.REP to send"
GOTO ENDRUN

:ENDRUN
    WAITFOR "QWK:"
    SEND "Q"
    WAITFOR " Main "
    SEND "G"
    WHEN "(y/N)" SEND "Y"
    WAITFOR "Thank you for calling"
    HANGUP
EXIT 0

;eof
