program Dda_CHoice_clone;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/08/25.  First public release.  DDA
v1.00a : 1993/08/30.  Minor tuning of .PAS code.  DDA
v1.01  : 1993/09/07.  Changed program so that user -must- press one of the
                              valid keys.  Timeout will still default to
                              the first though.  DDA
                      The key pressed will now only be echoed if the
                              user is having DCH display a message also.  DDA

------------------------------------------------------------------------------}

uses dos, crt ;
const
     progdata = 'DCH- Free DOS utility: batch file query.';
     progdat2 = 'V1.01: September 07, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';
       usage  = 'Usage:  DCH timeout_spec keys [text]';
var
     timestr     : string [7];
     maxtime     : longint ;
     time        : word ;
     timeout,
     timeoutmode : boolean ;

     echoing     : boolean ;

     choices     : string ;

     selection   : char ;
     errorlevel  : byte ;

     valerr      : integer ;

procedure showhelp ( errornum : byte );
var
    message : string [80];
begin
    writeln(progdata);
    writeln(progdat2);
    writeln;
    writeln(usage);
    writeln;

    case errornum of
      201 : message := 'you must have at least two parameters on the command line.';
      202 : message := 'timeout value must be bracketed with a "[" and a "]".';
      203 : message := 'timeout value must be a number between 0 and 65535.';
      204 : message := 'if you SET DCHCLR, it must be a value between 0 and 255.';
    end;
    writeln ( 'ERROR: (#',errornum,') - ', message );
    halt ( errornum );
end;

procedure settextcolor ;
var colorstr : string [3] ;
    colorval,
    valerr   : integer ;
begin
    colorstr := getenv ('dchclr');
    if colorstr <> '' then begin
       val ( colorstr, colorval, valerr ) ;
       if valerr <> 0 then showhelp (204);
       if colorval > 255 then showhelp (204);
       if colorval < 0 then showhelp (204);
       textattr := colorval ;
    end;
end;

function gettext : string ;
var
   counter,
   spaceplace : byte ;
   cmdline : string ;
begin
   cmdline := string ( ptr ( prefixseg,$0080 )^ );
    { ^^ this line courtesy of Martin Richardson ^^ }

   for counter := 1 to 3 do begin
       spaceplace := ( pos ( ' ',cmdline ));
       cmdline := copy ( cmdline,
                       ( spaceplace + 1 ),
                       ( length (cmdline) - spaceplace ) );
   end;
   gettext := cmdline ;
end;

begin
     checkbreak := false ;
     if paramcount < 2 then showhelp (201);
     timeout := false ;
     timeoutmode := false ;
     timestr := paramstr (1);

     if (( timestr [1] <> '[' )
     or (( timestr [ length ( timestr ) ] )  <> ']' )) then showhelp (202);

     if length (timestr) <> 2 then begin
        timeoutmode := true ;
        time := 0 ;
        timestr := copy ( timestr, 2, ( length ( timestr ) - 2) );
        val ( timestr, maxtime, valerr ) ;
        if valerr <> 0 then showhelp (203);
        if  (maxtime < 0)
         or (maxtime > 65535)
          then showhelp (203);

        maxtime := 10 * maxtime ;
        timeout := ( maxtime = 0 );
     end;

     choices := paramstr (2) ;

     if paramcount > 2 then begin
        echoing := true ;
        settextcolor;
        write ( gettext );
     end ;

     if keypressed
        then timeout := false ;
             { so we can process a pending keystroke even }
             { if the timeout parameter of [0] was used   }

     repeat
         while (( not keypressed ) and ( not timeout )) do begin
             delay ( 95 );
                   { if delay was 100, no time would be allowed for the loop }
             if timeoutmode then begin
                time := time + 1 ;
                if time >= maxtime then
                   timeout := true ;
             end; { if timeoutmode }
         end; { while not keypressed ... }

         if not timeout then begin
            selection := readkey ;
            if echoing then begin
               write ( selection );
               gotoxy ( wherex - 1, wherey );
            end;
            if selection = #0 then readkey ;
         end;

     until (( timeout ) or (( pos ( selection, choices )) <> 0 )) ;

     if timeout then
        selection := choices [1];

     if echoing then begin
        normvideo ;
        writeln ;
     end;

     errorlevel := ( pos ( selection , choices ) );
     if errorlevel = 0 then errorlevel := 255 ;
     if selection = '' then errorlevel := 0 ;
     halt ( errorlevel );
end.
