PROGRAM SetFileTime;
USES Dos;
CONST
     ProgData = 'REDATE!- Free DOS utility: file redater.';
     ProgDat2 = 'V1.00: July 14, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

      Usage  = '   Usage: REDATE! <file> <mm/dd/yy> <hh:mm:ss>';
      Usage2 = 'or Usage: REDATE! <file>  {change to current date/ time}';
VAR
   DirInfo               : SearchRec;
   FileToAlter           : File;
   DateDotTime           : String[18];
   Date_Time             : DateTime;
   TimeToStamp           : LongInt;

PROCEDURE ShowHelp;
BEGIN
     WriteLn;
     WriteLn(Usage);
     WriteLn(Usage2);
     Halt;
END;

PROCEDURE ParseDateTime;
VAR
     ValERR                : Integer;
BEGIN
     WITH Date_Time DO
     BEGIN
          Val(Copy(DateDotTime,1,2),MONTH,ValERR);
          Val(Copy(DateDotTime,4,2),DAY,ValERR);
          Val(Copy(DateDotTime,7,2),YEAR,ValERR);
          YEAR := 1900 + YEAR;
          Val(Copy(DateDotTime,11,2),HOUR,ValERR);
          Val(Copy(DateDotTime,14,2),MIN,ValERR);
          Val(Copy(DateDotTime,17,2),SEC,ValERR);
          PackTime(Date_Time,TimeToStamp);
     END;
END;

PROCEDURE StampFile;
BEGIN
     Assign(FileToAlter,DirInfo.Name);
     Reset(FileToAlter);
     SetFTime(FileToAlter,TimeToStamp);
     Close(FileToAlter);
     Write('.');
END;

PROCEDURE NewDate;
BEGIN
     DateDotTime := ParamStr(2) + '..' + ParamStr(3);
     ParseDateTime;
     WHILE DosError = 0 DO BEGIN
           StampFile;
           FindNext(DirInfo);
     END;
END;

PROCEDURE TDate;
VAR
    y,mo,d,w,
    h,mi,s,u : Word;
BEGIN
     GetDate(y,mo,d,w);  GetTime(h,mi,s,u);
     WITH Date_Time DO
     BEGIN
          YEAR := y;  MONTH := mo;  DAY := d;
          HOUR := h;  MIN   := mi;  SEC := s;
     END;
     PackTime(Date_Time,TimeToStamp);
     WHILE DosError = 0 DO
     BEGIN
          StampFile;
          FindNext(DirInfo);
     END;
END;

BEGIN
     Writeln(ProgData);
     Writeln(ProgDat2);
     Writeln;
     FindFirst(ParamStr(1), Archive, DirInfo);
     IF (DosError <> 0) THEN
          ShowHelp;
     Write('Working ');

     CASE ParamCount OF
          1 : TDate;
          2 : IF (ParamStr(2) = '/t') THEN TDate ELSE ShowHelp;
          3 : NewDate;
     ELSE
          ShowHelp;
     END;
     Writeln(' done!');
END.
