PROGRAM EnumerateLinesInFile;
CONST
     ProgData = 'LINEN5- Free DOS utility: text file enumerator and un-enumerator.';
     ProgDat2 = 'V1.00: July 14, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

      Usage = 'Usage:  LINEN5 source_file new_destination_file [/r (remove numbers)]';
VAR
   PS1, PS2,
   Line_Current           : String;
   Source_File,Dest_File  : Text;
   Numb                   : Word;
   Remove                 : Boolean;

PROCEDURE InitVars;
BEGIN
     Writeln(ProgData);
     Writeln(ProgDat2);
     Writeln;
     Numb := 10000;
     If ParamCount < 2 THEN Begin
        Writeln(Usage);
        Halt;
     End;
     PS1 := ParamStr(1);
     PS2 := ParamStr(2);
     Remove := ((ParamStr(3) = '/r') OR (ParamStr(3) = '/R'));
END;

PROCEDURE OpenFiles;
BEGIN
     Assign(Source_File,PS1);
{$I-} Reset(Source_File); {$I+}                    { Check if file exists.}
     IF (IOResult <> 0) THEN                       { If it                }
     BEGIN                                         {    doesn't, then     }
         Writeln('Unable to open "', PS1, '".');   {  quit with message.  }
         Halt;
     END;

     Assign(Dest_File,PS2);
{$I-} Reset(Dest_File);  {$I+}
      IF (IOResult <> 0) Then Begin
         Rewrite(Dest_File);
      End
      Else Begin
Writeln('Destination "',PS2,'" exists!  Rename, delete, or specify alternate.');
         Halt;
      End;
END;

PROCEDURE PutNumb;
BEGIN
     Writeln('Un-numbered file: ',PS1,'; Numbered file: ',PS2,'.');

     REPEAT
          ReadLn(Source_File,Line_Current);
          Numb := Succ(Numb);
          WriteLn(Dest_File,Numb,' ',Line_Current);
     UNTIL Eof(Source_File);
END;

PROCEDURE RmvNumb;
VAR
    strlinen  : string[5];
    vallinen  : longint;
    valcode   : integer;
BEGIN
     Writeln('Numbered file: ',PS1,'; Un-numbered file: ',PS2,'.');

     REPEAT
          ReadLn(Source_File,Line_Current);
           strlinen := copy(Line_Current,1,5);
           val(strlinen,vallinen,valcode);
           if (valcode <> 0) then begin
              writeln('The first five chars on line one are NOT a valid numeric!');
              writeln('Program aborted.');
              close(Dest_File);
              erase(Dest_File);
              halt;
           end;
          Delete(Line_Current,1,6);
          WriteLn(Dest_File,Line_Current);
     UNTIL Eof(Source_File);
END;

BEGIN
     InitVars;
     OpenFiles;

     IF Remove THEN RmvNumb
     ELSE PutNumb;

     Close(Source_File);
     Close(Dest_File);
     Writeln('Done!');
END.
