{
 *****************************************************************************
 * Name .......... TIMEVER.PAS
 * Description ... Utility to set the time (and optional date) of a file to
 *                 it's version number.
 * Programmer .... F. Martin Richardson, Jr.
 * Date Created .. October 12, 1991
 * Language ...... Turbo Pascal v6.0
 ******************************************************************************
 * This file is hereby public domain and may be used in any way either public
 * or commercial.  Enjoy!
 ******************************************************************************
 * NOTES:
 *
 * Turbo Pascal makes this easy.  Simply assign the file name to a file 
 * variable and use the SETFTIME on it to set the file time.  
 *
 * Major Version number is the number to the left of the dot.
 * Minor Version number is the number to the right of the dot.
 * (eg, v3.21 .. Major Version Number: 3, Minor Version Number: 21)
 *
 * Just press enter when prompted for a file spec when done entering.
 *
 * Since current versions of DOS report the time of a file in AM/PM format,
 * entering in a minor version number (or minutes) of 13 or greater will
 * be reported as 1 or greater (just subtract 12).  (eg, 13:52 is reported
 * by DOS as 1:52p).  To get a version number greater than 12, simply add
 * 12 to it! (eg, version 16 is entered as 28 (16+12)).
 *
 * Maximum values:
 *   Major Version Number (Hours)  : 31 (19 shown due to am/pm)
 *   Minor Version Number (Minutes): 63
 *   Day                           : 31
 *   Month                         : 15
 *   Year                          : 1980-2107
 *
 * Entering values outside of these ranges may get the result you desire, but
 * more oft than not you will wind up with some other number there, with the
 * rest of your values wrong as well!  Experiment and see what you can come
 * up with!
 *****************************************************************************
}

{$X+,V-}
USES DOS, CRT;

TYPE
     ArrayType = ARRAY[1..20] OF STRING;

VAR
   FileArray: ArrayType;
   DateInfo: DATETIME;
   FileTime: LONGINT;
   Major, Minor: WORD;
   nIndex, NumFiles: INTEGER;
   s: SEARCHREC;
   f: FILE;
   Month, Day: STRING[2];
   Year: STRING[4];
   DateChange: STRING[1];

{*****************************************************************************
 * Function ...... ItoS()
 * Purpose ....... To convert an integer/long integer to string format
 * Parameters .... nNum       Integer to convert
 *                 nLength    Length of resultant string
 * Returns ....... <nNum> as a string <nLength> characters in length.
 * Notes ......... TP does this already with the STR procedure, but functions
 *                 are far more useful.
 *               . Passing a length of 0 will return a string the length of
 *                 the number.
 * Author ........ Martin Richardson
 *****************************************************************************}
FUNCTION ItoS( nNum: LONGINT; nLength: INTEGER ): STRING;
VAR sString: STRING;
BEGIN
     IF nLength > 0 THEN
         STR( nNum:nLength, sString )
     ELSE
         STR( nNum:0, sString );
     ITOS := sString;
END;

{*****************************************************************************
 * Function ...... StoI()
 * Purpose ....... To convert a string to an integer format integer
 * Parameters .... sNum       String to convert
 * Returns ....... <sNum> as an integer.
 * Notes ......... TP does this already with the VAL procedure, but functions
 *                 are far more useful.
 * Author ........ Martin Richardson
 *****************************************************************************}
FUNCTION StoI( sNum: STRING ): LONGINT;
VAR c : INTEGER;
    i : LONGINT;
BEGIN
     VAL( sNum, i, c );
     STOI := i;
END;

{*****************************************************************************
 * Function ...... Empty()
 * Purpose ....... To determine if a string is empty.
 * Parameters .... sString         String to determine empty-ness
 * Returns ....... True if <sString> is empty
 * Notes ......... Definition of empty: 0 length, or contains spaces only
 * Author ........ Martin Richardson
 *****************************************************************************}
FUNCTION Empty( sString: STRING ): BOOLEAN; ASSEMBLER;
ASM
       CLD                          { We want to go left to right }
       XOR   CH, CH                 { Zero out CH }
       LES   DI, sString            { Point ES:DI at sString }
       MOV   CL, BYTE PTR ES:[DI]   { Load string length into CL }
       JCXZ  @@1                    { 0 Length?  Then empty! }
       INC   DI                     { Point to first character of string }
       MOV   AL, ' '                { Compare it to a space }
       REPE  SCASB                  { Compare AL to each byte in [ES:DI] }
       JZ    @@1                    { All spaces, so it must be empty! }
       MOV   AL, False              { We hit a non-space, so not empty }
       JMP   @@2                    { To avoid setting back to true }
@@1:   MOV   AL, True               { Empty! }
@@2:
END;

{*****************************************************************************
 * Function ...... GetPath()
 * Purpose ....... To return the path (minus the file name) from a path 
 *                 string.
 * Parameters .... sPath      Path string from which to extract the path
 *                            minus the file spec.
 * Returns ....... Path string with no file name attached.
 * Notes ......... Trailing slash *IS* included if present
 *                 (eg, GetPath("C:\DOS\COMMAND.COM") returns "C:\DOS\",
 *                      GetPath("C:COMMAND.COM") returns "C:" )
 * Author ........ Martin Richardson
 *****************************************************************************}
FUNCTION GetPath( sPath: STRING ): STRING;
VAR sDir  : DirStr;
    sName : NameStr;
    sExt  : ExtStr;
BEGIN
     FSPLIT( sPath, sDir, sName, sExt );
     GetPath := sDir;
END;

{****************************************************************************
 * Main Routine
 ****************************************************************************}

BEGIN
     WRITELN( 'TIMEVER by Martin Richardson' );
     WRITELN;
     WRITE( 'Enter MAJOR version number: ' );
     READLN( Major );
     WRITE( 'Enter MINOR version number: ' );
     READLN( Minor );
     WRITELN;

     WRITE( 'Change date as well? ' );
     READLN( DateChange );

     IF (DateChange[1] IN ['Y','y']) THEN BEGIN
        WRITELN;
        WRITE( 'Enter month: ' );
        READLN( Month );
        WRITE( 'Enter day: ' );
        READLN( Day );
        REPEAT
              WRITE( 'Enter year : ' );
              READLN( Year );
        UNTIL LENGTH( Year ) < 4;
        IF LENGTH( Year ) < 4 THEN Year := ItoS( StoI(Year) + 2000, 0 );
     END { IF };

     WRITELN;

     NumFiles := 0;
     REPEAT
           INC( NumFiles );
           WRITE( 'Enter File Spec [' + ItoS( NumFiles, 0 )+']: ' );
           READLN( FileArray[NumFiles] );
     UNTIL (NumFiles > 19) OR (Empty( FileArray[NumFiles] ));
     IF Empty( FileArray[NumFiles] ) THEN DEC( NumFiles );

     FOR nIndex := 1 TO NumFiles DO BEGIN
         FindFirst( FileArray[NumFiles], AnyFile, s );
         WHILE (DOSError = 0) DO BEGIN
               WRITELN( 'Changing ', GetPath(FileArray[NumFiles]) + s.name, '...' );
               ASSIGN( f, GetPath(FileArray[NumFiles]) + s.name );
               GETFTIME( f, FileTime );
               UNPACKTIME( FileTime, DateInfo );
               DateInfo.Hour     := Major;
               DateInfo.Min      := Minor;
               IF (DateChange[1] IN ['Y','y']) THEN BEGIN
                  DateInfo.Month := StoI( Month );
                  DateInfo.Day   := StoI( Day );
                  DateInfo.Year  := StoI( Year );
               END { IF };
               PACKTIME( DateInfo, FileTime );
               RESET( f );
               SETFTIME( f, FileTime );
               CLOSE( f );
               FINDNEXT( s );
         {W}END;
     END { NEXT nIndex };
END.
