
                    CHORDMASTER - Unregistered Version 1.6
                      Chord Chemistry Program for Guitar
                     Copyright (c) 1991,1992 Robert Watson
                             All Rights Reserved


      This software is licensed to you, for your own use.  This is
      copyrighted software.  You are not obtaining title to the software
      or any copyright rights.  You may not sublicense, rent, lease, convey,
      modify, translate, convert to another programming language, decompile,
      or disassemble the software for any purpose.
           You may make as many copies of this software as you need for
      back-up purposes.  You may use this software on more than one computer,
      provided there is no chance that it will be used simultaneously on more
      than one computer.  If you need to use the software on more than one 
      computer simultaneously, please contact us for information about site
      licenses.



                                 DISCLAIMER


      ROBERT WATSON DISCLAIMS ALL WARRANTIES RELATING TO THIS SOFTWARE,
      WHETHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY IMPLIED 
      WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
      AND ALL SUCH WARRANTIES ARE EXPRESSLY AND SPECIFICALLY DISCLAIMED.
      NEITHER ROBERT WATSON OR ANYONE ELSE WHO HAS BEEN INVOLVED IN THE
      CREATION, PRODUCTION, OR DELIVERY OF THIS SOFTWARE SHALL BE LIABLE
      FOR ANY INDIRECT, CONSEQUENTIAL, OR INCIDENTAL DAMAGES ARISING OUT
      OF THE USE OR INABILITY TO USE SUCH SOFTWARE EVEN IF ROBERT WATSON
      HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR CLAIMS.  IN 
      NO EVENT SHALL ROBERT WATSON'S LIABILITY FOR ANY DAMAGES EVER EXCEED 
      THE PRICE PAID FOR THE LICENSE TO USE THE SOFTWARE, REGARDLESS OF THE 
      FORM OF THE CLAIM.  THE PERSON USING THE SOFTWARE BEARS ALL RISK AS TO
      THE QUALITY AND PERFORMANCE OF THE SOFTWARE.
           Some states do not allow the exclusion of the limit of liability
      for consequential or incidental damages, so the above limitation may
      not apply to you.
          This agreement shall be governed by the laws of the State of
      California and shall inure to the benefit of Robert Watson and 
      any successors, administrators, heirs and assigns.  Any action or 
      proceeding brought by either party against the other arising out of 
      or related to this agreement shall be brought only in a STATE or 
      FEDERAL COURT of competent jurisdiction located in Los Angeles County, 
      California.  The parties hereby consent to in personam jurisdiction of
      said courts.


      This is an unregistered version of CHORDMASTER and it comes with fewer
      chord library files than the registered version.  If you purchase the
      registered version you will receive the full chord library which will
      display tens of thousands of different chords, as well as an integrated
      chord librarian and editor.  This allows the user to add new chords
      and create custom chord libraries.

      See the accompanying README.DOC file for registration information.





***


                               CHORDMASTER
                    Chord Chemistry Program for Guitar


                               USERS MANUAL




                             TABLE OF CONTENTS


            INTRODUCTION ............................... 1

            INSTALLATION ............................... 2
               FLOPPY DISK ............................. 2
               HARD DISK ............................... 2
               SHAREWARE ............................... 2
               WINDOWS USERS ........................... 2

            CHORD ENTRY ................................ 3
               CHORD ENTRY METHODS ..................... 3
               CHORD ENTRY TABLE ....................... 3
               CHORD ENTRY TABLE OPTIONS ............... 4
               COMMAND LINE ENTRY ...................... 4
                  IDENTIFIERS........................... 4
               NOTE ENTRY .............................. 5
               ERRORS .................................. 5

            SCREEN FORMAT .............................. 6
            SCREEN COMMANDS ............................ 7
            FRETBOARD COMMANDS ......................... 8

            DISPLAYING CHORDS .......................... 9

            OPTIONS MENU .............................. 10
               DISPLAY ................................ 10
               TUNINGS ................................ 11
               PLAY ................................... 11
               FILES .................................. 12
               PRINT .................................. 12
               RESOLVE ................................ 13





















***




                                INTRODUCTION

   CHORDMASTER is state-of-the-art chord chemistry software designed
   specifically for guitarists.  Though it was created with guitarists
   in mind, the concepts explored can be applied to a variety of musical
   instruments.  CHORDMASTER is designed to be an educational aid and
   reference, useful for a variety of educational and compositional
   purposes.


   CHORDMASTER UNREGISTERED VERSION 1.6 FEATURES -

            NEW!!! - Support for Sound Blaster and other sound cards.

            Interactive Chord Entry Table for easy input of chord entries.

            Chord entries can quickly be transposed to different keys.

            Chord libraries files for over 50 different chords.

            Enhances fretboard visualization by showing all notes of a
             chord on the fretboard.

            Fretboard views can be shifted to show a specific area.

            Two fretboards can be viewed simultaneously.

            Chords can be played by a MIDI device or internal speaker.

            Notes for two chords can be overlayed on one fretboard,
             allowing analysis of similarities and differences.

            Chords can be viewed either as notes or scale sequences.

            Chords can be input by name or by specifying notes to be
            resolved to a known chording.

            Obscure inputs can be resolved to proper chords,
             i.e.  Amaj add7 = Amaj7,  A C# E G# = Amaj7.

            Chords can be resolved to up to five chord synonyms.

            Individual chord display can be limited to certain string
             and fret ranges.

            Context-sensitive HELP screens.

            Mouse and printer support.









                                   - 1 -



***




                               INSTALLATION

   CHORDMASTER requires about 250 Kbytes of disk space, and can be run
   from either a floppy or hard disk.

   Versions distibuted on floppy disk can be run as is by logging the
   floppy drive and executing the program.

      Example:    A: <enter>                    (logs the drive)
                  CHORDS <enter>                (executes the program)


   A floppy disk version can easily be installed onto another disk or hard
   drive by copying the CHORDMASTER files and directories to the desired
   drive.

      Example:    C: <enter>                    (logs the drive)
                  CD\ <enter>                   (start from root directory)
                  MD CHORDS <enter>             (create chord directory)
                  CD CHORDS <enter>             (log the chord directory)
                  COPY A:\*.* <enter>           (copy CHORDMASTER from floppy)
                  CHORDS <enter>                (executes the program)


   Shareware versions of CHORDMASTER are distributed in ZIP format and
   require PKUNZIP to install.  Here's a sample hard drive installation
   that assumes that the CHORDS16.ZIP file is in the current directory.


      Example:    MD \CHORDS <enter>                (create chord directory)
                  PKUNZIP CHORDS16  \CHORDS <enter> (unzip CHORDMASTER)
                  CD \CHORDS                        (log the chord directory)
                  CHORDS <enter>                    (executes the program)





   WINDOWS USERS -

   CHORDMASTER will run either full screen or windowed in WINDOWS 3.x.  A
   windows icon (CHORDS.ICO) is included.  Create a PIF file for CHORDMASTER
   using the PIF editor.  128K of RAM is required.  To run CHORDMASTER in its
   own window, WINDOWS must be started in 386 enhanced mode.  If using the
   enhanced mode add a 'w' in the Optional Parameters box of the PIF screen.
   This will disable CHORDMASTER's graphical startup screen and avoid a video
   error in WINDOWS.

   NOTE : Mouse functions will not work if CHORDMASTER is executed in window.
          Sound Card functions may not work in WINDOWS.   







                                   - 2 -



***




                                CHORD ENTRY

   After the opening screens the program will display a blank fretboard
   and the cursor will blink, prompting for a chord entry.  There are
   several ways to enter chords.

   CHORD ENTRY METHODS

      Chord Entry Table  -  A quick interactive method for chord entry.

      Command Line       -  Type in the name of a chord.

      Note Entry         -  Specify the notes in a chord and let CHORDMASTER
                            identify it.

      Each of these methods is discussed below:


   CHORD ENTRY TABLE

   CHORDMASTER's Chord Entry Table is a quick, convenient way to enter a
   chord to be displayed.  The table can be accessed by striking the F10
   key to access the OPTIONS menu, and selecting the appropriate option 
   from the DISPLAY submenu.

   MOUSE USERS : The Chord Entry Table can be accessed by clicking at
                 the top of the screen when CHORDMASTER is expecting
                 a chord entry.

   The Chord Entry Table consists of four component sections: KEY, SUFFIX,
   ADD, and ALTER.  The first and second sections, KEY and SUFFIX, are
   essential and one item from each is always selected.  The ADD and ALTER
   sections are not essential and selections in them are optional.


   MAKING SELECTIONS

        TAB         to move from section to section.
     ARROW keys     to move around within a section.
     SPACE BAR      selects/deselects the highlighted item in the ADD/ALTER
                     section.

      MOUSE USERS : Click on an item to select it, click again to deselect.


   Note that at any given time certain ADD/ALTER selections are darkened and
   not available.  Which selections are available will depend on which SUFFIX
   and other ADD/ALTER selections are made.  The Chord Entry Table reacts
   interactively, showing which combinations are musically permissible.








                                   - 3 -



***




   CHORD ENTRY TABLE - OPTIONS

      FREE ARROW KEYS     - Some keyboard users will find this option a 
                            more convenient way to traverse the table.  
                            Using this method the ARROW keys can traverse 
                            the table, moving from section to section.  The
                            TAB key need only be used to anchor selections
                            in the leftmost columns of the KEY or SUFFIX 
                            areas.  This method requires fewer keystrokes
                            to accomplish many of the same tasks.

      REMEMBER LAST CHORD - This option makes the Chord Entry Table remember
                            the previous chording that was entered with the
                            table.  This is useful when entering successive
                            chords that are similar in some respect.



   COMMAND LINE CHORD ENTRY

   Use the following format for entering a chord by name:

                  [A-G][#,b(optional)] [chord identifier options]

   At the very least you must enter an uppercase letter in the range of
   'A' through 'G'.  Optionally, you may indicate that the note is to be
   sharped or flatted by adding a '#' for a sharp or a lowercase 'b' for
   a flat.  Why the preoccupation with upper and lowercase?  Consider a
   B flat chord.  It looks fine as 'Bb', but kind of silly as 'bb', 'BB',
   or 'bB'.

   So you must enter the key or root of the chord you want to work with.
   If this is all you enter it is assumed that you are looking for a
   major chord.  To specify other chords you must add one or more chord
   identifier options, separated by spaces.

   The following are legitimate identifier options:

   FIRST GROUP

      maj             maj6             maj7             maj9
      maj11           maj13            minmaj7          minmaj9
      min             min6             min7             min9
      min11           min13            dim              dim7
      5               6                7                9
      11              13               aug              aug9
      aug11           noroot


   SECOND GROUP

      add or /        sus              + or -    (followed by numbers 2 - 13)





                                   - 4 -



***




   Identifiers may be combined, separated by a space, in any combination that
   is musically sensible.  Now, what is musically sensible may vary according
   to whose rules you are following.  For the most part you will use one of
   the identifier options in the first group, optionally followed by one or
   more of the identifier combinations in the second group.

   The identifiers in the first group are common in describing chords.  See
   a book on chord theory for an explanation of these identifiers.

   The identifiers in the second group are less common and are often written
   in different ways.  Here is brief explanation of the second group:

      add   or   /      -  Used to add a tone to tone to a chord.  These
                           are useful in creating common and exotic chords
                           and scales.  The catch is that the tone to be
                           added must not have been described in a previous
                           identifier or an error message will result.
      sus               -  Generally used to add a 2nd or 4th tone to a
                           chord at the expense of the 3rd.
      +    or    -      -  used to add an altered tone, or alter an existing
                           tone, to an existing chord.


   Here are some of the errors that can be encountered during chord entry.
   Errors only occur when using the command-line input method.

         ILLEGAL                    -  What you typed is nonsensible.
         STEP ALREADY EXISTS        -  Your trying to add (add or /) a tone
                                       that has already been established.
         TONE SPECIFIED IS > 13     -  You've tried to add or alter a tone
                                       that is greater than 13.
         ILLEGAL TONE SPECIFIED     -  You've tried add or alter a
                                       non-numeric entity.


   NOTE ENTRY

   Entry can also be accomplished by specifying the notes to be used in the
   chord.  CHORDMASTER then attempts to identify the chord.  Note entry is
   particularly easy with a mouse.  Non-mouse users should use the RESOLVE
   - NOTE ENTRY item in the OPTIONS menu (pg. 13).

      IMPORTANT : A chord entered by notes cannot be properly identified
                  unless all notes in it's formula are part of the entry.

   NOTE ENTRY with a mouse:

      Enter a chord's notes by clicking on the desired fret positions on
      the active fretboard.  Clicking on a previously selected note will
      de-select it.  Once the desired notes have been selected, click on
      the word PROCESS which will appear above the active fretboard.  If
      the notes can be identified as a chord, its name will be displayed.
      The lowest note selected will be considered as the primary root for
      the resulting chord.



                                   - 5 -



***




   Once a valid chord has been entered, all the notes in the chord are
   displayed on a fretboard and the notes are sounded through the system
   speaker.  Additionally, a display appears above and to the right of the
   fretboard showing the relationship of the notes in the chord to the tones
   in a scale.  This display is the chord formula header.

   For instance, if 'A' is entered; the chord formula header will display
   the following:
                        1   2   3   4   5   6   7
                        A       C#      E

   This indicates that the 'A' major chord that was entered has three tones
   in it; a 1st or root, a 3rd and a 5th.  Therefore, an 'A' major chord has
   a formula of 1, 3, 5 .  The established spacing of these notes is function
   of established music theory and will not be discussed in this section.  It
   is not necessary to fully understand these mechanisms to begin using and
   enjoying CHORDMASTER.

   An additional line of text appears immediately below the fretboard, this
   is called the RESOLVE line.  If you entered 'A', as in the example above,
   this line would simply read 'A MAJ'.  This may seem kind of redundant at
   this point, but as you will see as you read on, the RESOLVE line is one of
   CHORDMASTER's most powerful features.

   Let's look again at the fretboard.  If you have entered the simple example
   chord shown above, the fretboard shows all the notes in an 'A' major chord
   scattered about the fretboard.  This is a powerful visual tool.  It allows
   the user to visualize an entire section of fretboard.  In this case, any
   fingerable combination of notes that contains at least one 'A', one 'C#'
   and one 'E', is a legitimate 'A' major chord.  Don't worry, CHORDMASTER
   can also display individual chord fingerings as we will see shortly.


























                                   - 6 -



***




                              SCREEN COMMANDS

   If you have been following along, a word should appear in the center of
   the screen.  This is actually one of a series of possible choices called
   the AUTOMENU.  If you strike the SPACEBAR repeatedly, alternate selections
   will appear.  A selection is executed by striking ENTER.  Let's take a
   look at each of these selections:

         REENTER     -  This selection only appears if there was an error
                        in the most recent chord entry.
         OVERLAY     -  Allows entry of another chord, whose notes will
                        appear in combination with those already on the
                        active fretboard.  On a color monitor, the results
                        may be particularly revealing.
         SWITCH      -  Opens a fretboard on the opposite half of the the
                        display for chord entry.
         CLEAR       -  Clears the active fretboard for chord entry.
         OPTIONS     -  Displays the OPTIONS menu.
         QUIT        -  Exits the program.


   The OVERLAY and SWITCH functions provide added power in fretboard
   visualization; allowing the user to view various chord patterns together,
   or side by side.


   MOUSE USERS :  To cycle through AUTOMENU choices, position the cursor in
                  the center of the screen and click the right mouse button.
                  Click the left mouse button on the desired selection to
                  execute it.

                  Chord entries equivalent to the OVERLAY, SWITCH, CLEAR and
                  REENTER can be initiated by clicking the left mouse button 
                  over the desired input area.

                  The OPTIONS menu can be accessed by clicking the left mouse
                  button at the top of the screen.




















                                   - 7 -



***




                             FRETBOARD COMMANDS

   There are several quick key combinations available after a chord is
   entered, they are:

         <- or ->    -  Shifts the fretboard view range left or right.
                        At any one time 16 frets are visible, over a range
                        of 25.

            P        -  Repeats the playing of the tones in the chord.

         -  or  +    -  Changes the timing of the playing of the tones
                        in the chord.

            D        -  Displays individual fingerings for the entered chord.

   UP or DOWN arrows -  TRANSPOSE the most recent entry to a higher
                        or lower key.

            T        -  Switch between like keys. For example 'C#' to 'Db'.

           F10       -  Accesses the OPTIONS menu.


   MOUSE USERS :  The OPTIONS menu can be accessed by clicking the left mouse
                  button at the top of the screen.

                  DISPLAY of individual chordings can be initiated by
                  clicking on the DISPLAY box which will appear above the
                  active fretboard.

                  Entries can be TRANSPOSED thru keys by clicking on the
                  appropriate side of the TRANSPOSE button.  Clicking in
                  the middle of the button will switch between like keys.
                  For example 'C#' to 'Db'.






















                                   - 8 -



***




                              DISPLAYING CHORDS

   Once a valid chord is entered on fretboard, individual chordings can be
   displayed.  This can be accomplished by pressing a 'D' on the keyboard or
   selecting DISPLAY from the OPTIONS menu.

   During DISPLAY the following keys are active:

            <-  and  ->      previous and next chords
             +  and  -       to change play timing
                 P           repeat chord play
                ESC          to quit DISPLAY


   MOUSE USERS : If mouse hardware is detected, buttons for some of the
                 functions listed above will appear above the active
                 fretboard.  Simply click on the desired button to display
                 chords.


   Use basic chord entries to test the DISPLAY system.  If all attempts to
   DISPLAY result in file errors it is likely that CHORDMASTER is improperly
   installed.  Be sure that the chord files (.CDF) in the CHORDS directory.

   This is an unregistered version of CHORDMASTER and it comes with fewer
   chord library files than the registered version.  If you purchase the
   registered version you will receive the full chord library which will
   display tens of thousands of different chords, as well as an integrated
   chord librarian and editor.  This allows the user to add new chords
   and create custom chord libraries.


   DISPLAY LIMITS

   Limits may be placed on the selection of chords to be displayed.  This
   is accomplished using the DISPLAY SETUP menu option, which is described
   in the next section of this manual.  If any limits have been placed on
   the chords selected for display, a message will appear advising the user
   that not all chords are being displayed.


















                                   - 9 -



***




                               OPTIONS MENU


   Let's examine the various features in the options menu.  We will work
   through the drop-down menus left to right.


   DISPLAY MENU

   The DISPLAY drop-down menu consists of three items.  The first choice,
   DISPLAY is equivalent to pressing the 'D' key after chord entry.  This
   choice initiates DISPLAY of individual chordings within the parameters
   specified by the second choice, DISPLAY SETUP.


   DISPLAY SETUP

   This menu selection brings up the DISPLAY SETUP menu.  The DISPLAY
   SETUP menu allows the user to specify the fret range, strings, and
   number of notes allowed for the chords to be displayed.

   Move from from field to field by pressing the up or down arrow keys,
   TAB or ENTER.  When the setup is as desired press F7 to save.  Press
   ESC to exit and ignore changes.

   For each STRING use the SPACEBAR to indicate whether it should be used 
   for DISPLAY.  If too many strings are disabled an error message will
   appear.  The number of strings required will vary according to the
   formula of the most recently entered chord.

   Specify the fret range over which chords should be displayed by adjusting  
   the LOW FRET and HIGH FRET entries.  Remember, not more than 16 frets can
   be diplayed at one time.  However, individual chordings may be displayed
   over a smaller range of frets.

   Select the MINIMUM and MAXIMUM number of notes in chords to be displayed.
   The MAXIMUM number of notes depends on how many strings are used, the 
   MINIMUM limit is determined by the formula of the chord.

   Select which tone in the chord should be the BASS NOTE.  Most commonly
   '1' would be entered to select the root note as the bass.  However, more
   chords will be displayed if '0' is entered, indicating no preference.

   The NOTE BLINK selection toggles the blinking of notes in a chord as they
   are displayed.
   
   MOUSE USERS : Click on a field to move cursor, click on a command
                 to execute it.


   INTERVALS

   This menu selection offers a choice between displaying notes on the
   fretboard by their musical names (i.e. A, F#, D, etc.), or by the number
   of the scale step that they represent in the selected chord.


                                   - 10 -



***




   TUNINGS MENU

   The TUNINGS menu allows fretboards to be tuned in a variety of manners.
   Tuning changes affect subsequent chord entries on.  Menu items allow for
   a quick change to STANDARD, OPEN A, OPEN C, OPEN D, OPEN E or OPEN G
   tunings.  The final menu item provides for CUSTOM TUNING, in which any
   string can be altered from the standard tuning up to four half steps in
   either direction.

   NOTE : Individual chord DISPLAY is only available for standard tuning.



   PLAY MENU

   This menu consists of two ON/OFF selections . . .

            PLAY ON ENTRY     -  Chord play on entry
            PLAY ON DISPLAY   -  Chord play on DISPLAY

            . . . and the PLAY SETTINGS menu.


   PLAY SETTINGS

   The PLAY SETTINGS sub-menu provides selections that control the ATTACK
   and DURATION timings of the chords being played.  Units of time are 
   defined as system ticks; approximately eighteen per second.

   Chords can be played through a MIDI device and/or Sound Card, by enabling 
   these via the appropriate Check Boxes.  If either of these devices exist, 
   additional menus will be available.  Press 'F2' for MIDI settings or 'F3'
   to set instruments for a Sound Card.


   MIDI SETTINGS

      PATCH DATA         -  Set the desired patch number to be transmitted 
                            to the MIDI device prior to playing.  Use numbers 
                            '1 -128' for patch data, or '0' to indicate that 
                            no patch data will be sent.

      KEY VELOCITY       -  Set the MIDI key velocity as desired.  The default
                            is 48.

      LOWEST MIDI CHAN   -  While the MIDI specification describes numbers
                            '0 - 15' for MIDI channel numbers, most devices
                            use numbers '1 - 16'.  Specify the desired scheme
                            here.  The default is '1'.

      MIDI CHANNEL       -  Specify which channel MIDI data should be sent on.
                            Use numbers '0 - 15' or '1 - 16' depending on the 
                            setting of the LOWEST MIDI CHANNEL selection.




                                   - 11 -
   


***




   SOUND CARD INSTRUMENTS

      Use this selection menu to tryout and/or select different instrument
      sounds when using a Sound Card.  The selection list appears with the
      currently selected instrument hi-lited.  If a new instrument can be
      tested by selecting it from the list and using 'T' to play a test
      chord.

      NOTE : Sound Card output must have been enabled in the previous menu
             for a chord to be played.  
             
      Once the desired selection has been made, it may be locked for future
      sessions by using the SAVE CONFIGURATION option under the FILES menu.
      


   FILES MENU

   SAVE CONFIGURATION

      The selection saves information about current program settings in a
      file called CHORD.CFG.  The settings saved in this file are restored
      every time the program is started.


   FACTORY SETTINGS

      Restores program settings to the original settings distributed with
      the program.




   PRINT MENU

   This drop-down menu consists of several selections which initiate printing
   of fretboards.  Printed output is sent to the standard print device.




















                                   - 12 -



***




   RESOLVE MENU

   The RESOLVE drop-down menu consists of selections that control the way
   chordings are resolved and displayed.

   RESOLVE performs two important functions.  First, RESOLVE can take an
   awkward chord entry and show a more eloquent method of achieving the
   same result.

   For instance, if you entered 'A MIN /2 /7', RESOLVE would "correct" your
   entry by responding with 'A MIN9'.  This is a useful educational tool,
   helping to reinforce the user's understanding of chord chemistry.

   Secondly, RESOLVE's perform is critical to the DISPLAY of individual
   chordings.  This is very important, so it should be emphasized that
   DISPLAY WILL NOT BE AVAILABLE FOR A CHORD UNLESS IT IS RESOLVED TO A
   CHORD WITH A ROOT, AND A CHORD FILE EXISTS FOR AT LEAST ONE RESOLUTION.

   RESOLVE is capable of revealing chord synonyms.  Factory settings limit the
   RESOLVE line display to three resolutions, but by altering these settings
   up to five synonyms or near matches can be displayed.  These synonyms may
   or may not include NOROOT chords depending on the settings.  This has
   implications in DISPLAY mode; if a chord is resolved to more than one
   perfect match by RESOLVE, chord library files for both chords would be
   combined and the resulting chordings DISPLAYed.  While this increase in
   DISPLAYed chordings is usually modest, it does provide a means by which
   NOROOT chords can be DISPLAYed, despite the fact that no chord library
   files exist for them.  To see this mechanism in action use the RESOLVE
   dropdown menu to set RESOLVE as follows DISPLAY ON, SET COUNT=2, PERFECT
   ONLY ON and NO ROOT OFF.  Obtain a clear fretboard for entry and enter
   'A MIN6'.  The RESOLVE line now indicates 'A MIN6  F#MIN7 -5'.  Upon
   DISPLAY files for both chords will be opened and combined for more
   chordings.


   Here's a description of the RESOLVE menu functions:

      RESOLVE        -  Resolves the most recently entered chord according
                        to the current RESOLVE settings.

      DISPLAY        -  Enables or disables the display of the resolve line.
                        Either way RESOLVE still occurs and the results
                        affect DISPLAY.

      SET COUNT      -  Sets the number of resolutions RESOLVE will attempt
                        to achieve.

      PERFECT ONLY   -  This setting decides whether or not non-perfect
                        chord synonyms will be resolved.  On the resolve line
                        perfect synonyms are shown in reverse video.

      NO ROOT        -  This setting decides whether NOROOT chords will be
                        resolved.




                                   - 13 -



***




      NOTE ENTRY     -  Provides a means by which individual notes of an
                        unknown chord can be entered and then resolved to
                        a known chord.  Notes should be entered separated by
                        a space.  Note Entry can be more easily accomplished
                        using a mouse (pg. 5).  The first note entered will
                        be considered as the primary root note for the chord.



















































                                   - 13 -

