//  AVAILRAM.C
//
//  Uses DOS BIOS Interrupt Service 12h to determine the
//  "available" RAM (accounts only for initial RAM, and
//  does not track memory blocks used).
//
//
//  This source and its compiled program are included in
//  the Version 2.7 release of KWMenu as a sample utility
//  to run from the menu and to serve as a simple
//  illustrative program for anyone interested in learning
//  C programming. The file can be compiled with the
//  makefile availram.mak.
//
//
//  This program was developed and released to the public
//  domain in 12/92 by KeenWare.  It is recognized that the
//  program is not particularly useful by itself, but it is
//  hoped that it has some educational value for those new
//  to C programming.

//  Since the main function does not need to use any
//  command line arguments,  declaring the functions
//  _setargv and _setenvp as null functions trims a few
//  bytes off the size of the executable. These functions
//  are used in the Microsoft Corporation's C and QuickC
//  compilers.  Other compilers might use different
//  functions.


#include <dos.h>

void _setargv(void)     {}
void _setenvp(void)     {}


union REGS inregs, outregs;

//  The following functions take the place of the standard
//  functions printf and itoa, thereby trimming about 3000
//  bytes off the size of the executable file.

int IntToAscii(int i, char *s);
void _bioswrite(char *outstring);
void _bioschar(char outchar);


main()
{
    int d, len, m=0;
    char output[80];
    char description[] =
         "kilobytes of available memory";
    /*-------------------------------------------------
     Call BIOS interrupt service 12h to obtain
     available memory and store the result (register
     ax) in 'd'.
    -------------------------------------------------*/
    int86( 0x12, &inregs, &outregs);
    d = outregs.x.ax;
    /*-------------------------------------------------
    Convert the result to an ascii string that can be
    displayed using standard BIOS character writing
    capabilities
    --------------------------------------------------*/
    len = IntToAscii(d, output);
    output[len] = ' ';
    while( *(description + m) )
        output[++len] = *(description + m++);
    output[len+1] = '\0';
    /*----show the result----*/
    _bioswrite(output);
}



//  Convert integer i (positive values only)
//  to ascii string s
//
//
int IntToAscii(int i, char *s)
{
    int k=0, length=0;
    do
    {
        *(s + k++) = i % 10 + '0';
    } while ((i /= 10) > 0);
    *(s + k) = '\0';
    length = k;
    {
        int c, j=0;
        --k;
        for ( ; j<k; j++, k--)
        {
            c = *(s+j);
            *(s+j) = *(s+k);
            *(s+k) = c;
        }
    }
    return length;
}


// Calls a BIOS character-writing routine for each
// character in the output string.
//
//
void _bioswrite( char *outstring)
{
    int i=0;
    while( outstring[i] )
        _bioschar(outstring[i++]);
}


//   Uses BIOS Interrupt service 10h, function 0Eh, to
//   print a character to the screen.
//
void _bioschar(char outchar)
{
    inregs.h.ah = 0x0E;
    inregs.h.al = outchar;
    inregs.x.bx = 0x07;
    int86( 0x10, &inregs, &outregs);
}

