//
//
//  DISKFREE.C
//
//
//  Uses DOS BIOS Interrupt Service 21h to determine the
//  amount of free disk space on Drive C.
//
//  This source and its compiled program are included in
//  the Version 2.7 release of KWMenu as a sample utility
//  to run from the menu and to serve as a simple
//  illustrative program for anyone interested in learning
//  C programming. The file can be compiled with the
//  makefile availram.mak.
//
//  This program was developed and released to the public
//  domain in 12/92 by KeenWare.  It is recognized that the
//  program is not particularly useful by itself, but it is
//  hoped that it has some educational value for those new
//  to C programming.
//



//
//
//  Since the main function does not need to use any
//  command line arguments,  declaring the functions
//  _setargv and _setenvp as null functions trims a few
//  bytes off the size of the executable. These functions
//  are used in the Microsoft Corporation's C and QuickC
//  compilers.  Other compilers might use different
//  functions.
//
//

#include <dos.h>

void _setargv(void)     {}
void _setenvp(void)     {}


union REGS inregs, outregs;

int IntToAscii(long i, char *s);
void _bioswrite(char *outstring);
void _bioschar(char outchar);

#define VIDEO    0x10

main()
{
    int h, len, m=0;
    int a, b, c, d;
    long f, g;
    char output1[60], output2[60];
    char description1[] =
        "bytes of drive space remaining\r\n";
    char description2[] =
        "out of original bytes =                        ";

    //  Call BIOS interrupt service 21h to obtain
    //  disk space usage
    //
//      _asm
//      {
//          mov ah, 36h
//          mov dl, 3       ;specify hard drive (c)
//          int 21h
//          mov a, ax
//          mov b, bx
//          mov c, cx
//          mov d, dx
//      }
    inregs.h.ah = 0x36;
    inregs.h.dl = 3;        //  Specify hard drive (c drive = 3)
    int86( 0x21, &inregs, &outregs);
    a=outregs.x.ax, b=outregs.x.bx, c=outregs.x.cx, d=outregs.x.dx;
    f = ((long)a) * ((long)b) * ((long)c);
    g = ((long)a) * ((long)c) * ((long)d);

    //  Convert the result to an ascii string that can be
    //  displayed using standard BIOS character writing
    //  capabilities


    len = IntToAscii(f, output1);
    output1[len] = ' ';
    while( *(description1 + m) )
        output1[++len] = *(description1 + m++);
    output1[len+1] = '\0';
    /*----show the result----*/
    _bioswrite(output1);
    m = 25;
    len = IntToAscii(g, output2);
    for (m=25, h=0; output2[h]; m++, h++)
        description2[m] = output2[h];
    description2[m+1] = '\0';
    /*----show the result----*/
    _bioswrite(description2);
}



//  Convert integer i (positive values only)
//
//
int IntToAscii(long i, char *s)
{
    int k=0, length=0;
    do
    {
        *(s + k++) = i % 10 + '0';
    } while ((i /= 10) > 0);
    *(s + k) = '\0';
    length = k;
    {
        long c;
        int j=0;
        --k;
        for ( ; j<k; j++, k--)
        {
            c = *(s+j);
            *(s+j) = *(s+k);
            *(s+k) = c;
        }
    }
    return length;
}


void _bioswrite( char *outstring)
{
    int i=0;
    while( outstring[i] )
        _bioschar(outstring[i++]);
}


void _bioschar(char outchar)
{
    inregs.h.ah = 0x0E;
    inregs.h.al = outchar;
    inregs.x.bx = 0x07;
    int86( 0x10, &inregs, &outregs);
}

