//  KWKEY.C
//
//  Stuffs keys that you specify into the DOS keyboard buffer so
//  that the program you run after kwkey.com will receive those
//  keys.  The accompanying documentation, kwkey.doc, provides
//  more detail on usage.
//
//      This source and its compiled program are included in the
//      Version 2.7 release of KWMenu as a sample utility to run
//      from the menu and to serve as a simple illustrative
//      program for anyone interested in learning C programming.
//      The file can be compiled with the makefile kwkey.mak.
//
//  This program was developed and released to the public domain
//  in 12/92 by KeenWare.  It is recognized that there are a
//  number of more powerful keyboard stuffers on the market and
//  that this program might not work in a few situations in
//  which a powerful stuffer would.  However, it is hoped that
//  this program will be useful to those not needing more
//  powerful (and sometimes more memory-consuming) keyboard
//  stuffers, and that it has some educational value for those
//  new to C programming.
//

#include <stdlib.h>     //  used for function atoi


void main( int argc, unsigned char *argv[] )
{
    //
    //  The 32-byte circular keyboard buffer resides at memory location
    //  0000:041E.  Keys ares pushed out from the buffer beginning at
    //  its head.  DOS stores a pointer to the buffer head in 0000:041A
    //  and stores a pointer to the buffer tail in 0000:041C.
    //  By accessing these locations, we can pretty well get the buffer
    //  to do what we want it to.  Note that each key is stored as a
    //  high byte and a low byte.
    //
    unsigned _far *Head = (unsigned _far *) 0x0000041AL;
    unsigned _far *Tail = (unsigned _far *) 0x0000041CL;
    char     _far *p    = (char     _far *) 0x0000041EL;
    int i, j, len;
    char *sptr = argv[1];
    unsigned char highbyte, lowbyte;
    char charac[4];

    // The following are the ASCII bytes of standard keyboard keys
    char ascii[] =
    {
        '~', '`', '!', '1', '@', '2','#', '3', '$', '4', '%', '5', '^', '6', '&', '7',
        '*', '8', '(', '9', ')', '0', '_', '-', '+', '=', '|', 0x5C,
        'Q', 'q', 'W', 'w', 'E', 'e', 'R', 'r', 'T', 't', 'Y', 'y', 'U', 'u',
        'I', 'i', 'O', 'o', 'P', 'p', '{', '[', '}', ']', 'A', 'a', 'S', 's',
        'D', 'd', 'F', 'f', 'G', 'g', 'H', 'h', 'J', 'j', 'K', 'k', 'L', 'l', ':', ';',
        0x22, 0x27, 'Z', 'z', 'X', 'x', 'C', 'c', 'V', 'v', 'B', 'b', 'N', 'n', 'M', 'm',
        '<', ',', '>', '.', '?', '/', 0
    };
    // And the following are their corresponding scan codes
    char scan[]  =
    {
        0x29, 0x29, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
        9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 0x2B, 0x2B,
        16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22,
        23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 30, 30, 31, 31,
        32, 32, 33, 33, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, 39, 39,
        40, 40, 44, 44, 45, 45, 46, 46, 47, 47, 48, 48, 49, 49, 50, 50,
        51, 51, 52, 52, 53, 53, 0
    };

    // The following are ASCII bytes of 'special' keys such as the
    // ESCAPE and ENTER keys, etc.
    char Sascii[] =
    {
        27, 13, 9, 11, 23, 5, 18, 20, 25, 21, 9, 15, 16,
        1, 19, 4, 6, 7, 8, 10, 11, 12, 26, 24, 3, 22, 2, 14, 13, 0
    };
    // And the following are their corresponding scan codes
    char Sscan[] =
    {
        1, 0x1c, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19,
        0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0
    };

    //
    // Determine the length of the string that is used as the argument
    // in key (that is how many characters are being stuffed).  Limit
    // this to 15 characters. The keyboard buffer can only hold 32 bytes
    // and each character takes two bytes (one for the ASCII code and one
    // for the scan code).  Although we could probably handle 16 characters,
    // we build in a little 'safety margin' (i.e., enusre we don't lose a
    // character) by limiting to 15 characters (30 bytes).
    //
    while ( *sptr != '\0' )
        sptr++;
    len = sptr - argv[1];
    if( len > 15 )
        len = 15;

    // Set the Head and Tail of the Buffer to its
    // beginning and clear the buffer out.
    *Tail = *Head = 0x001E;
    for (i = 0; i<32; i++)
        *(p + i) = 0;

    for (i = 0; i<len; i++)
    {
        // Default settings (no complicated characters) are:
        j = 0;
        while( argv[1][i] != ascii[j++] )
            ;
        highbyte = ascii[j-1] & 0x00ff;
        lowbyte  = scan[j-1];

        // Settings for ASCII characters that can't be presented on
        // the command line as a character (TAB, ENTER, ESC, and
        // a few others).  These are stuffed by preceding their
        // ASCII key code (for example, 13 for ENTER) with a #:
        if( argv[1][i] == '#' )
        {
            charac[0] = argv[1][++i];
            charac[1] = argv[1][++i];
            charac[2] = 0;
            highbyte  = (unsigned char)atoi( charac );
            // Although some of our other source code examples have avoided
            // the use of standard library routines, in order to reduce file
            // size, we make use of the standard library routine atoi here
            // because it's actually more code size efficient to do so than
            // to develop the corresponding code ourselves.

            /*----find matching scan code----*/
            j = 0;
            while( highbyte != Sascii[j++] )
                ;
            lowbyte   = Sscan[j-1];
        }
        // Settings for extended characters (those preceded on the
        // command line by a ?) are:
        if( argv[1][i] == '?' )
        {
            charac[0] = argv[1][++i];
            charac[1] = argv[1][++i];
            charac[2] = argv[1][++i];
            charac[3] = 0;
            lowbyte  = (unsigned char)atoi( charac );
            highbyte = 0;
        }
        /*----Stuff the ascii and scan codes into the keyboard buffer----*/
        *(p++) = highbyte;
        *(p++) = lowbyte;
    }

    /*----Readjust DOS's Tail pointer----*/
    *Tail = 0x001E + 2*len;
}


