Unit GpFrame;

{
This unit provides a basic frame for TGroups or decendents which have
been inserted into a TWindow. Note that you cannot use a TFrame for this
purpose, because a TFrame demands to be inserted directly into a
TWindow.

The frame is drawn in double-line characters in the TWindow palette
Active Frame color whenever the owning group gets the focus, or in
single-line characters using the Passive Frame color when the owning
group loses focus.

Note that the owning TGroup is assumed to have a "pass-thru" (nil)
GetPalette function, so that the frame is drawn using the TWindow
indexes. This will be true by default.

The frame dynamically resizes itself to the owning group's size.

Streaming Note:

No stream registration record is provided in this unit.  Most
programmers prefer to assign their own IDs anyway. If you plan to
stream this object, simply provide an appropriate record and call
RegisterType. No override of Store and Load is necessary, since this
object declares no fields.

}

interface
uses Views,Drivers,Objects;

type
  PGroupFrame = ^TGroupFrame;
  TGroupFrame = object(TView)
    constructor Init(var Bounds : TRect);
    procedure Draw; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

implementation

constructor TGroupFrame.Init;
begin
  Inherited Init(Bounds);
  EventMask := EventMask or evBroadcast;
end;

procedure TGroupFrame.HandleEvent(var Event: TEvent);
begin
  Inherited HandleEvent(Event);
  with Event do
  if (What = evBroadcast) and (InfoPtr = Owner) then
  case Event.Command of
    cmReleasedFocus, cmReceivedFocus : DrawView;
  end;
end;

procedure TGroupFrame.Draw;
const
  T1 = '';
  S1 = '';
  T2 = '';
  S2 = '';
var
  B : TDrawBuffer;
  N : string;
begin
  Size := Owner^.Size;
  with Size do if (X<2) or (Y<2) then exit;
  FillChar(N[1],Size.X-2,' '); N[0]:=Chr(Size.X-2);
  if Owner^.GetState(sfFocused) then
  begin
    WriteChar(0,0,'',2,1);
    WriteChar(1,0,T2,2,Size.X-2);
    WriteChar(Size.X-1,0,'',2,1);
    MoveStr(B, S2+N+S2, GetColor(2));
    WriteLine(0, 1, Size.X, Size.Y-2, B);
    WriteChar(0,Size.Y-1,'',2,1);
    WriteChar(1,Size.Y-1,T2,2,Size.X-2);
    WriteChar(Size.X-1,Size.Y-1,'',2,1);
  end else
  begin
    WriteChar(0,0,'',1,1);
    WriteChar(1,0,T1,1,Size.X-2);
    WriteChar(Size.X-1,0,'',1,1);
    MoveStr(B, S1+N+S1, GetColor(1));
    WriteLine(0, 1, Size.X, Size.Y-2, B);
    WriteChar(0,Size.Y-1,'',1,1);
    WriteChar(1,Size.Y-1,T1,1,Size.X-2);
    WriteChar(Size.X-1,Size.Y-1,'',1,1);
  end;
end;

end.
