PROGRAM PoPDlC;
{ͻ}
{ Download counter for Portal                   Last changed: 24.04.93  SA }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}

{ Revision history Ŀ
                                                                           
  Ver    Date      By  Comment                                             
   
  0.61.1 24-04-93  SA  Released to the public.....   .                     
  0.61.1 19-04-93  SA  Released to the beta testers...                     
  0.60.1 31.03.93  SA  Added check for memory overflow                     
                       Added IO check when writing new FILES.BBS           
                       Added "NormVideo" before all "Halt"                 
         30-03-93  SA  Only added 1 to DlC even if the file had been       
                       downloaded more than once.....                      
         29-03-93  SA  First compilation, based on some old source of mine 
                       from 1989-90 (DLCount)                              
 }

USES OpCrt, OpString, OpStrDev, Dos, UnixDate, PoPTypes;

CONST
  NotePadFileName= 'POPDLC.DAT';
  PoPDlCVer      = '0.61.1';
  MonthName      : ARRAY[1..12] OF String[3] = ('Jan', 'Feb', 'Mar', 'Apr',
                                                'May', 'Jun', 'Jul', 'Aug',
                                                'Sep', 'Oct', 'Nov', 'Dec');

TYPE
  { This is not very smart - change it sometime later.... }
  AreaRecord     = RECORD
                     FileName       : String[12];
                     Count          : Word;
                   END;
  AreaType       = ARRAY[1..100] OF AreaRecord;
  FileListPtr    = ^FileListType;
  FileListType   = RECORD
                     FilePath       : PathStr;
                     FileName       : String[12];
                     Next           : FileListPtr;
		   END;

  TCfg = RECORD
    LogFile	 : ARRAY[1..10] OF PathStr;
    Outbound     : PathStr;
    BBSType      : Byte;
    DLCntStart,
    DLCntStop    : Char;
    InsDLCnt     : Boolean;
    DlCDigits    : Byte;
    DlCZeroFill  : Boolean;
  END;

  TNotePad = RECORD
    LastRun  : LongInt;
    Logs     : ARRAY[1..10] OF RECORD
      FileName : PathStr;                     { Add support for this later.. }
      LastDate : LongInt;
    END;
    Filler  : ARRAY[1..180] OF Byte;
  END;


VAR
  LogFileNum	 : Byte;
  FileList,
  FirstFile      : FileListPtr;
  DataRec        : TNotePad;
  CfgInfo	 : TCfg;

  PROCEDURE WriteCopyRight;
  BEGIN
    TextColor(White);
    WriteLn('Portal of Power Download Counter v '+PoPDlCVer);
    WriteLn('(c) Copyright 1993 by The Portal Team');
    WriteLn;
  END;


  FUNCTION HasFileName(s: STRING): BOOLEAN;
  BEGIN
    HasFileName:=((s<>'') AND NOT (s[1] IN [#0..#32,';','-','@','%','/']));
  END;

{=== Download Counter manipulation ==========================================}

  FUNCTION MakeDlCnt(Num: LongInt): S10;
  VAR
    s : S10;
  BEGIN
    WITH CfgInfo DO
    BEGIN
      s:=DLCntStart+LeftPad(Long2Str(Num),DlCDigits)+DlCntStop;
      IF DlCZeroFill THEN s:=Substitute(s, ' ', '0');
    END;
    MakeDlCnt:=s;
  END;

  PROCEDURE AddDLC(VAR s: STRING);
  VAR
    Extra : S10;
    Desc  : String;
    i,j   : Byte;
    Num   : LongInt;
    Err   : Integer;
  BEGIN
    IF HasFileName(s) THEN
    BEGIN
      num:=0;
      i:=Pos(' ',s);
      IF i=0 THEN
      BEGIN
        s:=s+' '+MakeDlCnt(Num);
      END ELSE
      BEGIN
        Desc:=Trim(Copy(s,i,255));
        Extra:='';
        IF Length(Desc)>=2 THEN
        BEGIN
          IF (CfgInfo.BBSType=7) AND (Copy(Desc,1,1)='/') THEN
          BEGIN
            j:=Pos(' ',Desc);
            IF j>0 THEN
            BEGIN
              Extra:=Copy(Desc,1,j);
              Delete(Desc,1,j);
              Desc:=Trim(Desc);
            END ELSE
            BEGIN
              Extra:=Desc+' ';
              Desc:='';
            END;
          END;
          j:=Pos(CfgInfo.DlCntStop, Desc);
          IF (Copy(Desc,1,1)=CfgInfo.DlCntStart) AND (j>0) THEN
          BEGIN
            Val(Copy(Desc, 2, j-2), Num, Err);
            IF Err<>0 THEN Num:=0;
            Delete(Desc, 1, j);
            Desc:=Trim(Desc);
          END;
        END;
        s:=Pad(Copy(s,1,i),13)+Extra+MakeDlCnt(Num)+' '+Desc;
      END;
    END;
  END;

  PROCEDURE DelDLC(VAR s: STRING);
  VAR
    Start,
    Slut  : Byte;
  BEGIN
    IF HasFileName(s) THEN
    BEGIN
      AddDLC(s);
      Start:=Pos(CfgInfo.DlCntStart, s);
      Slut:=Pos(CfgInfo.DlCntStop, s);
      IF (Slut<Length(s)) AND (s[Start-1]=' ') AND (s[Slut+1]=' ') THEN Inc(Slut);
      Delete(s, Start, Slut-Start+1);
    END;
  END;

  PROCEDURE IncDLC(VAR s: STRING; Count: Byte);
  VAR
    Num   : LongInt;
    Start,
    Slut  : Byte;
    Err   : Integer;
  BEGIN
    IF HasFileName(s) THEN
    BEGIN
      AddDLC(s);

      Start:=Pos(CfgInfo.DlCntStart, s);
      Slut:=Pos(CfgInfo.DlCntStop, s);
      Val(Trim(Copy(s, Start+1, Slut-Start-1)), Num, Err);
      IF Err=0 THEN
        s:=Copy(s, 1, Start-1)+MakeDlCnt(Num+Count)+Copy(s, Slut+1, 255);
    END;
  END;

  PROCEDURE ZeroDLC(VAR s: STRING);
  BEGIN
    IF HasFileName(s) THEN
    BEGIN
      DelDLC(s);
      AddDLC(s);
    END;
  END;

  FUNCTION  GetDLC(s: STRING): LongInt;
  VAR
    Num   : LongInt;
    Start,
    Slut  : Byte;
    Err   : Integer;
  BEGIN
    Num:=0;
    IF HasFileName(s) THEN
    BEGIN
      AddDLC(s);
      Start:=Pos(CfgInfo.DlCntStart, s);
      Slut:=Pos(CfgInfo.DlCntStop, s);
      Val(Trim(Copy(s, Start+1, Slut-Start-1)), Num, Err);
      IF Err<>0 THEN Num:=0;
    END;
    GetDLC:=Num;
  END;



  FUNCTION UnixToDateStr(UDate: LongInt): String;
  VAR
    Year, Month, Day,
    Hour, Min, Sec    : Word;
    MinStr, SecStr    : String[3];
  BEGIN
    UnPackUnix(UDate, Year, Month, Day, Hour, Min, Sec);
    Str(Min,MinStr);
    If Min<10 THEN MinStr:='0'+MinStr;
    Str(Sec,SecStr);
    If Sec<10 THEN SecStr:='0'+SecStr;
    Write(TpStr,Day, '/', Month, '-', Year, '  ', Hour, ':', MinStr, ':', SecStr);
    UnixToDateStr:=ReturnStr;
  END;

  FUNCTION ConvertDate(DateStr : String) : LongInt;
  VAR
    Year, Month, Day, DoW,
    Hour, Min, Sec : Word;
    Temp           : String[5];
    ok             : Integer;
  BEGIN
    IF Length(DateStr)<>15 THEN
    BEGIN
      Convertdate:=0;
      Exit;
    END;
    GetDate(Year, Month, Day, DoW);
    Temp := Copy(DateStr, 1, 2);
    Val(Temp, Day, ok);
    Temp := Copy(DateStr, 4, 3);
    Month := 1;
    WHILE (Month < 12) AND (MonthName[Month] <> Temp) DO
      Inc(Month);
    IF Month = 13 THEN
    BEGIN
      ConvertDate := 0;
      Exit;
    END;
    Temp := Copy(DateStr, 8, 2);
    Val(Temp, Hour, ok);
    Temp := Copy(DateStr, 11, 2);
    Val(Temp, Min, ok);
    Temp := Copy(DateStr, 14, 2);
    Val(Temp, Sec, ok);
    ConvertDate := GetUnixDate(Year, Month, Day, Hour, Min, Sec);
  END;

  PROCEDURE ReadCfgFile;
  VAR
    f   : FILE OF TConfig;
    Cfg : TConFig;
    i   : Byte;
  BEGIN
    LogFileNum:=1;
    IF ParamCount>0 THEN
    BEGIN
      FOR i:=1 TO ParamCount DO
      BEGIN
        IF ParamStr(i)='00' THEN
          Assign(f, 'PORTAL.CFG')
        ELSE
          Assign(f, 'PORTAL'+ParamStr(i)+'.CFG');
        Reset(f);
        IF IOResult=0 THEN
        BEGIN
          Read(f, Cfg);
          IF Cfg.Version=CfgVersion THEN
          BEGIN
            IF LogFileNum>10 THEN
            BEGIN
              WriteLn('Too many logfiles');
              Break
            END;
            IF LogFileNum=1 THEN
            BEGIN
              CfgInfo.Outbound:=Cfg.Outbound;
              CfgInfo.BBSType:=Cfg.BBS.BBSType;
              CfgInfo.DlCntStart:=Cfg.AreaMan.DlCntStart;
              CfgInfo.DlCntStop:=Cfg.AreaMan.DlCntStop;
              CfgInfo.InsDlCnt:=Cfg.AreaMan.InsDlCnt;
              CfgInfo.DlCDigits:=Cfg.AreaMan.DlCDigits;
              CfgInfo.DlCZeroFill:=Cfg.AreaMan.DlCZeroFill;
            END;
            CfgInfo.LogFile[LogFileNum]:=Cfg.LogFileName;
            Inc(LogFileNum);
          END ELSE
            WriteLn('Wrong config file version for: PORTAL'+ParamStr(i)+'.CFG');
          Close(f);
        END ELSE
          WriteLn('Portal config file not found: PORTAL'+ParamStr(i)+'.CFG');
      END;
    END;

    IF LogFileNum=1 THEN
    BEGIN
      TextColor(Yellow);
      IF ParamCount>0 THEN WriteLn;
      WriteLn('USAGE:   POPDLC {Task}');
      WriteLn;
      WriteLn('EXAMPLE: POPDLC 01 02');
      WriteLn('         Count downloads for task 1 and 2 (use 00 for task 0)');
      NormVideo;
      Halt;
    END;
  END;

  PROCEDURE ReadNotePad;
  VAR
    DataFile : FILE OF TNotePad;
  BEGIN
    IF IOResult<>0 THEN WriteLn('I/O Error before reading notepadfile');
    Assign(DataFile, NotePadFileName);
    Reset(DataFile);
    IF IoResult <> 0 THEN
      FillChar(DataRec, SizeOf(DataRec), 0)
    ELSE
    BEGIN
      Read(DataFile, DataRec);
      IF IOResult<>0 THEN WriteLn('Error reading notepadfile');
      Close(DataFile);
    END;
  END;

  PROCEDURE WriteNotePad;
  VAR
    DataFile : FILE OF TNotePad;
  BEGIN
    IF IOResult<>0 THEN WriteLn('I/O Error before writing notepadfile');
    Assign(DataFile, NotePadFileName);
    Rewrite(DataFile);
    Write(DataFile, DataRec);
    Close(DataFile);
  END;

  PROCEDURE InsertFile(Path, Name : String);
  VAR
    Current, Next, NewFile : FileListPtr;
  BEGIN
    Path:=StUpCase(Path);
    Name:=StUpCase(Name);
    FileList := FirstFile;
    IF FileList = NIL THEN
    BEGIN
      New(FileList);
      FileList^.FilePath := Path;
      FileList^.FileName := Name;
      FileList^.Next := NIL;
      FirstFile := FileList;
    END ELSE
    BEGIN
      Current := NIL;
      WHILE (FileList <> NIL) AND (Path >= FileList^.FilePath) DO
      BEGIN
        Current := FileList;
        FileList := FileList^.Next;
      END;
      IF FileList = NIL THEN
      BEGIN
        New(FileList);
        FileList^.FilePath := Path;
        FileList^.FileName := Name;
        FileList^.Next := NIL;
        NewFile := FileList;
        FileList := Current;
        FileList^.Next := NewFile;
      END ELSE
      BEGIN
        Next := FileList;
        New(FileList);
        FileList^.FilePath := Path;
        FileList^.FileName := Name;
        FileList^.Next := Next;
        IF Next = FirstFile THEN FirstFile := FileList;
        IF Current <> NIL THEN
        BEGIN
          NewFile := FileList;
          FileList := Current;
          FileList^.Next := NewFile;
        END;
      END;
    END;
  END;

  PROCEDURE ReadLine(VAR f: File; VAR s: String);
  VAR
    OldPos : LongInt;
    Buf    : Array[0..254] Of Char;
    Test   : Integer;
    i      : Byte;
  BEGIN
    S:='';
    OldPos:=FilePos(f);
    BlockRead(f,Buf,SizeOf(Buf),Test);
    i:=0;
    WHILE (Test<>0) And (i<Test) AND (Buf[i]<>#10) DO
    BEGIN
      IF (Buf[i]<>#10) AND (Buf[i]<>#13) THEN S:=S+Buf[i];
      Inc(i);
    END;
    Seek(f,OldPos+i+1);
    IF IoResult<>0 THEN ;
  END;

  PROCEDURE ScanLogFile(LogFileNum: Byte);
  VAR
    LogFile        : File;
    LogFileName    : PathStr;
    FrontChar	   : Char;
    Request,LogProg	: String[10];
    FileName, Dir,
    Name, Ext, InStr : String;
    LogDate,
    NewLogDate,
    Line  :         LongInt;
    i : Byte;
  BEGIN
    LogFileName:=CfgInfo.LogFile[LogFileNum];
    Assign(LogFile, LogFileName); FileMode:=ShareRead+ShareDenyNone;
    Reset(LogFile,1);
    IF IoResult <> 0 THEN
    BEGIN
      WriteLn('The logfile: ',LogFileName,' does not exist');
      WriteLn;
      Exit;
    END;
    Line := 1;
    NewLogDate:=0;
    TextColor(LightBlue);
    Write('Scanning: ',JustFileName(LogFileName),' starting at:');
    TextColor(Yellow);
    IF DataRec.Logs[LogFileNum].LastDate<>0 THEN
    BEGIN
      WriteLn(' ',UnixToDateStr(DataRec.Logs[LogFileNum].LastDate));
    END ELSE
      WriteLn(' The beginning');
    TextColor(Cyan);
    WHILE NOT Eof(LogFile) DO
    BEGIN
      ReadLine(LogFile, InStr);
      LogDate := ConvertDate(Copy(InStr, 3, 15));
      IF LogDate<>0 THEN NewLogDate:=LogDate;
      IF (LogDate>DataRec.Logs[LogFileNum].LastDate) AND (LogDate<>0) THEN
      BEGIN
        FrontChar:=Instr[1];
        InStr:=Copy(Instr,19,Length(Instr)-18);
        LogProg:=Copy(Instr,1,Pos(' ',Instr)-1);
        InStr:=Trim(Copy(InStr,Length(LogProg)+2,Length(InStr)-Length(LogProg)));

        IF (LogProg='OPUS') OR (LogProg='MAX') THEN
        BEGIN
          IF (FrontChar = '=') AND (Copy(InStr, 1, 3) = 'DL-') THEN
          BEGIN
            FSplit(Copy(InStr, 6, Length(InStr) - 5), Dir, Name, Ext);
            InsertFile(Dir, Name+Ext);
          END;
        END;
        IF (LogProg='PORTAL') AND (FrontChar='+') AND (Copy(InStr,1,5)='Sent-') THEN
        BEGIN
          i:=Pos(' ',InStr);
          FSplit(Copy(InStr, i+1, Length(InStr)-i), Dir, Name, Ext);
          { Don't add files sent from outbound(s) }
          IF CfgInfo.Outbound<>StUpCase(Copy(Dir+'\',1,Length(CfgInfo.Outbound))) THEN
            InsertFile(Dir, Name+Ext);
        END;
        Write('+', Line:6, #13);
        IF MaxAvail<10240 THEN Break;
      END ELSE
        IF LogDate<>0 THEN Write('-', Line:6, #13);
      Inc(Line);
    END;
    DataRec.Logs[LogFileNum].LastDate:=NewLogDate;
    Close(LogFile);
    WriteLn;
    WriteLn;
  END;


  PROCEDURE UpdateFilesBbs(Path : String; AreaArray : AreaType);
  VAR
    FilesBbs,
    NewFilesBbs    : Text;
    InStr, OutStr  : String;
    FileName       : String[13];
    Count, NewCount: String[4];
    i              : Byte;
    ok             : Integer;
    NCount         : Word;
    InBuf, OutBuf  : ARRAY[1..4096] of Char;
  BEGIN
    Assign(FilesBbs, Path + 'FILES.BBS');
    Reset(FilesBbs);
    IF IoResult <> 0 THEN
    BEGIN
      TextColor(LightRed);
      WriteLn('No FILES.BBS found in ',Path);
      TextColor(Cyan);
      Exit;
    END;
    SetTextBuf(FilesBbs, InBuf);
    Assign(NewFilesBbs, Path+'FILES.DLC');
    Rewrite(NewFilesBbs);
    SetTextBuf(NewFilesBbs, OutBuf);
    WHILE NOT Eof(FilesBbs) DO
    BEGIN
      ReadLn(FilesBbs, InStr);
      IF HasFileName(InStr) THEN
      BEGIN
        IF Pos(' ', InStr) = 0 THEN
          FileName:=InStr
        ELSE
          FileName:=Copy(InStr, 1, Pos(' ', InStr) - 1);
        i := 1;
        WHILE (AreaArray[i].FileName<>FileName) AND (AreaArray[i].FileName<>'') DO
          Inc(i);
        IF AreaArray[i].FileName <> '' THEN
          IncDlC(InStr, AreaArray[i].Count)
        ELSE
          IF CfgInfo.InsDlCnt THEN AddDlc(InStr);
      END;
      WriteLn(NewFilesBbs, InStr);
{!}   IF IOResult<>0 THEN
      BEGIN
        Close(FilesBBS);
        Close(NewFilesBBS); Erase(NewFilesBBS);
        WriteLn('Can''t write '+Path+'FILES.BBS - Program aborted!');
        NormVideo;
        Halt;
      END;
    END;
    Close(FilesBbs);
    Erase(FilesBbs);
    Close(NewFilesBbs);
    Rename(NewFilesBbs, Path + 'FILES.BBS');
  END;

  PROCEDURE ProcessFilesBbs;
  VAR
    i              : Byte;
    OldPath        : PathStr;
    Count          : Word;
    OldFileName    : S12;
    AreaArray      : AreaType;
  BEGIN
    FileList := FirstFile;
    REPEAT
      FillChar(AreaArray, SizeOf(AreaArray), 0);
      OldPath := FileList^.FilePath;
      TextColor(Brown);
      WriteLn('Processing FILES.BBS in: '+OldPath);
      REPEAT
        OldFileName := FileList^.FileName;
        Count := 0;
        REPEAT
          Inc(Count);
          FileList := FileList^.Next;
        UNTIL (OldFileName <> FileList^.FileName);
        i := 1;
        WHILE (AreaArray[i].FileName <> OldFileName) AND (AreaArray[i].FileName <> '') DO
          Inc(i);
        IF AreaArray[i].FileName = '' THEN
        BEGIN
          AreaArray[i].FileName := OldFileName;
          AreaArray[i].Count := Count;
        END ELSE
          Inc(AreaArray[i].Count, Count);

      UNTIL OldPath <> FileList^.FilePath;
      UpdateFilesBbs(OldPath, AreaArray);
      i := 1;
      TextColor(Magenta);
      REPEAT
        Write('  ', Pad(AreaArray[i].FileName, 13), AreaArray[i].Count:4, ' ');
        Inc(i);
      UNTIL AreaArray[i].FileName = '';
      TextColor(Cyan);
      WriteLn; WriteLn;
    UNTIL FileList = NIL;
  END;

  PROCEDURE Init;
  VAR
    Year, Month, Day,
    DoW, Hour, Min,
    Sec, Sec100    : Word;
  BEGIN
    FileList := NIL;
    FirstFile := FileList;
    TextColor(LightGreen);
    IF DataRec.LastRun <> 0 THEN
      WriteLn('Last session was ', UnixToDateStr(DataRec.LastRun))
    ELSE
      WriteLn('First run');
    WriteLn;
    TextColor(Cyan);
    GetDate(Year, Month, Day, DoW);
    GetTime(Hour, Min, Sec, Sec100);
    DataRec.LastRun := GetUnixDate(Year, Month, Day, Hour, Min, Sec);
  END;

BEGIN
  DirectVideo:=True;
  CheckBreak:=False;
  WriteCopyRight;
  ReadCfgFile;
  ReadNotePad;
  Init;
  LogFileNum:=1;
  WHILE (LogFileNum<=10) AND (CfgInfo.LogFile[LogFileNum]<>'') DO
  BEGIN
    ScanLogFile(LogFileNum);
    Inc(LogFileNum);
  END;
  IF FirstFile <> NIL THEN
    ProcessFilesBbs
  ELSE
  BEGIN
    TextColor(LightGray);
    WriteLn('No new downloads found');
    WriteLn;
  END;
  WriteNotePad;
  TextColor(White);
  WriteLn('Done!');
  NormVideo;
END.
