PROGRAM ShowStat;
{ͻ}
{ Shows statistics from PORTAL.STA              Last changed: 31.03.93  SA }
{                                                                          }
{                         (C) Copyright 1989-93 by                         }
{       Dan Wulff, Jens Sandalgaard, Steen Christensen & Sren Ager        }
{                                                                          }
{ This source can be distributed freely, as long as it is done in a        }
{ lawfull and friendly manner.                                             }
{ͼ}

USES Dos, OpCrt, OpDate, OpString, PoPTypes, Misc;

CONST
  MaxNum = 3;

VAR
  MaxLines,i,j : Byte;
  StatRec : TPortalStat;
  StatFil : File Of TPortalStat;
  Pct : Array[0..6,0..23] Of Real;
  TotPct,MaxPct : Real;
  Secs,TotalHours : LongInt;
  Days: Word;
  Delta : Real;
  Out : Text;
  Err : Integer;
  D1 : DateTimeRec;

  FUNCTION Legend(Hour: Byte; CurPct: Real): String;

    FUNCTION Sum(Num, Hour: Byte): Real;
    VAR
      I : Byte;
      r : Real;
    BEGIN
      IF Pct[Num,Hour]=0.0 THEN
      BEGIN
        Sum:=0.0;
      END ELSE
      BEGIN
        r:=0.0;
        FOR i:=0 TO Num DO
          r:=r+Pct[i,Hour];
        Sum:=r;
      END;
    END;

  BEGIN
    IF CurPct=0.0 THEN Legend:='   ' ELSE
      IF Sum(0,Hour)>=CurPct THEN Legend:=' ' ELSE
        IF Sum(1,Hour)>=CurPct THEN Legend:=' ' ELSE
          IF Sum(2,Hour)>=CurPct THEN Legend:=' ' ELSE
            IF Sum(3,Hour)>=CurPct THEN Legend:=' ' ELSE
              IF (Sum(4,Hour)>=CurPct) And (MaxNum>3) THEN Legend:='## ' ELSE
                IF (Sum(5,Hour)>=CurPct) And (MaxNum>4) THEN Legend:='** ' ELSE
                  IF (Sum(6,Hour)>=CurPct) And (MaxNum>5) THEN Legend:='++ ' ELSE Legend:='   ';
  END;

  FUNCTION Extra(Hour: Byte): Byte;
  VAR
    StartHour, StartMin, StartSec, EndHour, EndMin, EndSec : Byte;
    i : Byte;
  BEGIN
    TimeToHMS(StatRec.Start.T,StartHour,StartMin,StartSec);
    TimeToHMS(D1.T,EndHour,EndMin,EndSec);
    i:=0;
    IF StatRec.Start.T>D1.T THEN
    BEGIN
      IF Hour=StartHour THEN i:=60-StartMin ELSE
        IF (Hour>StartHour) Or (Hour<EndHour) THEN i:=60 ELSE
          IF Hour=EndHour THEN i:=EndMin;
    END ELSE
    BEGIN
      IF Hour=StartHour THEN i:=60-StartMin ELSE
        IF (Hour>StartHour) And (Hour<EndHour) THEN i:=60 ELSE
          IF Hour=EndHour THEN i:=EndMin;
    END;
    IF i=0 THEN i:=1;
    Extra:=i;
  END;

  FUNCTION GetHours(j,i: Byte): LongInt;
  VAR
    l : LongInt;
    Day : DayType;
  BEGIN
    l:=0;
    FOR Day:=Sunday TO Saturday DO
      Inc(l, StatRec.Usage[j,Day,i]);
    GetHours:=l;
  END;


BEGIN
  Assign(StatFil, 'PORTAL'+GetPoPTask+'.STA'); Reset(StatFil);
  IF IOResult=0 THEN
  BEGIN
    Read(StatFil,StatRec); Close(StatFil);
    FillChar(MaxPct, SizeOf(MaxPct), 0);
    D1.T:=CurrentTime;
    D1.D:=Today;
    DateTimeDiff(D1,StatRec.Start,Days,Secs);
    TotalHours:=Days*60;
    FOR i:=0 TO 23 DO
    BEGIN
      TotPct:=0.0;
      FOR j:=0 TO MaxNum DO
      BEGIN
        Pct[j,i]:=GetHours(j,i)/(TotalHours+Extra(i))*100;
        TotPct:=TotPct+Pct[j,i];
      END;
      IF TotPct>MaxPct THEN MaxPct:=TotPct;
    END;
    Assign(Out,''); ReWrite(Out);
    IF TextRec(Out).Handle=1 THEN MaxLines:=ScreenHeight-6 ELSE MaxLines:=19;
    Delta:=MaxPct/MaxLines;
    WriteLn(Out,CharStr(' ',15),'BBS Usage statistic since: ',DateToDateString('dd.mm.yyyy',StatRec.Start.D),
                '  ',TimeToTimeString('hh:mm',StatRec.Start.T),'  Task: '+GetPoPTask);
    WriteLn(Out,'  %     Legend: =Users    =Mail In    =Mail Out    =Mail Processing');
    FOR i:=0 TO MaxLines-1 DO
    BEGIN
      Write(Out,MaxPct-(i*delta):3:0,'  ');
      FOR j:=0 TO 23 DO
        Write(Out,Legend(j,MaxPct-(i*Delta)));
      WriteLn(Out);
    END;
    WriteLn(Out,'    ',CharStr('',72));
    Write(Out,'      ');
    FOR j:=0 TO 23 DO
      Write(Out,j:2,' ');
    WriteLn(Out);
    Close(Out);
  END;
END.
