.TH DU 1L "GNU File Utilities" "FSF" \" -*- nroff -*-
.SH NAME
du \- summarize disk usage
.SH SYNOPSIS
.B du
[\-abcklsxDLS] [\-\-all] [\-\-total] [\-\-count-links] [\-\-summarize]
[\-\-bytes] [\-\-kilobytes] [\-\-one-file-system] [\-\-separate-dirs]
[\-\-dereference] [\-\-dereference-args] [\-\-help] [\-\-version] [path...]
.SH DESCRIPTION
This manual page
documents the GNU version of
.BR du .
.B du
displays the amount of disk space used by each argument and for each
subdirectory of directory arguments.  The space is measured in 1K
blocks by default, unless the environment variable POSIXLY_CORRECT is
set, in which case 512-byte blocks are used.
.SS OPTIONS
.TP
.I "\-a, \-\-all"
Display counts for all files, not just directories.
.TP
.I "\-b, \-\-bytes"
Print sizes in bytes.
.TP
.I "\-c, \-\-total"
Write a grand total of all of the arguments after all
arguments have been processed.  This can be used to find
out the disk usage of a directory, with some files excluded.
.TP
.I "\-k, \-\-kilobytes"
Print sizes in kilobytes.  This overrides the environment variable
POSIXLY_CORRECT.
.TP
.I "\-l, \-\-count-links"
Count the size of all files, even if they have appeared already in
another hard link.
.TP
.I "\-s, \-\-summarize"
Display only a total for each argument.
.TP
.I "\-x, \-\-one-file-system"
Skip directories that are on different filesystems from the one that
the argument being processed is on.
.TP
.I "\-D, \-\-dereference-args"
Dereference symbolic links that are command line arguments.  Does not
affect other symbolic links.  This is helpful for finding out the disk
usage of directories like /usr/tmp where they are symbolic links.
.TP
.I "\-L, \-\-dereference"
Dereference symbolic links (show the disk space used by the file or
directory that the link points to instead of the space used by the
link).
.TP
.I "\-S, \-\-separate-dirs"
Count the size of each directory separately, not including the sizes
of subdirectories.
.TP
.I "\-\-help"
Print a usage message and exit with a non-zero status.
.TP
.I "\-\-version"
Print version information on standard error then exit.
.SH BUGS
On BSD systems,
.B du
reports sizes that are half the correct values for files that are
NFS-mounted from HP-UX systems.  On HP-UX systems, it reports sizes
that are twice the correct values for files that are NFS-mounted from
BSD systems.  This is due to a flaw in HP-UX; it also affects the
HP-UX
.B du
program.
