/* -----------------------------------------------------------------------

@echo off
cls
ECHO This INSTALL routine requires that you have OS/2 REXX support installed.
ECHO You should run Selective Installation from the OS/2 Setup Folder to
ECHO install REXX support before attempting to run this CMD file.
PAUSE
EXIT

   -----------------------------------------------------------------------

     TE2SETUP.CMD -- Oberon Software TE/2 Install and Setup Procedure
                     Copyright (c) 1993 by Oberon Software, Mankato, MN
                     All rights reserved

   ----------------------------------------------------------------------- */

/* ----------------------------------------------------------------------- */
'@echo off'

/* ----------------------------------------------------------------------- */
/* Load REXXUTIL */
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/* ----------------------------------------------------------------------- */
/* "Global" variables */

CopyRLine0  = 'Oberon Software TE/2 Install and Setup Procedure'
CopyRILine0 = 'Oberon Software TE/2 Install Procedure'
CopyRCLine0 = 'Oberon Software TE/2 Setup Procedure'
CopyRLine1  = 'Copyright (c) 1993 by Oberon Software, Mankato, MN'
CopyRLine2  = 'All rights reserved'

SourcePath  = ''
TargetPath  = 'C:\TE2'
TargetPath2 = ''
DLLPath     = ''
INIFileName = 'TE2.INI'
RestorePath = ''

SpaceNeeded = 1400000
SpaceAvail  = 0

AvailDrives = ''
BootDrive   = ''
LIBSubPath. = ''
DLL16Bit    = 0

ProgAction  = '0'
SetupAction = '0'

Sensitive.  = ''
Sensitive.0 = 7
Sensitive.1 = 'Te2.Dir'    ; Sensitive.1.Backup = 'Te2Dir.BAK'
Sensitive.2 = 'Te2.Fnk'    ; Sensitive.2.Backup = 'Te2Fnk.BAK'
Sensitive.3 = 'Te2.Ini'    ; Sensitive.3.Backup = 'Te2Ini.BAK'
Sensitive.4 = 'Te2.Xex'    ; Sensitive.4.Backup = 'Te2Xex.BAK'
Sensitive.5 = 'Te2INP.Xlt' ; Sensitive.5.Backup = 'Te2INP.BAK'
Sensitive.6 = 'Te2OUT.Xlt' ; Sensitive.6.Backup = 'Te2OUT.BAK'
Sensitive.7 = 'Modem.Inc'  ; Sensitive.7.Backup = 'Modem.BAK'

InstDat01   = 'TE2INST.001'
InstDat02   = 'TE2INST.002'
InstallDone = 0

TE2Device   = ''
TE2Modem    = ''
ModemFile.  = ''
ModemSelect = 0

INIVar.     = ''
INIVar.0    = 25
INIVar.1    = 'Emulate'        ; INIVar.1.Val  = 'ANSI_TE2'
INIVar.2    = 'LFafterCR'      ; INIVar.2.Val  = 'FALSE'
INIVar.3    = 'LocalEcho'      ; INIVar.3.Val  = 'FALSE'
INIVar.4    = 'ClsReset'       ; INIVar.4.Val  = 'FALSE'
INIVar.5    = 'SwapBS4Del'     ; INIVar.5.Val  = 'FALSE'
INIVar.6    = 'MenuActive'     ; INIVar.6.Val  = 'TRUE'
INIVar.7    = 'DirActive'      ; INIVar.7.Val  = 'FALSE'
INIVar.8    = 'Scrollback'     ; INIVar.8.Val  = '512'
INIVar.9    = 'LogoDelay'      ; INIVar.9.Val  = '8'
INIVar.10   = 'AutoDirSave'    ; INIVar.10.Val = 'TRUE'
INIVar.11   = 'DialerTimeOut'  ; INIVar.11.Val = '45'
INIVar.12   = 'RedialDelay'    ; INIVar.12.Val = '2'
INIVar.13   = 'DialerSendInit' ; INIVar.13.Val = 'FALSE'
INIVar.14   = 'DownloadPath'   ; INIVar.14.Val = ''
INIVar.15   = 'UploadPath'     ; INIVar.15.Val = ''
INIVar.16   = 'DLPrtyClass'    ; INIVar.16.Val = 'FIXEDHIGH'
INIVar.17   = 'ULPrtyClass'    ; INIVar.17.Val = 'FIXEDHIGH'
INIVar.18   = 'AutoZM'         ; INIVar.18.Val = 'TRUE'
INIVar.19   = 'ClobberDL'      ; INIVar.19.Val = 'SALVAGE'
INIVar.20   = 'DirFile'        ; INIVar.20.Val = 'Te2.Dir'
INIVar.21   = 'FnkFile'        ; INIVar.21.Val = 'Te2.Fnk'
INIVar.22   = 'XexFile'        ; INIVar.22.Val = 'Te2.Xex'
INIVar.23   = 'CallLog'        ; INIVar.23.Val = ''
INIVar.24   = 'SnapShot'       ; INIVar.24.Val = 'Te2Snap.Sht'
INIVar.25   = 'LogPath'        ; INIVar.25.Val = ''

AvailDrives = SysDriveMap('A:', 'USED')

do forever
  call SelectAction
  select
    when ProgAction = '0' then leave
    when ProgAction = '1' then call Install
    when ProgAction = '2' then call Configure
  end
end

call SysCls
say 'Oberon Software TE/2 INSTALL and SETUP Ended!'
say ''
say '  Oberon Software'
say '  518 Blue Earth St.'
say '  Mankato, MN 56001-2142'
say '  1-507-388-7001'
say ''
Exit 0


/* ----------------------------------------------------------------------- */

SelectAction:
  call PutCopyright 'Full'
  say ''
  say 'Select one of the following:'
  say ''
  say ''
  say '       1. Install TE/2 onto your hard disk.'
  say '       2. Configure your installed TE/2'
  say '       0. Exit this program'
  say ''
  say ''
  call charout ,'Enter 0, 1, or 2: '
  do forever
    k = SysGetKey('NOECHO')
    if k = '0' | k = '1' | k = '2' | k = D2C(27) then
      do
        if k = D2C(27) then k = '0'
        say k
        ProgAction = k
        leave
      end
    else
      call beep 1760, 50
  end
  return

/* ----------------------------------------------------------------------- */

Install:
  if BootDrive = '' then
    do
      call GetBootDrive
      if result = 0 then return
    end
  if SourcePath = '' then
    do
      parse source . . argv0 .
      temp = reverse(argv0)
      temp = substr(temp, pos('\', temp))
      if length(temp) > 3 then temp = substr(temp, 2)
      SourcePath = reverse(temp)
    end

  do forever
    parse value SysDriveInfo(substr(TargetPath, 1, 2)) with dummy SpaceAvail dummy2
    if DLLPath = '*Program Directory*' then
      tempDLLPath = TargetPath
    else
      tempDLLPath = DLLPath
    if DLL16Bit = 0 then
      tempDLL16 = '32-bit'
    else
      tempDLL16 = '16-bit'
    InstallDone = 0
    call PutCopyright 'Install'
    say ''
    say 'Select one of the following:'
    say ''
    say ''
    say '       1. Select SOURCE Path      (Current is:' SourcePath')'
    say '       2. Select TARGET Path      (Current is:' TargetPath')'
    say '       3. Select DLL    Path      (Current is:' tempDLLPath')'
    say '       4. Select 16 or 32-bit DLL (Current is:' tempDLL16')'
    say '       5. Install TE/2'
    say '       0. Quit Install Procedure'
    say ''
    say ''
    if SpaceAvail < SpaceNeeded then
      say 'NOTE: Installation requires' SpaceNeeded 'bytes on target drive, only' SpaceAvail 'available!.'
    call charout ,'Enter 0, 1, 2, 3, 4, or 5: '
    do forever
      k = SysGetKey('NOECHO')
      if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = '5' | k = D2C(27) then
        do
          if k = D2C(27) then k = '0'
          say k
          ProgAction = k
          leave
        end
      else
        call beep 1760, 50
    end
    select
      when ProgAction = '0' then leave
      when ProgAction = '1' then call AskPath 'SOURCE'
      when ProgAction = '2' then call AskPath 'TARGET'
      when ProgAction = '3' then call AskLIBPath
      when ProgAction = '4' then call AskDLL16
      when ProgAction = '5' then call DoInstall
    end
    if InstallDone \= 0 then leave
  end
  return


/* ----------------------------------------------------------------------- */

Configure:
  call CheckINIFile
  if result = 0 then return
  call GetINISettings
  do forever
    call PutCopyright 'Setup'
    say 'Note: "Modem Setup" and "Color" changes take effect immediately, for all'
    say '      others, you will be prompted whether to save on exit.'
    say ''
    say '  File:' INIFileName
    say ''
    say '    1. Select COM Device  (Current:' TE2Device')'
    say '    2. Select Modem Setup (Current:' TE2Modem')'
    say '    3. Terminal Settings'
    say '    4. Dialer Settings'
    say '    5. Protocol Settings'
    say '    6. File and Path Settings'
    say '    7. Colors'
    say '    0. Exit Setup'
    say ''
    say ''
    call charout ,'Enter 0, 1, 2, 3, 4, 5, 6, or 7: '
    do forever
      k = SysGetKey('NOECHO')
      if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = '5' | k = '6' | k = '7' | k = D2C(27) then
        do
          if k = D2C(27) then k = '0'
          say k
          SetupAction = k
          leave
        end
      else
        call beep 1760, 50
    end
    select
      when SetupAction = '0' then leave
      when SetupAction = '1' then call SelectDevice
      when SetupAction = '2' then call SelectModem
      when SetupAction = '3' then call TermSettings
      when SetupAction = '4' then call DialerSettings
      when SetupAction = '5' then call ProtoSettings
      when SetupAction = '6' then call MiscSettings
      when SetupAction = '7' then call SetupColors
    end
  end

  say ''
  call GetYN 'Save changes to the file?'
  if result = 1 then call SaveINIFile

  if RestorePath \= '' then call directory RestorePath
  return

/* ----------------------------------------------------------------------- */

TermSettings:
  do forever
    call PutCopyright 'Setup'
    say '    1. Default Emulation           ('INIVar.1.Val')'
    say '    2. LF/CRLF Conversion          ('INIVar.2.Val')'
    say '    3. Local Echo                  ('INIVar.3.Val')'
    say '    4. CLS Resets Term Color       ('INIVar.4.Val')'
    say '    5. Backspace->DEL Conversion   ('INIVar.5.Val')'
    say '    6. Menu Initially Visible      ('INIVar.6.Val')'
    say '    7. Directory Initially Visible ('INIVar.7.Val')'
    say '    8. Scroll Back Lines           ('INIVar.8.Val')'
    say '    9. Logo Delay                  ('INIVar.9.Val')'
    say '    0. Exit Terminal Settings'
    say ''
    say ''
    call charout ,'Enter 0, 1, 2, 3, 4, 5, 6, 7, 8, or 9: '
    do forever
      k = SysGetKey('NOECHO')
      if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = '5' | k = '6' | k = '7' | k = '8' | k = '9' | k = D2C(27) then
        do
          if k = D2C(27) then k = '0'
          say k
          TermAction = k
          leave
        end
      else
        call beep 1760, 50
    end
    select
      when TermAction = '0' then leave
      when TermAction = '1' then
        do
          call PutCopyright 'Setup'
          say 'Default Emulation Mode (Current is:' INIVar.1.Val')'
          say ''
          say '    1. TTY'
          say '    2. ANSI_TE2'
          say '    3. ANSI'
          say '    4. VT100'
          say '    5. 3101'
          say '    0. No change'
          say ''
          say ''
          call charout ,'Enter 0, 1, 2, 3, 4, or 5: '
          do forever
            k = SysGetKey('NOECHO')
            if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = '5' | k = D2C(27) then
              do
                if k = D2C(27) then k = '0'
                say k
                TermAction1 = k
                leave
              end
            else
              call beep 1760, 50
          end
          select
            when TermAction1 = '1' then INIVar.1.Val = 'TTY'
            when TermAction1 = '2' then INIVar.1.Val = 'ANSI_TE2'
            when TermAction1 = '3' then INIVar.1.Val = 'ANSI'
            when TermAction1 = '4' then INIVar.1.Val = 'VT100'
            when TermAction1 = '5' then INIVar.1.Val = '3101'
            otherwise nop
          end
        end
      when TermAction = '8' then
        do
          call AskNumber 0, 32767, 'Scroll Back Lines'
          if result \= '' then INIVar.8.Val = result
        end
      when TermAction = '9' then
        do
          call AskNumber 0, 32767, 'Logo Delay'
          if result \= '' then INIVar.9.Val = result
        end
      otherwise
        do
          ta = TermAction
          if INIVar.ta.Val = 'TRUE' then
            INIVar.ta.Val = 'FALSE'
          else
            INIVar.ta.Val = 'TRUE'
        end
    end
  end
  return

/* ----------------------------------------------------------------------- */

DialerSettings:
  do forever
    call PutCopyright 'Setup'
    say '    1. Auto Save Directory File    ('INIVar.10.Val')'
    say '    2. Dialer Timeout              ('INIVar.11.Val')'
    say '    3. Redial Delay                ('INIVar.12.Val')'
    say '    4. Dialer Sends Modem Init     ('INIVar.13.Val')'
    say '    0. Exit Dialer Settings'
    say ''
    call charout ,'Enter 0, 1, 2, 3, or 4: '
    do forever
      k = SysGetKey('NOECHO')
      if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = D2C(27) then
        do
          if k = D2C(27) then k = '0'
          say k
          DialAction = k
          leave
        end
      else
        call beep 1760, 50
    end
    select
      when DialAction = '0' then leave
      when DialAction = '2' then
        do
          call AskNumber 1, 32767, 'Dialer Timeout'
          if result \= '' then INIVar.11.Val = result
        end
      when DialAction = '3' then
        do
          call AskNumber 1, 32767, 'Redial Delay'
          if result \= '' then INIVar.12.Val = result
        end
      otherwise
        do
          da = DialAction + 9
          if INIVar.da.Val = 'TRUE' then
            INIVar.da.Val = 'FALSE'
          else
            INIVar.da.Val = 'TRUE'
        end
    end
  end
  return

/* ----------------------------------------------------------------------- */

ProtoSettings:
  do forever
    call PutCopyright 'Setup'
    say '    1. Download Path               ('INIVar.14.Val')'
    say '    2. Upload Path                 ('INIVar.15.Val')'
    say '    3. Download Priority           ('INIVar.16.Val')'
    say '    4. Upload Priority             ('INIVar.17.Val')'
    say '    5. Automatic ZModem Start      ('INIVar.18.Val')'
    say '    6. Name Collision on Download  ('INIVar.19.Val')'
    say '    0. Exit Protocol Settings'
    say ''
    call charout ,'Enter 0, 1, 2, 3, 4, 5, or 6: '
    do forever
      k = SysGetKey('NOECHO')
      if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = '5' | k = '6' | k = D2C(27) then
        do
          if k = D2C(27) then k = '0'
          say k
          ProtoAction = k
          leave
        end
      else
        call beep 1760, 50
    end
    select
      when ProtoAction = '0' then leave
      when ProtoAction = '1' then
        do
          call AskPath2 'Enter Download Path: ', INIVar.14.Val, 'CREATE'
          if result \= '' then INIVar.14.Val = result
          if INIVar.14.Val = 'nul' then INIVar.14.Val = ''
        end
      when ProtoAction = '2' then
        do
          call AskPath2 'Enter Upload Path: ', INIVar.15.Val, 'CREATE'
          if result \= '' then INIVar.15.Val = result
          if INIVar.15.Val = 'nul' then INIVar.15.Val = ''
        end
      when ProtoAction = '5' then
        do
          if INIVar.18.Val = 'TRUE' then
            INIVar.18.Val = 'FALSE'
          else
            INIVar.18.Val = 'TRUE'
        end
      when ProtoAction = '6' then
        do
          call PutCopyright 'Setup'
          say 'Name Collision on Download (Current is:' INIVar.19.Val')'
          say ''
          say '    1. SALVAGE (rename existing file)'
          say '    2. TRUE    (overwrite existing file)'
          say '    3. FALSE   (fail is file exists)'
          say '    0. No change'
          say ''
          say ''
          call charout ,'Enter 0, 1, 2, or 3: '
          do forever
            k = SysGetKey('NOECHO')
            if k = '0' | k = '1' | k = '2' | k = '3' | k = D2C(27) then
              do
                if k = D2C(27) then k = '0'
                say k
                ProtoAction1 = k
                leave
              end
            else
              call beep 1760, 50
          end
          select
            when ProtoAction1 = '1' then INIVar.19.Val = 'SALVAGE'
            when ProtoAction1 = '2' then INIVar.19.Val = 'TRUE'
            when ProtoAction1 = '3' then INIVar.19.Val = 'FALSE'
            otherwise nop
          end
        end
      otherwise
        do
          pa = ProtoAction + 13
          call PutCopyright 'Setup'
          if pa = 16 then
            say 'Download Priority Class (Current is:' INIVar.16.Val')'
          else
            say 'Upload Priority Class (Current is:' INIVar.17.Val')'
          say ''
          say '    1. IDLE'
          say '    2. NORMAL'
          say '    3. FIXEDHIGH'
          say '    4. TIMECRITICAL'
          say '    0. No change'
          say ''
          say ''
          call charout ,'Enter 0, 1, 2, 3, or 4: '
          do forever
            k = SysGetKey('NOECHO')
            if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = D2C(27) then
              do
                if k = D2C(27) then k = '0'
                say k
                ProtoAction1 = k
                leave
              end
            else
              call beep 1760, 50
          end
          select
            when ProtoAction1 = '1' then INIVar.pa.Val = 'IDLE'
            when ProtoAction1 = '2' then INIVar.pa.Val = 'NORMAL'
            when ProtoAction1 = '3' then INIVar.pa.Val = 'FIXEDHIGH'
            when ProtoAction1 = '4' then INIVar.pa.Val = 'TIMECRITICAL'
            otherwise nop
          end
        end
    end
  end
  return

/* ----------------------------------------------------------------------- */

MiscSettings:
  do forever
    call PutCopyright 'Setup'
    say '    1. Dialing Directory            ('INIVar.20.Val')'
    say '    2. Function Key Definitions     ('INIVar.21.Val')'
    say '    3. External Program Definitions ('INIVar.22.Val')'
    say '    4. Call Log File                ('INIVar.23.Val')'
    say '    5. Snap Shot File               ('INIVar.24.Val')'
    say '    6. Log File Path                ('INIVar.25.Val')'
    say '    0. Exit File and Path Settings'
    say ''
    call charout ,'Enter 0, 1, 2, 3, 4, 5, or 6: '
    do forever
      k = SysGetKey('NOECHO')
      if k = '0' | k = '1' | k = '2' | k = '3' | k = '4' | k = '5' | k = '6' | k = D2C(27) then
        do
          if k = D2C(27) then k = '0'
          say k
          MiscAction = k
          leave
        end
      else
        call beep 1760, 50
    end
    select
      when MiscAction = '0' then leave
      when MiscAction = '6' then
        do
          call AskPath2 'Enter Log File Path: ', INIVar.25.Val, 'CREATE'
          if result \= '' then INIVar.25.Val = result
          if INIVar.25.Val = 'nul' then INIVar.25.Val = ''
        end
      otherwise
        do
          ma = MiscAction + 19
          say ''
          select
            when ma = 20 then say 'Enter Dialing Directory File Name'
            when ma = 21 then say 'Enter Function Key definition File Name'
            when ma = 22 then say 'Enter External Program Definition File Name'
            when ma = 23 then say 'Enter Call Log File Name'
            when ma = 24 then say 'Enter Snap Shot File Name'
          end
          say 'Current value is "'INIVar.ma.Val'", press ENTER to leave unchanged or'
          call charout ,'type new value: '
          r = linein('stdin')
          if length(r) \= 0 then INIVar.ma.val = r
        end
    end
  end
  return

/* ----------------------------------------------------------------------- */

AskPath:
parse arg apType
  cwd = directory()
  do forever
    call SysCls
    say 'Select' apType 'Path'
    say ''
    say 'Current setting is:'
    if apType = 'SOURCE' then
      say '    ' SourcePath
    else
      say '    ' TargetPath
    say ''
    call charout ,'Enter new setting (press ENTER to leave unchanged): '
    np = linein('stdin')
    np = strip(np, 'B')
    if length(np) = 0 then
      leave
    else
      do
        if substr(np, length(np), 1) = '\' then
          do
            if (np = '\') | (length(np) = 3 & substr(np, 2, 1) = ':') then
              nop
            else
              np = substr(np, 1, length(np) - 1)
          end
        if np = '..' & length(cwd) > 3 then
          do
            temp = reverse(cwd)
            temp = substr(temp, pos('\', temp)+1)
            np = reverse(temp)
          end
        if np = '.' then np = cwd
        if substr(np, 2, 1) \= ':' then
          do
            if substr(np, 1, 1) = '\' then
              np = substr(cwd, 1, 2) || np
            else
              np = cwd || '\' || np
          end
        if pos(translate(substr(np, 1, 2)), AvailDrives) = 0 then
          do
            call beep 1760, 50
            say ''
            say 'Invalid drive letter "'substr(np, 1, 2)'"'
            call charout ,'Press any key...'
            call SysGetKey 'NOECHO'
          end
        else
          do
            testnp = directory(np)
            if translate(testnp) = translate(np) then
              do
                call directory cwd
                if apType = 'SOURCE' then
                  SourcePath = testnp
                else
                  TargetPath = testnp
                leave
              end
            else
              do
                call beep 1760, 50
                say ''
                say 'Directory path "'np'" does not exist!'
                if apType = 'SOURCE' then
                  do
                    call charout ,'Press any key...'
                    call SysGetKey 'NOECHO'
                  end
                else
                  do
                    call GetYN 'Create it?'
                    if result = '1' then
                      do
                        r = SysMkDir(np)
                        if r = 0 then
                          do
                            testnp = directory(np)
                            call directory cwd
                            if apType = 'SOURCE' then
                              SourcePath = testnp
                            else
                              TargetPath = testnp
                            leave
                          end
                        else
                          do
                            say 'Cannot create directory "'np'"'
                            call charout, 'Press any key...'
                            call SysGetKey 'NOECHO'
                          end
                      end
                  end
              end
          end
      end
  end
  return


AskPath2:
parse arg ap2Prompt, ap2Current, ap2Flag
  cwd = directory()
  do forever
    say ap2Prompt
    say ''
    say 'Current setting is:' ap2Current
    say ''
    if ap2Flag = 'MUSTEXIST' then
      say 'Enter new setting (press ENTER to leave unchanged)'
    else
      say 'Enter new setting (press ENTER to leave unchanged, type "NUL" to clear)'
      call charout ,'> '
    np = linein('stdin')
    np = strip(np, 'B')
    testnp = ''
    if length(np) = 0 then
      leave
    else
      do
        if substr(np, length(np), 1) = '\' then
          do
            if (np = '\') | (length(np) = 3 & substr(np, 2, 1) = ':') then
              nop
            else
              np = substr(np, 1, length(np) - 1)
          end
        if np = '..' & length(cwd) > 3 then
          do
            temp = reverse(cwd)
            temp = substr(temp, pos('\', temp)+1)
            np = reverse(temp)
          end
        if np = '.' then np = cwd
        if translate(np) = 'NUL' then
          do
            testnp = 'nul'
            leave
          end
        if substr(np, 2, 1) \= ':' then
          do
            if substr(np, 1, 1) = '\' then
              np = substr(cwd, 1, 2) || np
            else
              np = cwd || '\' || np
          end
        if pos(translate(substr(np, 1, 2)), AvailDrives) = 0 then
          do
            call beep 1760, 50
            say ''
            say 'Invalid drive letter "'substr(np, 1, 2)'"'
            call charout ,'Press any key...'
            call SysGetKey 'NOECHO'
            say ''
          end
        else
          do
            testnp = directory(np)
            if translate(testnp) = translate(np) then
              do
                call directory cwd
                leave
              end
            else
              do
                call beep 1760, 50
                say ''
                say 'Directory path "'np'" does not exist!'
                if ap2Flag \= 'CREATE' then
                  do
                    call charout ,'Press any key...'
                    call SysGetKey 'NOECHO'
                    testnp = ''
                    say ''
                  end
                else
                  do
                    call GetYN 'Create it?'
                    if result = '1' then
                      do
                        r = SysMkDir(np)
                        if r = 0 then
                          do
                            testnp = directory(np)
                            call directory cwd
                            leave
                          end
                        else
                          do
                            say 'Cannot create directory "'np'"'
                            call charout, 'Press any key...'
                            call SysGetKey 'NOECHO'
                            testnp = ''
                            say ''
                          end
                      end
                    else
                      testnp = ''
                  end
              end
          end
      end
  end
  return testnp


/* ----------------------------------------------------------------------- */

GetBootDrive: /* procedure expose BootDrive AvailDrives DLLPath LIBSubPath */
  gbdRC = -1
  do while gbdRC = -1
    call PutCopyright 'Full'
    say '    Please enter the drive letter for your boot drive.'
    call charout ,'    Press the letter for the drive or ESC to quit: '
    do forever
      k = translate(SysGetKey('NOECHO'))
      if k = D2C(27) then
        do
          gbdRC = 0
          leave
        end
      else
        do
          if k = D2C(13) then k = 'C'
          k = k||':'
          if pos(k, AvailDrives) = 0 then
            call beep 1760, 50
          else
            do
              call SysFileTree k||'\Config.Sys', 'foo', 'F'
              if foo.0 = 0 then
                do
                  say ''
                  say 'Cannot locate file "'k'\Config.Sys"'
                  call charout ,'Press any key...'
                  call SysGetKey 'NOECHO'
                  leave
                end
              else
                do
                  BootDrive = k
                  call GetLIBPath
                  gbdRC = 1
                  leave
                end
            end
        end
    end
  end
  return gbdRC


/* ----------------------------------------------------------------------- */

GetLIBPATH: /* procedure expose BootDrive DLLPath LIBSubPath */
  srchRC = SysFileSearch('LIBPATH=', BootDrive||'\Config.Sys', 'lpath')
  if srchRC = 0 then
    do i = 1 to lpath.0
      if translate(substr(lpath.i, 1, 8)) = 'LIBPATH=' then
        do
          j = 0
          temp = substr(lpath.i, 9)
          do while length(temp) > 0
            parse var temp tpath ';' temp
            j = j + 1
            if tpath = '.' then
              do
                LIBSubPath.j = '*Program Directory*'
                DLLPath = LIBSubPath.j
              end
            else
              LIBSubPath.j = tpath
          end
          LIBSubPath.0 = j
          if DLLPath = '' then DLLPath = LIBSubPath.1
        end
    end
  return


AskLIBPath: /* procedure expose BootDrive DLLPath LIBSubPath */
  if LIBSubPath.0 > 0 then
    do
      j = 0
      i = 0
      lpSelect = 0
      topval   = 1
      call PutCopyright 'Install'
      say "    Please select a path for TE/2's associated DLL file to be placed"
      say '    from the following list of paths in your LIBPATH:'
      say ''
      do forever
        i = i + 1
        j = j + 1
        say '    ' D2C(j+64)':' LIBSubPath.i
        if j = 10 | i = LIBSubPath.0 then
          do
            topkey = D2C(j+C2D('A')-1)
            say ''
            call charout ,' -- A-'topkey'=Select, R=restart, Q (or ESC)=exit, any other key=more --'
            k = C2D(translate(SysGetKey('NOECHO')))
            if k = 27 then k = C2D('Q')
            if k = C2D('Q') then leave
            if k = C2D('R') then
              do
                i = 0
                j = 0
                topval = 1
              end
            else
              do
                topkey = j+C2D('A')
                if k > C2D('@') & k < topkey then
                  do
                    lpSelect = topval + (k - C2D('A'))
                    DLLPath = LIBSubPath.lpSelect
                    leave
                  end
                j = 0
                if i = LIBSubPath.0 then i = 0
                topval = i + 1
                call PutCopyright 'Install'
                say "    Please select a path for TE/2's associated DLL file to be placed"
                say '    from the following list of paths in your LIBPATH:'
                say ''
              end
          end
      end
    end
  return


/* ----------------------------------------------------------------------- */

AskDLL16:
  call PutCopyright 'Install'
  say 'TE/2 comes supplied with a 16-bit version of its COMMPAK2.DLL file'
  say 'which is compatible with OS/2 1.x and OS/2 2.x and with a 32-bit'
  say 'version which is only compatible with OS/2 2.x.  You currently have'
  say 'selected the' tempDLL16 'version.'
  say ''
  call GetYN 'Do you want to change to the other version?'
  if result then
    do
      if DLL16Bit = 0 then
        DLL16Bit = 1
      else
        DLL16Bit = 0
    end
  return

/* ----------------------------------------------------------------------- */

DoInstall:
  call PutCopyright 'Install'
  say 'PLEASE NOTE: If you are installing over an existing TE/2 installation'
  say 'you should make sure that you have made a BACKUP of your current'
  say 'setup!  This install procedure will attempt to protect your files'
  say 'which are user customizable (TE2.INI for example) but, for your'
  say 'protection and peace of mind, a good backup is highly recommended!'
  say ''
  call GetYN 'Do you want to continue with the installation at this time?'
  if result = 1 then
    do
      pathOK = 1
      cwd = directory()
      testpath = directory(TargetPath)
      call directory cwd
      if translate(testpath) \= translate(TargetPath) then
        do
          say ''
          say 'Target path "'TargetPath'" does not exist!'
          call GetYN 'Create it?'
          if result = '1' then
            do
              r = SysMkDir(TargetPath)
              if r \= 0 then
                do
                  say 'Cannot create directory "'TargetPath'"'
                  call charout ,'Press any key...'
                  call SysGetKey 'NOECHO'
                  pathOK = 0
                end
            end
          else
            pathOK = 0
        end
      if pathOK = 0 then return

      tempSrc = SourcePath
      n = length(tempSrc)
      if substr(tempSrc, n, 1) \= '\' then tempSrc = tempSrc||'\'
      tempDest = TargetPath
      n = length(tempDest)
      if substr(tempDest, n, 1) \= '\' then tempDest = tempDest||'\'
      r1 = stream(tempSrc||InstDat01, 'C', 'query exists')
      r2 = stream(tempSrc||InstDat02, 'C', 'query exists')
      if r1 = '' | r2 = '' then
        do
          call beep 1760, 50
          say ''
          say ''
          say 'Install cannot locate one or both of the installation data files:'
          say Instdat01 'and/or' InstDat02 'in the directory you specified as'
          say 'the source path ('SourcePath').  Please correct this situation'
          say 'before you continue.'
          say ''
          call charout ,'Press any key...'
          call SysGetKey 'NOECHO'
        end
      else
        do
          do i = 1 to Sensitive.0
            r = stream(tempDest||Sensitive.i, 'C', 'query exists')
            if r \= '' then
              do
                call PutCopyright 'Install'
                say 'NOTE:'
                say ''
                say 'The file:' Sensitive.i 'already exists in the target path!'
                say 'Select:'
                say '       1. Skip file (do not overwrite)'
                say '       2. Rename to' Sensitive.i.Backup 'and copy new file.'
                say '       3. Overwrite the file with the new version'
                say ''
                call charout ,'Enter 1, 2, or 3: '
                do forever
                  k = SysGetKey('NOECHO')
                  if k = '1' | k = '2' | k = '3' then
                      leave
                  else
                    call beep 1760, 50
                end
                say k
                if k = '2' then
                  'copy' tempDest||Sensitive.i tempDest||Sensitive.i.Backup
                if k \= '1' then
                  Sensitive.param = Sensitive.i||' '||Sensitive.param
              end
            else
              Sensitive.param = Sensitive.i||' '||Sensitive.param
          end

          cwd = directory()
          call directory TargetPath

          'ren' tempSrc||InstDat01 'TE2Inst1.EXE'
          call PutCopyright 'Install'
          say 'Installing from:' SourcePath '-->' targetPath
          say ''
          tempSrc||'Te2Inst1 * /o'
          'ren' tempSrc||'Te2Inst1.EXE' InstDat01

          if Sensitive.param \= '' then
            do
              'ren' tempSrc||InstDat02 'TE2Inst2.EXE'
              call PutCopyright 'Install'
              say 'Installing from:' SourcePath '-->' targetPath
              say ''
              tempSrc||'TE2Inst2' Sensitive.param '/o'
              'ren' tempSrc||'TE2Inst2.EXE' InstDat02
            end

          say 'Copying remaining files...'
          'copy' tempSrc||'Te2Setup.CMD'  TargetPath
          'copy' tempSrc||'Oberon.ICO' TargetPath

          if DLL16Bit = 1 then
            do
              say ''
              say 'Configuring for 16-bit DLL...'
              'ren COMMPAK2.DLL CPK2_32.DLL'
              'ren CPK2_16.DLL COMMPAK2.DLL'
            end

          if DLLPath \= '*Program Directory*' then
            do
              say ''
              say 'Copying COMMPAK2.DLL to' DLLPath'...'
              'copy Commpak2.DLL' DLLPath
            end

          call directory cwd
          call PutCopyright 'Install'
          say '    Installation of files is complete!'
          say ''
          say ''
          say 'If you wish, Install can create a desktop folder containing TE/2'
          say 'program and information objects for you.'
          say ''
          call GetYN 'Do you want a desktop folder installed?'
          if result = 1 then call CreateFolder

          call PutCopyright 'Install'
          say '    Installation of files is complete!'
          say ''
          say ''
          call charout ,'Press any key...'
          call SysGetKey 'NOECHO'

          InstallDone = 1
          TargetPath2 = TargetPath

        end
    end
  return

/* ----------------------------------------------------------------------- */

CreateFolder:
  call PutCopyright 'Install'

  classname='WPFolder'
  title='Oberon Software'
  location='<WP_DESKTOP>'
  setup='OBJECTID=<OBERON_FOLDER>;'||,
        'ICONFILE='tempDest'Oberon.ico;'||,
        'ICONPOS=25,75;'||,
        'OPEN=ICON;'
  option='U'
  call BldObj

  classname='WPProgram'
  title='TE/2^Windowed Session'
  location='<OBERON_FOLDER>'
  setup='OBJECTID=<OBERON_TE2>;'||,
        'EXENAME='tempDest'TE2.EXE;'||,
        'PARAMETERS=-fTe2.ini;'||,
        'STARTUPDIR='TargetPath';'||,
        'PROGTYPE=WINDOWABLEVIO;'
  option='R'
  call BldObj

  classname='WPProgram'
  title='TE/2 Setup'
  location='<OBERON_FOLDER>'
  setup='OBJECTID=<OBERON_TE2SETUP>;'||,
        'EXENAME='tempDest'TE2SETUP.CMD;'||,
        'STARTUPDIR='TargetPath';'||,
        'PROGTYPE=WINDOWABLEVIO;'
  option='R'
  call BldObj

  classname='WPProgram'
  title='TE/2 User Manual'
  location='<OBERON_FOLDER>'
  setup='OBJECTID=<OBERON_TE2DOC>;'||,
        'EXENAME=VIEW.EXE;'||,
        'PARAMETERS=TE2;'||,
        'STARTUPDIR='TargetPath';'||,
        'PROGTYPE=PM;'
  option='R'
  call BldObj

  classname='WPShadow'
  title='WHATS.NEW'
  location='<OBERON_FOLDER>'
  setup='SHADOWID='||tempDest||'WHATS.NEW;'
  option='R'
  call BldObj

  classname='WPShadow'
  title='ORDER FORM'
  location='<OBERON_FOLDER>'
  setup='SHADOWID='||tempDest||'ORDER.FRM;'
  option='R'
  call BldObj

  return


BldObj:
  call charout ,'    Building:' title '... '
  r = SysCreateObject(classname, title, location, setup, option)
  if r = 1 then
    say 'Object created!'
  else
    say 'Not created!  Return code='r
  return


/* ----------------------------------------------------------------------- */

CheckINIFile:
  rval = 0
  if TargetPath2 = '' then
    TargetPath2 = directory()

  n = length(TargetPath2)
  if substr(TargetPath2, n, 1) = '\' then
    testfn = TargetPath2||'TE2.INI'
  else
    testfn = TargetPath2||'\TE2.INI'

  r = stream(testfn, 'C', 'query exists')
  if r = '' then
    do forever
      call PutCopyright 'Setup'
      say 'Setup cannot locate the TE2.INI file.'
      say ''
      call AskPath2 'Please specify the path to your TE/2 installation', TargetPath2, 'MUSTEXIST'
      testfn = result
      if testfn \= '' then
        do
          TargetPath2 = testfn
          n = length(testfn)
          if substr(testfn, n, 1) = '\' then
            testfn = testfn||'TE2.INI'
          else
            testfn = testfn||'\TE2.INI'
          r = stream(testfn, 'C', 'query exists')
          if r \= '' then
            do
              RestorePath = directory()
              call directory TargetPath2
              INIFileName = testfn
              rval = 1
              leave
            end
        end
      else
        leave
    end
  else
    do
      RestorePath = directory()
      call directory TargetPath2
      INIFileName = testfn
      rval = 1
    end
  return rval

/* ----------------------------------------------------------------------- */

GetINISettings:
  say ''
  call charout ,'Reading:' INIFileName'...'
  srchTemp. = ''
  srchRC = SysFileSearch('Device', INIFileName, 'srchTemp')
  if srchRC = 0 then
    do i = 1 to srchTemp.0
      if translate(substr(strip(srchTemp.i, 'L'), 1, 6)) = 'DEVICE' then
        do
          parse var srchTemp.i dummy1 TE2Device dummy2
          leave
        end
    end
  if TE2Device = '' then
    TE2Device = 'COM1'

  r = stream('MODEM.INC', 'C', 'open read')
  TE2Modem = substr(linein('MODEM.INC'), 3)
  r = stream('MODEM.INC', 'C', 'close')
  if TE2Modem = '' then
    TE2Modem = 'Generic 2400 baud'

  do i = 1 to INIVar.0
    srchTemp. = ''
    srchRC = SysFileSearch(INIVar.i, INIFileName, 'srchTemp')
    if srchRC = 0 then
      do j = 1 to srchTemp.0
        if translate(substr(strip(srchTemp.j, 'L'), 1, length(INIVar.i))) = translate(INIVar.i) then
          do
            parse var srchTemp.j dummy1 INIVar.i.Val dummy2
            if substr(INIVar.i.Val, 1, 1) = ';' then INIVar.i.Val = ''
            leave
          end
      end
  end

  say ' Done!'
  return

/* ----------------------------------------------------------------------- */

SaveINIFile:
  say ''
  call charout ,'Saving values to:' INIFileName'...'

  inputfile  = INIFileName
  n = length(TargetPath2)
  if substr(TargetPath2, n, 1) = '\' then
    do
      outputfile = TargetPath2||'TEMPINI.$$$'
      backupfile = TargetPath2||'TE2INI.BAK'
    end
  else
    do
      outputfile = TargetPath2||'\TEMPINI.$$$'
      backupfile = TargetPath2||'\TE2INI.BAK'
    end

  call SysFileDelete outputfile
  r = stream(inputfile,  'C', 'open read')
  r = stream(outputfile, 'C', 'open write')
  do while lines(inputfile)
    aline = linein(inputfile)
    parse var aline keywd keyval
    test = translate(strip(keywd))
    if test = 'DEVICE' then
      aline = 'Device  '||TE2Device
    else
      do i = 1 to INIVar.0
        if test = translate(INIVar.i) then
          do
            if length(INIVar.i.val) > 0 then
              aline = INIVar.i||'  '||INIVar.i.Val
            else
              aline = INIVar.i||'  ;'
            INIVar.i.Written = 'Y'
            leave
          end
      end
    call lineout outputfile, aline
  end

  do i = 1 to INIVar.0
    if INIVar.i.Written \= 'Y' then
      do
        if length(INIVar.i.val) > 0 then
          aline = INIVar.i||'  '||INIVar.i.Val
        else
          aline = INIVar.i||'  ;'
        call lineout outputfile, aline
      end
    INIVar.i.Written = ''
  end

  r = stream(inputfile,  'C', 'close')
  r = stream(outputfile, 'C', 'close')
  call SysFileDelete backupfile
  'ren' inputfile 'TE2INI.BAK'
  'ren' outputfile 'TE2.INI'

  say ' Done!'
  return

/* ----------------------------------------------------------------------- */

SelectDevice:
  do forever
    call PutCopyright 'Setup'
    say 'Please enter the name of the COM device you wish to use with TE/2'
    say '(i.e., COM1, COM2, etc.).  You may just press ENTER if you want to'
    say 'use' TE2Device'.'
    say ''
    call charout ,'Enter device name: '
    tempDevice = strip(linein('stdin'), 'B')
    if tempDevice = '' then tempDevice = TE2Device
    say ''
    say 'You selected:' tempDevice
    call charout ,'Press Y to confirm or any other key to retype the name...'
    if translate(SysGetKey('NOECHO')) = 'Y' then
     do
       TE2Device = tempDevice
       leave
     end
    say ''
    say ''
  end
  return

/* ----------------------------------------------------------------------- */

SelectModem:

  if ModemFile.0 = '' then
    do
      call PutCopyright 'Setup'
      call charout ,'Reading Modem files...'

      n = length(TargetPath2)
      if substr(targetPath2, n, 1) = '\' then
        tempPath = TargetPath2
      else
        tempPath = TargetPath2||'\'

      call SysFileTree tempPath'MODEMS\*.INC', 'ModemFile', 'F'
    end

  sftFNStart = 38      /* Where the actual filename starts in the returned */
                       /* info from SysFileTree                            */

  if ModemFile.0 > 0 then
    do
      call PutCopyright 'Setup'
      j = 0
      ModemSelect = 0
      topval = 1
      i = 0

      do forever
        i = i + 1
        j = j + 1

        if ModemFile.i.Desc = '' then
          do
            ModemFile.i = substr(ModemFile.i, sftFNStart)
            r = stream(ModemFile.i, 'C', 'open read')
            ModemFile.i.Desc = linein(ModemFile.i)
            r = stream(ModemFile.i, 'C', 'close')
          end

        say D2C(j+64)':' substr(ModemFile.i.Desc, 3)

        if (j = 10) | (i = ModemFile.0) then
          do
            topkey = D2C(j+C2D('A')-1)
            say ''
            call charout ,'  -- Press A-'topkey' to select, R to start over, Q to exit, SPACE to continue --'
            k = C2D(translate(SysGetKey('NOECHO')))
            if k = 27 then k = C2D('Q')
            if k = C2D('Q') then leave
            if k = C2D('R') then
              do
                i = 0
                j = 0
                topval = 1
                call PutCopyright 'Setup'
              end
            else
              do
                topkey = j+C2D('A')
                if (k > C2D('@')) & (k < topkey) then
                  do
                    ModemSelect = topval + (k - C2D('A'))
                    say ''
                    say 'Select:' substr(ModemFile.ModemSelect.Desc, 3)||'?'
                    call charout ,'Press Y to confirm, any other key to continue...'
                    k = translate(SysGetKey('NOECHO'))
                    if k = 'Y' then leave
                  end
                call PutCopyright 'Setup'
                j = 0
                if i = ModemFile.0 then i = 0
                topval = i + 1
              end
          end
      end

      if ModemSelect \= 0 then
        do
          call SysCls
          TE2Modem = substr(ModemFile.ModemSelect.Desc, 3)
          say 'You selected:' substr(ModemFile.ModemSelect.Desc, 3)
          say ''
          say 'You may need to perform a one-time modem setup for this modem.'
          say 'Here are the comments from the modem configuration file (these'
          say 'comments may be found later in the file MODEM.INC in your TE/2'
          say 'directory).'
          say ''
          call charout ,'Press any key to view comments...'
          call SysGetKey 'NOECHO'
          call SysCls
          r = stream(ModemFile.ModemSelect, 'C', 'open read')
          do forever
            aline = linein(ModemFile.ModemSelect)
            if substr(aline, 1, 1) \= ';' then leave
            say substr(aline, 2)
          end
          r = stream(ModemFile.ModemSelect, 'C', 'close')
          say ''
          say 'Copying' ModemFile.ModemSelect 'to' tempPath'MODEM.INC.'
          'copy' ModemFile.ModemSelect tempPath'MODEM.INC.'
          call charout ,'Press any key to continue...'
          call SysGetKey 'NOECHO'
        end
    end
  else
    do
      say '  No Modem Files Found!'
      say ''
      call charout ,'Press any key to continue...'
      call SysGetKey 'NOECHO'
    end

  return


/* ----------------------------------------------------------------------- */

SetupColors:
  r = stream('te2color.exe', 'C', 'query exists')
  if r = '' then
    do
      call PutCopyright 'Setup'
      say 'The TE/2 color setup program, TE2Color.EXE cannot be found!'
      say ''
      call charout ,'Press any key...'
      call SysGetKey 'NOECHO'
    end
  else
    'te2color' INIFileName
  return

/* ----------------------------------------------------------------------- */

PutCopyright:
parse arg crType
  call SysCls
  select
    when crType = 'Install' then say CopyRILine0
    when crType = 'Setup'   then say CopyRCLine0
    otherwise                    say CopyRLine0
  end
  say CopyRLine1
  say CopyRLine2
  say ''
  say ''
  return

/* ----------------------------------------------------------------------- */

GetYN: procedure
parse arg gynPrompt
  call charout ,gynPrompt '(y/N) '
  do forever
    k = translate(SysGetKey('NOECHO'))
    if k = D2C(27) | k = D2C(13) then k = 'N'
    select
      when k = 'Y' then
        do
          ynRC = 1
          leave
        end
      when k = 'N' then
        do
          ynRC = 0
          leave
        end
      otherwise
        call beep 1760, 50
    end
  end
  return ynRC

/* ----------------------------------------------------------------------- */

AskNumber: procedure
parse arg min, max, prompt
  rval = ''
  say ''
  say 'Press ENTER to leave' prompt 'unchanged or'
  call charout ,'Type a value between' min 'and' max': '
  do forever
    r = linein('stdin')
    if length(r) = 0 then leave
    if datatype(r, 'Number') \= 1 then
      call charout ,'Bad value, try again: '
    else
      do
        if r >= min & r <= max then
          do
            rval = r
            leave
          end
        else
          call charout ,'Out of bounds, try again: '
      end
  end
  return rval

