/* written by Justin Newman      date: July 4th, 1993 */
/* generates sine and cosine tables */

#include <stdio.h>
#include <math.h>

#define NUM	256
#define NUMB 8

int
main()
{
	 int i,i1,stuff,a;
	 FILE *fp;

	 if ((fp=fopen("sincos.h","w+"))==NULL)
		{
			printf("file error:  can't open file SINCOS.H\n");
			return -1;
		}

	 /* message */ printf("creating SINCOS.H\n");

	 fprintf(fp,"/* sincos.h: */\n");
	 fprintf(fp,"/*   sine and cosine tables   use: sintbl[] = sin  * %d */\n",NUM);
	 fprintf(fp,"/*   there are 360 entries for each table */\n");
	 fprintf(fp,"\n");
	 fprintf(fp,"#ifndef _SINCOS_H\n");
	 fprintf(fp,"#define _SINCOS_H\n");
	 fprintf(fp,"\n");
	 fprintf(fp,"#define NUM %d\n",NUM);
	 fprintf(fp,"#define NUMB %d\n",NUMB);
	 fprintf(fp,"\n");
	 fprintf(fp,"int sintbl[]={   /* sine table */\n");
	 for (i=0;i<36;i++)
		{
			fprintf(fp,"   ");
			for (i1=0;i1<10;i1++)
			 {
				a=i*10+i1;
				stuff=(int)(ceil(sin((double)a*(3.141592654/180))*NUM));
				fprintf(fp,"%6d,",stuff);
			 }
			fprintf(fp,"\n");
		}
	 fprintf(fp,"}; /* end sintbl */\n");
	 fprintf(fp,"\n");
	 fprintf(fp,"int costbl[]={   /* cosine table */\n");
	 for (i=0;i<36;i++)
		{
			fprintf(fp,"   ");
			for (i1=0;i1<10;i1++)
			 {
				a=i*10+i1;
				stuff=(int)(ceil(cos((double)a*(3.141592654/180))*NUM));
				fprintf(fp,"%6d,",stuff);
			 }
			fprintf(fp,"\n");
		}
	 fprintf(fp,"}; /* end costbl */\n");
	 fprintf(fp,"\n");
	 fprintf(fp,"#endif\n");
	 fclose(fp);

	 /* message */ printf("done\n");

	 return 0;
}

