PROGRAM OS2VT;

{$M 16000, 0, 655360}

USES Dos,
     VTSpecial, VTGlobal, VTCmd, 
     SoundDevices, DevFile,
     PlayMod, ModCommands, SongUnit, SongUtils,
     CmdLine, Heaps, Debugging, FileUtil;




VAR
  NoMods : BOOLEAN;

FUNCTION DoOneMOD(FName, InsidePath: PathStr) : BOOLEAN; FAR;
  VAR
    Song         : TSong;
    ch           : CHAR;
    IsInsideSong : BOOLEAN;
    NoMod        : BOOLEAN;
  BEGIN
    NoMods   := FALSE;

    NoMod        := TRUE;
    ch           := #0;
    IsInsideSong := FALSE;

    SetVTDevice;
    SetVTFreq;
    MaxOutputFreq := ActualHz;

    FillChar(UserVols, SIZEOF(UserVols), VtVolume);

    Song.Init;

    REPEAT
      Song.SetInsidePath(InsidePath);

      IF VT1stPattern <> 0 THEN
        Song.SongStart := VT1stPattern;

      IF VTSongLen <> 0 THEN
        Song.SongLen := VTSongLen;

      Song.LoadFName(FName);
      IF Song.ThereIsMore THEN
        IsInsideSong := TRUE;

      IF (Song.Status = msOk) OR (Song.Status = msFileTooShort) THEN
        BEGIN
          NoMod := FALSE;

          Write(#13, FName);

          IF IsInsideSong THEN
            Write('/'+Song.GetInsidePath);

          FirstPattern := VT1stPattern;
          RepStart     := VTRepStart;
          SongLen      := VTSongLen;

          PlayStart(Song);
          ch := FileRun;
          PlayStop;
          EndSampling;
          WriteLn;
        END;
    UNTIL NOT Song.ThereIsMore;

    IF NoMod THEN
      Write(#13'Error en el fichero:', FName);

    DoOneMOD := ch <> #27;

    Song.Done;
  END;




CONST
  NombreApp = 'OS2VT';

  AppID : STRING[Length(NombreApp) + 2 + Length(Version) + Length(BetaStr)] =
            NombreApp+' v'+Version+BetaStr;

VAR
  s       : STRING;
  i, r    : WORD;

BEGIN

  WriteLn;
  WriteLn(    '   Ŀ');
  WriteLn(    '     OS2VT. Versin para OS/2 del VangeliSTracker, v'+Version+'  ');
  WriteLn(    '                  (C) 1992-93  VangeliSTeam               ');
  WriteLn(    '   ');

  IF ParamCount = 0 THEN
    BEGIN
      WriteLn(' Ŀ');
      WriteLn('  OS2VT <fichero>[.MOD|.OKT|.WOW] [<frecuencia> [<fichero de salida>]] ');
      WriteLn(' ');
      HALT(1);
    END;

  VTResidentCheck(AppID);

  Debugging.Debug := FALSE{TRUE};

  LoopMod      := FALSE;
  ForceLoopMod := FALSE;

  InitHeapVariables;
  InitUmbHeap;
  Cmd.Init;
  SongColl.Init(2, 3);

  DevID := FileDevID;
  OneModProc := DoOneMod;

  InitSoundDevices;
  InitModUnit;

  NoMods := TRUE;
  Cmd.ParseLine(GetDOSCmdLine);
  IF DoSongColl(Cmd.FileDir) THEN
    IF NoMods THEN
      WriteLn('No encuentro ninguna cancin.');
END.
