PROGRAM ShellVT;

{$M 20000, 0, 655360}

USES Dos,
     VTSpecial, VTGlobal, VTCfg, VTCmd, 
     SoundDevices, DevSB, DevSbDac, DevDAC, DevSpkr, DevAdlib,
     PlayMod, ModCommands, SongUnit, SongUtils,
     CmdLine, Heaps, Debugging, FileUtil;




VAR
  NoMods : BOOLEAN;

FUNCTION DoOneMOD(FName: PathStr; InsidePath: PathStr) : BOOLEAN; FAR;
  VAR
    Song     : TSong;
    HeapSize : LONGINT;
  BEGIN
    NoMods   := FALSE;
    DoOneMOD := TRUE;

    IF ShellLoopMod THEN
      BEGIN
        LoopMod      := TRUE;
        ForceLoopMod := TRUE;
      END;

    SetVTDevice;
    SetVTFreq;
    MaxOutputFreq := ActualHz;

    FillChar(UserVols, SIZEOF(UserVols), VtVolume);

    Song.Init;

    Song.SetInsidePath(InsidePath);

    IF VT1stPattern <> 0 THEN
      Song.SongStart := VT1stPattern;

    IF VTSongLen <> 0 THEN
      Song.SongLen := VTSongLen;

    Song.LoadFName(FName);

    IF Song.Status <= msFileTooShort THEN
      BEGIN
        DoOneMOD := FALSE;

        FirstPattern := VT1stPattern;
        RepStart     := VTRepStart;
        SongLen      := VTSongLen;

        PlayStart(Song);

        HeapSize := Heap.HTotalAvail;
        ShrinkSystemHeap(0);
        SwapVectors;
        Exec(ShellPath, ShellParam);
        SwapVectors;
        ShrinkSystemHeap(HeapSize);

        PlayStop;
        EndSampling;

        WriteLn;
        WriteLn('Ŀ');
        WriteLn(' ShellVT desinstalado. ');
        WriteLn('');
      END
    ELSE
      WriteLn(#13'Error en el fichero: '+FName);

    Song.Done;
  END;




CONST
  NombreApp = 'ShellVT';

  AppID : STRING[Length(NombreApp) + 2 + Length(Version) + Length(BetaStr)] =
            NombreApp+' v'+Version+BetaStr;

VAR
  s       : STRING;
  i, r    : WORD;

BEGIN

  WriteLn;
  WriteLn(    '    Ŀ');
  WriteLn(    '     '+NombreApp+'. Versin residente del VangeliSTracker, v'+Version+' ');
  WriteLn(    '                   (C) 1992-93  VangeliSTeam               ');
  WriteLn(    '    ');

  IF ParamCount = 0 THEN
    BEGIN
      WriteLn(' Ŀ');
      WriteLn('  ShellVT <fichero>[<.Ext>] [<disp.> [<frec.> [<programa> [parmetros]]]] ');
      WriteLn(' ');
      HALT(1);
    END;

  VTResidentCheck(AppID);

  Debugging.Debug := FALSE;

  InitHeapVariables;
  InitUmbHeap;

  Cmd.Init;
  SongColl.Init(1, 1);

  InitSoundDevices;
  InitModUnit;

  DesiredHz  := ShellHz;
  OneModProc := DoOneMod;

  NoMods := TRUE;

  Cmd.ParseLine(GetDOSCmdLine);
  IF DoSongColl(Cmd.FileDir) THEN
    IF NoMods THEN
      WriteLn('No encuentro ninguna cancin.');
END.
