






          RanDOOM(1)                    MS-DOS                   RanDOOM(1)


NAME
     RanDOOM - A smart object placement randomization utility for DOOM.

SYNOPSIS
     RanDOOM [WAD_file_name] [-C<c>] [-M<n>] [-W<filename>] [-D]

DESCRIPTION
     RanDOOM is a utility which will randomize the placement of objects in
     the DOOM playfield. Additionally, RanDOOM has some smarts about the
     manner in which it will randomize things - it's designed to never
     leave you with a pillar blocking the exit, or a keycard on the
     opposite side of the door from where you start, or to erase all the
     DEATHMATCH warp-in spots with other objects (preventing DEATHMATCH
     network play), or to replace the endgame bosses with other objects
     (thus preventing the completion of an episode). In short, RanDOOM will
     always leave you with a playable level. RanDOOM is also user
     configurable - it allows you to specify the proportion of total
     objects a given object will comprise via a customizable object
     weighting scheme. This allows you to tailor RanDOOM's randomizing to
     your personal taste (and/or masochism ;-).


OPTIONS
     WAD_file_name - Use this path to the WAD file. If no filename is
     specified, doom.wad in the current directory is used.

     -D - Restores the WAD file to its default state. When the -D switch is
     specified, all other switches are ignored.

     -C<c> - Use character c as the seed value for the pseudorandom number
     generator. The character is case-sensitive, so 'K' and 'k' yield
     different seed values. If no -C parameter is specified, a seed value
     is taken based on the current system time.

     -M<n> - Use randomization mode n, where n is a single digit [0-9].
     Currently only three randomization modes (0, 1 and 2) are supported.
     If no -M parameter is specified, mode 0 is used by default.

     Randomization mode 0 takes the objects currently placed on each level
     and rearranges them. No objects are added, subtracted, or replaced -
     if a given level contains 2 Barons of Hell, 12 Imps, 32 blue health
     vials, and a chainsaw, then the modified level will also contain 2
     Barons of Hell, 12 Imps, 32 blue health vials, and one chainsaw,
     rearranged in random order. Keycards, immovable objects (such as
     torches and posts), the player starting positions, teleporters, and
     DEATHMATCH warp-in spots are not affected.

     Randomization mode 1 replaces "nonessential" objects with other
     randomly selected objects from the entire range of available objects,

                                     1














          RanDOOM(1)                    MS-DOS                   RanDOOM(1)

     from all levels. This randomization mode may place objects into a
     level which would not normally appear there, e.g. Cacodemons may
     appear in the Hangar level. As with Mode 0, care is taken so as not to
     remove or replace essential objects, such as keycards, DEATHMATCH
     spots, etc., nor are immovable objects placed in front of switches or
     doors. 

     Randomization mode 2 does the same things as mode 1 with the addition
     of weight factors for replaceable objects. These weights are user
     adjustable (via the weight file specified using the -W switch) to
     allow a relative increase or decrease in the number of a given item
     inserted in the game. Thus, items with higher weights have a higher
     probability of being selected. NOTE: If the -M2 switch is specified,
     the -W switch must also be specified.

     NOTE: With randomization modes 1 and 2 ALL objects will appear at ALL
     four skill levels - e.g. there will be no variation between "Hey, Not
     Too Rough" and "Ultra Violence." This may be addressed in future
     versions of RanDOOM. 

     -W<filename> - Use item weight factors from file <filename> in place
     of the default weights in randomization mode 2. The weight file is a
     flat ASCII text file consisting of a series of <itemname> <weight>
     pairs, one pair per line. <itemname> must be one of the predefined
     names listed in the sample weight file (randoom.w), while <weight>
     must be a floating point value greater than or equal to 0.0. The
     larger the weight value, the more occurrences of that object RanDOOM
     will put into the game.

EXAMPLES
     RanDOOM
          Display a brief usage synopsis.

     RanDOOM -Ck -M1 
          Rearrange levels using randomization mode 1 and random seed
          character 'k'.

     RanDOOM -M0
          Rearrange levels using randomization mode 0 and random seed based
          on the system time.

     RanDOOM -D
          Restore all objects in the WAD file to their default positions.

     RanDOOM -M2 -Wc:\doom\randoom.w -CZ
          Rearrange levels using mode 2 with weights given in the file
          "c:\doom\randoom.w" and using the character 'Z' as the random
          number seed value.

     RanDOOM c:\doom\doom.wad -CT

                                     2














          RanDOOM(1)                    MS-DOS                   RanDOOM(1)

          Rearrange levels in WAD file c:\doom\doom.wad using randomization
          mode 0 and seed character 'T'.

NOTICES
     This software is copyright 1994 ASRE. You are free to use and
     distribute this software provided that no modifications or derivative
     works are produced from it and that no fees are charged for its
     distribution or use. Do I even need to mention that you should back up
     your WAD file before running this program?

BUGS
     Sometimes RanDOOM will place objects partially "within" a wall. This
     happens when a very large object, like the Spider Demon, is placed
	 where a small object formerly sat. To correct this problem will require
     RanDOOM to decipher the map layout and determine whether the object to
     be placed will have enough room. Future versions of RanDOOM will
     address this problem. Please email any bug reports and/or comments to
     tmkk@uiuc.edu.

































                                     3







