/*-----------------------------------------
   HATCHPEN.C -- Hatched Pen Demo
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>

char szClass [] = "HatchPen" ;
char szTitle [] = "HatchPen: Hatched Pen Demo" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     LOGBRUSH lb ;

     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 100, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea, cyArea, NULL) ;

     SetBkColor (hdc, RGB (0, 0, 255)) ;

     lb.lbStyle = BS_HATCHED ;
     lb.lbColor = RGB (255, 0, 0) ;
     lb.lbHatch = HS_DENSE3 ;

     SelectObject (hdc,
          ExtCreatePen (PS_GEOMETRIC | PS_SOLID, 25, &lb, 0, NULL)) ;

     Ellipse (hdc, 25, 25, 75, 75) ;

     DeleteObject (
          SelectObject (hdc,
               GetStockObject (BLACK_PEN))) ;
     }
