Unit Graph_FG;

{$F+}         {Force Far Calls}
{$O+}         {Enable Overlay Code Generation}
{$S-}         {Disable Stack Overflow Checking}
{$D-}         {Disable Debug Information}

{=========================================================================}
{ FastGraph support unit for use with Turbo Vision programs. See          }
{ TV_FG.PAS for an example of how to use this unit.  Idea copied from     }
{ GRAPHAPP.PAS, shipped with TP 6.0                                       }
{                                                                         }
{ This code is given AS IS to anyone who wants it.  I would appreciate    }
{ any feedback on it, good or bad.                                        }
{                                                                         }
{ Patrick Mitchel 10/21/93                                                }
{ Compuserve      72400,2215                                              }
{=========================================================================}

Interface

Function  GraphicsStart(Var Mode, Pages : Integer): Boolean;
Procedure GraphicsStop;
Function  GraphicsActive: Boolean;

{=========================================================================}

Implementation

Uses
    Drivers,    {To shutdown and restart TurboVision}
    Memory,     {To shutdown and restart TurboVision}
    App,
    FGMain,
    FGSVGA;

Var
   OldMode : Integer;           {Saves original video mode}
   GraphActive : Boolean;       {Flag}

{************************************************}

Function GraphicsStart(Var Mode, Pages : Integer): Boolean;
Begin
     {Are Graphics already active?}
     If GraphActive Then
        Exit;
     {Initialize SVGA kernel if necessary}
     If Mode >= 24 Then
        If FG_SVGAInit(1) = 0 Then
        Begin
             {Sorry, no SVGA available}
             GraphActive   := FALSE;
             GraphicsStart := FALSE;
             Exit;
        End;
     {Do we have the requested mode and pages available?}
     If FG_TestMode(Mode, Pages) = 0 Then
     Begin
          {Sorry, mode unavailable}
          GraphicsStart := FALSE;
          GraphActive   := FALSE;
          Exit;
     End;
     {Save Old Mode}
     OldMode := FG_GetMode;
     {Shutdown TurboVision systems}
     DoneSysError;
     DoneEvents;
     DoneVideo;
     DoneMemory;
     {Go into FG Graphics Mode!}
     FG_SetMode(Mode);
     {Set Flag}
     GraphActive   := TRUE;
     GraphicsStart := TRUE;
End;

{************************************************}

Function GraphicsActive: Boolean;
Begin
     GraphicsActive := GraphActive;
End;

{************************************************}

Procedure GraphicsStop;
Begin
     {Shutdown FG if active}
     If GraphActive Then
     Begin
          FG_SetMode(OldMode);
          FG_Reset;
          GraphActive := FALSE;
          {Fire Up TurboVision systems}
          InitMemory;
          InitVideo;
          InitEvents;
          InitSysError;
          Application^.Redraw;
     End;
End;

{************************************************}

BEGIN
     {Initialize GraphActive Flag}
     GraphActive := FALSE;
END.
