Program TV_FG;

{=========================================================================}
{ This test program uses Graph_FG to show switching to FastGraph graphics }
{ from TurboVision.  Patterned after GRAPHAPP and TVBGI from Borland.     }
{ It is given freely to anyone who wants it, and can maybe have some fun  }
{ with it.  It is supplied AS IS, with no guarantees of any kind, in fact,}
{ there are probably some short comings with the unit, and I would        }
{ appreciate any feedback on this code.                                   }
{                                                                         }
{ Patrick Mitchel 10/21/93                                                }
{ Compuserve 72400,2215                                                   }
{=========================================================================}

{$M 8192,8192,655360}
{$S-}
{$X+}

Uses
    Dos, Objects, Drivers, Memory, Views, Menus, Dialogs, Gadgets,
    StdDlg, MsgBox, App, Graph_FG, FGPCX, FGMisc, FGMain;

Const
     cmTile       = 100;
     cmCascade    = 101;
     cmNewWin     = 1000;
     cmGetVideo   = 1001;
     cmAbout      = 1002;
     cmDoGraphics = 1003;
     cmNewFile    = 1004;

Type
    PFGApp = ^TFGApp;
    TFGApp = object(TApplication)
           Clock: PClockView;
           Heap: PHeapView;
           Constructor Init;
           Destructor Done; virtual;
           Procedure HandleEvent(Var Event: TEvent); virtual;
           Procedure InitMenuBar; virtual;
           Procedure InitStatusLine; virtual;
           Procedure OutOfMemory; virtual;
           Procedure Idle; virtual;
    End;

Var
   Mode, Pages : Integer;
   MyData      : PDialog;
   FileName    : PathStr;

   DataRec : Record
           Field1 : Word;  {Radiobuttons to choose video mode}
   End;

{************************************************}

Procedure NewFile;
Var
   D : PFileDialog;

Begin
     D := New(PFileDialog, Init('*.PCX', 'Open a .PCX File',
                                'File~n~ame',
                                fdOpenButton, 10));

     If Desktop^.ExecView(D) <> cmCancel Then
        D^.GetFileName(FileName);

    Dispose(D, Done);
End;

{************************************************}

FUNCTION AboutDialog : PDialog;
Var
   Dlg     : PDialog;
   R       : TRect;
   Control : PView;
Begin
     R.Assign(19,6,60,17);
     New(Dlg, Init(R, '[ ABOUT ]'));

     With Dlg^ Do
     Begin
          Palette := dpBlueDialog;
          Flags   := Flags and not wfClose;
          Options := $1300;

          R.Assign(7,1,34,2);
          Control := New(PStaticText, Init(R,
                         'FastGraph with TURBOVISION!'));
          Control^.Options := $1100;
          Insert(Control);

          R.Assign(4,3,36,4);
          Control := New(PStaticText, Init(R,
                         'Based on GRAPHAPP.PAS by BORLAND'));
          Control^.Options := $1100;
          Insert(Control);

          R.Assign(11,5,29,6);
          Control := New(PStaticText, Init(R, ^C'By Patrick Mitchel'));
          Control^.Options := $1100;
          Insert(Control);

          R.Assign(8,8,32,10);
          Control := New(PButton, Init(R,
                         'LET''S GET ON WITH IT', cmCancel, bfDefault));
          Control^.Options := $1135;
          Insert(Control);

          SelectNext(False);
          AboutDialog := Dlg;
     End;
End;

{************************************************}

Procedure About;
Var
   MyAbout : PDialog;
Begin
     MyAbout := AboutDialog;
     DeskTop^.ExecView(MyAbout);
     Dispose(MyAbout, Done);
End;

{************************************************}

Constructor TFGApp.Init;
Var
   R : TRect;
Begin
     TApplication.Init;

     {Put a clock in the menu bar}
     GetExtent(R);
     R.A.X := R.B.X - 9; R.B.Y := R.A.Y + 1;
     Clock := New(PClockView, Init(R));
     Insert(Clock);

     {Put heapview in the status line}
     GetExtent(R);
     Dec(R.B.X);
     R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
     Heap := New(PHeapView, Init(R));
     Insert(Heap);

     {Initialize our Globals}
     DataRec.Field1 := 0;
     {Default to 640x350x16 mode}
     Mode  := 16;
     Pages := 1;

     FileName := '';

     {Display About Box}
     About;
End;

{************************************************}

Destructor TFGApp.Done;
Begin
     {Shutdown graphics if necessary}
     GraphicsStop;
     TApplication.Done;
End;

{************************************************}

FUNCTION WarningDialog : PDialog;
Var
   Dlg     : PDialog;
   R       : TRect;
   Control : PView;
Begin
     R.Assign(16,7,63,16);
     New(Dlg, Init(R, 'Sorry...'));

     With Dlg^ Do
     Begin
          Flags   := Flags and not wfClose;
          Palette := dpBlueDialog;
          Options := $1300;

          R.Assign(3,2,44,3);
          Control := New(PStaticText, Init(R,
                         'Your video card does not support the mode'));
          Insert(Control);

          R.Assign(3,3,41,4);
          Control := New(PStaticText, Init(R,
                         'you just selected, please try another.'));
          Insert(Control);

          R.Assign(17,6,30,8);
          Control := New(PButton, Init(R, 'TRY AGAIN', cmCancel, bfDefault));
          Control^.Options := $1135;
          Insert(Control);

          SelectNext(False);
          WarningDialog := Dlg;
     End;
End;

{************************************************}

FUNCTION VideoDialog : PDialog;
Var
   Dlg     : PDialog;
   R       : TRect;
   Control : PView;

Begin
     R.Assign(13,2,49,17);
     New(Dlg, Init(R, 'Video Resolution Selection'));

     With Dlg^ Do
     Begin
          Flags   := Flags and not wfClose;
          Palette := dpBlueDialog;
          Options := Options or ofCentered;
          R.Assign(9,4,27,11);
          Control := New(PRadioButtons, Init(R,
                  NewSItem('640x350x16',
                  NewSItem('640x480x16',
                  NewSItem('640x480x256',
                  NewSItem('800x600x16',
                  NewSItem('800x600x256',
                  NewSItem('1024x768x16',
                  NewSItem('1024x768x256',Nil)))))))));
          PCluster(Control)^.Value := 0;
          Insert(Control);

          R.Assign(7,2,29,3);
          Control := New(PStaticText, Init(R, 'Choose a Video Mode...'));
          Insert(Control);

          R.Assign(5,12,13,14);
          Control := New(PButton, Init(R, '~O~k', cmOK, bfDefault));
          Insert(Control);

          R.Assign(19,12,31,14);
          Control := New(PButton, Init(R, '~C~ancel', cmCancel, bfNormal));
          Insert(Control);

          SelectNext(False);
          VideoDialog := Dlg;
     End;
End;

{************************************************}

Procedure TFGApp.HandleEvent(Var Event: TEvent);

{******************}

Procedure NewWin;
Const
     WinNum: Word = 0;
Var
   R: TRect;
   S: string[3];
   P: PWindow;
Begin
     Str(WinNum, S);
     DeskTop^.GetExtent(R);
     With DeskTop^.Size Do
          R.Assign(WinNum mod Pred(Y), WinNum mod Pred(Y), X, Y);
     Inc(WinNum);
     P := New(PWindow, Init(R, 'Window ' + S, 0));
     P^.Options := P^.Options or ofTileable;
     DeskTop^.Insert(ValidView(P));
End;

{******************}

Procedure Warning;
Var
   MyWarning : PDialog;
Begin
     MyWarning := WarningDialog;
     DeskTop^.ExecView(MyWarning);
     Dispose(MyWarning, Done);
End;

{******************}

Procedure DoGraphics;
Begin
     If FileName = '' Then
        NewFile;
     GraphicsStart(Mode, Pages);
     If GraphicsActive Then
     Begin
          FG_ShowPCX(FileName + Chr(0), 0);
          FG_WaitKey;
          GraphicsStop;
     End
     Else
         {Chosen video mode was unavailable!}
         Warning;
End;

{******************}

Procedure Tile1;
Var
  R: TRect;
Begin
  Desktop^.GetExtent(R);
  Desktop^.Tile(R);
End;

{******************}

Procedure Cascade1;
Var
  R: TRect;
Begin
  Desktop^.GetExtent(R);
  Desktop^.Cascade(R);
End;

{******************}

Procedure GetVideo;
Begin
     MyData := VideoDialog;
     MyData^.SetData(DataRec);

     If DeskTop^.ExecView(MyData) <> cmCancel Then
     Begin
          MyData^.GetData(DataRec);
          Dispose(MyData, Done);
     End
     Else
         Dispose(MyData, Done);

     Case DataRec.Field1 Of
          0  : Begin
                    Mode  := 16;
                    Pages := 1;
               End;
          1  : Begin
                    Mode  := 18;
                    Pages := 1;
               End;
          2  : Begin
                    Mode  := 25;
                    Pages := 1;
               End;
          3  : Begin
                    Mode  := 28;
                    Pages := 1;
               End;
          4  : Begin
                    Mode  := 26;
                    Pages := 1;
               End;
          5  : Begin
                    Mode  := 29;
                    Pages := 1;
               End;
          6  : Begin
                    Mode  := 27;
                    Pages := 1;
               End;
     End;
End;

{******************}

Begin
     TApplication.HandleEvent(Event);
     Case Event.What Of
     evCommand:
               Case Event.Command Of
                    cmNewWin     : NewWin;
                    cmDoGraphics : DoGraphics;
                    cmTile       : Tile1;
                    cmCascade    : Cascade1;
                    cmGetVideo   : GetVideo;
                    cmAbout      : About;
                    cmNewFile    : NewFile;
               Else
                   Exit;
               End;
     Else
         Exit;
     End;
     ClearEvent(Event);
End;

{************************************************}

Procedure TFGApp.InitMenuBar;
Var
   R: TRect;
Begin
     GetExtent(R);
     R.B.Y := R.A.Y + 1;
     MenuBar := New(PMenuBar, Init(R, NewMenu(
      NewSubMenu('~T~est', hcNoContext, NewMenu(
      NewItem('~G~raph', 'Alt-F5', kbAltF5, cmDoGraphics, hcNoContext,
      NewItem('Get ~V~ideo', 'Alt-V', kbAltV, cmGetVideo, hcNoContext,
      NewItem('~N~ew PCX File', 'Alt-N', kbAltN, cmNewFile, hcNoContext,
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      NewItem('~A~bout', 'Alt-A', kbAltA, cmAbout, hcNoContext,
      nil)))))),
      NewSubMenu('~W~indows', hcNoContext, NewMenu(
      NewItem('~S~ize/move','Ctrl-F5', kbCtrlF5, cmResize, hcNoContext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      NewItem('~T~ile', '', kbNoKey, cmTile, hcNoContext,
      NewItem('C~a~scade', '', kbNoKey, cmCascade, hcNoContext,
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~P~revious', 'Shift-F6', kbShiftF6, cmPrev, hcNoContext,
      NewItem('~C~lose', 'Alt-F3', kbAltF3, cmClose, hcNoContext,
      NewLine(
      NewItem('Add ~w~indow','F4', kbF4, cmNewWin, hcNoContext,
      nil)))))))))),
      nil)))));
End;

{************************************************}

Procedure TFGApp.InitStatusLine;
Var
  R: TRect;
Begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  New(StatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~Alt-F5~ Graph', kbAltF5, cmDoGraphics,
      NewStatusKey('~Alt-V~ Video', kbAltV, cmGetVideo,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbF5, cmZoom,
      NewStatusKey('', kbCtrlF5, cmResize,
      NewStatusKey('', kbF6, cmNext,
      nil)))))))),
    nil)));
End;

{************************************************}

Procedure TFGApp.OutOfMemory;
Begin
     MessageBox('Out of memory.', nil, mfError or mfOkButton);
End;

{************************************************}

Procedure TFGApp.Idle;

Begin
     TApplication.Idle;
     Clock^.Update;
     Heap^.Update;
End;

{************************************************}

Var
   FGApp: TFGApp;

BEGIN
     FGApp.Init;
     FGApp.Run;
     FGApp.Done;
END.
