/****************** Sierpinsky Gasket, alias The Chaos Game ****************/

#include <conio.h>
#include <graphics.h>
#include <stdlib.h>
#include <time.h>

#define NUMBER_OF_VERTICES 3
#define POINT_COUNT (NUMBER_OF_VERTICES + 1)
#define CIRCLE_RADIUS 4
#define TRIANGLE_COLOR RED
#define CIRCLE_COLOR CYAN
#define BACKGROUND_COLOR WHITE
#define MAX_SCREEN_WIDTH 639
#define MAX_SCREEN_HEIGHT 479
#define MID_DIVISOR 2
#define V0x 320
#define V0y 10
#define V1x 10
#define V1y 450
#define V2x 630
#define V2y 450


   typedef struct { int x_coord, y_coord; } Point;
   int triangle[ POINT_COUNT * 2 ] =
				 { V0x, V0y, V1x, V1y, V2x, V2y, V0x, V0y };
   Point V[NUMBER_OF_VERTICES] = {
				 { V0x, V0y },
				 { V1x, V1y },
				 { V2x, V2y }
				 };

   void graphics_setup( int background_color );
   void draw_triangle();
   void set_up();
   void Sierpinsky();
   Point get_seed();
   Point calculate_midpoint( Point p1, Point p2 );


void main()
{
  
      set_up();
     
      Sierpinsky();

      getch(); // Stop the action...
      getch(); // Wait for new keypress.
      closegraph();
}        

void set_up()
{

      randomize();
      graphics_setup( BACKGROUND_COLOR );
      setlinestyle( SOLID_LINE, 1, NORM_WIDTH );
      draw_triangle();

      return;

}

void graphics_setup( int background_color )
{
   int grdriver = VGA,
       grmode = VGAHI;

       registerfarbgidriver( EGAVGA_driver_far );
       registerfarbgifont( triplex_font_far );
       initgraph( &grdriver, &grmode, "" );
       setbkcolor( background_color );

       return;

}

void draw_triangle( )
{

      setcolor( TRIANGLE_COLOR );
      drawpoly( POINT_COUNT, triangle );

      return;
}

Point get_seed()
{
   Point Initial;

   Initial.x_coord = random( MAX_SCREEN_WIDTH );
   Initial.y_coord = random( MAX_SCREEN_HEIGHT ); 

      return ( Initial );
}

Point calculate_midpoint( Point p1, Point p2 )
{
   Point mid;

      mid.x_coord = ( p2.x_coord + p1.x_coord ) / MID_DIVISOR;

      mid.y_coord = ( p2.y_coord + p1.y_coord ) / MID_DIVISOR;

      return( mid );

} 

void Sierpinsky()
{
   Point Pi,
	  P,
	  Pnext;
    int pixel_color;
    register int t;

      Pi = get_seed();
      P = Pi;
      putpixel( P.x_coord, P.y_coord, pixel_color );
      setcolor( CIRCLE_COLOR );
      circle( P.x_coord, P.y_coord, CIRCLE_RADIUS );

      while( !kbhit() )
	 {
	 t = random( NUMBER_OF_VERTICES );

	 Pnext = calculate_midpoint( P, V[t] );
	 putpixel( Pnext.x_coord, Pnext.y_coord, 2 * t + 1 );
	 P = Pnext;
	 }

      return;

}