EXTPROC CEnvi
/***********************************************************
 *** BoxPos.cmd - Set and/or show the default values for ***
 ***              OS/2 and DOS boxes                     ***
 ***********************************************************/

#include <Profile.lib>

main(argc,argv)
{
   // Get current size
   #define SHAPE_SIZE   18
   #define ROW_OFFSET   6
   #define COL_OFFSET   8
   BLObSize(current,SHAPE_SIZE);
   PrfQueryProfileData(HINI_USERPROFILE,"Shield","sInitialShape",current,SHAPE_SIZE);
   printf("Current Position (row x col) = %d x %d\n",
          BLObGet(current,ROW_OFFSET,SWORD16),BLObGet(current,COL_OFFSET,SWORD16));

   if ( argc != 1  &&  argc != 3 )
      Instructions();
   else if ( argc == 3 ) {
      row = atoi(argv[1]), col = atoi(argv[2]);
      BLObPut(current,ROW_OFFSET,row,SWORD16);
      BLObPut(current,COL_OFFSET,col,SWORD16);
      PrfWriteProfileData(HINI_USERPROFILE,"Shield","sInitialShape",current,SHAPE_SIZE);
   }
}

Instructions()
{
   printf("\n")
   printf("BoxPos - Show and Set the default position for DOS and OS/2 windows\n")
   printf("\n")
   printf("USAGE: BoxPos [Row Column]\n")
   printf("\n")
   printf("WHERE: Row & Column are the position for lower-left corner\n")
   printf("\n")
   printf("EXAMPLES: BoxPos 0 0      - Set to lowest left corner\n")
   printf("          BoxFont 100 300 - Set to row 100, column 300\n");
   printf("\n")
}

