@echo off
REM ******************************************************
REM *** Install the rest of this code to stay resident ***
REM ******************************************************

start "BugHunt" /N /B /WIN /MIN CEnvi "#include 'BugHunt.cmd,,,/*RESIDENT*/'"
call WinSet BugHunt HIDE
EXIT

/*RESIDENT*/
/*************************************************************************
 *** BugHunt.cmd - Example program for using the ClipBoard routines in ***
 ***               ClipBrd.lib.  This is a very silly program that     ***
 ***               searches every few seconds for the text of "bug"    ***
 ***               anywhere in the clipboard text.                     ***
 ***                                                                   ***
 ***               This program also demonstrates the unusual          ***
 ***               technique of calling CEnvi to execute code contain  ***
 ***               within the source of another CEnvi program.         ***
 *************************************************************************/

#define  BUGHUNT_FREQUENCY    5   // how many seconds to wait between hunts

#include <ClipBrd.lib>
#include <MsgBox.lib>


MessageBox("This program will search for\n"
           "bugs in your clipboard. That\n"
           "is, it will search for the\n"
           "word \"bug\" (case-insensitive)\n"
           "and ask you if you want to\n"
           "delete the clipboard if a\n"
           "\"bug\" is found.",
           "EXTERMINATOR!");


for(;;) {   // FOREVER
   ClipText = GetClipboardData(CF_TEXT);
   if ( ClipText != NULL ) {
      // check clipboard, case-insensitive, for the "bug" string
      while ( NULL != (ClipText = strpbrk(ClipText,"Bb")) ) {
         // check if the rest of this is "ug"
         if ( !memicmp(++ClipText,"ug",2) ) {
            if ( ExterminationWanted() )
               ExterminateTheClipboard();
            break;
         }
      }
   }
   suspend(BUGHUNT_FREQUENCY * 1000);
}

ExterminationWanted() // Return TRUE if user wants to delete the clipboard
{
   return ( MBID_YES == MessageBox("A bug has been found in\n"
                                   "the clipboard. Should the\n"
                                   "clipboard be exterminated?",
                                   "EXTERMINATOR!",
                                   MB_WARNING|MB_MOVEABLE|MB_YESNO) );
}

ExterminateTheClipboard() // spawn message program to run while this program
{                         // deletes the text in the clipboard.
   // Run another CEnvi process to tell that extermination is happening.
   // That other program will read the code from this program; weird, huh!
   system("start /N /WIN /MAX CEnvi \"#include <BugHunt.cmd,,//Exterminator!>\" ");ugh
   // while that's going on, we'll simultaneously delete the clipboard
   PutClipboardData(NULL);
}


// The text below, which is a comment in this program, is the CODE for another
// instance of CEnvi which was spawned above in the ExterminateTheClipboard()
// routine.  Since Windows is multitasking (sort of) this code will be running
// while the original instance of CEnvi is deleting the clipboard.

//Exterminator!   for ( i = 0; i < 100; i++ ) {
//Exterminator!      printf("Bug!\tEEEK!\t");
//Exterminator!   }
//Exterminator!   suspend(500);
//Exterminator!   printf("\nCLIPBOARD EXTERMINATED!");
//Exterminator!   suspend(500);
