EXTPROC CEnvi
/**************************************************************
 *** Devices - Get information about attached devices using ***
 ***           DosDevConfig() calls.                        ***
 **************************************************************/

#define DEVINFO_PRINTER       0  // Number of attached printers.
#define DEVINFO_RS232         1  // Number of RS232 ports.
#define DEVINFO_FLOPPY        2  // Number of diskette drives.
#define DEVINFO_COPROCESSOR   3  // Presence of math coprocessor hardware:
                                 //  0 = No coprocessor hardware.
                                 //  1 = Coprocessor hardware installed.
#define DEVINFO_SUBMODEL      4  // PC Submodel Type.  The returned
                                 // information is the system submodel byte.
#define DEVINFO_MODEL         5  // PC Model Type.  The returned information
                                 // is the system model byte.
#define DEVINFO_ADAPTER       6  // Type of primary display adapter:
                                 //  0 = Monochrome or printer adapter.
                                 //  1 = Other.

printf("Device configuration for your system:\n");
printf("  Printer count: %d\n",GetDosDevConfig(DEVINFO_PRINTER));
printf("  RS232 port count: %d\n",GetDosDevConfig(DEVINFO_RS232));
printf("  Floppy drive count: %d\n",GetDosDevConfig(DEVINFO_FLOPPY));
printf("  Math coprocessor installed: %s\n",
       GetDosDevConfig(DEVINFO_FLOPPY) ? "YES" : "NO" );
printf("  PC Model: %d\n",GetDosDevConfig(DEVINFO_MODEL));
printf("  PC Submodel: %d\n",GetDosDevConfig(DEVINFO_SUBMODEL));
printf("  Primary display adapter: %s\n",
       GetDosDevConfig(DEVINFO_FLOPPY) ? "Color" : "Monochrome" );


GetDosDevConfig(DeviceType)   // call DosDevConfig() to return the value for
{                             // requested DeviceType.
   BLObSize(DeviceInfo,100);  // make it big in case a lot of data is returned
   #define ORD_DOS32DEVCONFIG 231
   rc = DynamicLink("doscalls",ORD_DOS32DEVCONFIG,BIT32,CDECL,
                    DeviceInfo,DeviceType)
   assert( 0 == rc );
   // all known DeviceTypes get a byte returned about their info
   return( BLObGet(DeviceInfo,0,UWORD8) );
}

