EXTPROC CEnvi
/****************************************************************
 *** DosObj - This is an example, and a template, for using   ***
 ***          the WinCreateObject function to create any type ***
 ***          of object.  You can easily adapt this.          ***                                       full-screen Windows session.  You may **
 ****************************************************************/

#include <PMdll.lib>
//#include <KeyPush.lib>
#include <ClipBrd.lib>
#include <Profile.lib>
SetupString = ""; // initialize to contain nothing

// SET THE SESSION PROGRAM TYPE, UNCOMMENT THE FOLLOWING LINE THAT APPLIES
   // Setup("PROGTYPE=FULLSCREEN"); // OS/2 full screen
   // Setup("PROGTYPE=WINDOWABLEVIO");// OS/2 windowed
   // Setup("PROGTYPE=VDM");        // DOS full screen
   Setup("PROGTYPE=WINDOWEDVDM");   // DOS windowed
   // Setup("PROGTYPE=PM");         // PM
   // Setup("PROGTYPE=SEPARATEWIN");// WIN-OS2 window in separate VDM
   // Setup("PROGTYPE=WIN");        // WIN-OS2 full screen
   // Setup("PROGTYPE=WINDOWEDWIN");// WIN-OS2 windowed
   // Setup("PROGTYPE=PROG_31_ENH");   // WIN-OS/2 full screen,
                                       // NOT a separate VDM session
                                       // 3.1 Enhanced
   // Setup("PROGTYPE=PROG_31_ENHSEAMLESSVDM); // WIN-OS2 windowed,
                                               // Separate VDM session
                                               // 3.1 Enhanced
   // Setup("PROGTYPE=PROG_31_ENHSEAMLESSCOMMON); // WIN-OS2 windowed
                                                  // NOT a separate VDM
                                                  // 3.1 Enhanced

// Windowed session options; uncomment those to apply
   // Setup("MINIMIZED=YES");    // Start program minimized
   Setup("MAXIMIZED=YES");    // Start program maximized
   // Setup("NOAUTOCLOSE=YES");  // Leaves the window open
   // Setup("NOAUTOCLOSE=NO");   // Closes the window at termination

// LOTS OF DOS (and Windows) SETTINGS; USE THOSE THAT ARE NOT THE DEFAULT
// AND THAT YOU WANT TO APPLY, (there's more than listed here)
   // Setup("SET DOS_DEVICE=")
   // Setup("SET DOS_FCBS=2")
   // Setup("SET DOS_FCBS_KEEP=2")
   // Setup("SET DOS_FILES=55")
   // Setup("SET DOS_HIGH=0")
   // Setup("SET DOS_UMB=0")
   // Setup("SET DPMI_DOS_API=ENABLED")
   // Setup("SET DPMI_MEMORY_LIMIT=3")
   // Setup("SET DPMI_NETWORK_BUFF_SIZE=1")
   Setup("SET IDLE_SECONDS=8")
   Setup("SET IDLE_SENSITIVITY=85")
   // Setup("SET EMS_FRAME_LOCATION=NONE")
   // Setup("SET EMS_HIGH_OS_MAP_REGION=0")
   // Setup("SET EMS_LOW_OS_MAP_REGION=0")
   // Setup("SET EMS_MEMORY_LIMIT=0")
   // Setup("SET VIDEO_8514A_XGA_IOTRAP=0")
   // Setup("SET VIDEO_SWITCH_NOTIFICATION=1")
   // Setup("SET XMS_HANDLES=0")
   // Setup("SET XMS_MEMORY_LIMIT=0")
   // Setup("SET XMS_MINIMUM_HMA=0")

// TELL TO OPEN IMMEDIATELY (OPEN=SETTINGS would open SETTINGS folder)
   Setup("OPEN=DEFAULT");

// Set up executable name, parameters, and startup directory
   Setup("EXENAME=*");
   Setup("PARAMETERS=/K mode 80,25");
   Setup("STARTUPDIR=C:\\OS2");

// Set the title for this session
   Title = "DOS Box";

// Before calling, save current font and set to the one we want: 10 x 8
   GetCurrentBoxFont(SaveFontHeight,SaveFontWidth);
   SetCurrentBoxFont(10,8);

// Call the API function to create an object
   handle = WinCreateObject("WPProgram",Title,SetupString,"<WP_NOWHERE>",
                            CO_REPLACEIFEXISTS);

// Restore window font to what it used to be
   SetCurrentBoxFont(SaveFontHeight,SaveFontWidth);

   if ( handle == NULL )
      printf("\a\a\aUnable to WinCreateObject() with given settings.\n"), exit(1);

// Get the Window handle from its title
   hwnd = GetWindowHandle(Title,SwitchHandle)

// call switch.cmd CEnvi function to bring this program to the foreground
   WinSwitchToProgram(SwitchHandle);

// Get Dimensions of this window and of the whole screen
   #define HWND_DESKTOP 1
   GetWindowPosition(HWND_DESKTOP,col,row,DesktopWidth,DesktopHeight)
   GetWindowPosition(hwnd,col,row,width,height)

// Move this window to where we want it, this could be anywhere...
// In this case center it against the right edge of the screen.
   col = DesktopWidth - width;
   row = (DesktopHeight - height) / 2;
// Some screen positions don't look so good, so adjust to "good" position
   #define GOOD_COL_OFFSET 8
   #define GOOD_ROW_OFFSET 1
   col -= (col - GOOD_COL_OFFSET/2) % GOOD_COL_OFFSET
   row -= (row - GOOD_ROW_OFFSET/2) % GOOD_ROW_OFFSET
   MoveWindow( hwnd, col, row );

// Send a "DIR" command to this session via the clipboard
   // ClipCommand = "DIR\r";
   // PutClipboardData(ClipCommand,1+strlen(ClipCommand),CF_TEXT);
   // KeyStroke(VK_ALT), KeyStroke('P');

/****************** FUNCTIONS USED BY ABOVE CODE *********************/

Setup(format) // This is like printf, but adds to the end of SetupString for
              // each incarnation, plus a ';' to separate fields
{
   va_start(va_list,format);
   str = SetupString + strlen(SetupString);
   vsprintf(str,format,va_list);
   va_end(va_list);
   strcat(SetupString,";");
}

GetWindowHandle(WindowName,Switch_Handle)
{
   // will try a number of times, to give it time to get going
   #define  RETRY_COUNT    50
   #define  RETRY_DELAY    100   // milliseconds to wait between retries
   for ( retry = 0; retry < RETRY_COUNT; retry++, suspend(RETRY_DELAY) ) {
      // build list of all window titles
      SwitchList = WinQuerySwitchList(PMInfo().hab);
      for ( i = GetArraySpan(SwitchList); 0 <= i; i-- ) {
         if ( 0 == WinQuerySwitchEntry(SwitchList[i],SwEntry) ) {
            if ( !strcmp(WindowName,SwEntry.title)
              &&  NULL != SwEntry.hwnd ) {
               Switch_Handle = SwitchList[i];
               return(SwEntry.hwnd);
            }
         }
      }
   }
   // if made it here then window not found, so exit
   exit(1);
}

MoveWindow(hwnd,col,row)
{
   #define ORD_WIN32SETWINDOWPOS 875
   #define SWP_MOVE              0x0002
   #define SWP_NOADJUST          0x0040
   PMDynamicLink("PMWIN",ORD_WIN32SETWINDOWPOS,BIT32,CDECL,
                 hwnd,0,col,row,0,0,SWP_MOVE | SWP_NOADJUST);
}

GetWindowPosition(hwnd,Col,Row,Width,Height)
{
   #define SWP_BLOB_SIZE 9 * 4
   BLObSize(swp,SWP_BLOB_SIZE);
   #define ORD_WIN32QUERYWINDOWPOS  837
   if !DynamicLink("PMWIN",ORD_WIN32QUERYWINDOWPOS,BIT32,CDECL,hwnd,swp)
      exit(1);
   Height = BLObGet(swp,4,SWORD32);
   Width = BLObGet(swp,8,SWORD32);
   Row = BLObGet(swp,12,SWORD32);
   Col = BLObGet(swp,16,SWORD32);
}

GetCurrentBoxFont(height,width)
{
   BLObSize(current,2);
   PrfQueryProfileData(HINI_USERPROFILE,"Shield","~Font Size...",current,2);
   height = BLObGet(current,1,UWORD8);
   width = BLObGet(current,0,UWORD8);
}

SetCurrentBoxFont(height,width)
{
   BLObPut(current,0,width,UWORD8);
   BLObPut(current,1,height,UWORD8);
   PrfWriteProfileData(HINI_USERPROFILE,"Shield","~Font Size...",current,2);
}

