EXTPROC CEnvi
/*********************************************************
 *** DumpINI - Dump profile settings from a .INI file. ***
 ***           This is a CEnvi example for using the   ***
 ***           Profile.lib Cmm library .               ***
 *********************************************************/
 
#include <Profile.lib>

main(argc,argv)
{
   if ( argc < 2 ||  !strcmp(argv[1],"/?")  ||  !stricmp(argv[1],"/help")  || 4 < argc )
      Instructions();
   else {
      // Get parameters from input; default to NULL if parameter not supplied
      IniSpec = argv[1];
      AppSpec = 2 < argc ? argv[2] : NULL ;
      KeySpec = 3 < argc ? argv[3] : NULL ;

      hini = OpenIni(IniSpec);
      if ( NULL == AppSpec ) {
         // display for ALL apps in this ini
         AppCount = PrfGetApplicationNames(hini,AppList);
         for ( i = 0; i < AppCount; i++ )
         DisplayAppIni(hini,AppList[i],KeySpec);
      } else {
         // display for only one app
         DisplayAppIni(hini,AppSpec,KeySpec);
      }
      CloseIni(hini);
   }
   return(EXIT_SUCCESS);
}

DisplayAppIni(hini,AppName,KeySpec)
{
   printf("\n<%s>\n",AppName);
   if ( NULL == KeySpec ) {
      // display for ALL keys in this App
      KeyCount = PrfGetKeyNames(hini,AppName,KeyList);
      for ( i = 0; i < KeyCount; i++ )
         DisplayKeyIni(hini,AppName,KeyList[i]);
   } else {
      // display for only one key
      DisplayKeyIni(hini,AppName,KeySpec);
   }
}

DisplayKeyIni(hini,AppName,KeyName)
{
   printf(" <%s>\n",KeyName);
   // Get size of data
   if ( !PrfQueryProfileSize(hini,AppName,KeyName,datalen) || !datalen )
      printf("\aKey \"%s\" not found!\n",KeyName);
   else {
      // make buffer 3 times this big, just to be sure
      BLObSize(data,datalen *= 3);
      if ( !PrfQueryProfileData(hini,AppName,KeyName,data,datalen) || !datalen )
         printf("\aKey \"%s\" not found!\n",KeyName);
      else
         DisplayBinaryData(data,datalen);
   }
}

DisplayBinaryData(buf,buflen)
{
   Unprintables = "\a\b\t\r\n\032\033"
   for ( offset = 0; 0 < (count = min(buflen,16)); buf += count, buflen -= count ) {
      // indent each line
      printf("    ")
      // display hex value for each number
      for ( i = 0; i < count; i++ )
         printf("%02X ",buf[i])
      // fill in any extra gaps if count < 16
      while( i++ < 16 )
         printf("   ")
      // display ascii value for each printable character
      // substitute a period for unprintable characters
      memcpy(str,buf,count);
      str[count] = 0; // string must be null-terminated
      while( (UnprintableIndex = strcspn(str,Unprintables)) < count )
         str[UnprintableIndex] = '.';
      printf("   %s\n",str)
   }
}

#define  OS2_INI     "OS2"
#define  OS2SYS_INI  "OS2SYS"

OpenIni(Spec)
{
   if ( !strcmpi(Spec,OS2_INI) ) return HINI_USERPROFILE;
   if ( !strcmpi(Spec,OS2SYS_INI) ) return HINI_SYSTEMPROFILE;
   if ( NULL == (hini = PrfOpenProfile(Info().hab,Spec)) ) {
      printf("\aCannot open profile filespec \"%s\"\n",Spec);
      exit(EXIT_FAILURE);
   }
   return hini;
}

CloseIni(hini)
{
   if ( HINI_USERPROFILE != hini  &&  HINI_SYSTEMPROFILE != hini )
      PrfCloseProfile(hini);
}

Instructions()
{
   printf("\n")
   printf("DumpINI - Display profile settings in a .INI file\n")
   printf("\n")
   printf("SYNTAX: DumpINI <FileSpec> [ApplicationName [KeyName]]\n")
   printf("\n")
   printf("Where: FileSpec - Name of the INI file.  For the OS2 system file use the\n")
   printf("                  spacial name \"%s\" and for OS2 user file use \"%s\".\n",OS2SYS_INI,OS2_INI)
   printf("       ApplicationName - Application number under which the settings are saved\n")
   printf("                  If not supplied then list ALL applications\n")
   printf("       KeyName - Name of the KEY for this setting; defaults to ALL keys\n")
   printf("\n")
}

