EXTPROC CEnvi
/************************************************************************
 *** EPM.cmd - CEnvi program to start EPM with my favorite parameters ***
 ***           and also by linking related .C, .H, or .CPP files if   ***
 ***           any related file is an input parameter.                ***
 ************************************************************************/

main(argc,argv)
{
   // all commands begin initially the same
   EPMCommand = "start C:\\OS2\\APPS\\EPM.EXE /O /M /W"
   IncludeFamily = FALSE  // assume family not included
   if ( argc == 2  &&  !NameContainsWildcards(argv[1]) ) {
      ext = SplitFileName(argv[1]).ext
      if ( !stricmp(ext,".cpp")  ||  !stricmp(ext,".h")  ||  !stricmp(ext,".c") ) {
         IncludeFamily = TRUE;
         // build full name including .cpp, .h, and .c and include them all,
         // but include the one that was entered first so it appears first
         FileSpec = FullPath(argv[1])
         if ( !AddFilespecIfFileExists(EPMCommand,FileSpec) )
            AddFilespecsToCommand(EPMCommand,FileSpec)
         NameParts = SplitFileName(FileSpec)
         AddFilespecIfFileExists(EPMCommand,NameParts.dir,NameParts.name,".cpp")
         AddFilespecIfFileExists(EPMCommand,NameParts.dir,NameParts.name,".h")
         AddFilespecIfFileExists(EPMCommand,NameParts.dir,NameParts.name,".c")
      }
   }
   if ( !IncludeFamily ) {
      // any number of names was supplied, or just one name was supplied but it
      // contained wildcards, and so simply open up with all of the names
      for ( i = 1; i < argc; i++ )
         AddFilespecsToCommand(EPMCommand,argv[i])
   }
   // EPMCommand has been build, and so finally execute it
   system(EPMCommand)
}

AddFilespecIfFileExists(Command,name1) // return TRUE if added, else FALSE
{                                      // also fix case
   // build full file spec
   strcpy(fullspec,name1)
   for ( i = 2; i < va_arg(); i++ )
      strcat(fullspec,va_arg(i))
   if ( NULL != (dirlist = Directory(fullspec)) ) {
      AddFilespecsToCommand(Command,dirlist[0].name)
      return TRUE
   }
   return FALSE
}

AddFilespecsToCommand(Command,FileName)
{
   strcat(strcat(Command," "),FileName)
}

NameContainsWildcards(Name) // return TRUE if contains wildcards, else FALSE
{
   return( NULL != strchr(Name,'*')  ||  NULL != strchr(Name,'?') )
}

