@echo OFF
REM *************************************************************************
REM *** GetUKey.cmd - Batch file using CEnvi to display a prompt and user ***
REM ***               choices and then set the UKEY environment variable  ***
REM ***               to what was chosen.                                 ***
REM *************************************************************************
CALL CEnviSet.cmd %0.cmd %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO CENVI_EXIT

main(argc,argv)
{
   if (argc < 2) {
      // no arguments were given, and so show how to use
      Instructions();
   } else {
      // everything up to the last argument is the prompt
      for ( KeyArg = 1; KeyArg < (argc-1); KeyArg++ )
         printf("%s ",argv[KeyArg])
      KeyList = strupr(argv[KeyArg])
      // flush keyboard
      while kbhit() getch();
      // read until one of the keys from KeyList is pressed
      while ( 0==(key=toupper(getch()))  ||  NULL == strchr(KeyList,key) )
         printf("\a")   // beep because an invalid key was pressed
      printf("%c\n",key)
      // save this key as short environment string UKEY
      (UKEY = "*")[0] = key
   }
}

Instructions()
{
   printf("\a\n")
   printf("GetUKey.cmd - Display a prompt and get key from user input.  The\n")
   printf("              environment variable UKEY will be set to the key selected\n")
   printf("\n")
   printf("USAGE: CEnvi GetUKey.cmd [Prompt] <KeyList>\n")
   printf("Where:\n")
   printf("   Prompt  - Text to display before prompting for character\n")
   printf("   KeyList - A string with the characters that will be accepted\n")
   printf("\n")
   printf("Example: CEnvi GetUKey.cmm \"Copy File, Delete it, or Quit? (C/D/Q)\" CDQ\n")
}

:CENVI_EXIT
