EXTPROC CEnvi
/**********************************************************************
 *** HexDump.cmd - Hexidecimal dump of the contents of a file. This ***
 ***               examples program uses the CEnvi file routines.   ***
 **********************************************************************/

main(argc,argv)
{
   if ( 2 != argc ) {
      Instructions()
   } else if ( NULL == (fp = fopen(argv[1],"rb")) ) {
      printf("Could not open file \"%s\" for hex output.\a\n",argv[1])
   } else {
      dump(fp)
      fclose(fp)
   }
}

dump(file)
{
   Unprintables = "\a\b\t\r\n\032\033"
   for ( offset = 0; 0 < (count = fread(data,16,file)); offset += 16 ) {
      // display hex offset in file
      printf("%06X  ",offset)
      // display hex value for each number
      for ( i = 0; i < count; i++ )
         printf("%02X ",data[i])
      // fill in any extra gaps if count < 16
      while( i++ < 16 )
         printf("   ")
      // display ascii value for each printable character
      // substitute a period for unprintable characters
      data[count] = 0; // string must be null-terminated
      while( (UnprintableIndex = strcspn(data,Unprintables)) < count )
         data[UnprintableIndex] = '.';
      printf("   %s\n",data)
      if ( count < 16 )
         break
   }
}

Instructions()
{
   printf("\n");
   printf("HexDump.cmd - Hexidecimal binary display of file data\n");
   printf("\n");
   printf("USAGE: HexDump <filespec>\n");
   printf("\n");
   printf("Where: filespec - Complete file specification without wildcards\n");
   printf("\n");
}

