EXTPROC CENVI
/**************************************************************************
 *** KeyState.cmd - CEnvi sample file which will set, unset, or display ***
 ***                the state of keyboard keys.                         ***
 **************************************************************************/

#include <FileIO.lib>
#include <DevIOCtl.lib>

#define  NUMLOCK_BIT    0x20
#define  CAPSLOCK_BIT   0x40
#define  INSERT_BIT     0x80
#define  VK_NUMLOCK     0x1D
#define  VK_CAPSLOCK    0x0E
#define  VK_INSERT      0x1A

main(argc,argv)
{
   // check that the input is valid
   if ( argc != 3
     || ( argv[1][1] != 0  ||  !strchr("+?-",argv[1][0]) )
     || ( strnicmp("CAP",argv[2],3)
       && strnicmp("NUM",argv[2],3)
       && strnicmp("INS",argv[2],3) ) ) {
      Instructions()
   } else {

      // determine whether to apply to CapsLock or NumLock
      if ( !strnicmp("CAP",argv[2],3) )
         KeyName = "CapsLock", KeyBit = CAPSLOCK_BIT, VKey = VK_CAPSLOCK;
      else if ( !strnicmp("NUM",argv[2],3) )
         KeyName = "NumLock",  KeyBit = NUMLOCK_BIT,  VKey = VK_NUMLOCK;
      else
         KeyName = "Insert",   KeyBit = INSERT_BIT,   VKey = VK_INSERT;

      // get current keyboard status
      KeyTable = GetGlobalKeyboardTable();

      switch( argv[1][0] ) {
         case '+':   // Set Key ON
            DesiredState = TRUE;
            break
         case '-':   // Turn KEY OFF
            DesiredState = FALSE;
            break
         case '?':   // desired state is whatever it currently is
            DesiredState = KeyTable[VKey] & 1;
            printf("%s is currently set %s.\n",KeyName,DesiredState ? "ON" : "OFF")
            break;
      }
      // In case any values are out-of-sync, set them all now
      SetLocalKeyboardStatus(KeyBit,DesiredState);
      SetGlobalKeyboardTable(KeyTable,VKey,DesiredState);
      return( DesiredState )
   }
}


SetLocalKeyboardStatus(KeyBit,Set)  // set keyboard state from structure
{                                   // elements .ShiftState and .NLS
   // Open $Kbd device
   rc = DosOpen("\\DEV\\KBD$",FileHandle,ActionTaken,0,0,
                OPEN_ACTION_OPEN_IF_EXISTS,
                OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,NULL);
   assert( 0 == rc );

   // call DosDevIOCTL to get kbd state
   #define KEYBOARD_CATEGORY     4
   #define KBD_GETSHIFTSTATE     0x0073
   #define GET_DATA_SIZE         3
   rc = DosDevIOCtl(FileHandle,KEYBOARD_CATEGORY,KBD_GETSHIFTSTATE,
                    NULL,0,0,Data,GET_DATA_SIZE,DataSize);
   assert( 0 == rc );
   ShiftState = BLObGet(Data,0,UWORD16);

   // call DosDevIOCTL to set kbd state
   if ( Set )
      ShiftState |= KeyBit;
   else
      ShiftState &= ~KeyBit;
   #define KBD_SETSHIFTSTATE     0x0053
   BLObPut(Data,0,ShiftState,UWORD16);
   rc = DosDevIOCtl(FileHandle,KEYBOARD_CATEGORY,KBD_SETSHIFTSTATE,
                    Data,DataSize,DataSize,NULL,0,0);
   assert( 0 == rc );


   // set LED's to show the state of the keyboard
   #define KBD_SETLEDS  0x005A
   leds = (ShiftState & 0x70) >> 4;
   BLObPut(Data,0,leds,UWORD16);
   DataSize = 2;
   DynamicLink("doscalls",ORD_DOS32DEVIOCTL,BIT32,CDECL,
               FileHandle,KEYBOARD_CATEGORY,KBD_SETLEDS,
               Data,DataSize,DataSize,NULL,0,NULL);

   // close device
   DosClose(FileHandle);
}


#define HWND_DESKTOP                     1
#define ORD_WIN32SETKEYBOARDSTATETABLE   921

GetGlobalKeyboardTable()   // return 256-byte buffer for current keyboard
{
   table[255] = '\0';   // initialize 256-byte key table
   DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
               HWND_DESKTOP,table,FALSE);
   return(table);
}

SetGlobalKeyboardTable(KeyTable,VirtualKey,SetBool)
{
   if ( SetBool )
      KeyTable[VirtualKey] |= 1;
   else
      KeyTable[VirtualKey] &= 0xFE;
   DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
               HWND_DESKTOP,KeyTable,TRUE);
}

Instructions()
{
   printf("\a\n")
   printf("KeyState - Set, Clear, or Show the keyboard state of NumLock or CapsLock\n");
   printf("\n");
   printf("SYNTAX: KeyState < + | - | ? > < CAP | NUM | INS >\n");
   printf("\n");
   printf("Where:  +    Set KeyState ON\n");
   printf("        -    Set KeySTate OFF\n");
   printf("        ?    Display current Key State, and return ERRORLEVEL 1 if set\n");
   printf("             and ERRORLEVEL 0 if clear\n");
   printf("        NUM  Apply command < + | - | ? > to the NumLock key\n");
   printf("        CAP  Apply command < + | - | ? > to the CapsLock key\n");
   printf("        INS  Apply command < + | - | ? > to the Insert key\n");
   printf("\n");
   printf("Examples: KeyState + Num      Turn on the Numlock key\n");
   printf("          KeyState - Cap      Turn of the CapsLock key\n");
   printf("          KeyState ? Num      Show state of NumLock, return ERRORLEVEL if set\n");
   printf("\n")
}

