EXTPROC CEnvi
/***********************************************************************
 *** Kill.cmd - CEnvi program to kill a running process by reference ***
 ***            to its ID, partial name, or full name, or by full or ***
 ***            partial name of it Window.                           ***
 ***********************************************************************/

#include <PMdll.lib>

#define  NO_ERROR          0     // return code from most successful DosCalls

DosKillProcess(ActionCode,ProcessID)
   // kill specified ProcessID using action code DKP_PRECESSTREE or DKP_PROCESS
{
   #define DKP_PROCESSTREE    0  // kill process and all descendents, if created by this process
   #define DKP_PROCESS        1  // kill any process even if not created by this process
   #define ORD_DOS32KILLPROCESS  235
   return DynamicLink("doscalls",ORD_DOS32KILLPROCESS,BIT32,CDECL,ActionCode,ProcessID)
}

MaybeKill(KillSpec,id,fullname)  // if KillSpec matches any part of ProcSpec, then kill
{                                // the id of ProcSpec
   // divide this process id into numbers and parts so we can compare
   // against any one of these types
   root = SplitFileName(fullname).name;
   sprintf(name,"%s%s",root,SplitFileName(fullname).ext);
   if ( (0 != id  &&  id == atoi(KillSpec))
     || 0 == stricmp(KillSpec,fullname)
     || 0 == stricmp(KillSpec,root)
     || 0 == stricmp(KillSpec,name) ) {
      // this id matched, and so try to kill it
      rc = DosKillProcess(DKP_PROCESS,id);
      if ( NO_ERROR == rc ) {
         printf("%s has been killed.\n",fullname);
      } else {
         printf("\aError %d in DosKillProcess() from id %d\n",rc,id);
      }
   }
}

main(argc,argv)
{
   if ( argc != 2  ||  !strcmp(argv[1],"/?")  ||  !strcmpi(argv[1],"help") ) {
      Instructions();
   } else {
      // build list of all running processes
      ProcList = ProcessList();
      assert( NULL != ProcList );
      ProcCount = 1 + GetArraySpan(ProcList);
      // check each running process against this ID, whether it be name, or id
      // number, or full or partial name, and try to kill it if it matches
      for ( i = 0; i < ProcCount; i++ )
         MaybeKill(argv[1],ProcList[i].id,ProcList[i].name);
      // build list of all window titles
      SwitchList = WinQuerySwitchList(Info().hab);
      assert( SwitchList != NULL );
      SwitchCount = 1 + GetArraySpan(SwitchList);
      for ( i = 0; i < SwitchCount; i++ ) {
         if ( 0 == WinQuerySwitchEntry(SwitchList[i],SwEntry) )
            MaybeKill(argv[1],SwEntry.process,SwEntry.title);
      }
   }
}

Instructions()
{
   printf("\n")
   printf("Kill - Kill a running process by name, Window name, process ID.\n")
   printf("\n")
   printf("SYNTAX: Kill ProcessName | WindowTitle | ProcessID\n")
   printf("\n")
   printf("Where:  ProcessName - Full or partial name of running process\n")
   printf("        WindowTitle - Full Window title\n")
   printf("        ProcessID   - Numeric ID of the process to kill\n")
   printf("\n")
   printf("Example: Kill e.exe\n")
   printf("\n")
}

