EXTPROC CENVI
/****************************************************************************
 *** NumLock.cmd - Turn ON NUMLOCK for this session and for all sessions. ***
 ***               This program, or a shadow of it, can be included in    ***
 ***               your OS/2 startup folder if you want NumLock on as     ***
 ***               a default when you turn on your computer.              ***
 ***                                                                      ***
 ***               If you run with a second parameter, then that is the   ***
 ***               wait interval and this program runs forever setting    ***
 ***               the numlock key at that interval.                      ***
 ****************************************************************************/


main(argc,argv)
{
   if ( argc != 1  &&  0 == (WaitInterval = atoi(argv[1])) ) {
      ShowInstructions();
   } else {
      SetLocalKeyboardStatus();
      SetGlobalKeyboardTable();
      if ( 1 != argc ) {
         // kill the resident if it's already running
         system("kill \"%s\"",WindowTitle);
         // install the resident version of this program
         system("start \"%s\" /N /B /WIN /MIN CEnvi #include '%s,,,/*RESIDENT*/' Forever(%d)",
                WindowTitle,argv[0],WaitInterval);
      }
   }
}

ShowInstructions()
{
   printf("\a\n");
   printf("NumLock.cmd - Set the NumLock key ON for OS/2 sessions and for the WPS.\n");
   printf("\n");
   printf("SYNTAX: NumLock [Interval]\n");
   printf("\n");
   printf("Where:   Interval - Optional period to suspend, without taking processor\n");
   printf("                    time, before setting the NUMLOCK key again. If this\n");
   printf("                    is not supplied or is 0 then will only set NUMLOCK\n");
   printf("                    once and then exit. Time is in milliseconds. You may\n");
   printf("                    want to set this process looping every second, or so,\n");
   printf("                    if you need to keep NUMLOCK reset after a full-screen\n");
   printf("                    session has undone it.\n");
   printf("\n");
   printf("Example: NumLock         - sets NumLock only once\n");
   printf("         NumLock 1000    - sets NumLock once every second\n");
   printf("\n");
}

#define  NUMLOCK_BIT    0x20

SetLocalKeyboardStatus()  // set NUMLOCK on for local session
{
   // Open $Kbd device
   #define ORD_DOS32OPEN   273
   DynamicLink("doscalls",ORD_DOS32OPEN,BIT32,CDECL,
               "\\DEV\\KBD$",FileHandle,ActionTaken,0,
               0,0x01,0x40,0);

   // call DosDevIOCTL to get kbd state
   #define ORD_DOS32DEVIOCTL     284
   #define KEYBOARD_CATEGORY     4
   #define KBD_GETSHIFTSTATE     0x0073
   #define DATA_SIZE             3
   BLObSize(Data,DATA_SIZE);
   DynamicLink("doscalls",ORD_DOS32DEVIOCTL,BIT32,CDECL,
               FileHandle,KEYBOARD_CATEGORY,KBD_GETSHIFTSTATE,
               NULL,0,NULL,Data,DATA_SIZE,NULL);
   ShiftState = BLObGet(Data,0,UWORD16);

   // call DosDevIOCTL to set kbd state
   ShiftState |= NUMLOCK_BIT;
   #define KBD_SETSHIFTSTATE     0x0053
   BLObPut(Parms,ShiftState,UWORD16);
   DynamicLink("doscalls",ORD_DOS32DEVIOCTL,BIT32,CDECL,
               FileHandle,KEYBOARD_CATEGORY,KBD_SETSHIFTSTATE,
               Parms,DATA_SIZE,NULL,NULL,0,NULL);

   // set LED's to show the state of the keyboard
   #define KBD_SETLEDS  0x005A
   leds = (ShiftState & 0x70) >> 4;
   BLObPut(Parms,0,leds,UWORD16);
   DynamicLink("doscalls",ORD_DOS32DEVIOCTL,BIT32,CDECL,
               FileHandle,KEYBOARD_CATEGORY,KBD_SETLEDS,
               Parms,2,NULL,NULL,0,NULL);

   // close device
   #define ORD_DOS32CLOSE  257
   DynamicLink("doscalls",ORD_DOS32CLOSE,BIT32,CDECL,FileHandle);
}


/*RESIDENT*/
// All code below this is part of the resident program

WindowTitle = "NumLock Forever";

Forever(WaitInterval)
{
   // hide this window
   system("WinSet \"%s\" HIDE",WindowTitle);
   // check at every interval and set keyboard if it is not already set
   for(;;) {
      SetGlobalKeyboardTable();
      suspend(WaitInterval);
   }
}

SetGlobalKeyboardTable() // set VK_NUMLOCK bit if not already set
{
   #define HWND_DESKTOP                     1
   #define VK_NUMLOCK     0x1D
   #define ORD_WIN32SETKEYBOARDSTATETABLE   921
   KeyTable[255] = '\0'; // pre-allocate a 256 byte buffer
   if ( DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
                    HWND_DESKTOP,KeyTable,FALSE) ) {
      if ( !(KeyTable[VK_NUMLOCK] & 1) ) {
         KeyTable[VK_NUMLOCK] |= 1;
         DynamicLink("PMWIN",ORD_WIN32SETKEYBOARDSTATETABLE,BIT32,CDECL,
                     HWND_DESKTOP,KeyTable,TRUE);
         printf("\a");
      }
   }
}

