EXTPROC CEnvi
/****************************************************************************
 *** Primes.cmd  Print out prime numbers until a key is pressed or we run ***
 ***             out of memory or overflow                                ***
 ****************************************************************************/

printf("Printing prime numbers until a key pressed (or failure):\n")

for ( Count = 0, Try = 2; !kbhit(); Try++ ) {
   // check if this is divisible by any of the primes found so far
   for ( i = 0; i < Count; i++ )
      if !(Try % Prime[i])
         break
   if ( i == Count )
      // this new prime number was found, and so add to the list and print it
      printf("%d\t",Prime[Count++]=Try)
}
// flush the keyboard
while( kbhit() ) getch()

printf("\n")

