:: ShutDown.cmd - A weird script that uses many instances of CEnvi
::                To shutdown the system.
::
:: The ShutDown.cmd Algorithm: First, lazy writing is turned off
:: and some processes are killed if they are running.  You can put
:: any batch commands in this first section.  The ones here represent
:: some processes that do not respond to the PMshell's shutdown
:: procedure and would otherwise need to be manually terminated.
cache /LAZY:OFF
CALL Kill "Background Randomizer"
CALL Kill hook_kbs
CALL Kill os2execd
CALL Kill MemStat
CALL Kill MAXP
CALL Kill NomBBS
CALL Kill "NumLock Forever"

:: Next, start the first CEnvi instance of this program, which will kill
:: the second instance when the second instance is waiting for keyboard
:: input.  Give this process a couple of seconds to get going
start "KillMe" /N /F /WIN CEnvi #include 'ShutDown.cmd,,,EXIT' KillShutDown()
CEnvi suspend(2000);

:: Then start the second CEnvi instance, which will call WinShutdownSystem().
:: Shutdown will try to shut this process itself, and so that is why the
:: first instance was created
start "ShutSystem" /N /B /WIN CEnvi #include 'ShutDown.cmd,,,EXIT' ShutDown()

:: Finally, exit ShutDown.cmd so that the system shutdown doesn't bother it.
:: All of the code below EXIT is used by the CEnvi calls of this source.
EXIT


ShutDown()  // Execute the WinShutdownSystem() function
{
   // Give the shell that started this process time to EXIT
   suspend(3000);

   // Get Msg Queue of this window
   #define ORD_WIN32QUERYWINDOWULONG   843
   #define QWL_HMQ   (-4)
   MsgQueue = DynamicLink("PMWIN",ORD_WIN32QUERYWINDOWULONG,BIT32,CDECL,
                          Info().WinHandle,QWL_HMQ);

   // Call WinShutdownSystem()
   #define  ORD_WIN32SHUTDOWNSYSTEM 149
   DynamicLink("PMWP",ORD_WIN32SHUTDOWNSYSTEM,BIT32,CDECL,
               Info().hab,MsgQueue);
}

KillShutDown() // Kill the ShutDown procedure because WinShutdwnSystem()
{              // will try to get stuck getting rid of that window
   // Increase priority of this process because the shutdown modal dialog
   // can tak up a LOT of time
   #define ORD_DOS32SETPRIORITY  236
   #define PRTYC_TIMECRITICAL 3
   DynamicLink("doscalls",ORD_DOS32SETPRIORITY,BIT32,CDECL,
                1/*all threads*/,PRTYC_TIMECRITICAL,0,0);

   // Wait for this focus window to change from this one. That's how well
   // know that the kill message is present
   printf("Waiting for \"ShutSystem\" to need shutting down...");
   Focus = GetFocusWindow();
   do {
      suspend(1000);
   } while ( Focus == GetFocusWindow() );

   // Call command to kill the ShutDown session so it doesn't start on reboot
   printf("\nKill ShutSystem\n");
   system("Kill ShutSystem");

   // Right now a dialog box is asking if we want to kill "SHUTDOWN". Send
   // it the 'Y' keystroke and get out of here
   PostKeystroke('Y');
}

PostKeystroke(KeyStroke)
{
   #define KC_CHAR         0x0001
   #define KC_LONEKEY      0x0100
   Param1 = ((KC_CHAR | KC_LONEKEY)) | (1 << 16);

   #define ORD_WIN32POSTMSG   919
   #define WM_CHAR   0x007a
   DynamicLink("PMWIN",ORD_WIN32POSTMSG,BIT32,CDECL,
               GetFocusWindow(),WM_CHAR,Param1,KeyStroke);
}

GetFocusWindow()  // return handle of active focus window
{
   #define ORD_WIN32QUERYFOCUS   817
   return DynamicLink("PMWIN",ORD_WIN32QUERYFOCUS,BIT32,CDECL,1);
}
