EXTPROC CEnvi
/**************************************************************************
 *** ValidDir.cmd   Check if the specified directory is valid.  Return  ***
 ***                errorlevel 0 if it's OK, else ERRORLEVEL 1.  If two ***
 ***                parameters are given then print error if problem.   ***
 **************************************************************************/

main(argc,argv)
{
   RetCode = 1; // assume failure
   if ( 1 == argc  ||  !strcmpi(argv[1],"/?")  ||  !stricmp(argv[1],"/help") ) {
      Instructions();
   } else {
      RetCode = ( ValidSubDirectoryName(argv[1],argc==3) ) ? 0 : 1 ;
   }
   return( RetCode );
}

ValidSubDirectoryName(DirName,PrintMessageIfInvalid)
   // test if DirName is a valid directory name.  If it is then return TRUE, else
   // print message if PrintMessageIfInvalid is True and return FALSE.  This function
   // reports the root directory as being invalid.
{
   DirIsValid = FALSE; // assume failure
   FullDirName = FullPath(DirName);
   if ( NULL != FullDirName ) {
      // append "\." to name to check for directory
      sprintf(TestDir,"%s\\.",FullDirName);
      if ( 0 != DirName[0]
        && '\\' != DirName[strlen(DirName)-1]
        && NULL != Directory(TestDir,FALSE,0xFFFF,FATTR_SUBDIR) ) {
         DirIsValid = TRUE
      }
   }
   if ( !DirIsValid  &&  PrintMessageIfInvalid )
      fprintf(stderr,"\n\"%s\" IS NOT A VALID SUB-DIRECTORY NAME.\a\n",DirName);
   return(DirIsValid);
}

Instructions()
{
   printf("\n")
   printf("   ValidDir.cmd - Test if a subdirectory name is valid\n")
   printf("\n")
   printf("   USAGE: ValidDir SubdirSpec [PrintError]\n")
   printf("\n")
   printf("          Check if subdirectory name is valid, and return ERRORLEVEL 0 if it is\n")
   printf("          and ERRORLEVEL 1 if it is not.  If PrintError is supplied then a\n")
   printf("          message will be printed if directory is invalid.\n")
   printf("\n")
}

