EXTPROC CEnvi
/****************************************************************
 *** FullWin - An examples of the WinCreateObject function to ***
 ***           create a full-screen Windows session.  You may ***
 ***           want to edit the settings in this file to suit ***
 ***           your OS/2 setup and configurations.            ***
 ****************************************************************/

#include <PMdll.lib>
#include <Switch,cmd,,EXTPROC> // Switch routine

#define  DEFAULT_EXECUTABLE   "ProgMan.exe"
SetupString = ""; // initialize to contain nothing

main(argc,argv)
{
   if ( 2 == argc  &&  !strcmp("/?",argv[1]) )
      Instructions();
   else {
      // Set as a full-screen windows session
      Setup("PROGTYPE=WIN");
      // Setup("PROGTYPE=WINDOWEDWIN");
      // Setup("PROGTYPE=PROG_31_ENH");
      // Setup("PROGTYPE=PROG_31_ENHSEAMLESSVDM);
      // Setup("PROGTYPE=PROG_31_ENHSEAMLESSCOMMON);
      // Tell to open immediately
      Setup("OPEN=DEFAULT");
      // add input paramters to setup string.  If first argument then that
      // is the program to start, else default.
      Executable = ( argc < 2 ) ? DEFAULT_EXECUTABLE : argv[1] ;
      Setup("EXENAME",Executable);
      // add the root of this executable into the title
      sprintf(Title,SplitFileName(Executable).name);
      // if more than one argument, then make those the parameters
      if ( argc < 3 )
         Parameters = NULL;
      else {
         Parameters = "";
         for ( i = 2; i < argc; i++ ) {
            if ( i != 2 ) strcat(Parameters," ");
            strcat(Parameters,argv[i]);
            // add root of this parameter to the title
            sprintf(Title,"%s %s",Title,SplitFileName(argv[i]).name);
         }
         Setup("PARAMETERS",Parameters);
      }
      // Set specific dos parameters
      SetDosSessionParameters();
      // finally, create object and switch to it
      handle = WinCreateObject("WPProgram",Title,SetupString,"<WP_NOWHERE>",CO_REPLACEIFEXISTS);
      if ( handle == NULL )
         printf("\a\a\aUnable to create the Windows object.\n"), exit(1);
      // call switch.cmd CEnvi function to bring this program to the foreground
      SwitchToName(Title);
   }
}

SetDosSessionParameters()  // add any specific DOS session setttings.  These are the
{                          // Settings I like.  YOU may change them.
 //Setup("SET DOS_DEVICE=")
 //Setup("SET DOS_FCBS=2")
 //Setup("SET DOS_FCBS_KEEP=2")
   Setup("SET DOS_FILES=55")
 //Setup("SET DOS_HIGH=0")
 //Setup("SET DOS_UMB=0")
 //Setup("SET DPMI_DOS_API=ENABLED")
 //Setup("SET DPMI_MEMORY_LIMIT=3")
 //Setup("SET DPMI_NETWORK_BUFF_SIZE=1")
   Setup("SET IDLE_SECONDS=8")
   Setup("SET IDLE_SENSITIVITY=85")
 //Setup("SET EMS_FRAME_LOCATION=NONE")
 //Setup("SET EMS_HIGH_OS_MAP_REGION=0")
 //Setup("SET EMS_LOW_OS_MAP_REGION=0")
 //Setup("SET EMS_MEMORY_LIMIT=0")
 //Setup("SET VIDEO_8514A_XGA_IOTRAP=0")
 //Setup("SET VIDEO_SWITCH_NOTIFICATION=1")
 //Setup("SET XMS_HANDLES=0")
 //Setup("SET XMS_MEMORY_LIMIT=0")
 //Setup("SET XMS_MINIMUM_HMA=0")
}

Setup(Key,Value) // if one parameter then just append this string.  If two then
{                // it is key,value, so must make key=value
   strcat(SetupString,Key);
   if ( va_arg() == 2 )
      strcat(strcat(SetupString,"="),Value);
   strcat(SetupString,";");
}

Instructions()
{
   printf("\n")
   printf("Windows - Start a full-screen windows session with optional parameters.  The\n")
   printf("          particular settings for you system can be altered by editing this\n")
   printf("          Windows.cmd file.\n")
   printf("\n")
   printf("SYNTAX: Windows [Program [Parameters...]]\n")
   printf("\n")
   printf("Where: Program     - A windows executable; defaults to %s\n",DEFAULT_EXECUTABLE)
   printf("       Parameters  - Parameters passed to the Executable\n")
   printf("\n")
   printf("Examples: The following example assume Windows.cmd and ProgMan.exe are in the\n")
   printf("          PATH, and that AmiPro.exe is not in the PATH.\n")
   printf("\n")
   printf("   Windows\n")
   printf("   Windows ProgMan.exe\n")
   printf("   Windows ProgMan.exe C:\\Utl\\AmiPro\\AmiPro.exe\n")
   printf("   Windows ProgMan.exe C:\\Utl\\AmiPro\\AmiPro.exe C:\\DOCS\\MANUAL.SAM\n")
   printf("   Windows C:\\Utl\\AmiPro\\AmiPro.exe\n")
   printf("   Windows C:\\Utl\\AmiPro\\AmiPro.exe C:\\DOCS\\MANUAL.SAM\n")
   printf("\n")
}

