EXTPROC CEnvi
/*********************************************************
 *** WinSet.cmd - CEnvi program to position, maximize, ***
 ***              or hide a window                     ***
 *********************************************************/

#include <PMdll.lib>
#include <WinTools.lib>

#define  NO_ERROR          0     // return code from most successful DosCalls

// Initialize an array of Commands, their functions, and how many extra
// arguments they require
commands = { { "MIN",      "MyMinimizeWindow",     "0" },
             { "MAX",      "MyMaximizeWindow",     "0" },
             { "RESTORE",  "MyRestoreWindow",      "0" },
             { "HIDE",     "MyHideWindow",         "0" },
             { "SHOW",     "MyShowWindow",         "0" },
             { "ACTIVE",   "MyActivateWindow",     "0" },
             { "INACTIVE", "MyInactivateWindow",   "0" },
             { "CLOSE",    "MyClose",              "0" },
             { "SIZE",     "MySizeWindow",         "2" },
             { "MOVE",     "MyMoveWindow",         "2" } };

main(argc,argv)
{
   if ( argc < 3  ||  !strcmp(argv[1],"/?")  ||  !strcmpi(argv[1],"help") ) {
      Instructions();
   } else if ( argc == 4  &&  !stricmp(argv[2],"TITLE") ) {
      SetWindowTitle(argv[1],argv[3]);
   } else {
      // find the command in list of commands we know
      for ( i = GetArraySpan(commands); 0 <= i; i-- ) {
         command = commands[i];
         if ( !stricmp(argv[2],commands[i][0]) )
            break;
      }
      if ( i < 0  ||  argc != 3 + (ArgCount = atoi(command[2])) ) {
         Instructions();
      } else {
         // build array of args
         for ( i = 0; i < ArgCount; i++ )
            Args[i] = atoi(argv[3+i]);
         // send command to window
         function(command[1],argv[1],
                  Args[0],Args[1],Args[2],Args[3],Args[4],
                  Args[5],Args[6],Args[7],Args[8],Args[9]);
      }
   }
}

Instructions()
{
   printf("\a\n")
   printf("WinSet - Tell a window where to go\n")
   printf("\n")
   printf("SYNTAX: WinSet Title MIN\n")
   printf("        WinSet Title MAX\n")
   printf("        WinSet Title HIDE\n")
   printf("        WinSet Title SHOW\n")
   printf("        WinSet Title RESTORE\n")
   printf("        WinSet Title ACTIVE\n")
   printf("        WinSet Title INACTIVE\n")
   printf("        WinSet Title CLOSE\n")
   printf("        WinSet Title SIZE Width Height\n")
   printf("        WinSet Title MOVE Column Row\n")
   printf("        WinSet Title TITLE NewTitle\n")
   printf("\n")
   printf("   Where: Title - All or partial name of a Window\n")
   printf("\n");
   printf("EXAMPLE: WinSet \"OS/2 Window\" MOVE 300 200\n");
   printf("         WinSet \"Drive C\" TITLE \"Boot Drive\"\n")
   printf("\n")
}

MyMinimizeWindow(WinSpec)
{
   ShowWindow(WinSpec,SW_MINIMIZE);
}

MyMaximizeWindow(WinSpec)
{
   ShowWindow(WinSpec,SW_SHOWMAXNOACTIVE);
}

MyHideWindow(WinSpec)
{
   ShowWindow(WinSpec,SW_HIDE);
}

MyShowWindow(WinSpec)
{
   ShowWindow(WinSpec,SW_SHOWNOACTIVATE);
}

MyRestoreWindow(WinSpec)
{
   ShowWindow(WinSpec,SW_RESTORENOACTIVE);
}

MySizeWindow(WinSpec,Width,Height)
{
   SetSize(WinSpec,Width,Height);
}

MyMoveWindow(WinSpec,Column,Row)
{
   SetPosition(WinSpec,Column,Row);
}

MyActivateWindow(WinSpec)
{
   if ( 0 != (_handle = GetWindowHandle(WinSpec)) )
      SetActiveWindow(_handle);
}

MyActivateWindow(WinSpec)
{
   if ( 0 != (_handle = GetWindowHandle(WinSpec)) )
      SetActiveWindow(_handle);
}

MyInactivateWindow(WinSpec)
{
   if ( 0 != (_handle = GetWindowHandle(WinSpec)) )
      SetWindowPos(_handle,0,0,0,0,0,SWP_DEACTIVATE);
}

MyClose(WinSpec)
{
//CloseWindow(WindowSpec)
//{
   if ( !(_handle = GetWindowHandle(WinSpec)) )
      return(FALSE);
   #define WM_CLOSE  0x0029
   #define WM_QUIT                    0x002a
   PostMessage(_handle,WM_QUIT,0,0);
   return(TRUE);
//}
//   CloseWindow(WinSpec);
}

