/*------------------------------------------------------------------------*/
/*                                                                        */
/*           LISTEA.CMD - Version 1.0 - Version Date 1994-01-29           */
/*                Copyright (C) 1994 by C F S Nevada, Inc.                */
/*                                                                        */
/*                 by Dick Goran  - Voice   702-732-9616                  */
/*                                - FAX     702-732-3847                  */
/*                                - CIS     72200,347                     */
/*                                - FIDO    1:209/705                     */
/*                                - IBMLink DEV4672                       */
/*                                                                        */
/*------------------------------------------------------------------------*/
/*  The windowing functions, including RXWIN30.DLL, along with REXXLIB    */
/*    are the property of, and are used with the permission of their      */
/*     owner - Quercus Systems, P.O. Box 2157, Saratoga, Ca. 95070.       */
/*         Voice 408-867-7399, BBS 408-867-7488, CIS 75300,2450           */
/*------------------------------------------------------------------------*/
/*
     This program will build a file, LISTEA.TXT, in the same directory
     where this program resides. This file will contain a text listing
     of all of the Extended Attributes (in both hex and character
     notation) for all directories and files in the object system
     except that REXX metafiles are not detailed and non-local drives
     are ignored.

     Two temporary work files, SYS001 and SYS002, area created in the
     same directory where LISTEA.CMD resides while the program is
     running. They are erased on completion.

     This program may take a considerable amount of time to run
     depending on the speed of the system and the number of files to
     be processed.

     The file created by this program, LISTEA.TXT, will be large (2 MB
     - 3 MB) and can be viewed with any viewer or ASCII editor capable
     of handling large files.

     An index list of the EA names encountered is included at the end
     of LISTEA.TXT with the name of a file which contains this EA.
     Also, the number of times that that EA type occurs in the system
     is indicated.

Updates:
         94/01/12 - Eliminate non LOCAL drives
         94/01/21 - Minor changes
*/
                                                                  /* 0047 */
parse Version  REXX_Version .                                     /* 0048 */
parse Source   OS_Name  Calling_Environment  program_path_and_name
OS_Environment = 'OS2ENVIRONMENT'                                 /* 0050 */
program_name = FileSpec( 'N', program_path_and_name )             /* 0051 */
program_path = LEFT( program_path_and_name, LENGTH(program_path_and_name) -,
                                            LENGTH(program_name) )
program_version = 1.0               /* program version / mod level */
say 'Begin' program_name 'at' TIME('N')                           /* 0055 */
elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu     */
call REGISTER_REQUIRED_FUNCTIONS    /* register DLLs if needed            */
                                                                  /* 0058 */
   SIGNAL ON ERROR                  /* trap object time errors     */
/* SIGNAL ON HALT */                /* trap object time errors     */
   SIGNAL ON NOVALUE                /* trap object time errors     */
   SIGNAL ON SYNTAX                 /* trap object time errors     */
   !signal_value = 0                /* used to determine the above */
                                                                  /* 0064 */
/*----------------------------*/                                  /* 0065 */
/* Define output & work files */                                  /* 0066 */
/*----------------------------*/                                  /* 0067 */
output_file  = program_path || 'LISTEA.TXT'                       /* 0068 */
output_disk = FILESPEC( 'D', output_file )                        /* 0069 */
call SysFileDelete output_file                                    /* 0070 */
output_file_line_count = 0                                        /* 0071 */
free_space = DOSDISK( 'F', output_disk )                          /* 0072 */
if free_space < (2 * 1024 * 1024) then                            /* 0073 */
   do                                                             /* 0074 */
      call LINEOUT 'CON:',,                                       /* 0075 */
         'WARNING! There may not be adequate free space on drive ' ||,
         UPPER(output_disk) || '.'                                /* 0077 */
      call LINEOUT 'CON:',,                                       /* 0078 */
         '         However, program will continue.'               /* 0079 */
   end                                                            /* 0080 */
                                                                  /* 0081 */
SYS001 = program_path || 'LISTEA.SY1' /* directory lines                  */
SYS002 = program_path || 'LISTEA.SY2' /* ea file size & full name         */
                                                                  /* 0084 */
/*-------------------------------*/                               /* 0085 */
/* Table & constant declarations */                               /* 0086 */
/*-------------------------------*/                               /* 0087 */
call INITIALIZE                     /* setup tables & constants           */
ea_max_length = 0                   /* length of longest name             */
                                                                  /* 0090 */
/* signal PROCESS_SYS002 */ /* for test use only */               /* 0091 */
                                                                  /* 0092 */
/*------------------------------------*/                          /* 0093 */
/* Put EA file size & names in SYS002 */                          /* 0094 */
/*------------------------------------*/                          /* 0095 */
say 'Sorting directory & file names'                              /* 0096 */
call SysFileDelete SYS002                                         /* 0097 */
do w = 1 to WORDS(drive_table)                                    /* 0098 */
   call PROCESS_DRIVE  WORD( drive_table, w )                     /* 0099 */
end                                                               /* 0100 */
call STREAM SYS002, 'C', 'CLOSE'                                  /* 0101 */
                                                                  /* 0102 */
/*---------------------------------------*/                       /* 0103 */
/* Sort and write all EAs to output file */                       /* 0104 */
/*---------------------------------------*/                       /* 0105 */
PROCESS_SYS002:                                                   /* 0106 */
file_table. = ''                      /* initialize array */      /* 0107 */
file_table_max_length = 0                                         /* 0108 */
e = 0                                                             /* 0109 */
do while LINES(SYS002) > 0                                        /* 0110 */
   e = e + 1                                                      /* 0111 */
   input_line = LINEIN(SYS002)                                    /* 0112 */
   file_table.e = input_line                                      /* 0113 */
   file_table_max_length = MAX( file_table_max_length,,           /* 0114 */
                                LENGTH( WORD( input_line, 2 ) ) ) /* 0115 */
end                                                               /* 0116 */
call STREAM SYS002, 'C', 'CLOSE'                                  /* 0117 */
                                                                  /* 0118 */
file_table.0 = e                                                  /* 0119 */
call ARRAYSORT 'file_table', 1, file_table.0,,                    /* 0120 */
                                10, file_table_max_length         /* 0121 */
                                                                  /* 0122 */
call CHAROUT 'CON:', 'Building ' ||,                              /* 0123 */
                     output_file ||,                              /* 0124 */
                     COPIES( ' ', 2 )                             /* 0125 */
bksp = '08'x                                                      /* 0126 */
progress_list = '\|/'                                            /* 0127 */
progress_subscript = 1                                            /* 0128 */
do e = 1 to file_table.0                                          /* 0129 */
   call FORMAT_EA_ITEM file_table.e                               /* 0130 */
   call CHAROUT 'CON:', bksp ||,                                  /* 0131 */
                       SUBSTR( progress_list, progress_subscript, 1 )
   progress_subscript = progress_subscript + 1                    /* 0133 */
   if progress_subscript > LENGTH(progress_list) then             /* 0134 */
      progress_subscript = 1                                      /* 0135 */
end                                                               /* 0136 */
call LINEOUT 'CON:', bksp || ' '                                  /* 0137 */
                                                                  /* 0138 */
/*--------------------------------------*/                        /* 0139 */
/* Write sorted EA index to output file */                        /* 0140 */
/*--------------------------------------*/                        /* 0141 */
call LINEOUT output_file,  heading.2 ||,                          /* 0142 */
                           '0D0A'x                                /* 0143 */
                                                                  /* 0144 */
output_line = LEFT( 'EA Name', 22 ) ||,                           /* 0145 */
              LEFT( 'Type',     8 ) ||,                           /* 0146 */
              LEFT( 'Ct.',      7 ) ||,                           /* 0147 */
              'Example'                                           /* 0148 */
call LINEOUT output_file, output_line                             /* 0149 */
                                                                  /* 0150 */
output_line = COPIES( '-', 19 ) ||,                               /* 0151 */
              COPIES( ' ',  3 ) ||,                               /* 0152 */
              COPIES( '-',  4 ) ||,                               /* 0153 */
              COPIES( ' ',  4 ) ||,                               /* 0154 */
              COPIES( '-',  4 ) ||,                               /* 0155 */
              COPIES( ' ',  3 ) ||,                               /* 0156 */
              COPIES( '-', 39 )                                   /* 0157 */
call LINEOUT output_file, output_line                             /* 0158 */
                                                                  /* 0159 */
call ARRAYSORT 'ea_table', 1, ea_table.0                          /* 0160 */
do i = 1 to ea_table.0                                            /* 0161 */
   parse value ea_table.i with ea_name ea_hex_value ea_example    /* 0162 */
   output_line = LEFT( ea_name, 22) ||,                           /* 0163 */
                 C2X( ea_hex_value ) ||,                          /* 0164 */
                 COPIES( ' ', 3 ) ||,                             /* 0165 */
                 FORMAT( ea_table.ea_name, 5 ) ||,                /* 0166 */
                 COPIES( ' ', 3 ) ||,                             /* 0167 */
                 ea_example                                       /* 0168 */
   call WRITE_OUTPUT_FILE output_line                             /* 0169 */
end                                                               /* 0170 */
call STREAM output_file, 'C', 'CLOSE'                             /* 0171 */
                                                                  /* 0172 */
call SysFileDelete SYS001           /* erase work files                   */
call SysFileDelete SYS002                                         /* 0174 */
                                                                  /* 0175 */
call EOJ 0                                                        /* 0176 */
                                                                  /* 0177 */
!tr!=VALUE('TRACE',,'OS2Environment'); if !tr!<>'' then do;TRACE(!tr!);nop;end
/*#-----------------------------------------------------------------------*/
/*                                                                        */
/*                               End of Job                               */
/*                                                                        */
/*------------------------------------------------------------------------*/
EOJ:                                                              /* 0184 */
   Procedure expose program_name                                  /* 0185 */
                                                                  /* 0186 */
if ARG() = 0 then                                                 /* 0187 */
   eoj_rc = 0                                                     /* 0188 */
else                                                              /* 0189 */
   eoj_rc = ARG(1)                                                /* 0190 */
elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu     */
parse value elapsed_time with seconds '.' micro_seconds           /* 0192 */
if SUBSTR(micro_seconds, 1, 1) >= 5 then                          /* 0193 */
   seconds = seconds + 1                                          /* 0194 */
ss = FORMAT(seconds // 60, 2)                                     /* 0195 */
minutes = (seconds - ss) / 60                                     /* 0196 */
mm = FORMAT(minutes // 60, 2)                                     /* 0197 */
hh = FORMAT((minutes - mm) / 60, 2)                               /* 0198 */
duration = hh':'mm':'ss                                           /* 0199 */
say 'EOJ  ' program_name 'at' TIME('N') ||,                       /* 0200 */
    ', duration' TRANSLATE(duration, '0', ' ')                    /* 0201 */
exit eoj_rc                                                       /* 0202 */
                                                                  /* 0203 */
                                                                  /* 0204 */
/*#-----------------------------------------------------------------------*/
/*                                                                        */
/*         Get each EA and write to output file & build EA matrix         */
/*                                                                        */
/*------------------------------------------------------------------------*/
FORMAT_EA_ITEM:                                                   /* 0210 */
   Procedure expose,                                              /* 0211 */
      ea_max_length,                                              /* 0212 */
      ea_table.,                                                  /* 0213 */
      program_name,                                               /* 0214 */
      output_file,                                                /* 0215 */
      output_file_line_count,                                     /* 0216 */
      contig_hex_tt,                                              /* 0217 */
      spread_hex_tt,                                              /* 0218 */
      SYS001 SYS002,                                              /* 0219 */
      tt_128                                                      /* 0220 */
                                                                  /* 0221 */
parse arg file_size file_name                                     /* 0222 */
file_name = STRIP(file_name)                                      /* 0223 */
crlf = '0D0A'x                                                    /* 0224 */
                                                                  /* 0225 */
ea_count = DOSEALIST( file_name, 'name_stem', 'value_stem', 'flag_stem' )
if ea_count > 0 then                                             /* 0227 */
   do                                                             /* 0228 */
      say '0D0A'x || 'DOSEALIST unexpected return code of ' ||,   /* 0229 */
          ea_count                                                /* 0230 */
      say '   for' file_name                                      /* 0231 */
      say '   Data for above file will not appear in ' ||,        /* 0232 */
          FILESPEC( 'N', output_file )                            /* 0233 */
      return                                                      /* 0234 */
   end                                                            /* 0235 */
                                                                  /* 0236 */
do i = 1 to name_stem.0                                           /* 0237 */
   name = STRIP( name_stem.i, 'L', '.' )                          /* 0238 */
                                                                  /* 0239 */
   /*------------------------*/                                   /* 0240 */
   /* Write Formatted output */                                   /* 0241 */
   /*------------------------*/                                   /* 0242 */
   output_line = file_name                                        /* 0243 */
   if file_size = '<DIR>' then                                    /* 0244 */
      do                                                          /* 0245 */
         output_line = output_line || ' <DIR>'                    /* 0246 */
      end                                                         /* 0247 */
                                                                  /* 0248 */
   list_name_only = 0                                             /* 0249 */
   if ( LEFT( name, 5 ) = 'REXX.' ) |,                            /* 0250 */
         ( name = 'ICON' ) then                                   /* 0251 */
      do                                                          /* 0252 */
         list_name_only = 1                                       /* 0253 */
      end                                                         /* 0254 */
                                                                  /* 0255 */
   if list_name_only = 1 then                                     /* 0256 */
      if i = 1 then                                               /* 0257 */
         do                                                       /* 0258 */
            if output_file_line_count > 0 then                    /* 0259 */
               output_line = crlf || output_line /* preceed with blank line */
            call WRITE_OUTPUT_FILE output_line                    /* 0261 */
         end                                                      /* 0262 */
      else                                                        /* 0263 */
         nop                                                      /* 0264 */
   else                                                           /* 0265 */
      do                                                          /* 0266 */
         if output_file_line_count > 0 then                       /* 0267 */
            output_line = crlf || output_line /* preceed with blank line */
         call WRITE_OUTPUT_FILE output_line                       /* 0269 */
      end                                                         /* 0270 */
                                                                  /* 0271 */
   output_line = COPIES( ' ', 3 ) ||,                             /* 0272 */
                 LEFT( 'Flag = ''' || C2X(flag_stem.i) || '''x', 15) ||,
                 'Name = ' ||,                                    /* 0274 */
                 LEFT( name_stem.i, 35 ) ||,                      /* 0275 */
                 'Length = ''' ||,                                /* 0276 */
                 D2X( LENGTH(value_stem.i), 4 ) ||,               /* 0277 */
                 '''x'                                            /* 0278 */
   call WRITE_OUTPUT_FILE output_line                             /* 0279 */
                                                                  /* 0280 */
   if list_name_only = 0 then                                     /* 0281 */
      do                                                          /* 0282 */
         call FORMAT_EA_DETAIL  value_stem.i                      /* 0283 */
      end                                                         /* 0284 */
                                                                  /* 0285 */
   /*---------------------------------*/                          /* 0286 */
   /* Cross index EA name in EA table */                          /* 0287 */
   /*---------------------------------*/                          /* 0288 */
   if ea_table.name = '' then                                     /* 0289 */
      do                                                          /* 0290 */
         e = ea_table.0 + 1                                       /* 0291 */
         ea_table.0 = e                                           /* 0292 */
         ea_table.e = name,                                       /* 0293 */
                      SUBSTR( value_stem.i, 2, 1 ) ||,            /* 0294 */
                      SUBSTR( value_stem.i, 1, 1 ),               /* 0295 */
                      file_name                                   /* 0296 */
         ea_table.name = 1                                        /* 0297 */
         if LENGTH(name) > ea_max_length then                     /* 0298 */
            ea_max_length = LENGTH(name)                          /* 0299 */
      end                                                         /* 0300 */
   else                                                           /* 0301 */
      do                                                          /* 0302 */
         ea_table.name = ea_table.name + 1                        /* 0303 */
      end                                                         /* 0304 */
                                                                  /* 0305 */
end                                                               /* 0306 */
                                                                  /* 0307 */
return                                                            /* 0308 */
                                                                  /* 0309 */
/*------------------------------------------------------------------------*/
/*                                                                        */
/*                    Format hex & character EA detail                    */
/*                                                                        */
/*------------------------------------------------------------------------*/
FORMAT_EA_DETAIL:                                                 /* 0315 */
   Procedure expose,                                              /* 0316 */
      output_file,                                                /* 0317 */
      output_file_line_count,                                     /* 0318 */
      program_name,                                               /* 0319 */
      contig_hex_tt,                                              /* 0320 */
      spread_hex_tt,                                              /* 0321 */
      SYS001 SYS002,                                              /* 0322 */
      tt_128                                                      /* 0323 */
                                                                  /* 0324 */
ea_data               = ARG(1)                                    /* 0325 */
hex_displacement      = 0                                         /* 0326 */
prev_character_string = ''                                        /* 0327 */
sameness_switch        = 0                                        /* 0328 */
                                                                  /* 0329 */
do until ea_data = ''                                             /* 0330 */
   parse value ea_data with leading_token 17 ea_data              /* 0331 */
                                                                  /* 0332 */
   temp_character_string = LEFT( leading_token, 16 )              /* 0333 */
   if temp_character_string <> prev_character_string then         /* 0334 */
      do                                                          /* 0335 */
         temp_hex_string = TRANSLATE( spread_hex_tt,,             /* 0336 */
                                      C2X(temp_character_string),,
                                      contig_hex_tt )             /* 0338 */
         word_count = ( LENGTH(leading_token) - 1 ) % 4           /* 0339 */
         byte_count = LENGTH(leading_token) - ( 4 * word_count )  /* 0340 */
         temp_hex_length = ( 9 * word_count ) + ( 2 * byte_count )
         output_line = COPIES( ' ', 10 ) ||,                      /* 0342 */
                       '+' || D2X( hex_displacement, 4 ) ||,      /* 0343 */
                       COPIES( ' ', 3 ) ||,                       /* 0344 */
                       '| ' ||,                                   /* 0345 */
                       LEFT( temp_hex_string, temp_hex_length ) ||,
                       COPIES( ' ', 35 - temp_hex_length ) ||,    /* 0347 */
                       ' |' ||,                                   /* 0348 */
                       COPIES( ' ', 3 ) ||,                       /* 0349 */
                       TRANSLATE( temp_character_string, tt_128 ) /* 0350 */
         call WRITE_OUTPUT_FILE output_line                       /* 0351 */
         sameness_switch = 0                                      /* 0352 */
      end                                                         /* 0353 */
   else                                                           /* 0354 */
      if sameness_switch = 0 then                                 /* 0355 */
         do                                                       /* 0356 */
            output_line = COPIES( ' ', 10 ) ||,                   /* 0357 */
                          '+' || D2X( hex_displacement, 4 ) ||,   /* 0358 */
                          COPIES( ' ', 3 ) ||,                    /* 0359 */
                          '| ' ||,                                /* 0360 */
                          LEFT( 'same', 35 ) ||,                  /* 0361 */
                          ' |'                                    /* 0362 */
            call WRITE_OUTPUT_FILE output_line                    /* 0363 */
            sameness_switch = 1                                   /* 0364 */
         end                                                      /* 0365 */
                                                                  /* 0366 */
   hex_displacement = hex_displacement + 16                       /* 0367 */
   prev_character_string = temp_character_string                  /* 0368 */
end                                                               /* 0369 */
return                                                            /* 0370 */
                                                                  /* 0371 */
/*#-----------------------------------------------------------------------*/
/*                                                                        */
/*                      Initialize translate tables                       */
/*                                                                        */
/*------------------------------------------------------------------------*/
INITIALIZE:                                                       /* 0377 */
   Procedure expose,                                              /* 0378 */
      contig_hex_tt,                                              /* 0379 */
      drive_table,                                                /* 0380 */
      ea_table.,                                                  /* 0381 */
      heading.,                                                   /* 0382 */
      hex_tt,                                                     /* 0383 */
      program_name,                                               /* 0384 */
      output_file,                                                /* 0385 */
      spread_hex_tt,                                              /* 0386 */
      tt_128,                                                     /* 0387 */
      tt_256                                                      /* 0388 */
                                                                  /* 0389 */
drive_table  = SysDriveMap( 'C', 'LOCAL' )                        /* 0390 */
ea_table.    = ''; ea_table.0   = 0                               /* 0391 */
output_width = 76                                                 /* 0392 */
                                                                  /* 0393 */
title =,                                                          /* 0394 */
         'Listing of EAs on Drives ' ||,                          /* 0395 */
         STRIP(drive_table)                                       /* 0396 */
heading.1 =,                                                      /* 0397 */
         DATE('O') ||,                                            /* 0398 */
         COPIES( ' ', 2 ) ||,                                     /* 0399 */
         TIME('N') ||,                                            /* 0400 */
         COPIES( ' ', 10 ) ||,                                    /* 0401 */
         title                                                    /* 0402 */
                                                                  /* 0403 */
heading.2 =,                                                      /* 0404 */
         '0C'x ||,                                                /* 0405 */
         CENTER( 'EA Index List', output_width )                  /* 0406 */
                                                                  /* 0407 */
call LINEOUT output_file, heading.1 || '0D0A'x                    /* 0408 */
                                                                  /* 0409 */
hex_tt = COPIES( '00'x, 256 )                                     /* 0410 */
hex_tt = OVERLAY( XRANGE('30'x, '39'x), hex_tt, X2D(30) + 1 ) /* 0 - 9    */
hex_tt = OVERLAY( XRANGE('41'x, '46'x), hex_tt, X2D(41) + 1 ) /* A - F    */
hex_tt = OVERLAY( XRANGE('41'x, '46'x), hex_tt, X2D(61) + 1 ) /* a - f    */
                                                                  /* 0414 */
/* used for hex display of data */                                /* 0415 */
contig_hex_tt = XRANGE('01'x, '21'x)                              /* 0416 */
spread_hex_tt = XRANGE('01'x, '08'x) || '21'x ||,                 /* 0417 */
                XRANGE('09'x, '10'x) || '21'x ||,                 /* 0418 */
                XRANGE('11'x, '18'x) || '21'x ||,                 /* 0419 */
                XRANGE('19'x, '20'x)                              /* 0420 */
                                                                  /* 0421 */
tt_128 = COPIES( '.', 32 ) || XRANGE('20'X, '7F'X) || COPIES( '.', 128 )
tt_256 = '2E01 0203 0405 062E 2E2E 2E0B 0C2E 0E0F'X ||,           /* 0423 */
         '1011 1213 1415 1617 1819 1A2E 1C1D 1E1F'X ||,           /* 0424 */
         XRANGE('20'X, 'FE'X) || '.'                              /* 0425 */
                                                                  /* 0426 */
                                                                  /* 0427 */
return                                                            /* 0428 */
                                                                  /* 0429 */
/*#-----------------------------------------------------------------------*/
/*                                                                        */
/*               Build Work File 02 From Directory Entries                */
/*                                                                        */
/*------------------------------------------------------------------------*/
PROCESS_DRIVE:                                                    /* 0435 */
   Procedure expose,                                              /* 0436 */
      SYS001 SYS002                                               /* 0437 */
                                                                  /* 0438 */
drive = ARG(1)                                                    /* 0439 */
notready_switch = ''                                              /* 0440 */
call ON NOTREADY name DRIVE_NOTREADY                              /* 0441 */
call STREAM drive || '*', 'D'       /* check for not ready */     /* 0442 */
call OFF NOTREADY                                                 /* 0443 */
if notready_switch <> '' then                                     /* 0444 */
   do                                                             /* 0445 */
      say '   Drive ' ||,                                         /* 0446 */
          drive ||,                                               /* 0447 */
          ' is not ready and is being ignored.'                   /* 0448 */
      return                                                      /* 0449 */
   end                                                            /* 0450 */
                                                                  /* 0451 */
if DOSFILESYS(drive) = 'CDFS' then return /* ignore CDROM drives */
                                                                  /* 0453 */
say '   Reading drive' drive                                      /* 0454 */
'@dir' drive || '\*.* /s /n /o:n 1>' SYS001                       /* 0455 */
                                                                  /* 0456 */
do while LINES(SYS001) > 0                                        /* 0457 */
   directory_line = LINEIN(SYS001)                                /* 0458 */
   if LEFT( directory_line, 13 ) = ' Directory of' then           /* 0459 */
      do                                                          /* 0460 */
         parse value directory_line with . 15 path_name           /* 0461 */
         if SUBSTR( path_name, LENGTH(path_name), 1 ) <> '\' then /* 0462 */
            path_name = path_name || '\'                          /* 0463 */
         iterate                                                  /* 0464 */
      end                                                         /* 0465 */
   if ( SUBSTR( directory_line, 3, 1 ) <> '-' )  |,               /* 0466 */
      ( SUBSTR( directory_line, 6, 1 ) <> '-' ) then iterate      /* 0467 */
   parse var directory_line,                                      /* 0468 */
              file_date,                                          /* 0469 */
              file_time,                                          /* 0470 */
              file_size,                                          /* 0471 */
              file_ea_size,                                       /* 0472 */
              file_name                                           /* 0473 */
   if file_ea_size = 0 then iterate                               /* 0474 */
   if ( file_name = '.' )  |,                                     /* 0475 */
      ( file_name = '..' ) then iterate                           /* 0476 */
   full_file_name = path_name ||,                                 /* 0477 */
                    STRIP(file_name)                              /* 0478 */
   output_line = LEFT( file_size, 9 ) ||,                         /* 0479 */
                 full_file_name                                   /* 0480 */
   call LINEOUT SYS002, output_line                               /* 0481 */
end                                                               /* 0482 */
call STREAM SYS001, 'C', 'CLOSE'                                  /* 0483 */
call SysFileDelete SYS001                                         /* 0484 */
return                                                            /* 0485 */
                                                                  /* 0486 */
DRIVE_NOTREADY:                                                   /* 0487 */
   Procedure expose notready_switch                               /* 0488 */
notready_switch = 1                                               /* 0489 */
return                                                            /* 0490 */
                                                                  /* 0491 */
/*#-----------------------------------------------------------------------*/
/*                                                                        */
/*                  Register external function routines                   */
/*                                                                        */
/*------------------------------------------------------------------------*/
REGISTER_REQUIRED_FUNCTIONS:                                      /* 0497 */
   Procedure expose REXX_Version                                  /* 0498 */
                                                                  /* 0499 */
/*----------------------------------------*/                      /* 0500 */
/* Load REXXUtil External Function Module */                      /* 0501 */
/*----------------------------------------*/                      /* 0502 */
function_name      = 'SysLoadFuncs'                               /* 0503 */
entry_name         = 'SysLoadFuncs'                               /* 0504 */
module             = 'RexxUtil'                                   /* 0505 */
anticipated_return = ''                                           /* 0506 */
call REGISTER_ROUTINE function_name module entry_name anticipated_return
                                                                  /* 0508 */
/*-----------------------------------*/                           /* 0509 */
/* Load the REXXLIB Function Package */                           /* 0510 */
/*-----------------------------------*/                           /* 0511 */
if REXX_Version = 'REXX/Personal' then                            /* 0512 */
   do                                                             /* 0513 */
      module = 'qrexxlib'                                         /* 0514 */
   end                                                            /* 0515 */
else                                                              /* 0516 */
   do                                                             /* 0517 */
      module = 'rexxlib'                                          /* 0518 */
   end                                                            /* 0519 */
entry_name         = 'RexxLibRegister'                            /* 0520 */
function_name      = 'RexxLibRegister'                            /* 0521 */
anticipated_return = '1'                                          /* 0522 */
call REGISTER_ROUTINE function_name module entry_name anticipated_return
return                                                            /* 0524 */
                                                                  /* 0525 */
                                                                  /* 0526 */
REGISTER_ROUTINE:                                                 /* 0527 */
parse ARG  function_name,                                         /* 0528 */
           module,                                                /* 0529 */
           entry_name,                                            /* 0530 */
           anticipated_return                                     /* 0531 */
                                                                  /* 0532 */
if RxFuncQuery(function_name) = 0 then return      /* function registered */
                                                                  /* 0534 */
if LENGTH(module) > 8 then                                        /* 0535 */
   do                                                             /* 0536 */
      dll_drive = FILESPEC( 'D', module )                         /* 0537 */
      dll_path  = STRIP( FILESPEC( 'P', module ), 'T', '\' )      /* 0538 */
      module    = FILESPEC( 'N', module )                         /* 0539 */
      '@' || dll_drive                                            /* 0540 */
      '@cd' dll_drive || dll_path                                 /* 0541 */
   end                                                            /* 0542 */
else                                                              /* 0543 */
   do                                                             /* 0544 */
      dll_drive = ''                                              /* 0545 */
   end                                                            /* 0546 */
                                                                  /* 0547 */
parse var module module_fname '.' module_fext                     /* 0548 */
if RxFuncAdd( function_name, module_fname, entry_name ) = 0 then  /* 0549 */
   do                                                             /* 0550 */
      register_call = 'call' function_name                        /* 0551 */
      interpret register_call                                     /* 0552 */
      if WORD( RESULT, 1 ) <> WORD( anticipated_return, 1 ) then  /* 0553 */
         do                                                       /* 0554 */
            Say function_name 'returned' RESULT '-',              /* 0555 */
                                         anticipated_return 'was expected'
            exit 255                                              /* 0557 */
         end                                                      /* 0558 */
   end                                                            /* 0559 */
else                                                              /* 0560 */
   do                                                             /* 0561 */
      Say 'RxFuncAdd returned' RESULT 'registering' module        /* 0562 */
      exit 254                                                    /* 0563 */
   end                                                            /* 0564 */
if dll_drive <> '' then                                           /* 0565 */
   do                                                             /* 0566 */
      '@' || LEFT( program_path_and_name, 2 )                     /* 0567 */
   end                                                            /* 0568 */
return                                                            /* 0569 */
                                                                  /* 0570 */
/*#-----------------------------------------------------------------------*/
/*                                                                        */
/*                             Trap Routines                              */
/*                                                                        */
/*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC                 /* 0576 */
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC                 /* 0577 */
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''                 /* 0578 */
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''                 /* 0579 */
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC                 /* 0580 */
                                                                  /* 0581 */
TRAP_PROCESSING:                                                  /* 0582 */
   parse Source . . trap_path                                     /* 0583 */
   trap_file_name = LEFT( trap_path, LENGTH(trap_path) - 3 ) ||,  /* 0584 */
                    'DMP'                                         /* 0585 */
   call SysFileDelete trap_file_name                              /* 0586 */
                                                                  /* 0587 */
   dbl_h    = ''                   /* double line - horizontal   */
   dbl_v    = ''                   /* double line - vertical     */
   dbl_bl   = ''                   /* double line - bottom left  */
   dbl_br   = ''                   /* double line - bottom right */
   dbl_tl   = ''                   /* double line - top left     */
   dbl_tr   = ''                   /* double line - top right    */
   say ' '                                                        /* 0594 */
   trap_error_description = 'Tracing begun because of ' ||,       /* 0595 */
                            ARG(2) ||,                            /* 0596 */
                            ',  error line = ' || ARG(1)          /* 0597 */
   if ARG(3) <> '' then                                           /* 0598 */
      trap_error_description = trap_error_description ||,         /* 0599 */
                               ',  return_code = ' || ARG(3)      /* 0600 */
   say dbl_tl || COPIES( dbl_h, LENGTH(trap_error_description) + 2 ) || dbl_tr
   say dbl_v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl_v
   say dbl_v               trap_error_description                       dbl_v
   say dbl_v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl_v
   say dbl_v     CENTER( 'See: ' || trap_file_name,,              /* 0605 */
                                      LENGTH(trap_error_description) )  dbl_v
   say dbl_v  || COPIES( ' ',   LENGTH(trap_error_description) + 2 ) || dbl_v
   say dbl_bl || COPIES( dbl_h, LENGTH(trap_error_description) + 2 ) || dbl_br
   say ' '                                                        /* 0609 */
   say 'Source line at time of trap:'                             /* 0610 */
   say SOURCELINE(ARG(1))                                         /* 0611 */
   say ' '                                                        /* 0612 */
   call VARDUMP trap_file_name  /* write variables to program.DMP file */
   trace ?r; nop                                                  /* 0614 */
   exit -255                                                      /* 0615 */
                                                                  /* 0616 */
/*------------------------------------------------------------------------*/
/*                                                                        */
/*                  Write output line & tally line count                  */
/*                                                                        */
/*------------------------------------------------------------------------*/
WRITE_OUTPUT_FILE:                                                /* 0622 */
   Procedure expose,                                              /* 0623 */
      program_name,                                               /* 0624 */
      output_file,                                                /* 0625 */
      output_file_line_count,                                     /* 0626 */
      SYS001 SYS002                                               /* 0627 */
                                                                  /* 0628 */
output_file_line_count = output_file_line_count + 1               /* 0629 */
call LINEOUT output_file, ARG(1)                                  /* 0630 */
if RESULT <> 0 then                                               /* 0631 */
   do                                                             /* 0632 */
      call LINEOUT 'CON:', '0D0A'x ||,                            /* 0633 */
         'Error writing line number ' ||,                         /* 0634 */
         output_file_line_count ||,                               /* 0635 */
         ' to ' ||,                                               /* 0636 */
         output_file || '.'                                       /* 0637 */
      call LINEOUT 'CON:',,                                       /* 0638 */
         'Possibly insufficient disk space.'                      /* 0639 */
      call LINEOUT 'CON:',,                                       /* 0640 */
         'Work files - ' ||,                                      /* 0641 */
         SYS001 || ' & ' || SYS002 ||,                            /* 0642 */
         ' not erased.'                                           /* 0643 */
      call EOJ 255                                                /* 0644 */
   end                                                            /* 0645 */
return                                                            /* 0646 */
/*#********  REXX Cross Reference  - Created: 01/30/94 11:57pm ***********
        F:\REXXPROG\LISTEA.CMD - Directory time stamp 1/30/94 11:43p

---- VARIABLES ----
!signal_value       0063<
!tr!                0178<  0178   0178
?r                  0614
Calling_Environment
                    0049
DRIVE_NOTREADY      0441
OS_Environment      0050<
OS_Name             0049
RC                  0576   0577   0580
RESULT              0553   0555   0562   0631
REXX_Version        0048   0498   0512
SIGL                0576   0577   0578   0579   0580
SYS001              0082<  0173   0219   0322   0437   0455   0457   0458
                    0483   0484   0627   0642
SYS002              0083<  0097   0101   0110   0112   0117   0174   0219
                    0322   0437   0481   0627   0642
Version             0048
X                   0422   0422   0423   0424   0425   0425
anticipated_return  0506<  0507   0522<  0523   0531   0553   0556
bksp                0126<  0131   0137
byte_count          0340<  0341
contig_hex_tt       0217   0320   0338   0379   0416<
crlf                0224<  0260   0268
dbl_bl              0590<  0608
dbl_br              0591<  0608
dbl_h               0588<  0601   0608
dbl_tl              0592<  0601
dbl_tr              0593<  0601
dbl_v               0589<  0602   0602   0603   0603   0604   0604   0605
                    0606   0607   0607
directory_line      0458<  0459   0461   0466   0467   0468
dll_drive           0537<  0540   0541   0545<  0565
dll_path            0538<  0541
drive               0439<  0442   0447   0452   0454   0455
drive_table         0098   0099   0380   0390<  0396
duration            0199<  0201
e                   0109<  0111<  0111   0119   0129   0291<  0292
ea_count            0226<  0227   0230
ea_data             0325<  0330   0331   0331
ea_example          0162   0168
ea_hex_value        0162   0164
ea_max_length       0089<  0212   0298   0299<
ea_name             0162   0163
ea_table.           0213   0381   0391<
ea_table.0          0160   0161   0291   0292<  0391<
ea_table.e          0293<
ea_table.ea_name    0166
ea_table.i          0162
ea_table.name       0289   0297<  0303<  0303
elapsed_time        0056<  0191<  0192
entry_name          0504<  0507   0520<  0523   0530   0549
eoj_rc              0188<  0190<  0202
file_date           0469
file_ea_size        0472   0474
file_name           0222   0223<  0223   0226   0231   0243   0296   0473
                    0475   0476   0478
file_size           0222   0244   0471   0479
file_table.         0107<
file_table.0        0119<  0120   0129
file_table.e        0113<  0130
file_table_max_length
                    0108<  0114<  0114   0121
file_time           0470
flag_stem.i         0273
free_space          0072<  0073
full_file_name      0477<  0480
function_name       0503<  0507   0521<  0523   0528   0533   0549   0551
                    0555
heading.            0382
heading.1           0397<  0408
heading.2           0142   0404<
hex_displacement    0326<  0343   0358   0367<  0367
hex_tt              0383   0410<  0411<  0411   0412<  0412   0413<  0413
hh                  0198<  0199
i                   0161   0237   0257
input_line          0112<  0113   0115
leading_token       0331   0333   0339   0340
list_name_only      0249<  0253<  0256   0281
micro_seconds       0192   0193
minutes             0196<  0197   0198
mm                  0197<  0198   0199
module              0505<  0507   0514<  0518<  0523   0529   0535   0537
                    0538   0539<  0539   0548   0562
module_fext         0548
module_fname        0548   0549
name                0238<  0250   0251   0293   0298   0299   0441
name_stem.0         0237
name_stem.i         0238   0275
notready_switch     0440<  0444   0488   0489<
output_disk         0069<  0072   0077
output_file         0068<  0069   0070   0124   0142   0149   0158   0171
                    0215   0233   0317   0385   0408   0625   0630   0637
output_file_line_count
                    0071<  0216   0259   0267   0318   0626   0629<  0629
                    0635
output_line         0145<  0149   0151<  0158   0163<  0169   0243<  0246<
                    0246   0260<  0260   0261   0268<  0268   0269   0272<
                    0279   0342<  0351   0357<  0363   0479<  0481
output_width        0392<  0406
path_name           0461   0462   0462   0463<  0463   0477
prev_character_string
                    0327<  0334   0368<
program_name        0051<  0053   0055   0185   0200   0214   0319   0384
                    0624
program_path        0052<  0068   0082   0083
program_path_and_name
                    0049   0051   0052   0052   0567
program_version     0054<
progress_list       0127<  0132   0134
progress_subscript  0128<  0132   0133<  0133   0134   0135<
register_call       0551<  0552
sameness_switch     0328<  0352<  0355   0364<
seconds             0192   0194<  0194   0195   0196
spread_hex_tt       0218   0321   0336   0386   0417<
ss                  0195<  0196   0199
temp_character_string
                    0333<  0334   0337   0350   0368
temp_hex_length     0341<  0346   0347
temp_hex_string     0336<  0346
title               0394<  0402
trap_error_description
                    0595<  0599<  0599   0601   0602   0603   0604   0606
                    0607   0608
trap_file_name      0584<  0586   0605   0613
trap_path           0583   0584   0584
tt_128              0220   0323   0350   0387   0422<
tt_256              0388   0423<
value_stem.i        0277   0283   0294   0295
w                   0098   0099
with                0162   0192   0331   0461
word_count          0339<  0340   0341
x                   0126   0143   0224   0229   0405   0408   0410   0411
                    0411   0412   0412   0413   0413   0416   0416   0417
                    0417   0417   0418   0418   0418   0419   0419   0419
                    0420   0420   0633

---- LABELS ----
DRIVE_NOTREADY      0487:
EOJ                 0176   0184:  0644
ERROR               0059   0576:
FAILURE             0577:
FORMAT_EA_DETAIL    0283   0315:
FORMAT_EA_ITEM      0130   0210:
HALT                0578:
INITIALIZE          0088   0377:
NOVALUE             0061   0579:
OFF                 0443
ON                  0441
PROCESS_DRIVE       0099   0435:
PROCESS_SYS002      0106:
REGISTER_REQUIRED_FUNCTIONS
                    0057   0497:
REGISTER_ROUTINE    0507   0523   0527:
SYNTAX              0062   0580:
TRAP_PROCESSING     0576   0577   0578   0579   0580   0582:
WRITE_OUTPUT_FILE   0169   0261   0269   0279   0351   0363   0622:

---- FUNCTIONS ----
ARG                 0187   0190   0325   0439   0596   0597   0598   0600
                    0611   0630
ARRAYSORT           0120   0160
C2X                 0164   0273   0337
CENTER              0406   0605
CHAROUT             0123   0131
COPIES              0125   0151   0152   0153   0154   0155   0156   0157
                    0165   0167   0272   0342   0344   0347   0349   0357
                    0359   0399   0401   0410   0422   0422   0601   0602
                    0604   0607   0608
D2X                 0277   0343   0358
DATE                0398
DOSDISK             0072
DOSEALIST           0226
DOSFILESYS          0452
FILESPEC            0069   0233   0537   0538   0539
FORMAT              0166   0195   0197   0198
FileSpec            0051
LEFT                0052   0145   0146   0147   0163   0250   0273   0275
                    0333   0346   0361   0459   0479   0567   0584
LENGTH              0052   0053   0115   0134   0277   0298   0299   0339
                    0340   0462   0535   0584   0601   0602   0604   0606
                    0607   0608
LINEIN              0112   0458
LINEOUT             0075   0078   0137   0142   0149   0158   0408   0481
                    0630   0633   0638   0640
LINES               0110   0457
MAX                 0114
OVERLAY             0411   0412   0413
RxFuncAdd           0549
RxFuncQuery         0533
SOURCELINE          0611
STREAM              0101   0117   0171   0442   0483
STRIP               0223   0238   0396   0478   0538
SUBSTR              0132   0193   0294   0295   0462   0466   0467
SysDriveMap         0390
SysFileDelete       0070   0097   0173   0174   0484   0586
TIME                0055   0056   0191   0200   0400
TRACE               0178
TRANSLATE           0201   0336   0350
UPPER               0077
VALUE               0178
VARDUMP             0613
WORD                0099   0115   0553   0553
WORDS               0098
X2D                 0411   0412   0413
XRANGE              0411   0412   0413   0416   0417   0418   0419   0420
                    0422   0425

*********************  End of REXX Cross Reference  *********************/
