/*************************************************************************
 *
 * This file was generated by the SOM Compiler.
 * FileName: wpprgext.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 *
 *************************************************************************/

/*************************************************************************
 * 
 * 
 *   Module Name : WPPRGEXT
 * 
 *   Description : OS/2 Workplace Shell WPProgram Object Extension.
 *                 This extension adds the option to close the folder
 *                 to which the launching program belongs.
 * 
 *   Programmer  : Yong D. Lee
 *   Date        : Nov 21, 1993
 * 
 *   Disclaimer of warranties:
 *       The code is provided "AS IS", without warranty of any kind.  I shall
 *       not be liable for any damages arising out of your use of this code.
 * 
 *************************************************************************/

#define WPPrgExt_Class_Source
#define M_WPPrgExt_Class_Source

#include "wpprgext.ih"
#include "wpprgext.ph"

#include <string.h>
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>

/*************************************************************************/
/*                                                                       */
/*                     Non-method function prototype                     */
/*                                                                       */
/*************************************************************************/

MRESULT EXPENTRY FolderDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY CloseKeyDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2);

/*************************************************************************/
/*                                                                       */
/*               Global/Static (Non-Instance) Data Section               */
/*                                                                       */
/*************************************************************************/

UCHAR szWPPrgExtClassTitle[CCHMAXPATH] = "";
HMODULE hmod = NULLHANDLE;
LONG virtualKey;

/*************************************************************************/
/*                                                                       */
/*                         Method Implementation                         */
/*                                                                       */
/*************************************************************************/

/*************************************************************************
 * 
 *  METHOD: QueryFolderClose                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    Query state of folder close flag
 * 
 *  RETURN:
 * 
 *    ULONG - folder closing option
 * 
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpprgext_QueryFolderClose(WPPrgExt *somSelf)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_QueryFolderClose");

    return (ULONG) _folderClose;
}

/*************************************************************************
 *
 *  METHOD: SetFolderClose                                 ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Set state of folder close flag
 *
 *************************************************************************/

SOM_Scope VOID   SOMLINK wpprgext_SetFolderClose(WPPrgExt *somSelf, ULONG flag)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_SetFolderClose");

    _folderClose = flag;
}

/*************************************************************************
 * 
 *  METHOD: AddFolderOptionPage                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 * 
 *    Add the folder page to the settings notebook
 * 
 *  RETURN:
 * 
 *    0              Unsuccessful
 *    ulPageId       Identifier for the inserted page
 * 
 * 
 *    Methods from the WPObject class
 * 
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpprgext_AddFolderOptionPage(WPPrgExt *somSelf, HWND hwndNotebook)
{
    PAGEINFO pageinfo;
    ULONG pageId;

    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_AddFolderOptionPage");

    memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
    pageinfo.cb = sizeof(PAGEINFO);
    pageinfo.hwndPage = NULLHANDLE;
    pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags = BKA_LAST;
    pageinfo.pfnwp = FolderDlgProc;
    pageinfo.resid = hmod;
    pageinfo.dlgid = IDD_FOLDER;
    pageinfo.pszName = "Folder";
    pageinfo.pCreateParams = somSelf;

    /*
     * Insert folder key page
     */
    pageId = _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);

    /*
     * Insert status line text
     */
    WinSendMsg(hwndNotebook, BKM_SETSTATUSLINETEXT, (MPARAM)pageId, MPFROMP("Folder - Page 1 of 2 "));

    return pageId;

}

/*************************************************************************
 *
 *  METHOD: AddFolderKeyPage                               ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Add the folder key selection page to the settings notebook
 *
 *  RETURN:
 *
 *    0              Unsuccessful
 *    ulPageId       Identifier for the inserted page
 *
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpprgext_AddFolderKeyPage(WPPrgExt *somSelf, HWND hwndNotebook)
{
    PAGEINFO pageinfo;
    ULONG pageId;

    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_AddFolderKeyPage");

    memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
    pageinfo.cb = sizeof(PAGEINFO);
    pageinfo.hwndPage = NULLHANDLE;
    pageinfo.usPageStyleFlags = BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags = BKA_LAST;
    pageinfo.pfnwp = CloseKeyDlgProc;
    pageinfo.resid = hmod;
    pageinfo.dlgid = IDD_FOLDERKEY;
    pageinfo.pCreateParams = somSelf;

    /*
     * Insert folder key page
     */
    pageId = _wpInsertSettingsPage(somSelf, hwndNotebook, &pageinfo);

    /*
     * Insert status line text
     */
    WinSendMsg(hwndNotebook, BKM_SETSTATUSLINETEXT, (MPARAM)pageId, MPFROMP("Folder - Page 2 of 2 "));

    return pageId;
}

/*************************************************************************
 *
 *  METHOD: FindKeyFromScancode                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Find key name from scancode
 *
 *************************************************************************/

SOM_Scope VOID SOMLINK wpprgext_FindKeyFromScancode(WPPrgExt *somSelf, LONG scanCode, CHAR *str)
{
    SHORT keyID;

    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_FindKeyFromScancode");

    switch (scanCode) {
        case VK_SHIFT:
            keyID = IDSC_SHIFT;
            break;

        case VK_F1:
            keyID = IDSC_F1;
            break;

        case VK_F2:
            keyID = IDSC_F2;
            break;

        case VK_F3:
            keyID = IDSC_F3;
            break;

        case VK_F4:
            keyID = IDSC_F4;
            break;

        case VK_F5:
            keyID = IDSC_F5;
            break;

        case VK_F6:
            keyID = IDSC_F6;
            break;

        case VK_F7:
            keyID = IDSC_F7;
            break;

        case VK_F8:
            keyID = IDSC_F8;
            break;

        case VK_F9:
            keyID = IDSC_F9;
            break;

        case VK_F10:
            keyID = IDSC_F10;
            break;

        case VK_F11:
            keyID = IDSC_F11;
            break;

        case VK_F12:
            keyID = IDSC_F12;
            break;

    }

    WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), _clsQueryModuleHandle((M_WPPrgExt *)_somGetClass(somSelf)), (ULONG)keyID, CCHMAXPATH, str);
}

/*************************************************************************
 *
 *  METHOD: FindScancodeFromKey                            ( ) PRIVATE
 *                                                         (X) PUBLIC
 *  DESCRIPTION:
 *
 *    Find scancode from keyname
 *
 *  RETURN
 *    key scancode
 *
 *************************************************************************/

SOM_Scope ULONG   SOMLINK wpprgext_FindScancodeFromKey(WPPrgExt *somSelf, CHAR *str)
{
    SHORT sCount;
    CHAR keyStr[CCHMAXPATH];

    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_FindScancodeFromKey");

    for (sCount = 0; sCount < MAXKEY; sCount++) {
        WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), _clsQueryModuleHandle((M_WPPrgExt *)_somGetClass(somSelf)), (ULONG)(IDSC_SHIFT + sCount), CCHMAXPATH, keyStr);

        if (strcmp(str, keyStr) == 0)
            break;

    }

    switch (IDSC_SHIFT + sCount) {
        case IDSC_SHIFT:
            return VK_SHIFT;

        case IDSC_F1:
            return VK_F1;

        case IDSC_F2:
            return VK_F2;

        case IDSC_F3:
            return VK_F3;

        case IDSC_F4:
            return VK_F4;

        case IDSC_F5:
            return VK_F5;

        case IDSC_F6:
            return VK_F6;

        case IDSC_F7:
            return VK_F7;

        case IDSC_F8:
            return VK_F8;

        case IDSC_F9:
            return VK_F9;

        case IDSC_F10:
            return VK_F10;

        case IDSC_F11:
            return VK_F11;

        case IDSC_F12:
            return VK_F12;

    }

    return 0;
}

/*************************************************************************/
/*                                                                       */
/*                     Override Method Implementation                    */
/*                                                                       */
/*************************************************************************/

/*************************************************************************
 * 
 *  OVERRIDE: wpInitData
 * 
 *  DESCRIPTION:
 * 
 *    Initialize the state variables and allocate any extra memory
 *    that might be needed
 * 
 *************************************************************************/

SOM_Scope void   SOMLINK wpprgext_wpInitData(WPPrgExt *somSelf)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpInitData");

    memset((PVOID)somThis, 0, sizeof(WPPrgExtData));
    _folderClose = DONOTCLOSE;

    parent_wpInitData(somSelf);
}

/*************************************************************************
 * 
 *  OVERRIDE: wpUnInitData
 * 
 *  DESCRIPTION:
 * 
 *    Clear up memory that was allocated on wpInitData
 * 
 *************************************************************************/

SOM_Scope void   SOMLINK wpprgext_wpUnInitData(WPPrgExt *somSelf)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpUnInitData");

    parent_wpUnInitData(somSelf);
}

/*************************************************************************
 * 
 *  OVERRIDE: wpSaveState
 * 
 *  DESCRIPTION:
 * 
 *    Save state variable (folder close flag)
 * 
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpprgext_wpSaveState(WPPrgExt *somSelf)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpSaveState");

    _wpSaveLong(somSelf, szWPPrgExtClassTitle, IDKEY_FOLDER, _folderClose);

    return (parent_wpSaveState(somSelf));
}

/*************************************************************************
 * 
 *  OVERRIDE: wpRestoreState
 * 
 *  DESCRIPTION:
 * 
 *    Restore saved state variable
 * 
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpprgext_wpRestoreState(WPPrgExt *somSelf, ULONG ulReserved)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpRestoreState");

    _wpRestoreLong(somSelf, szWPPrgExtClassTitle, IDKEY_FOLDER, &_folderClose);

    return (parent_wpRestoreState(somSelf,ulReserved));
}

/*************************************************************************
 * 
 *  OVERRIDE: wpAddSettingsPages
 * 
 *  DESCRIPTION:
 * 
 *    Add folder settings page to let the user alter the flag
 * 
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpprgext_wpAddSettingsPages(WPPrgExt *somSelf, HWND hwndNotebook)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpAddSettingsPages");

    if (parent_wpAddSettingsPages(somSelf, hwndNotebook) && _AddFolderOptionPage(somSelf, hwndNotebook) && _AddFolderKeyPage(somSelf, hwndNotebook)) {
        return (TRUE);
    } else {
        return (FALSE);
    }
  
}

/*************************************************************************
 * 
 *   METHOD: wpOpen                                        
 *                                                         
 *   DESCRIPTION:
 * 
 *     Opens the program object window. Close folder upon openning 
 *     according to folderClose flag
 * 
 *************************************************************************/

SOM_Scope HWND   SOMLINK wpprgext_wpOpen(WPPrgExt *somSelf, HWND hwndCnr, ULONG ulView, ULONG param)
{
    ULONG longSize = sizeof(LONG);
    LONG keyState;
    BOOL close;
    HWND hwndTop;
    HWND hwndClient;
    CHAR className[CCHMAXPATH];

    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpOpen");

    /*
     * Get close key scancode from system profile
     */

    if (!PrfQueryProfileData(HINI_USERPROFILE, "WPPrgExt", "WPPrgExt", (PVOID)&virtualKey, &longSize))
        virtualKey = VK_SHIFT;

    /*
     * Get the state of shift keys so that we can close the parent
     * folder if shift key is pressed
     */
    keyState = WinGetKeyState(HWND_DESKTOP, virtualKey);

    if (keyState & 0x8000)
        close = TRUE;
    else {

        /*
         * Check for the flags in the Folder page in settings notebook
         */
        switch (ulView) {

            case OPEN_SETTINGS:

                if (_folderClose & CLOSENOTEBOOK)
                    close = TRUE;
                else
                    close = FALSE;

                break;

            case OPEN_RUNNING:

                if (_folderClose & CLOSEPROGRAM)
                    close = TRUE;
                else
                    close = FALSE;

                break;

            default:
                close = FALSE;

        }
    }

    if (close) {
        /*
         * The active window before opening the new program must be
         * the parent folder. If it's not the desktop window (if there
         * are no window below the parent folder in z-order), close the
         * parent window
         */
        if (((hwndTop = WinQueryActiveWindow(HWND_DESKTOP)) != NULLHANDLE) && (WinQueryWindow(hwndTop, QW_NEXT) != NULLHANDLE)) {

            if ((hwndClient = WinWindowFromID(hwndTop, FID_CLIENT)) != NULLHANDLE) {
                WinQueryClassName(hwndClient, sizeof(className), className);

                if (strcmp(className, "#37") == 0)
                    WinSendMsg(hwndTop, WM_CLOSE, (MPARAM)0, (MPARAM)0);

            }
        }
    }

    /*
     * Call the original wpOpen
     */
    hwndTop = parent_wpOpen(somSelf, hwndCnr, ulView, param);

    /*
     * If the parent window is closed, the newly created program loses it's focus.
     * This will give it the focus back
     */
    if (close)
       WinSetFocus(HWND_DESKTOP, hwndTop);

    return hwndTop;
}

/*************************************************************************
 * 
 *  OVERRIDE: wpSetup
 * 
 *  DESCRIPTION:
 * 
 *    Specift setup strings and do some initialization
 * 
 *************************************************************************/

SOM_Scope BOOL   SOMLINK wpprgext_wpSetup(WPPrgExt *somSelf, PSZ pszSetupString)
{
    WPPrgExtData *somThis = WPPrgExtGetData(somSelf);
    WPPrgExtMethodDebug("WPPrgExt","wpprgext_wpSetup");

    return (parent_wpSetup(somSelf,pszSetupString));
}

#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta

/*************************************************************************/
/*                                                                       */
/*                      Class Method Implementation                      */
/*                                                                       */
/*************************************************************************/

/*************************************************************************
 *
 *  METHOD: clsQueryModuleHandle                         ( ) PRIVATE
 *                                                       (X) PUBLIC
 *  DESCRIPTION:
 *
 *    This method returns the module handle of this class.
 *
 *  RETURN:
 *
 *    0          Unsuccessful
 *    non-zero   Module handle
 *
 *************************************************************************/

SOM_Scope HMODULE   SOMLINK wpprgextM_clsQueryModuleHandle(M_WPPrgExt *somSelf)
{
    zString zsPathName;
    APIRET rc;

    /* M_WPPrgExtData *somThis = M_WPPrgExtGetData(somSelf); */
    M_WPPrgExtMethodDebug("M_WPPrgExt","wpprgextM_clsQueryModuleHandle");

    if (hmod == NULLHANDLE) {

       /*
        *   Retrieve registered pathname of our module (DLL) and query the
        *   module handle.
        */
       zsPathName = _somLocateClassFile(SOMClassMgrObject,
                                        SOM_IdFromString("WPPrgExt"),
                                        WPPrgExt_MajorVersion,
                                        WPPrgExt_MinorVersion);
       rc = DosQueryModuleHandle(zsPathName, &hmod);
    }

    return (hmod);
}

/*************************************************************************/
/*                                                                       */
/*                  Override Class Method Implementation                 */
/*                                                                       */
/*************************************************************************/

/*************************************************************************
 * 
 *  METHOD: wpclsInitData
 * 
 *  DESCRIPTION:
 * 
 *    Initialize the class data
 * 
 *************************************************************************/

SOM_Scope void   SOMLINK wpprgextM_wpclsInitData(M_WPPrgExt *somSelf)
{

    /* M_WPPrgExtData *somThis = M_WPPrgExtGetData(somSelf); */
    M_WPPrgExtMethodDebug("M_WPPrgExt","wpprgextM_wpclsInitData");

    parent_wpclsInitData(somSelf);

    /* 
     * Get class title
     */

    if (!WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), 
                       _clsQueryModuleHandle(somSelf),  
                       ID_TITLE,        
                       sizeof(szWPPrgExtClassTitle),
                       szWPPrgExtClassTitle))
        strcpy(szWPPrgExtClassTitle, parent_wpclsQueryTitle(somSelf));
}

/*************************************************************************
 * 
 *  METHOD: wpclsUnInitData
 * 
 *  DESCRIPTION:
 * 
 *    Free any class data
 * 
 *************************************************************************/

SOM_Scope void   SOMLINK wpprgextM_wpclsUnInitData(M_WPPrgExt *somSelf)
{
    /* M_WPPrgExtData *somThis = M_WPPrgExtGetData(somSelf); */
    M_WPPrgExtMethodDebug("M_WPPrgExt","wpprgextM_wpclsUnInitData");

    parent_wpclsUnInitData(somSelf);
}

/*************************************************************************
 *
 *  METHOD: wpclsQueryTitle                                
 *                                                         
 *  DESCRIPTION:
 *
 *    Return the string "Extended Program".
 *
 *************************************************************************/

SOM_Scope PSZ   SOMLINK wpprgextM_wpclsQueryTitle(M_WPPrgExt *somSelf)
{
    /* M_WPPrgExtData *somThis = M_WPPrgExtGetData(somSelf); */
    M_WPPrgExtMethodDebug("M_WPPrgExt","wpprgextM_wpclsQueryTitle");

    /* 
     * Return the class title for a WPPrgExt
     */
    if (*szWPPrgExtClassTitle)
        return (szWPPrgExtClassTitle);
    else 
        return (parent_wpclsQueryTitle(somSelf));

}

/*************************************************************************/
/*                                                                       */
/*                   Non-method function implementation                  */
/*                                                                       */
/*************************************************************************/

MRESULT EXPENTRY FolderDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   PFOLDEROPTION pFolder;
   MRESULT rc;

   switch(msg) {
      case WM_INITDLG:
         pFolder = (PFOLDEROPTION)_wpAllocMem((WPPrgExt *)mp2, sizeof(FOLDEROPTION), NULL);

         if (pFolder) {
            memset((PVOID)pFolder, 0, sizeof(FOLDEROPTION));
            pFolder->cb = sizeof(FOLDEROPTION);
            pFolder->somSelf = (WPPrgExt *)mp2;
            pFolder->closeFolder = _QueryFolderClose(pFolder->somSelf);
         }
         else 
            break;

         WinSetWindowPtr(hwndDlg, QWL_USER, pFolder);

         if (pFolder->closeFolder & CLOSENOTEBOOK)
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_SETCHECK, MPFROMSHORT(0), (MPARAM)0);

         if (pFolder->closeFolder & CLOSEPROGRAM)
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEPROGRAM), BM_SETCHECK, MPFROMSHORT(1), (MPARAM)0);
         else
            WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEPROGRAM), BM_SETCHECK, MPFROMSHORT(0), (MPARAM)0);

         return (MRESULT)TRUE;

      case WM_CLOSE:
         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);
 
         if (pFolder == NULL) 
             break;

         _wpFreeMem(pFolder->somSelf, (PBYTE)pFolder);
         return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));

      case WM_CONTROL:
         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pFolder == NULL) 
            break;

         switch (SHORT1FROMMP(mp1)) {

            case IDCHECK_CLOSENOTEBOOK:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  rc = WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSENOTEBOOK), BM_QUERYCHECK, (MPARAM)0, (MPARAM)0);

                  if ((USHORT)rc == 1)
                     pFolder->closeFolder |= CLOSENOTEBOOK;
                  else if ((USHORT)rc == 0)
                     pFolder->closeFolder &= ~CLOSENOTEBOOK;

                  _SetFolderClose(pFolder->somSelf, pFolder->closeFolder);
               }

               break;
            case IDCHECK_CLOSEPROGRAM:

               if (SHORT2FROMMP(mp1) == BN_CLICKED) {
                  rc = WinSendMsg(WinWindowFromID(hwndDlg, IDCHECK_CLOSEPROGRAM), BM_QUERYCHECK, (MPARAM)0, (MPARAM)0);

                  if ((USHORT)rc == 1)
                     pFolder->closeFolder |= CLOSEPROGRAM;
                  else if ((USHORT)rc == 0)
                     pFolder->closeFolder &= ~CLOSEPROGRAM;

                  _SetFolderClose(pFolder->somSelf, pFolder->closeFolder);
               }

               break;

         }
      
         return (MRESULT)TRUE;
   }

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));
} 

/*************************************************************************
 *
 * Window procedure : CloseKeyDlgProc
 *
 *************************************************************************/

MRESULT EXPENTRY CloseKeyDlgProc(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   SHORT sCount;
   CHAR str[CCHMAXPATH];
   PFOLDERKEY pFolder;

   switch (msg) {
      case WM_INITDLG:
         pFolder = (PFOLDERKEY)_wpAllocMem((WPPrgExt *)mp2, sizeof(FOLDERKEY), NULL);

         if (pFolder) {
            memset((PVOID)pFolder, 0, sizeof(FOLDERKEY));
            pFolder->cb = sizeof(FOLDERKEY);
            pFolder->somSelf = (WPPrgExt *)mp2;
         }
         else
            break;

         WinSetWindowPtr(hwndDlg, QWL_USER, pFolder);

         for (sCount=0; sCount < MAXKEY; sCount++) {
            WinLoadString(WinQueryAnchorBlock(HWND_DESKTOP), _clsQueryModuleHandle((M_WPPrgExt *)_somGetClass(pFolder->somSelf)), (ULONG)(IDSC_SHIFT + sCount), CCHMAXPATH, str);

            WinSendMsg(WinWindowFromID(hwndDlg, IDCOMBO_KEYSELECTION), LM_INSERTITEM, MPFROMSHORT(LIT_END), MPFROMP(str));
         }

         _FindKeyFromScancode(pFolder->somSelf, virtualKey, str);
         WinSetWindowText(WinWindowFromID(hwndDlg, IDCOMBO_KEYSELECTION), str);
         return (MRESULT)TRUE;

      case WM_CLOSE:

         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pFolder == NULL)
             break;

         _wpFreeMem(pFolder->somSelf, (PBYTE)pFolder);
         return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));

      case WM_CONTROL:

         pFolder = WinQueryWindowPtr(hwndDlg, QWL_USER);

         if (pFolder == NULL)
            break;

         switch (SHORT1FROMMP(mp1)) {

            case IDCOMBO_KEYSELECTION:

               if (SHORT2FROMMP(mp1) == CBN_ENTER) {
                  WinQueryWindowText(WinWindowFromID(hwndDlg, IDCOMBO_KEYSELECTION), CCHMAXPATH, str);
                  virtualKey = _FindScancodeFromKey(pFolder->somSelf, str);
                  PrfWriteProfileData(HINI_USERPROFILE, "WPPrgExt", "WPPrgExt", &virtualKey, sizeof(LONG));
               }

               break;
         }

         return (MRESULT)TRUE;
   }

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}

