# include "Local.h"
# include "yyALocal.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 27 "AdaptLocal.puma"

# include "Idents.h"

# include "protocol.h"

# include "Transfor.h"   /* ExpToVarParam, ... */
# include "Dalib.h"       /* MakeUsedVarA, .... */
# include "Shapes.h"      /* struct shape */
# include "Types.h"       /* LastIndex    */

# include "IndexSha.h" /* FindShapeExp */


static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module AdaptLocal, routine %s failed\n", yyFunction);
 exit (1);
}

tTree LocalDoLocal ARGS((tTree t, tTree parvar));
tTree LocalArrayAssignment ARGS((tTree t));
tTree MakeRangeStmt ARGS((tTree v, tTree slice));
static void MakeLocalRange ARGS((tTree var, tTree range, tTree * stmt, tTree * local_range));
static void ReplaceLocalRange ARGS((tTree range, tTree local_range));
static bool IsFullLastIndex ARGS((tTree v, tTree slice));
static tTree MakeRangeSlice ARGS((tIdent name, tTree slice));
static tTree MakeLocalSlice ARGS((tIdent name, tTree slice));
static tTree MakeLocalExp ARGS((tTree exp, tTree range, tTree local_range));
static void RestrictActualShape ARGS((tTree formal, tTree actual, tTree local_f));

tTree LocalDoLocal
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree parvar)
# else
(t, parvar)
 register tTree t;
 register tTree parvar;
# endif
{
  if (t->Kind == kACF_DOLOCAL) {
  if (parvar->Kind == kINDEXED_VAR) {
# line 48 "AdaptLocal.puma"
 {
  tTree newfor;
  {
# line 54 "AdaptLocal.puma"
 if (TreeVarName (t->ACF_DOLOCAL.DOLOCAL_ID) != TreeVarName (LastIndex (parvar->INDEXED_VAR.IND_EXPS)))
        { printf("LocalParfor: INTERNAL ERROR \n");
          FileUnparse (stdout, parvar);
          exit (-1);
        }

# line 61 "AdaptLocal.puma"

# line 63 "AdaptLocal.puma"
   newfor = MakeRangeStmt (parvar->INDEXED_VAR.IND_VAR, t->ACF_DOLOCAL.DOLOCAL_RANGE);
# line 65 "AdaptLocal.puma"
 if (newfor != NoTree)
        newfor = mACF_LIST (newfor, mACF_LIST (t, NoTree));
      else
        newfor = t;

# line 71 "AdaptLocal.puma"
 t->Kind = kACF_DO;
  }
  {
   return newfor;
  }
 }

  }
  }
# line 76 "AdaptLocal.puma"
  {
# line 77 "AdaptLocal.puma"
   error_protocol ("Illegal Call of LocalDoLocal");
# line 78 "AdaptLocal.puma"
   printf ("Illegal Call of LocalDoLocal\n");
# line 79 "AdaptLocal.puma"
   FileUnparse (stdout, t);
# line 80 "AdaptLocal.puma"
   FileUnparse (stdout, parvar);
  }
   return NoTree;

}

tTree LocalArrayAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
# line 99 "AdaptLocal.puma"
  {
# line 100 "AdaptLocal.puma"
   if (! ((TreeDistribution (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR) != 1))) goto yyL1;
  {
# line 101 "AdaptLocal.puma"
   error_protocol ("LocalArrayAssignment: lhs var not distributed");
  }
  }
   return t;
yyL1:;

  if (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR->Kind == kINDEXED_VAR) {
# line 105 "AdaptLocal.puma"
  {
# line 106 "AdaptLocal.puma"
   if (! ((TreeDistribution (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR->INDEXED_VAR.IND_EXPS) != 0))) goto yyL2;
  {
# line 107 "AdaptLocal.puma"
   error_protocol ("LocalArrayAssignment: lhs var indexes not replicated");
  }
  }
   return t;
yyL2:;

# line 119 "AdaptLocal.puma"
 {
  tTree NewAssign;
  {
# line 121 "AdaptLocal.puma"

# line 123 "AdaptLocal.puma"
   if (! ((TreeRank (LastIndex (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR->INDEXED_VAR.IND_EXPS)) == 0))) goto yyL3;
  {
# line 125 "AdaptLocal.puma"
   stmt_protocol ("LocalArrayAssignment (masked)");
# line 127 "AdaptLocal.puma"
   NewAssign = MaskNodeStmt (t, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
# line 129 "AdaptLocal.puma"
   tree_protocol ("New Statement : ", NewAssign);
  }
  }
  {
   return NewAssign;
  }
 }
yyL3:;

# line 142 "AdaptLocal.puma"
 {
  tTree last_index;
  tTree NewAssign;
  tTree local_range;
  {
# line 144 "AdaptLocal.puma"

# line 146 "AdaptLocal.puma"
   last_index = LastIndex (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR->INDEXED_VAR.IND_EXPS);
# line 148 "AdaptLocal.puma"

# line 149 "AdaptLocal.puma"

# line 151 "AdaptLocal.puma"
 if (last_index->Kind == kSLICE_EXP)
      {

        stmt_protocol ("local array assignment (restricted slice)");

        MakeLocalRange (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR->INDEXED_VAR.IND_VAR, last_index, &NewAssign, &local_range);



        t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = MakeLocalExp (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, last_index, local_range);



        ReplaceLocalRange (last_index, local_range);

        if (NewAssign != NoTree)
          NewAssign = mACF_LIST (NewAssign, mACF_LIST (t, NoTree));
         else
          NewAssign = mACF_LIST (t, NoTree);
        tree_protocol ("New Statement(s) : ", NewAssign);
      }
     else
      { NewAssign = t;
        error_protocol ("LocalArrayAssignment: vector-valued subscript");
      }

  }
  {
   return NewAssign;
  }
 }

  }
  }
  }
 yyAbort ("LocalArrayAssignment");
}

tTree MakeRangeStmt
# if defined __STDC__ | defined __cplusplus
(register tTree v, register tTree slice)
# else
(v, slice)
 register tTree v;
 register tTree slice;
# endif
{
# line 190 "AdaptLocal.puma"

bool  found;
int   value;
tTree new;

  if (v->Kind == kUSED_VAR) {
  if (slice->Kind == kSLICE_EXP) {
  if (slice->SLICE_EXP.START->Kind == kDUMMY_EXP) {
  if (slice->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
  if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 202 "AdaptLocal.puma"
   return NoTree;

  }
  }
  }
# line 207 "AdaptLocal.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 208 "AdaptLocal.puma"
   MakeLocalRange (v, slice, & yyV1, & yyV2);
# line 209 "AdaptLocal.puma"
   ReplaceLocalRange (slice, yyV2);
  }
  {
   return yyV1;
  }
 }

  }
  }
# line 213 "AdaptLocal.puma"
  {
# line 214 "AdaptLocal.puma"
   printf ("MakeRangeStmt fails\n");
# line 215 "AdaptLocal.puma"
   printf ("var = ");
# line 215 "AdaptLocal.puma"
   FileUnparse (stdout, v);
# line 215 "AdaptLocal.puma"
   printf ("\n");
# line 216 "AdaptLocal.puma"
   printf ("slice = ");
# line 216 "AdaptLocal.puma"
   FileUnparse (stdout, slice);
# line 216 "AdaptLocal.puma"
   printf ("\n");
# line 217 "AdaptLocal.puma"
   WriteTree (stdout, v);
# line 218 "AdaptLocal.puma"
   WriteTree (stdout, slice);
# line 219 "AdaptLocal.puma"
   kill_in_protocol ();
  }
   return NoTree;

}

static void MakeLocalRange
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree range, register tTree * stmt, register tTree * local_range)
# else
(var, range, stmt, local_range)
 register tTree var;
 register tTree range;
 register tTree * stmt;
 register tTree * local_range;
# endif
{
# line 236 "AdaptLocal.puma"

bool found;
int  value;

  if (var == NoTree) return;
  if (range == NoTree) return;
  if (var->Kind == kUSED_VAR) {
# line 241 "AdaptLocal.puma"
 {
  tTree yyV1;
  tTree yyV2;
  {
# line 242 "AdaptLocal.puma"
   MakeLocalRange (var->USED_VAR.VARNAME, range, & yyV1, & yyV2);
  }
   * stmt = yyV1;
   * local_range = yyV2;
   return;
 }

  }
  if (var->Kind == kVAR_OBJ) {
  if (range->Kind == kSLICE_EXP) {
# line 245 "AdaptLocal.puma"
 {
  tTree slice;
  tTree new;
  {
# line 247 "AdaptLocal.puma"

# line 248 "AdaptLocal.puma"

# line 250 "AdaptLocal.puma"
 if ((range->SLICE_EXP.START->Kind == kDUMMY_EXP) || (range->SLICE_EXP.STOP->Kind == kDUMMY_EXP))
       { printf ("MakeLocalRange: range not normalized");
         WriteTree (stdout, range);
       }

     if (range->SLICE_EXP.INC->Kind != kDUMMY_EXP)
       { GetIntConstValue (range->SLICE_EXP.INC, &found, &value);
         if (found && (value == 1))
            range->SLICE_EXP.INC = mDUMMY_EXP ();
       }

     slice = mSLICE_EXP (range->SLICE_EXP.START, range->SLICE_EXP.STOP, range->SLICE_EXP.INC);

     if (IsFullLastIndex (var, slice))
        new = MakeLocalSlice (var->VAR_OBJ.Ident, slice);
      else
        new = MakeRangeSlice (var->VAR_OBJ.Ident, slice);

  }
   * stmt = new;
   * local_range = slice;
   return;
 }

  }
  }
;
}

static void ReplaceLocalRange
# if defined __STDC__ | defined __cplusplus
(register tTree range, register tTree local_range)
# else
(range, local_range)
 register tTree range;
 register tTree local_range;
# endif
{
  if (range == NoTree) return;
  if (local_range == NoTree) return;
  if (range->Kind == kSLICE_EXP) {
  if (local_range->Kind == kSLICE_EXP) {
# line 272 "AdaptLocal.puma"
  {
# line 273 "AdaptLocal.puma"
 range->SLICE_EXP.START = local_range->SLICE_EXP.START;
     range->SLICE_EXP.STOP = local_range->SLICE_EXP.STOP;
     range->SLICE_EXP.INC = local_range->SLICE_EXP.INC;

  }
   return;

  }
  }
;
}

static bool IsFullLastIndex
# if defined __STDC__ | defined __cplusplus
(register tTree v, register tTree slice)
# else
(v, slice)
 register tTree v;
 register tTree slice;
# endif
{
  if (v == NoTree) return false;
  if (slice == NoTree) return false;
  if (v->Kind == kVAR_OBJ) {
  if (slice->Kind == kSLICE_EXP) {
  if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 289 "AdaptLocal.puma"
 {
  int rank;
  struct_shape shp;
  {
# line 291 "AdaptLocal.puma"

# line 292 "AdaptLocal.puma"

# line 294 "AdaptLocal.puma"
   rank = VarRank (v->VAR_OBJ.Object);
# line 295 "AdaptLocal.puma"
   GetCurrentShape (v, & shp);
# line 297 "AdaptLocal.puma"
   if (! (EqualExpression (slice->SLICE_EXP.START, shp . bounds [rank - 1] [0]) == true)) goto yyL1;
  {
# line 298 "AdaptLocal.puma"
   if (! (EqualExpression (slice->SLICE_EXP.STOP, shp . bounds [rank - 1] [1]) == true)) goto yyL1;
  }
  }
   return true;
 }
yyL1:;

  }
  }
  }
  return false;
}

static tTree MakeRangeSlice
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree slice)
# else
(name, slice)
 register tIdent name;
 register tTree slice;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
  if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 310 "AdaptLocal.puma"
 {
  tTree ParamList;
  tTree Param;
  tTree CallStmt;
  {
# line 312 "AdaptLocal.puma"

# line 313 "AdaptLocal.puma"

# line 315 "AdaptLocal.puma"
   ParamList = mBTP_EMPTY ();
# line 317 "AdaptLocal.puma"
   Param = mVAR_PARAM (MakeUsedVarA (name, "_STOP"));
# line 318 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 320 "AdaptLocal.puma"
   Param = mVAR_PARAM (MakeUsedVarA (name, "_START"));
# line 321 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 323 "AdaptLocal.puma"
   Param = ExpToVarParam (slice->SLICE_EXP.STOP);
# line 324 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 326 "AdaptLocal.puma"
   Param = ExpToVarParam (slice->SLICE_EXP.START);
# line 327 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 329 "AdaptLocal.puma"
   Param = ArrayFormals (GetLocalDecl (name));
# line 330 "AdaptLocal.puma"
   ParamList = DalibLastFormalParam (Param, ParamList);
# line 332 "AdaptLocal.puma"

# line 334 "AdaptLocal.puma"
   CallStmt = mPROC_OBJ (MakeDalibId ("local_slice"));
# line 335 "AdaptLocal.puma"
   CallStmt = mACF_BASIC (mCALL_STMT (CallStmt, ParamList));
# line 337 "AdaptLocal.puma"
   slice->SLICE_EXP.START = mVAR_EXP (MakeUsedVarA (name, "_START"));
# line 338 "AdaptLocal.puma"
   slice->SLICE_EXP.STOP = mVAR_EXP (MakeUsedVarA (name, "_STOP"));
  }
  {
   return CallStmt;
  }
 }

  }
# line 350 "AdaptLocal.puma"
 {
  tTree ParamList;
  tTree Param;
  tTree CallStmt;
  {
# line 352 "AdaptLocal.puma"

# line 353 "AdaptLocal.puma"

# line 355 "AdaptLocal.puma"
   ParamList = mBTP_EMPTY ();
# line 357 "AdaptLocal.puma"
   Param = mVAR_PARAM (MakeUsedVarA (name, "_INC"));
# line 358 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 360 "AdaptLocal.puma"
   Param = mVAR_PARAM (MakeUsedVarA (name, "_STOP"));
# line 361 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 363 "AdaptLocal.puma"
   Param = mVAR_PARAM (MakeUsedVarA (name, "_START"));
# line 364 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 366 "AdaptLocal.puma"
   Param = ExpToVarParam (slice->SLICE_EXP.INC);
# line 367 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 369 "AdaptLocal.puma"
   Param = ExpToVarParam (slice->SLICE_EXP.STOP);
# line 370 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 372 "AdaptLocal.puma"
   Param = ExpToVarParam (slice->SLICE_EXP.START);
# line 373 "AdaptLocal.puma"
   ParamList = mBTP_LIST (Param, ParamList);
# line 375 "AdaptLocal.puma"
   Param = ArrayFormals (GetLocalDecl (name));
# line 376 "AdaptLocal.puma"
   ParamList = DalibLastFormalParam (Param, ParamList);
# line 378 "AdaptLocal.puma"

# line 380 "AdaptLocal.puma"
   CallStmt = mPROC_OBJ (MakeDalibId ("local_range"));
# line 381 "AdaptLocal.puma"
   CallStmt = mACF_BASIC (mCALL_STMT (CallStmt, ParamList));
# line 383 "AdaptLocal.puma"
   slice->SLICE_EXP.START = mVAR_EXP (MakeUsedVarA (name, "_START"));
# line 384 "AdaptLocal.puma"
   slice->SLICE_EXP.STOP = mVAR_EXP (MakeUsedVarA (name, "_STOP"));
# line 385 "AdaptLocal.puma"
   slice->SLICE_EXP.INC = mVAR_EXP (MakeUsedVarA (name, "_INC"));
  }
  {
   return CallStmt;
  }
 }

  }
 yyAbort ("MakeRangeSlice");
}

static tTree MakeLocalSlice
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree slice)
# else
(name, slice)
 register tIdent name;
 register tTree slice;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
  if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
# line 399 "AdaptLocal.puma"
  {
# line 401 "AdaptLocal.puma"
   slice->SLICE_EXP.START = mVAR_EXP (MakeUsedVarA (name, "_LOW"));
# line 402 "AdaptLocal.puma"
   slice->SLICE_EXP.STOP = mVAR_EXP (MakeUsedVarA (name, "_HIGH"));
  }
   return NoTree;

  }
  }
 yyAbort ("MakeLocalSlice");
}

static tTree MakeLocalExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree range, register tTree local_range)
# else
(exp, range, local_range)
 register tTree exp;
 register tTree range;
 register tTree local_range;
# endif
{

  switch (exp->Kind) {
  case kOP_EXP:
# line 423 "AdaptLocal.puma"
  {
# line 424 "AdaptLocal.puma"
 exp->OP_EXP.OPND1 = MakeLocalExp (exp->OP_EXP.OPND1, range, local_range);
# line 425 "AdaptLocal.puma"
 exp->OP_EXP.OPND2 = MakeLocalExp (exp->OP_EXP.OPND2, range, local_range);
  }
   return exp;

  case kOP1_EXP:
# line 429 "AdaptLocal.puma"
  {
# line 430 "AdaptLocal.puma"
 exp->OP1_EXP.OPND = MakeLocalExp (exp->OP1_EXP.OPND, range, local_range);
  }
   return exp;

  case kCONST_EXP:
# line 434 "AdaptLocal.puma"
   return exp;

  case kADDR:
# line 438 "AdaptLocal.puma"
  {
# line 439 "AdaptLocal.puma"
 exp->ADDR.E = MakeLocalExp (exp->ADDR.E, range, local_range);
  }
   return exp;

  case kVAR_EXP:
# line 443 "AdaptLocal.puma"
  {
# line 444 "AdaptLocal.puma"
 exp->VAR_EXP.V = MakeLocalExp (exp->VAR_EXP.V, range, local_range);
  }
   return exp;

  case kFUNC_CALL_EXP:
# line 448 "AdaptLocal.puma"
  {
# line 449 "AdaptLocal.puma"
   if (! (IsIntrFunc (exp) == true)) goto yyL6;
  {
# line 450 "AdaptLocal.puma"
   if (! ((IntrFuncKind1 (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)
       || IntrFuncKind2 (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)
       || IntrFuncKindn (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)
      ))) goto yyL6;
  {
# line 451 "AdaptLocal.puma"
 exp->FUNC_CALL_EXP.FUNC_PARAMS = MakeLocalExp (exp->FUNC_CALL_EXP.FUNC_PARAMS, range, local_range);
  }
  }
  }
   return exp;
yyL6:;

  break;
  case kBTP_LIST:
  if (exp->BTP_LIST.Elem->Kind == kVAR_PARAM) {
# line 455 "AdaptLocal.puma"
  {
# line 456 "AdaptLocal.puma"
 exp->BTP_LIST.Elem->VAR_PARAM.V = MakeLocalExp (exp->BTP_LIST.Elem->VAR_PARAM.V, range, local_range);
# line 457 "AdaptLocal.puma"
 exp->BTP_LIST.Next  = MakeLocalExp (exp->BTP_LIST.Next, range, local_range);
  }
   return exp;

  }
  break;
  case kBTP_EMPTY:
# line 461 "AdaptLocal.puma"
   return exp;

  case kARRAY_EXP:
  if (exp->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (exp->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (exp->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 471 "AdaptLocal.puma"
  {
# line 472 "AdaptLocal.puma"
   RestrictActualShape (range, exp->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem, local_range);
  }
   return exp;

  }
  }
  }
  break;
  case kUSED_VAR:
# line 482 "AdaptLocal.puma"
  {
# line 483 "AdaptLocal.puma"
   if (! ((TreeRank (exp->USED_VAR.VARNAME) == 0))) goto yyL10;
  }
   return exp;
yyL10:;

# line 495 "AdaptLocal.puma"
   return MakeLocalExp (MakeFullShape (exp), range, local_range);

  case kINDEXED_VAR:
# line 499 "AdaptLocal.puma"
 {
  tTree h;
  {
# line 501 "AdaptLocal.puma"

# line 503 "AdaptLocal.puma"
 h = MakeFullShape (exp);
# line 505 "AdaptLocal.puma"
   RestrictActualShape (range, LastIndex (exp->INDEXED_VAR.IND_EXPS), local_range);
  }
  {
   return exp;
  }
 }

  }

# line 510 "AdaptLocal.puma"
  {
# line 511 "AdaptLocal.puma"
   printf ("MakeLocalExp failed\n");
# line 512 "AdaptLocal.puma"
   FileUnparse (stdout, exp);
# line 513 "AdaptLocal.puma"
   WriteTree (stdout, exp);
  }
   return exp;

}

static void RestrictActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree formal, register tTree actual, register tTree local_f)
# else
(formal, actual, local_f)
 register tTree formal;
 register tTree actual;
 register tTree local_f;
# endif
{
  if (formal == NoTree) return;
  if (actual == NoTree) return;
  if (local_f == NoTree) return;
  if (formal->Kind == kSLICE_EXP) {
  if (actual->Kind == kSLICE_EXP) {
  if (local_f->Kind == kSLICE_EXP) {
# line 532 "AdaptLocal.puma"
 {
  tTree new_lb;
  tTree new_ub;
  {
# line 535 "AdaptLocal.puma"

# line 536 "AdaptLocal.puma"

# line 538 "AdaptLocal.puma"
 new_lb = CopyTree (local_f->SLICE_EXP.START);
     new_lb = FindShapeExp (actual, formal->SLICE_EXP.START, formal->SLICE_EXP.STOP, formal->SLICE_EXP.INC, new_lb);
     new_ub = CopyTree (local_f->SLICE_EXP.STOP);
     new_ub = FindShapeExp (actual, formal->SLICE_EXP.START, formal->SLICE_EXP.STOP, formal->SLICE_EXP.INC, new_ub);

     actual->SLICE_EXP.START = new_lb;
     actual->SLICE_EXP.STOP = new_ub;

  }
   return;
 }

  }
  }
  }
;
}

void BeginAdaptLocal ()
{
}

void CloseAdaptLocal ()
{
}
