/****************************************************************************\
*                                                                            *
*  AREAS.C                                                                   *
*                                                                            *
*  Copyright 1993 Diana Gruber. All rights reserved.                         *
*                                                                            *
*  This is example source code for Fastgraph users. This is just a simple    *
*  that demonstrates how to use the mouse. The mouse touches areas on the    *
*  screen and reports the color.                                             *
*                                                                            *
*  The code is interesting because it uses an array of structures. Okay,     *
*  maybe it's not that interesting, but it is free. :)                       *
*                                                                            *
*  You may use any or all of this code in your Fastgraph applications.       *
*                                                                            *
*  See MISC.DOC for compile and link commands.                               *
*                                                                            *
\****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fastgraf.h>

#define BETWEEN(x,a,b) ((x >= a) && (x <= b))
#define ESC  27
#define FALSE 0
#define TRUE  1

/* be sure to declare functions before defining structures */

int looking_at(void);
int touching(void);
int do_areas(void);
int default_message(void);

/* pointer to an integer function */

typedef int (*PFI)();

/* define the structure */

typedef struct cmd
{
   PFI  func;        /* function to be called */
   char *string;     /* the menu item as written on the screen */
   int x1;           /* coordinates of active menu area */
   int x2;
   int y1;
   int y2;
}  CMD;

/* declare some structures */

int NAREAS = 4;

CMD mouse_area[] =
{
   looking_at, "RED",     0, 99, 16,199,
   looking_at, "BLUE",  100,199, 16,199,
   touching,   "GREEN", 200,299, 16, 99,
   touching,   "YELLOW",200,299,100,199
};

char area_string[80];

/****************************************************************************\
*                                                                            *
*  main                                                                      *
*                                                                            *
\****************************************************************************/

void main()
{
   int old_mode;

   /* initialize the video environment and the mouse */

   if (fg_testmode(19,0) == 0)
   {
      printf("This program requires VGA or MCGA graphics.\n");
      exit(1);
   }
   old_mode = fg_getmode();
   fg_setmode(19);

   /* initialize the mouse */

   if (fg_mouseini() <= 0)
   {
      fg_setmode(old_mode);
      fg_reset();
      printf("This program requires a mouse.\n");
      exit(1);
   }

   do_areas();

   /* reset the video mode and exit */

   fg_setmode(old_mode);
   fg_reset();
   exit(0);
}

/****************************************************************************\
*                                                                            *
*  do_areas -- display information based on what are the mouse is touching   *
*                                                                            *
\****************************************************************************/

int do_areas()
{
   unsigned char key,aux;
   register int i;
   int current_area;
   int xmouse,ymouse,buttons;
   int x1,x2,y1,y2;
   int found;
   static int area_color[] = {4,1,2,14};

   /* draw some colored rectangles */

   for (i = 0; i < NAREAS; i++)
   {
      x1 = mouse_area[i].x1;
      x2 = mouse_area[i].x2;
      y1 = mouse_area[i].y1;
      y2 = mouse_area[i].y2;

      fg_setcolor(area_color[i]);
      fg_rect(x1,x2,y1,y2);
   }
   fg_mousevis(1);

   /* now look at where the mouse is */

   current_area = -1;
   for(;;)
   {
      fg_mousepos(&xmouse,&ymouse,&buttons);
      found = FALSE;
      for (i = 0; i < NAREAS; i++)
      {
         x1 = mouse_area[i].x1;
         x2 = mouse_area[i].x2;
         y1 = mouse_area[i].y1;
         y2 = mouse_area[i].y2;

         if (BETWEEN(xmouse,x1,x2) && BETWEEN(ymouse,y1,y2))
         {
            found = TRUE;

            /* have we moved into a new area? */

            if (i != current_area)
            {
               strcpy(area_string,mouse_area[i].string);

               /* call the function as defined in the structure */

               (*mouse_area[i].func)();
               current_area = i;
               break;
            }
         }
      }

      /* not a hot spot -- display null message */

      if (!found && current_area != NAREAS)
      {
         default_message();
         current_area = NAREAS;
      }

      /* check for ESC key */

      fg_waitfor(3);
      fg_intkey(&key,&aux);
      if (key == ESC) break;
   }
   return(0);
}

/****************************************************************************\
*                                                                            *
*  looking_at -- function called when looking at a color                     *
*                                                                            *
\****************************************************************************/

looking_at()
{
   char string[80];
   int nchar;

   strcpy(string,"I'm looking at ");
   strcat(string,area_string);
   nchar = strlen(string);

   fg_mousevis(0);
   fg_setcolor(0);
   fg_rect(0,319,0,15);
   fg_setcolor(15);
   fg_locate(0,5);
   fg_text(string,nchar);
   fg_mousevis(1);

   return(0);
}

/****************************************************************************\
*                                                                            *
*  touching -- function called when touching a color                         *
*                                                                            *
\****************************************************************************/

touching()
{
   char string[80];
   int nchar;

   strcpy(string,"I'm touching ");
   strcat(string,area_string);
   nchar = strlen(string);

   fg_mousevis(0);
   fg_setcolor(0);
   fg_rect(0,319,0,15);
   fg_setcolor(15);
   fg_locate(0,5);
   fg_text(string,nchar);
   fg_mousevis(1);

   return(0);
}

/****************************************************************************\
*                                                                            *
*  default_message -- blank message                                          *
*                                                                            *
\****************************************************************************/

default_message()
{
   fg_mousevis(0);
   fg_setcolor(0);
   fg_rect(0,319,0,15);
   fg_mousevis(1);

   return(0);
}
