////////////////////////////////////////////////////////////////
// MFX 1993 Written by Paul DiLascia.

#include "mfx.h"

////////////////////////////////////////////////////////////////
// Generic mouse drag operations
//
CDragger::CDragger()
{
   m_dragOp = FALSE;
}

//////////////////
// Begin dragging
// pt     = current mouse location
// Optional:
// dragop = app-specific drag mode (0=no dragging, dflt = 1)
// pRc    = current rectangle (optional)
// pWnd   = ptr to window to capture mouse, or NULL
// pmt    = 
//
void CDragger::Begin(CPoint pt, int dragop, CRect* pRc, CWnd *pWnd)
{
   // Initialize state
   m_dragOp = dragop;
   m_ptPrev = m_ptCur = m_ptOrg = pt;
   if (pRc)
      m_rcPrev = m_rcOrg = m_rcCur = *pRc;
   m_rcClip.SetRectEmpty();

   // Maybe capture mouse
   if (pWnd) 
      pWnd->SetCapture();
   m_pCapWnd = pWnd;
}

//////////////////
// Stop dragging. Display optional prompt
//
void CDragger::End()
{
   m_dragOp = FALSE;             // no longer dragging
   if (m_pCapWnd)
      ReleaseCapture();
   if (!m_rcClip.IsRectEmpty())
      TheCursor.UnClip();
}

//////////////////
// Start of two-step move operation
// move current location to new point
//
void CDragger::BeginMove(CPoint pt)
{
   m_ptCur = pt;
   m_rcCur += m_ptCur;
   m_rcCur -= m_ptPrev;
}

//////////////////
// End two-step move operation
// update previous location to current 
//
void CDragger::EndMove()
{
   m_ptPrev   = m_ptCur;
   m_rcPrev = m_rcCur;
}

//////////////////
// Set cursor clipping rectangle
//
void CDragger::Clip(CRect& rcScreen)
{
   m_rcClip = rcScreen;
   TheCursor.Clip(m_rcClip);
}

//////////////////
// Set cursor clipping rectangle from window
//
void CDragger::Clip(CWnd* pWnd, CWinRect::WHICHRECT which)
{
   CWinRect rcWin(pWnd, which);
   m_rcClip = rcWin;
   TheCursor.Clip(m_rcClip);
}
